/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core;

import endorh.simpleconfig.api.ConfigBuilderFactoryProxy;
import endorh.simpleconfig.api.SimpleConfig;
import endorh.simpleconfig.api.SimpleConfigBuilder;
import endorh.simpleconfig.api.annotation.ConfigClass;
import endorh.simpleconfig.core.SimpleConfigImpl;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.javafmlmod.FMLModContainer;
import net.minecraftforge.fml.loading.moddiscovery.ModAnnotation;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="simpleconfig")
public class SimpleConfigDiscoverer {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Type CONFIG_CLASS_TYPE = Type.getType(ConfigClass.class);

    @Nullable
    private static IEventBus tryGetEventBus(@Nullable ModContainer container) {
        Object object;
        if (container == null) {
            return null;
        }
        if (container instanceof FMLModContainer) {
            FMLModContainer fmlContainer = (FMLModContainer)container;
            return fmlContainer.getEventBus();
        }
        Class<?> cls = container.getClass();
        try {
            Method method = cls.getMethod("getEventBus", new Class[0]);
            method.setAccessible(true);
            if (IEventBus.class.isAssignableFrom(method.getReturnType()) && (object = method.invoke((Object)container, new Object[0])) instanceof IEventBus) {
                IEventBus modEventBus = (IEventBus)object;
                return modEventBus;
            }
            LOGGER.warn("Unexpected type returned by ModContainer#getEventBus(): " + method.getReturnType().getCanonicalName());
        }
        catch (NoSuchMethodException method) {
        }
        catch (IllegalAccessException | InvocationTargetException ignored) {
            LOGGER.warn("Unexpected reflection error while trying to invoke ModContainer#getEventBus() for mod: " + container.getModId());
        }
        try {
            Field field = cls.getField("eventBus");
            field.setAccessible(true);
            if (IEventBus.class.isAssignableFrom(field.getType()) && (object = field.get(container)) instanceof IEventBus) {
                IEventBus modEventBus = (IEventBus)object;
                return modEventBus;
            }
            LOGGER.warn("Unexpected type found in ModContainer#eventBus: " + field.getType().getCanonicalName());
        }
        catch (NoSuchFieldException field) {
        }
        catch (IllegalAccessException e) {
            LOGGER.warn("Unexpected reflection error while trying to read ModContainer#eventBus for mod: " + container.getModId());
        }
        LOGGER.debug("Couldn't get mod event bus for mod: " + container.getModId() + " (mod container type: " + container.getClass().getCanonicalName() + "), Simple Config config class discovery may fail for this mod.");
        return null;
    }

    @ApiStatus.Internal
    public static void discoverConfigs() {
        try {
            ModList modList = ModList.get();
            for (ModFileScanData scanData : modList.getAllScanData()) {
                List mods;
                String inferredModID = null;
                IEventBus eventBus = null;
                List modFiles = scanData.getIModInfoData();
                if (!modFiles.isEmpty() && !(mods = ((IModFileInfo)modFiles.get(0)).getMods()).isEmpty()) {
                    IModInfo modInfo = (IModInfo)mods.get(0);
                    String modId = modInfo.getModId();
                    ModContainer container = (ModContainer)modList.getModContainerById(modId).orElseThrow(() -> new IllegalStateException("Mod container for mod ID " + modId + " not found"));
                    eventBus = SimpleConfigDiscoverer.tryGetEventBus(container);
                    inferredModID = modId;
                }
                LOGGER.debug("Discovering mod file for config annotations (inferred mod ID: " + inferredModID + ")");
                List<ModFileScanData.AnnotationData> ccTargets = scanData.getAnnotations().stream().filter(d -> CONFIG_CLASS_TYPE.equals((Object)d.annotationType())).toList();
                for (ModFileScanData.AnnotationData d2 : ccTargets) {
                    Map args = d2.annotationData();
                    ModAnnotation.EnumHolder typeHolder = args.getOrDefault("type", new ModAnnotation.EnumHolder(null, "CLIENT"));
                    SimpleConfig.Type type = SimpleConfig.Type.valueOf(typeHolder.getValue());
                    String modID = args.getOrDefault("modID", inferredModID);
                    String className = d2.clazz().getClassName();
                    if (modID == null) {
                        throw new SimpleConfigDiscoveryException("Missing mod ID in class annotated as @ConfigClass: " + className);
                    }
                    try {
                        Class<?> cls = Class.forName(className);
                        LOGGER.debug("Discovered  mod config for mod: " + SimpleConfigImpl.getModNameOrId(modID) + "(" + modID + ")");
                        SimpleConfigBuilder builder = ConfigBuilderFactoryProxy.config(modID, type, cls);
                        builder.buildAndRegister(eventBus != null ? eventBus : FMLJavaModLoadingContext.get().getModEventBus());
                    }
                    catch (ClassNotFoundException e) {
                        throw new SimpleConfigDiscoveryException("Error accessing class annotated as @ConfigClass: " + className, e);
                    }
                }
            }
            LOGGER.debug("Finished discovering config classes");
        }
        catch (RuntimeException e) {
            throw new ReportedException(CrashReport.m_127521_((Throwable)e, (String)"Error discovering config classes"));
        }
    }

    public static class SimpleConfigDiscoveryException
    extends RuntimeException {
        public SimpleConfigDiscoveryException(String message) {
            super(message);
        }

        public SimpleConfigDiscoveryException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

