/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core;

import com.google.common.collect.Sets;
import endorh.simpleconfig.api.AtomicEntryBuilder;
import endorh.simpleconfig.api.ConfigBuilderFactoryProxy;
import endorh.simpleconfig.api.ConfigCategoryBuilder;
import endorh.simpleconfig.api.ConfigEntryBuilder;
import endorh.simpleconfig.api.ConfigGroupBuilder;
import endorh.simpleconfig.api.SimpleConfig;
import endorh.simpleconfig.api.SimpleConfigBuilder;
import endorh.simpleconfig.api.SimpleConfigCategory;
import endorh.simpleconfig.api.SimpleConfigGroup;
import endorh.simpleconfig.api.annotation.Advanced;
import endorh.simpleconfig.api.annotation.Bake;
import endorh.simpleconfig.api.annotation.Bind;
import endorh.simpleconfig.api.annotation.Category;
import endorh.simpleconfig.api.annotation.ConfigClass;
import endorh.simpleconfig.api.annotation.Default;
import endorh.simpleconfig.api.annotation.Entry;
import endorh.simpleconfig.api.annotation.Error;
import endorh.simpleconfig.api.annotation.Experimental;
import endorh.simpleconfig.api.annotation.Group;
import endorh.simpleconfig.api.annotation.HasAlpha;
import endorh.simpleconfig.api.annotation.Length;
import endorh.simpleconfig.api.annotation.Linked;
import endorh.simpleconfig.api.annotation.Max;
import endorh.simpleconfig.api.annotation.Min;
import endorh.simpleconfig.api.annotation.NonPersistent;
import endorh.simpleconfig.api.annotation.NotEntry;
import endorh.simpleconfig.api.annotation.Operator;
import endorh.simpleconfig.api.annotation.RequireRestart;
import endorh.simpleconfig.api.annotation.Size;
import endorh.simpleconfig.api.annotation.Slider;
import endorh.simpleconfig.api.annotation.Suggest;
import endorh.simpleconfig.api.annotation.Text;
import endorh.simpleconfig.api.entry.CaptionedCollectionEntryBuilder;
import endorh.simpleconfig.api.entry.EntryMapEntryBuilder;
import endorh.simpleconfig.api.entry.EntryPairListEntryBuilder;
import endorh.simpleconfig.api.entry.EntrySetEntryBuilder;
import endorh.simpleconfig.api.entry.ListEntryBuilder;
import endorh.simpleconfig.api.ui.icon.Icon;
import endorh.simpleconfig.core.AbstractConfigEntryBuilder;
import endorh.simpleconfig.core.AbstractSimpleConfigEntryHolderBuilder;
import endorh.simpleconfig.core.BackingField;
import endorh.simpleconfig.core.EntryType;
import endorh.simpleconfig.core.ReflectionUtil;
import endorh.simpleconfig.core.SimpleConfigBuilderImpl;
import endorh.simpleconfig.core.entry.TextEntry;
import endorh.simpleconfig.core.reflection.BindingContext;
import endorh.simpleconfig.core.reflection.FieldParser;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class SimpleConfigClassParser {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Set<Class<? extends Annotation>> CONFIG_ENTRY_ANNOTATIONS = Sets.newHashSet((Object[])new Class[]{Advanced.class, Bake.class, Bake.Scale.class, Default.class, Error.class, Experimental.class, HasAlpha.class, Length.class, Linked.class, Max.class, Min.class, NonPersistent.class, Operator.class, RequireRestart.class, Size.class, Slider.class, Suggest.class});
    protected static final Map<Class<?>, AbstractSimpleConfigEntryHolderBuilder<?>> builders = new ConcurrentHashMap();
    protected static final Map<SimpleConfigBuilderImpl, Map<Class<?>, Set<Method>>> seenMethods = new ConcurrentHashMap();

    protected static void decorateBuilder(SimpleConfigBuilderImpl root) {
        BindingContext ctx = null;
        if (root.configClass != null) {
            ctx = SimpleConfigClassParser.methodBindingContext(root, root.configClass, null);
            SimpleConfigClassParser.decorateAbstractBuilder(root, ctx, root.configClass, root);
        }
        for (SimpleConfigBuilderImpl.CategoryBuilder catBuilder : root.categories.values()) {
            if (catBuilder.configClass == null) continue;
            SimpleConfigClassParser.decorateAbstractBuilder(root, SimpleConfigClassParser.methodBindingContext(root, catBuilder.configClass, ctx), catBuilder.configClass, catBuilder);
        }
        SimpleConfigClassParser.checkBoundMethods(root);
        seenMethods.remove(root);
    }

    private static BindingContext methodBindingContext(SimpleConfigBuilderImpl root, Class<?> cls, @Nullable BindingContext parent) {
        HashSet<Method> set = new HashSet<Method>();
        seenMethods.computeIfAbsent(root, c -> new HashMap()).put(cls, set);
        return BindingContext.forConfigClass(cls, parent, set);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void decorateAbstractBuilder(SimpleConfigBuilderImpl root, BindingContext ctx, Class<?> configClass, AbstractSimpleConfigEntryHolderBuilder<?> builder) {
        BindingContext.MethodWrapper.AdapterMethodWrapper iconGetter;
        builders.put(configClass, builder);
        Class builderTypeClass = SimpleConfigClassParser.match(builder, r -> SimpleConfigBuilder.class, c -> ConfigCategoryBuilder.class, g -> ConfigGroupBuilder.class);
        EntryType builderType = EntryType.unchecked(builderTypeClass);
        BindingContext.MethodWrapper buildMethod = ctx.findOwnMethod("build", BindingContext.ParametersAdapter.singleSignature(builderType), BindingContext.ReturnTypeAdapter.identity(builderType));
        if (buildMethod != null) {
            builder = (AbstractSimpleConfigEntryHolderBuilder)buildMethod.invoke(builder);
        }
        if ((iconGetter = ctx.findCompatibleOwnMethod("getIcon", false, BindingContext.ParametersAdapter.emptySignature(), BindingContext.ReturnTypeAdapter.identity(EntryType.unchecked(Icon.class)))) != null) {
            if (builder != root && !(builder instanceof SimpleConfigBuilderImpl.CategoryBuilder)) {
                LOGGER.warn("Config class " + configClass.getName() + " has an icon getter, but it's not a config file nor a category! Only categories and the file itself can have an icon getter, so this method will be ignored.");
            } else {
                try {
                    Icon icon = (Icon)iconGetter.invoke(new Object[0]);
                    if (icon != null) {
                        if (builder == root) {
                            if (root.defaultCategory.icon != Icon.EMPTY) {
                                LOGGER.warn("Config class " + configClass.getName() + " has an icon getter, but it already has a default category icon! Only the first icon set will be used!\n  Remove the `getIcon` method, or the call to `withIcon` to suppress this warning!");
                            } else {
                                root.withIcon(icon);
                            }
                        } else {
                            SimpleConfigBuilderImpl.CategoryBuilder cb = (SimpleConfigBuilderImpl.CategoryBuilder)builder;
                            if (cb.icon != Icon.EMPTY) {
                                LOGGER.warn("Config category class " + configClass.getName() + " has an icon getter, but it already has an icon! Only the first icon set will be used!\n  Remove the `getIcon` method, or the call to `withIcon` to suppress this warning!");
                            } else {
                                cb.withIcon(icon);
                            }
                        }
                    } else {
                        LOGGER.warn("Icon getter for method " + iconGetter.getMethodName() + " returned a null icon!");
                    }
                }
                catch (RuntimeException e2) {
                    throw new SimpleConfigClassParseException(builder, "Error creating icon for config category from method " + iconGetter.getMethodName());
                }
            }
        }
        if (configClass.isAnnotationPresent(Category.class)) {
            if (!(builder instanceof SimpleConfigBuilderImpl.CategoryBuilder)) {
                throw new SimpleConfigClassParseException(builder, "Config class " + configClass.getName() + " is annotated with @Category, but is not associated with a category builder!!");
            }
            SimpleConfigBuilderImpl.CategoryBuilder cb = (SimpleConfigBuilderImpl.CategoryBuilder)builder;
            Category cat = configClass.getAnnotation(Category.class);
            if (!cat.background().isEmpty()) {
                if (cb.background != null) {
                    LOGGER.warn("Config class " + configClass.getName() + " specifies a background texture in its @Category annotation, but already has a background!\n  Only the first background set will be used. Remove the background from the annotation to suppress this warning.");
                } else {
                    cb.withBackground(cat.background());
                }
            }
            if (cat.color() != 0) {
                if (cb.tint != 0) {
                    LOGGER.warn("Config class " + configClass.getName() + " specifies a tint color in its @Category annotation, but already has a tint color!\n  Only the first tint set will be used. Remove the color from the annotation to suppress this warning.");
                } else {
                    cb.withColor(cat.color());
                }
            }
        }
        if (configClass.isAnnotationPresent(ConfigClass.class)) {
            if (builder != root) {
                throw new SimpleConfigClassParseException(builder, "Config class " + configClass.getName() + " is annotated with @ConfigClass, but is not the root config class!!");
            }
            ConfigClass config = configClass.getAnnotation(ConfigClass.class);
            if (!config.background().isEmpty()) {
                if (root.background != null) {
                    LOGGER.warn("Config class " + configClass.getName() + " specifies a background texture in its @ConfigClass annotation, but already has a background!\n  Only the first background set will be used. Remove the background from the annotation to suppress this warning.");
                } else {
                    root.withBackground(config.background());
                }
            }
            if (config.color() != 0) {
                if (root.defaultCategory.tint != 0) {
                    LOGGER.warn("Config class " + configClass.getName() + " specifies a default tint color in its @ConfigClass annotation, but already has a default tint color!\n  Only the first tint set will be used. Remove the color from the annotation to suppress this warning.");
                } else {
                    root.withColor(config.color());
                }
            }
        }
        HashMap<Field, Pair> secondaryBackingFieldBindings = new HashMap<Field, Pair>();
        HashSet<Object> seenFields = new HashSet<Object>();
        for (String name : builder.entries.keySet()) {
            List<BackingField.BackingFieldBinding<?, ?>> bindings = builder.getSecondaryBackingFieldBindings(name);
            if (bindings.isEmpty()) continue;
            for (BackingField.BackingFieldBinding backingFieldBinding : bindings) {
                String fieldName = backingFieldBinding.buildName(name);
                try {
                    Field field = configClass.getDeclaredField(fieldName);
                    field.setAccessible(true);
                    if (!Modifier.isStatic(field.getModifiers())) {
                        throw new SimpleConfigClassParseException(builder, "Config class members must be static. Found non-static field " + ReflectionUtil.getFieldName(field));
                    }
                    secondaryBackingFieldBindings.put(field, Pair.of((Object)name, (Object)backingFieldBinding));
                    seenFields.add(field);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new SimpleConfigClassParseException(builder, "Missing backing field \"" + configClass.getSimpleName() + "#" + fieldName + "\" for entry \"" + name + "\"");
                }
            }
        }
        String className = configClass.getName();
        Field captionField = null;
        ConfigEntryBuilder<?, ?, ?, ?> captionBuilder = null;
        for (Field field : configClass.getDeclaredFields()) {
            Object value;
            String name = field.getName();
            if (seenFields.contains(field)) continue;
            String fieldTypeName = field.getGenericType().getTypeName();
            if (!Modifier.isStatic(field.getModifiers())) {
                throw new SimpleConfigClassParseException(builder, "Config class members must be static. Found non-static field " + ReflectionUtil.getFieldName(field));
            }
            if (field.isAnnotationPresent(Group.class) || field.isAnnotationPresent(Category.class)) {
                String holderName;
                if (captionField != null) {
                    throw SimpleConfigClassParser.captionTarget(builder, captionField);
                }
                Group group2 = field.getAnnotation(Group.class);
                if (field.getType() != Void.class) {
                    throw new SimpleConfigClassParseException(builder, "Found " + (group2 != null ? "group" : "category") + " marker field with non-void type: " + ReflectionUtil.getFieldName(field));
                }
                String string = holderName = name.endsWith("$marker") ? name.substring(0, name.length() - 7) : name;
                if (group2 != null) {
                    if (builder.groups.containsKey(holderName)) {
                        throw new SimpleConfigClassParseException(builder, "Found group marker field for already registered group: " + ReflectionUtil.getFieldName(field));
                    }
                    boolean expand = group2.expand();
                    Class cl = Arrays.stream(configClass.getDeclaredClasses()).filter(c -> c.getSimpleName().equals(holderName)).findFirst().orElseThrow(() -> new SimpleConfigClassParseException(configClass, "Found group marker field without matching group class: " + ReflectionUtil.getFieldName(field)));
                    Group gr = cl.getAnnotation(Group.class);
                    builder.n(ConfigBuilderFactoryProxy.group(holderName, expand |= gr != null && gr.expand()));
                } else {
                    if (root != builder) {
                        throw new SimpleConfigClassParseException(builder, "Found category marker field in non-root builder: " + ReflectionUtil.getFieldName(field));
                    }
                    if (root.categories.containsKey(holderName)) {
                        throw new SimpleConfigClassParseException(builder, "Found category marker field for already registered category: " + ReflectionUtil.getFieldName(field));
                    }
                    Class cl = Arrays.stream(configClass.getDeclaredClasses()).filter(c -> c.getSimpleName().equals(holderName)).findFirst().orElseThrow(() -> new SimpleConfigClassParseException(configClass, "Found category marker field without matching category class: " + ReflectionUtil.getFieldName(field)));
                    root.n(ConfigBuilderFactoryProxy.category(holderName, cl));
                }
                if (SimpleConfigClassParser.hasAnyConfigAnnotation(field)) {
                    LOGGER.warn("Group/category marker field " + ReflectionUtil.getFieldName(field) + " has config annotations that have no effect\n  Remove them to suppress this warning.");
                }
                seenFields.add(field);
                continue;
            }
            try {
                field.setAccessible(true);
                value = field.get(null);
            }
            catch (IllegalAccessException e3) {
                throw new SimpleConfigClassParseException(builder, "Couldn't access config class field " + ReflectionUtil.getFieldName(field) + "\n  Details: " + e3.getMessage(), (Exception)e3);
            }
            if (field.isAnnotationPresent(Text.class)) {
                TextEntry.Builder textBuilder;
                if (captionField != null) {
                    throw SimpleConfigClassParser.captionTarget(builder, captionField);
                }
                if (field.getType() == Void.class) {
                    textBuilder = new TextEntry.Builder();
                } else if (value instanceof Component) {
                    Component tc = (Component)value;
                    textBuilder = new TextEntry.Builder(() -> tc);
                } else {
                    if (!(value instanceof Supplier) || !EntryType.from(Supplier.class, Component.class).matches(EntryType.fromField(field))) throw new SimpleConfigClassParseException(builder, "Unsupported text supplier in config field " + ReflectionUtil.getFieldName(field) + " of type " + (String)fieldTypeName + "\n  Should be either String (contents ignored), Component or Supplier<Component>");
                    Supplier supplier = (Supplier)value;
                    textBuilder = new TextEntry.Builder(supplier);
                }
                ctx.setContextName(field);
                builder.add(SimpleConfigClassParser.getOrder(field), field.getName(), FieldParser.addTooltip(ctx, textBuilder));
                seenFields.add(field);
                continue;
            }
            if (builder.hasEntry(name) && !field.isAnnotationPresent(NotEntry.class)) {
                if (captionField != null) {
                    throw SimpleConfigClassParser.captionTarget(builder, captionField);
                }
                BackingField.BackingFieldBuilder fieldBuilder = builder.getEntry((String)name).backingFieldBuilder;
                if (fieldBuilder == null) {
                    LOGGER.warn("Found config backing field " + ReflectionUtil.getFieldName(field) + " for entry of type " + builder.getEntry(name).getClass().getSimpleName() + ", which does not support backing fields. The field will be ignored\nRename the field or annotate it with @NotEntry to suppress this warning.");
                    continue;
                }
                BackingField backingField = fieldBuilder.build(field);
                if (builder.backingFields.containsKey(name)) {
                    throw new SimpleConfigClassParseException(builder, "Config entry " + name + " cannot have two backing fields");
                }
                builder.setBackingField(name, backingField);
                if (SimpleConfigClassParser.hasAnyConfigAnnotation(field)) {
                    LOGGER.warn("Config field " + ReflectionUtil.getFieldName(field) + " has config annotations but is already defined by the builder. Its annotations will be ignored.");
                }
                seenFields.add(field);
                continue;
            }
            if (field.isAnnotationPresent(Entry.Caption.class)) {
                if (captionField != null) {
                    throw SimpleConfigClassParser.captionTarget(builder, captionField);
                }
                captionField = field;
                captionBuilder = FieldParser.parseField(ctx, field);
                continue;
            }
            if (field.isAnnotationPresent(Entry.class) || field.isAnnotationPresent(Group.Caption.class)) {
                if (field.isAnnotationPresent(Group.Caption.class) && captionField != null) {
                    throw SimpleConfigClassParser.captionTarget(builder, captionField);
                }
                ConfigEntryBuilder<?, ?, ?, ?> entryBuilder = FieldParser.parseField(ctx, field);
                if (captionField != null) {
                    entryBuilder = SimpleConfigClassParser.makeCaption(captionBuilder, captionField, entryBuilder, field);
                    captionField = null;
                    captionBuilder = null;
                }
                if (!(entryBuilder instanceof AbstractConfigEntryBuilder)) {
                    throw new IllegalStateException("Entry builder " + entryBuilder.getClass().getCanonicalName() + " is not an AbstractConfigEntryBuilder");
                }
                AbstractConfigEntryBuilder b = (AbstractConfigEntryBuilder)entryBuilder;
                BackingField.BackingFieldBuilder fieldBuilder = b.backingFieldBuilder;
                if (fieldBuilder == null) {
                    throw new SimpleConfigClassParseException(builder, "Config entry generated from field does not support backing fields");
                }
                BackingField backingField = fieldBuilder.build(field);
                for (BackingField.BackingFieldBinding f2 : b.backingFieldBindings) {
                    String fieldName = f2.buildName(name);
                    try {
                        Field secondaryField = configClass.getDeclaredField(fieldName);
                        secondaryBackingFieldBindings.put(secondaryField, Pair.of((Object)name, f2));
                        seenFields.add(secondaryField);
                    }
                    catch (NoSuchFieldException e4) {
                        throw new SimpleConfigClassParseException(builder, "Missing backing field \"" + configClass.getSimpleName() + "#" + fieldName + "\" for entry \"" + name + "\"");
                    }
                }
                if (field.isAnnotationPresent(Group.Caption.class)) {
                    if (!(builder instanceof SimpleConfigBuilderImpl.GroupBuilder)) throw new SimpleConfigClassParseException(builder, "Found @Caption annotation on field " + ReflectionUtil.getFieldName(field) + " in non-group builder: " + className);
                    SimpleConfigBuilderImpl.GroupBuilder gBuilder = (SimpleConfigBuilderImpl.GroupBuilder)builder;
                    if (gBuilder.captionBuilder != null) {
                        throw new SimpleConfigClassParseException(builder, "Field " + ReflectionUtil.getFieldName(field) + " is annotated with @Caption, but this group already has a caption entry: " + gBuilder.captionName);
                    }
                    SimpleConfigClassParser.addCaption(gBuilder, name, entryBuilder, field);
                } else {
                    builder.add(SimpleConfigClassParser.getOrder(field), name, entryBuilder);
                }
                builder.setBackingField(name, backingField);
                seenFields.add(field);
                continue;
            }
            if (!SimpleConfigClassParser.hasAnyConfigAnnotation(field)) continue;
            throw new SimpleConfigClassParseException(builder, "Unsupported config annotation/field type combination in field " + ReflectionUtil.getFieldName(field) + " of type " + (String)fieldTypeName);
        }
        Optional<Field> unbound = Arrays.stream(configClass.getDeclaredFields()).filter(f -> f.isAnnotationPresent(Bind.class) && !seenFields.contains(f)).findFirst();
        if (unbound.isPresent()) {
            throw new SimpleConfigClassParseException(builder, "Config field " + ReflectionUtil.getFieldName(unbound.get()) + " was annotated with @Bind but no matching config entry was found defined");
        }
        if (captionField != null) {
            throw SimpleConfigClassParser.captionTarget(builder, captionField);
        }
        Map map = secondaryBackingFieldBindings.entrySet().stream().collect(Collectors.groupingBy(e -> (String)((Pair)e.getValue()).getKey(), Collectors.toList()));
        for (String string : map.keySet()) {
            ArrayList backingFields = new ArrayList();
            for (Map.Entry e5 : map.get(string)) {
                Field field = (Field)e5.getKey();
                BackingField.BackingFieldBinding f3 = (BackingField.BackingFieldBinding)((Pair)e5.getValue()).getValue();
                BackingField backingField = f3.build(field);
                backingFields.add(backingField);
                if (!SimpleConfigClassParser.hasAnyConfigAnnotation(field)) continue;
                LOGGER.warn("Config field " + ReflectionUtil.getFieldName(field) + " has config annotations but is already defined by the builder. Its annotations will be ignored.");
            }
            builder.setSecondaryBackingFields(string, backingFields);
        }
        for (Class<?> clazz : configClass.getDeclaredClasses()) {
            Annotation a;
            String name = clazz.getSimpleName();
            if (clazz.isAnnotationPresent(Category.class) || root.categories.containsKey(name)) {
                SimpleConfigBuilderImpl.CategoryBuilder catBuilder;
                if (builder != root) {
                    throw new SimpleConfigClassParseException(builder, "Config category " + className + "." + name + " found outside of upper config level");
                }
                if (root.categories.containsKey(name)) {
                    catBuilder = root.categories.get(name);
                    if (catBuilder.configClass != null) {
                        throw new SimpleConfigClassParseException(builder, "Attempt to declare backing class for config category that already has a backing class: " + name + ", class: " + clazz.getName());
                    }
                } else {
                    a = clazz.getAnnotation(Category.class);
                    catBuilder = new SimpleConfigBuilderImpl.CategoryBuilder(name);
                    if (clazz.isAnnotationPresent(RequireRestart.class)) {
                        catBuilder.restart();
                    }
                    root.n(catBuilder, a.value());
                }
                SimpleConfigClassParser.decorateAbstractBuilder(root, SimpleConfigClassParser.methodBindingContext(root, clazz, ctx), clazz, catBuilder);
                continue;
            }
            if (clazz.isAnnotationPresent(Group.class) || builder.groups.containsKey(name)) {
                SimpleConfigBuilderImpl.GroupBuilder gBuilder;
                if (builder.groups.containsKey(name)) {
                    gBuilder = builder.groups.get(name);
                } else {
                    a = clazz.getAnnotation(Group.class);
                    boolean expand = a.expand();
                    gBuilder = new SimpleConfigBuilderImpl.GroupBuilder(name, expand);
                    if (clazz.isAnnotationPresent(RequireRestart.class)) {
                        gBuilder.restart();
                    }
                    builder.n(gBuilder, a.value());
                }
                SimpleConfigClassParser.decorateAbstractBuilder(root, SimpleConfigClassParser.methodBindingContext(root, clazz, ctx), clazz, gBuilder);
                continue;
            }
            if (!clazz.isAnnotationPresent(Bind.class)) continue;
            throw new SimpleConfigClassParseException(builder, "Config inner class " + clazz.getName() + " was annotated with @Bind but no matching config category/group was found defined");
        }
        Class bakeArgClass = SimpleConfigClassParser.match(builder, c -> SimpleConfig.class, c -> SimpleConfigCategory.class, c -> SimpleConfigGroup.class);
        Consumer consumer = SimpleConfigClassParser.match(builder, c -> c.baker, c -> c.baker, c -> c.baker);
        BindingContext.MethodWrapper baker = ctx.findOwnMethod("bake", BindingContext.ParametersAdapter.oneOptionalAdapter(EntryType.unchecked(bakeArgClass)), BindingContext.ReturnTypeAdapter.ofVoid());
        if (baker != null) {
            if (consumer == null) {
                SimpleConfigClassParser.match(builder, c -> c.withBaker(xva$0 -> {
                    Void cfr_ignored_0 = (Void)baker.invoke(xva$0);
                }), c -> c.withBaker(xva$0 -> {
                    Void cfr_ignored_0 = (Void)baker.invoke(xva$0);
                }), c -> c.withBaker(xva$0 -> {
                    Void cfr_ignored_0 = (Void)baker.invoke(xva$0);
                }));
            } else {
                LOGGER.warn("Found bake method in config class " + className + ", but this config file/category/group already has a configured baker\nOnly the already configured baker will be used\nIf the configured baker is precisely this method, rename it or let the reflection find it to suppress this warning.");
            }
        }
        builders.remove(configClass);
    }

    private static ConfigEntryBuilder<?, ?, ?, ?> makeCaption(ConfigEntryBuilder<?, ?, ?, ?> caption, Field captionField, ConfigEntryBuilder<?, ?, ?, ?> builder, Field field) {
        Class<?> configClass = field.getDeclaringClass();
        try {
            ConfigEntryBuilder<?, ?, ?, ?> cb;
            if (builder instanceof EntryPairListEntryBuilder) {
                EntryPairListEntryBuilder plb = (EntryPairListEntryBuilder)builder;
                cb = FieldParser.makeCaptionedPairList(caption, plb, null);
            } else if (builder instanceof ListEntryBuilder) {
                ListEntryBuilder lb = (ListEntryBuilder)builder;
                cb = FieldParser.makeCaptionedList(caption, lb, null);
            } else if (builder instanceof EntrySetEntryBuilder) {
                EntrySetEntryBuilder sb = (EntrySetEntryBuilder)builder;
                cb = FieldParser.makeCaptionedSet(caption, sb, null);
            } else if (builder instanceof EntryMapEntryBuilder) {
                EntryMapEntryBuilder mb = (EntryMapEntryBuilder)builder;
                cb = FieldParser.makeCaptionedMap(caption, mb, null);
            } else {
                throw SimpleConfigClassParser.captionTarget(SimpleConfigClassParser.getBuilderForClass(configClass), captionField);
            }
            if (!(cb instanceof CaptionedCollectionEntryBuilder)) {
                throw new SimpleConfigClassParseException(configClass, "Unexpected type for captioned collection entry: " + cb.getClass().getName());
            }
            CaptionedCollectionEntryBuilder cceb = (CaptionedCollectionEntryBuilder)cb;
            cb = cceb.captionField(captionField.getName()).collectionField();
            return cb;
        }
        catch (IllegalArgumentException e) {
            throw new SimpleConfigClassParseException(configClass, "Unexpected error creating captioned entry.\n  Possible cause: Expected type of field " + ReflectionUtil.getFieldName(captionField) + " to be atomic. Actual type is: " + EntryType.fromField(captionField), (Exception)e);
        }
        catch (SimpleConfigClassParseException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new SimpleConfigClassParseException(configClass, "Unexpected error creating captioned entry for fields: " + ReflectionUtil.getFieldName(captionField) + " and " + ReflectionUtil.getFieldName(field), (Exception)e);
        }
    }

    private static <V, C, G, B extends ConfigEntryBuilder<V, C, G, B> & AtomicEntryBuilder> B atomic(ConfigEntryBuilder<?, ?, ?, ?> builder, Field field) {
        if (!(builder instanceof AtomicEntryBuilder)) {
            throw new SimpleConfigClassParseException(field.getDeclaringClass(), "Expected field " + ReflectionUtil.getFieldName(field) + " to have an atomic entry type, but found: " + EntryType.fromField(field));
        }
        return (B)builder;
    }

    private static SimpleConfigClassParseException captionTarget(AbstractSimpleConfigEntryHolderBuilder<?> builder, Field field) {
        return new SimpleConfigClassParseException(builder, "@Entry.Caption annotated field \"" + ReflectionUtil.getFieldName(field) + "\" is not followed by a valid composite entry\n  The only entry types that support a caption are List, Set and Map\n  To set the caption of a config group or bean entry, use @Group.Caption");
    }

    private static <V, C, G, B extends ConfigEntryBuilder<V, C, G, B> & AtomicEntryBuilder> void addCaption(SimpleConfigBuilderImpl.GroupBuilder builder, String name, ConfigEntryBuilder<V, C, G, ?> entryBuilder, Field field) {
        if (!(entryBuilder instanceof AtomicEntryBuilder)) {
            throw new SimpleConfigClassParseException(builder, "Field " + ReflectionUtil.getFieldName(field) + " is annotated with @Caption, but its entry type builder doesn't implement AtomicEntryBuilder\nThis type of config entry cannot be used as caption: " + EntryType.fromField(field));
        }
        builder.caption(name, entryBuilder);
    }

    protected static void checkBoundMethods(SimpleConfigBuilderImpl root) {
        Map<Class<?>, Set<Method>> methodSets = seenMethods.remove(root);
        if (methodSets == null) {
            return;
        }
        for (Map.Entry<Class<?>, Set<Method>> e : methodSets.entrySet()) {
            Class<?> cls = e.getKey();
            Set<Method> methods = e.getValue();
            Optional<Method> opt = Arrays.stream(cls.getDeclaredMethods()).filter(m -> m.isAnnotationPresent(Bind.class) && !methods.contains(m)).findFirst();
            if (!opt.isPresent()) continue;
            throw new SimpleConfigClassParseException(cls, "Found unbound method in config class annotated with @Bind: " + ReflectionUtil.getMethodName(opt.get()) + "\nMake sure the references to this method from config annotations are correct or remove the @Bind annotation");
        }
    }

    protected static <R> R match(AbstractSimpleConfigEntryHolderBuilder<?> builder, Function<SimpleConfigBuilderImpl, R> rootGetter, Function<SimpleConfigBuilderImpl.CategoryBuilder, R> categoryGetter, Function<SimpleConfigBuilderImpl.GroupBuilder, R> groupGetter) {
        if (builder instanceof SimpleConfigBuilderImpl) {
            SimpleConfigBuilderImpl root = (SimpleConfigBuilderImpl)builder;
            return rootGetter.apply(root);
        }
        if (builder instanceof SimpleConfigBuilderImpl.CategoryBuilder) {
            SimpleConfigBuilderImpl.CategoryBuilder category = (SimpleConfigBuilderImpl.CategoryBuilder)builder;
            return categoryGetter.apply(category);
        }
        if (builder instanceof SimpleConfigBuilderImpl.GroupBuilder) {
            SimpleConfigBuilderImpl.GroupBuilder group2 = (SimpleConfigBuilderImpl.GroupBuilder)builder;
            return groupGetter.apply(group2);
        }
        throw new IllegalArgumentException("Unknown builder type: " + builder.getClass().getCanonicalName());
    }

    protected static boolean hasAnyConfigAnnotation(Field field) {
        for (Class<? extends Annotation> cls : CONFIG_ENTRY_ANNOTATIONS) {
            if (!field.isAnnotationPresent(cls)) continue;
            return true;
        }
        return false;
    }

    protected static int getOrder(Field field) {
        if (field.isAnnotationPresent(Entry.class)) {
            return field.getAnnotation(Entry.class).value();
        }
        if (field.isAnnotationPresent(Text.class)) {
            return field.getAnnotation(Text.class).value();
        }
        if (field.isAnnotationPresent(Group.Caption.class)) {
            return -1;
        }
        return 0;
    }

    public static AbstractSimpleConfigEntryHolderBuilder<?> getBuilderForClass(Class<?> clazz) {
        return builders.get(clazz);
    }

    public static class SimpleConfigClassParseException
    extends RuntimeException {
        public SimpleConfigClassParseException(Class<?> parsedClass, String message) {
            this(SimpleConfigClassParser.getBuilderForClass(parsedClass), message);
        }

        public SimpleConfigClassParseException(Class<?> parsedClass, String message, Exception cause) {
            this(SimpleConfigClassParser.getBuilderForClass(parsedClass), message, cause);
        }

        public SimpleConfigClassParseException(AbstractSimpleConfigEntryHolderBuilder<?> builder, String message) {
            super(message + SimpleConfigClassParseException.getExtraMessage(builder));
        }

        public SimpleConfigClassParseException(AbstractSimpleConfigEntryHolderBuilder<?> builder, String message, Exception cause) {
            super(message + SimpleConfigClassParseException.getExtraMessage(builder), cause);
        }

        public static String getExtraMessage(Class<?> parsedClass) {
            return SimpleConfigClassParseException.getExtraMessage(SimpleConfigClassParser.getBuilderForClass(parsedClass));
        }

        public static String getExtraMessage(AbstractSimpleConfigEntryHolderBuilder<?> builder) {
            if (builder == null) {
                return "\n  Could not get config building context information";
            }
            StringBuilder r = new StringBuilder("\n");
            r.append("  Parsing config ").append(builder).append("\n");
            r.append("    Defined entries:\n");
            for (Map.Entry<String, AbstractConfigEntryBuilder<?, ?, ?, ?, ?, ?>> entry : builder.entries.entrySet()) {
                AbstractConfigEntryBuilder<?, ?, ?, ?, ?, ?> e = entry.getValue();
                r.append("      ").append(entry.getKey()).append(": ").append(Arrays.stream(e.getClass().getInterfaces()).filter(ConfigEntryBuilder.class::isAssignableFrom).findFirst().map(Class::getSimpleName).orElse(e.getClass().getSimpleName() + " [unknown builder interface!]"));
                if (e.type != null) {
                    r.append(" (").append(e.type).append(")");
                }
                r.append("\n");
            }
            return r.toString();
        }

        public static String getEntryBuilderName(ConfigEntryBuilder<?, ?, ?, ?> builder) {
            return Arrays.stream(builder.getClass().getInterfaces()).filter(ConfigEntryBuilder.class::isAssignableFrom).findFirst().map(Class::getSimpleName).orElse(builder.getClass().getSimpleName());
        }
    }
}

