/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core;

import endorh.simpleconfig.api.SimpleConfig;
import endorh.simpleconfig.api.SimpleConfigCategory;
import endorh.simpleconfig.api.SimpleConfigTextUtil;
import endorh.simpleconfig.api.ui.icon.Icon;
import endorh.simpleconfig.config.ClientConfig;
import endorh.simpleconfig.core.AbstractConfigEntry;
import endorh.simpleconfig.core.AbstractSimpleConfigEntryHolder;
import endorh.simpleconfig.core.ServerI18n;
import endorh.simpleconfig.core.SimpleConfigGroupImpl;
import endorh.simpleconfig.core.SimpleConfigImpl;
import endorh.simpleconfig.ui.api.ConfigCategoryBuilder;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.api.ConfigScreenBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleConfigCategoryImpl
extends AbstractSimpleConfigEntryHolder
implements SimpleConfigCategory {
    public final SimpleConfigImpl parent;
    public final String name;
    protected final String title;
    protected final String tooltip;
    @Nullable
    protected Supplier<List<Component>> description;
    @Nullable
    protected final Consumer<SimpleConfigCategory> baker;
    protected Map<String, SimpleConfigGroupImpl> groups;
    protected List<SimpleConfigImpl.IGUIEntry> order;
    @Nullable
    protected BiConsumer<SimpleConfigCategory, ConfigCategoryBuilder> decorator;
    @Nullable
    protected ResourceLocation background;
    protected Icon icon = Icon.EMPTY;
    protected int color = 0;
    protected boolean isRoot;

    @ApiStatus.Internal
    protected SimpleConfigCategoryImpl(SimpleConfigImpl parent, String name, String title, boolean isRoot, @Nullable Consumer<SimpleConfigCategory> baker) {
        this.parent = parent;
        this.name = name;
        this.title = title;
        this.baker = baker;
        this.isRoot = isRoot;
        this.root = parent;
        this.tooltip = title + ":help";
    }

    @ApiStatus.Internal
    protected void build(Map<String, AbstractConfigEntry<?, ?, ?>> entries2, Map<String, SimpleConfigGroupImpl> groups, List<SimpleConfigImpl.IGUIEntry> order, @Nullable Supplier<List<Component>> description, Icon icon, int color) {
        if (this.entries != null) {
            throw new IllegalStateException("Called buildEntry() twice");
        }
        this.entries = entries2;
        this.groups = groups;
        this.children = groups;
        this.order = order;
        this.description = description;
        this.icon = icon;
        this.color = color;
    }

    @Override
    public String getPath() {
        return this.isRoot ? "" : this.name;
    }

    @Override
    public String getPathPart() {
        return this.isRoot ? "" : this.name + ".";
    }

    @Override
    @NotNull
    public AbstractSimpleConfigEntryHolder getParent() {
        return this.root;
    }

    @Override
    protected String getName() {
        return this.name;
    }

    @Override
    protected String getConfigComment() {
        StringBuilder builder = new StringBuilder();
        if (this.title != null && ServerI18n.hasKey(this.title)) {
            String name = SimpleConfigTextUtil.stripFormattingCodes(ServerI18n.format(this.title, new Object[0]).trim());
            builder.append(name).append('\n');
            if (ServerI18n.hasKey(this.tooltip)) {
                String tooltip = "  " + SimpleConfigTextUtil.stripFormattingCodes(ServerI18n.format(this.tooltip, new Object[0]).trim().replace("\n", "\n  "));
                builder.append(tooltip).append('\n');
            }
        }
        return builder.toString();
    }

    @Override
    public void markDirty(boolean dirty) {
        super.markDirty(dirty);
        if (dirty) {
            this.parent.markDirty(true);
        }
    }

    @Override
    public SimpleConfigGroupImpl getGroup(String path) {
        if (path.contains(".")) {
            String[] split = path.split("\\.", 2);
            if (this.groups.containsKey(split[0])) {
                return this.groups.get(split[0]).getGroup(split[1]);
            }
        } else if (this.groups.containsKey(path)) {
            return this.groups.get(path);
        }
        throw new SimpleConfig.NoSuchConfigGroupError(path);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void buildGUI(ConfigScreenBuilder builder, ConfigFieldBuilder entryBuilder, boolean forRemote) {
        ConfigCategoryBuilder category = builder.getOrCreateCategory(this.name, this.root.getType().asEditType(forRemote));
        category.setEditable(this.getRoot().canEdit());
        category.setTitle(this.getTitle());
        category.setDescription(() -> this.description != null ? Optional.of((Component[])this.description.get().toArray(Component[]::new)) : (I18n.m_118936_((String)this.tooltip) ? Optional.of(SimpleConfigTextUtil.splitTtc(this.tooltip, new Object[0]).toArray(new Component[0])) : Optional.empty()));
        this.root.getFilePath(this.name).ifPresent(category::setContainingFile);
        if (this.background != null) {
            category.setBackground(this.background);
        } else if (this.parent.background != null) {
            category.setBackground(this.parent.background);
        }
        category.setColor(this.color);
        category.setIcon(this.icon);
        if (!this.order.isEmpty()) {
            for (SimpleConfigImpl.IGUIEntry entry : this.order) {
                entry.buildGUI(category, entryBuilder, forRemote);
            }
        }
        if (this.decorator != null) {
            this.decorator.accept(this, category);
        }
    }

    @Override
    protected void bake() {
        for (SimpleConfigGroupImpl group2 : this.groups.values()) {
            group2.bake();
        }
        if (this.baker != null) {
            this.baker.accept(this);
        }
    }

    protected void bakeFields() {
        for (SimpleConfigGroupImpl group2 : this.groups.values()) {
            group2.bakeFields();
        }
        for (AbstractConfigEntry entry : this.entries.values()) {
            entry.bakeField();
        }
    }

    @Override
    public void commitFields() {
        try {
            for (SimpleConfigGroupImpl group2 : this.groups.values()) {
                group2.commitFields();
            }
            for (AbstractConfigEntry entry : this.entries.values()) {
                entry.commitField();
            }
        }
        catch (IllegalAccessException e) {
            throw new SimpleConfig.ConfigReflectiveOperationException("Could not access mod config field during config commit\n  Details: " + e.getMessage(), e);
        }
    }

    protected Component getTitle() {
        if (ClientConfig.advanced.translation_debug_mode) {
            return Component.m_237113_((String)this.title);
        }
        return I18n.m_118936_((String)this.title) ? Component.m_237115_((String)this.title) : Component.m_237113_((String)WordUtils.capitalize((String)this.name));
    }
}

