/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import endorh.simpleconfig.api.AtomicEntryBuilder;
import endorh.simpleconfig.api.ConfigEntryBuilder;
import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.ConfigEntryHolderBuilder;
import endorh.simpleconfig.api.ConfigGroupBuilder;
import endorh.simpleconfig.api.SimpleConfig;
import endorh.simpleconfig.api.SimpleConfigBuilder;
import endorh.simpleconfig.api.SimpleConfigCategory;
import endorh.simpleconfig.api.SimpleConfigGroup;
import endorh.simpleconfig.api.ui.icon.Icon;
import endorh.simpleconfig.core.AbstractConfigEntry;
import endorh.simpleconfig.core.AbstractConfigEntryBuilder;
import endorh.simpleconfig.core.AbstractSimpleConfigEntryHolderBuilder;
import endorh.simpleconfig.core.SimpleConfigCategoryImpl;
import endorh.simpleconfig.core.SimpleConfigClassParser;
import endorh.simpleconfig.core.SimpleConfigGUIManagerImpl;
import endorh.simpleconfig.core.SimpleConfigGroupImpl;
import endorh.simpleconfig.core.SimpleConfigImpl;
import endorh.simpleconfig.core.SimpleConfigModConfig;
import endorh.simpleconfig.ui.api.ConfigCategoryBuilder;
import endorh.simpleconfig.ui.api.ConfigScreenBuilder;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleConfigBuilderImpl
extends AbstractSimpleConfigEntryHolderBuilder<SimpleConfigBuilder>
implements SimpleConfigBuilder {
    protected final String modId;
    protected final SimpleConfig.Type type;
    @Nullable
    protected LiteralArgumentBuilder<CommandSourceStack> commandRoot = null;
    protected final String title;
    protected final Map<String, CategoryBuilder> categories = new LinkedHashMap<String, CategoryBuilder>();
    protected final Map<CategoryBuilder, Integer> categoryOrder = new HashMap<CategoryBuilder, Integer>();
    protected final CategoryBuilder defaultCategory;
    protected String path;
    @Nullable
    protected final Class<?> configClass;
    @Nullable
    protected Consumer<SimpleConfig> baker = null;
    @Nullable
    protected Consumer<SimpleConfigImpl> saver = null;
    @Nullable
    protected BiConsumer<SimpleConfig, ConfigScreenBuilder> decorator = null;
    @Nullable
    protected Predicate<SimpleConfigCategory> categoryFilter = null;
    @Nullable
    protected ResourceLocation background = null;
    protected boolean transparent = true;
    protected boolean isWrapper;

    protected SimpleConfigBuilderImpl(String modId, SimpleConfig.Type type) {
        this(modId, type, null);
    }

    protected SimpleConfigBuilderImpl(String modId, SimpleConfig.Type type, @Nullable Class<?> configClass) {
        this.modId = modId;
        this.type = type;
        this.configClass = configClass;
        String classifier = type.name().toLowerCase();
        this.title = modId + ".config.category." + classifier;
        this.path = classifier;
        this.defaultCategory = new CategoryBuilder(classifier);
        this.defaultCategory.setParent(this);
        this.defaultCategory.path = this.path;
        this.defaultCategory.title = modId + ".config.category." + this.path;
    }

    @Override
    @Contract(value="_ -> this")
    @NotNull
    public SimpleConfigBuilderImpl withBaker(Consumer<SimpleConfig> baker) {
        this.baker = baker;
        return this;
    }

    @Override
    @Contract(value="_ -> this")
    @NotNull
    public SimpleConfigBuilderImpl withBackground(String resourceName) {
        return this.withBackground(new ResourceLocation(resourceName));
    }

    @Override
    @Contract(value="_ -> this")
    @NotNull
    public SimpleConfigBuilderImpl withBackground(ResourceLocation background) {
        this.background = background;
        return this;
    }

    @Override
    @Contract(value="_ -> this")
    @NotNull
    public SimpleConfigBuilderImpl withIcon(Icon icon) {
        this.defaultCategory.withIcon(icon);
        return this;
    }

    @Override
    @Contract(value="_ -> this")
    @NotNull
    public SimpleConfigBuilderImpl withColor(int tint) {
        this.defaultCategory.withColor(tint);
        return this;
    }

    @Override
    @Contract(value="-> this")
    @NotNull
    public SimpleConfigBuilderImpl withSolidInGameBackground() {
        this.transparent = false;
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Contract(value="_ -> this")
    public SimpleConfigBuilderImpl withGUIDecorator(BiConsumer<SimpleConfig, ConfigScreenBuilder> decorator) {
        this.decorator = decorator;
        return this;
    }

    @Override
    @Contract(value="_ -> this")
    @NotNull
    public SimpleConfigBuilderImpl withDynamicGUICategoryFilter(Predicate<SimpleConfigCategory> categoryFilter) {
        this.categoryFilter = categoryFilter;
        return this;
    }

    @Override
    @Contract(value="_ -> this")
    @NotNull
    public SimpleConfigBuilderImpl withCommandRoot(LiteralArgumentBuilder<CommandSourceStack> root) {
        this.commandRoot = root;
        return this;
    }

    @Override
    protected void checkName(String name) {
        super.checkName(name);
        if (this.categories.containsKey(name)) {
            throw new IllegalArgumentException("Duplicate config entry name: " + name);
        }
    }

    @Override
    @Contract(value="-> this")
    @NotNull
    public SimpleConfigBuilderImpl restart() {
        super.restart();
        this.categories.values().forEach(AbstractSimpleConfigEntryHolderBuilder::restart);
        return this;
    }

    @Override
    protected void addEntry(int order, String name, AbstractConfigEntryBuilder<?, ?, ?, ?, ?, ?> entry) {
        this.checkName(name);
        if (this.entries.containsKey(name) || this.groups.containsKey(name) || this.categories.containsKey(name)) {
            throw new IllegalArgumentException("Duplicate name for entry: " + name);
        }
        if (this.requireRestart) {
            entry = (AbstractConfigEntryBuilder)entry.restart();
        }
        this.entries.put(name, entry);
        this.guiOrder.put(name, order);
    }

    @Override
    protected AbstractConfigEntryBuilder<?, ?, ?, ?, ?, ?> getEntry(String name) {
        return (AbstractConfigEntryBuilder)this.entries.get(name);
    }

    @Override
    protected boolean hasEntry(String name) {
        return this.entries.containsKey(name);
    }

    @Override
    public ConfigEntryHolderBuilder<?> getOrCreateHolderBuilder(String name, boolean preferCreateCategory, boolean createExpanded, int createIndex) {
        String[] split = name.split("\\.", 2);
        AbstractSimpleConfigEntryHolderBuilder sub = this.categories.get(split[0]);
        if (sub == null) {
            sub = (AbstractSimpleConfigEntryHolderBuilder)this.groups.get(split[0]);
        }
        if (sub == null) {
            if (this.entries.containsKey(split[0])) {
                throw new IllegalArgumentException("Cannot create config group \"" + split[0] + "\" as an entry with the same name already exists!");
            }
            if (preferCreateCategory) {
                CategoryBuilder c = new CategoryBuilder(split[0]);
                this.n(c, createIndex);
                sub = c;
            } else {
                GroupBuilder g = new GroupBuilder(split[0], createExpanded);
                this.n(g, createIndex);
                sub = g;
            }
        }
        return split.length == 2 ? sub.getOrCreateHolderBuilder(split[1], false, createExpanded, createIndex) : sub;
    }

    protected String translation(String name) {
        return this.modId + ".config." + this.path + "." + name;
    }

    protected String tooltip(String name) {
        return this.translation(name) + ":help";
    }

    @Override
    protected void buildTranslations(AbstractConfigEntry<?, ?, ?> entry) {
        if (entry.getTranslation() == null) {
            entry.setTranslation(this.translation(entry.name));
        }
        if (entry.getTooltipKey() == null) {
            entry.setTooltipKey(this.tooltip(entry.name));
        }
    }

    @Override
    @Contract(value="_ -> this")
    @NotNull
    public SimpleConfigBuilderImpl n(endorh.simpleconfig.api.ConfigCategoryBuilder cat) {
        return this.n(cat, 0);
    }

    @Override
    @Contract(value="_, _ -> this")
    @NotNull
    public SimpleConfigBuilderImpl n(endorh.simpleconfig.api.ConfigCategoryBuilder cat, int index) {
        if (!(cat instanceof CategoryBuilder)) {
            throw new IllegalArgumentException("Category must be a CategoryBuilder");
        }
        CategoryBuilder c = (CategoryBuilder)cat;
        this.checkName(c.name);
        this.categories.put(c.name, c);
        this.categoryOrder.put(c, index);
        c.setParent(this);
        if (this.requireRestart) {
            c.restart();
        }
        return this;
    }

    @Override
    @Contract(value="_, _ -> this")
    @NotNull
    public SimpleConfigBuilderImpl n(ConfigGroupBuilder group2, int index) {
        if (!(group2 instanceof GroupBuilder)) {
            throw new IllegalArgumentException("Group must be a GroupBuilder");
        }
        GroupBuilder g = (GroupBuilder)group2;
        this.checkName(g.name);
        this.groups.put(g.name, g);
        this.guiOrder.put(g.name, index);
        g.setParent(this.defaultCategory);
        if (this.requireRestart) {
            g.restart();
        }
        return this;
    }

    protected void preBuildHook() {
        SimpleConfigClassParser.decorateBuilder(this);
    }

    @Override
    @NotNull
    public SimpleConfigImpl buildAndRegister() {
        try {
            return this.buildAndRegister(FMLJavaModLoadingContext.get().getModEventBus());
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Cannot call SimpleConfigBuilder#buildAndRegister in non-Java mod without passing the mod event bus. Pass your mod event bus to buildAndRegister.");
        }
    }

    @ApiStatus.Internal
    @NotNull
    public SimpleConfigBuilderImpl markAsWrapper() {
        this.isWrapper = true;
        return this;
    }

    @Override
    @NotNull
    public SimpleConfigImpl buildAndRegister(@NotNull IEventBus modEventBus) {
        return this.buildAndRegister(modEventBus, new ForgeConfigSpecConfigValueBuilder());
    }

    @ApiStatus.Internal
    public SimpleConfigImpl buildAndRegister(IEventBus modEventBus, ConfigValueBuilder builder) {
        try {
            this.preBuildHook();
            if (this.type == SimpleConfig.Type.SERVER) {
                this.saver = FMLEnvironment.dist == Dist.DEDICATED_SERVER ? SimpleConfigImpl::syncToClients : SimpleConfigImpl::syncToServer;
            } else if (this.type == SimpleConfig.Type.COMMON) {
                this.saver = FMLEnvironment.dist == Dist.DEDICATED_SERVER ? SimpleConfigImpl::syncToClients : SimpleConfigImpl::checkRestart;
            } else if (FMLEnvironment.dist != Dist.DEDICATED_SERVER) {
                this.saver = SimpleConfigImpl::checkRestart;
            }
            SimpleConfigImpl config = new SimpleConfigImpl(this.modId, this.type, this.title, this.baker, this.saver, this.configClass);
            LinkedHashMap entriesByName = new LinkedHashMap();
            LinkedHashMap categoryMap = new LinkedHashMap();
            LinkedHashMap<String, SimpleConfigGroupImpl> groupMap = new LinkedHashMap<String, SimpleConfigGroupImpl>();
            this.entries.forEach((name, value) -> {
                if (builder.canBuildEntry((String)name)) {
                    Object entry = value.build(config, (String)name);
                    entriesByName.put(name, entry);
                    this.buildTranslations((AbstractConfigEntry<?, ?, ?>)entry);
                    ((AbstractConfigEntry)entry).backingField = this.getBackingField((String)name);
                    ((AbstractConfigEntry)entry).secondaryBackingFields = this.getSecondaryBackingFields((String)name);
                    builder.build((AbstractConfigEntryBuilder<?, ?, ?, ?, ?, ?>)value, (AbstractConfigEntry<?, ?, ?>)entry);
                }
            });
            SimpleConfigCategoryImpl defaultCategory = this.defaultCategory.build(config, builder, true);
            for (GroupBuilder group2 : this.groups.values()) {
                if (!builder.canBuildSection(group2.name)) continue;
                SimpleConfigGroupImpl g = group2.build(defaultCategory, builder);
                groupMap.put(group2.name, g);
            }
            this.categories.values().stream().sorted(Comparator.comparing(c -> this.categoryOrder.getOrDefault(c, 0))).forEachOrdered(c -> {
                if (builder.canBuildSection(c.name)) {
                    categoryMap.put(c.name, c.build(config, builder, false));
                }
            });
            List<SimpleConfigImpl.IGUIEntry> order = this.guiOrder.keySet().stream().sorted(Comparator.comparing(a -> this.guiOrder.getOrDefault(a, 0))).map(n -> groupMap.containsKey(n) ? (SimpleConfigImpl.IGUIEntry)groupMap.get(n) : (SimpleConfigImpl.IGUIEntry)entriesByName.get(n)).toList();
            config.build(Collections.unmodifiableMap(entriesByName), Collections.unmodifiableMap(categoryMap), Collections.unmodifiableMap(groupMap), order, builder.build(), defaultCategory.icon, defaultCategory.color, this.commandRoot);
            builder.buildModConfig(config);
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
                config.decorator = this.decorator;
                config.categoryFilter = this.categoryFilter;
                config.background = this.background;
                config.transparent = this.transparent;
                SimpleConfigGUIManagerImpl.INSTANCE.registerConfig(config);
            });
            if (modEventBus != null) {
                modEventBus.register((Object)config);
            }
            return config;
        }
        catch (RuntimeException e) {
            throw new ReportedException(CrashReport.m_127521_((Throwable)e, (String)("Building config for mod " + this.modId)));
        }
    }

    public String toString() {
        return "SimpleConfig[" + this.path + "]";
    }

    public static class CategoryBuilder
    extends AbstractSimpleConfigEntryHolderBuilder<endorh.simpleconfig.api.ConfigCategoryBuilder>
    implements endorh.simpleconfig.api.ConfigCategoryBuilder {
        protected SimpleConfigBuilderImpl parent;
        protected final String name;
        protected String title;
        @Nullable
        protected Supplier<List<Component>> description = null;
        protected Icon icon = Icon.EMPTY;
        protected int tint = 0;
        protected Class<?> configClass;
        @Nullable
        protected Consumer<SimpleConfigCategory> baker = null;
        protected String path;
        @Nullable
        protected BiConsumer<SimpleConfigCategory, ConfigCategoryBuilder> decorator;
        @Nullable
        protected ResourceLocation background;

        protected CategoryBuilder(String name) {
            this(name, null);
        }

        protected CategoryBuilder(String name, Class<?> configClass) {
            this.name = name;
            this.path = name;
            this.configClass = configClass;
        }

        protected void setParent(SimpleConfigBuilderImpl parent) {
            this.parent = parent;
            this.path = parent.path + "." + this.name;
            this.title = parent.modId + ".config." + this.path;
            for (GroupBuilder group2 : this.groups.values()) {
                group2.setParent(this);
            }
        }

        @Override
        @Contract(value="_ -> this")
        @NotNull
        public CategoryBuilder withDescription(Supplier<List<Component>> description) {
            this.description = description;
            return this;
        }

        @Override
        @Contract(value="_ -> this")
        @NotNull
        public CategoryBuilder withBaker(Consumer<SimpleConfigCategory> baker) {
            this.baker = baker;
            return this;
        }

        @Override
        @Contract(value="_ -> this")
        @NotNull
        public CategoryBuilder withBackground(String resourceName) {
            return this.withBackground(new ResourceLocation(resourceName));
        }

        @Override
        @Contract(value="_ -> this")
        @NotNull
        public CategoryBuilder withBackground(ResourceLocation background) {
            this.background = background;
            return this;
        }

        @Override
        @Contract(value="_ -> this")
        @NotNull
        public CategoryBuilder withIcon(Icon icon) {
            this.icon = icon;
            return this;
        }

        @Override
        @Contract(value="_ -> this")
        @NotNull
        public CategoryBuilder withColor(int tint) {
            this.tint = tint;
            return this;
        }

        @OnlyIn(value=Dist.CLIENT)
        @Contract(value="_ -> this")
        public CategoryBuilder withGUIDecorator(BiConsumer<SimpleConfigCategory, ConfigCategoryBuilder> decorator) {
            this.decorator = decorator;
            return this;
        }

        @Override
        protected void addEntry(int order, String name, AbstractConfigEntryBuilder<?, ?, ?, ?, ?, ?> entry) {
            this.checkName(name);
            if (this.entries.containsKey(name) || this.groups.containsKey(name)) {
                throw new IllegalArgumentException("Duplicate name for entry: " + name);
            }
            if (this.requireRestart) {
                entry = (AbstractConfigEntryBuilder)entry.restart();
            }
            this.entries.put(name, entry);
            this.guiOrder.put(name, order);
        }

        @Override
        protected AbstractConfigEntryBuilder<?, ?, ?, ?, ?, ?> getEntry(String name) {
            return (AbstractConfigEntryBuilder)this.entries.get(name);
        }

        @Override
        protected boolean hasEntry(String name) {
            return this.entries.containsKey(name);
        }

        protected String translation(String name) {
            return this.parent.modId + ".config." + this.path + "." + name;
        }

        protected String tooltip(String name) {
            return this.translation(name) + ":help";
        }

        @Override
        protected void buildTranslations(AbstractConfigEntry<?, ?, ?> entry) {
            if (entry.getTranslation() == null) {
                entry.setTranslation(this.translation(entry.name));
            }
            if (entry.getTooltipKey() == null) {
                entry.setTooltipKey(this.tooltip(entry.name));
            }
        }

        @Override
        @Contract(value="_, _ -> this")
        @NotNull
        public CategoryBuilder n(ConfigGroupBuilder group2, int index) {
            if (!(group2 instanceof GroupBuilder)) {
                throw new IllegalArgumentException("Group must be a GroupBuilder");
            }
            GroupBuilder g = (GroupBuilder)group2;
            if (this.groups.containsKey(g.name)) {
                throw new IllegalArgumentException("Duplicated config group: \"" + g.name + "\"");
            }
            this.groups.put(g.name, g);
            this.guiOrder.put(g.name, index);
            if (this.parent != null) {
                g.setParent(this);
            }
            if (this.requireRestart) {
                g.restart();
            }
            return this;
        }

        protected SimpleConfigCategoryImpl build(SimpleConfigImpl parent, ConfigValueBuilder builder, boolean isRoot) {
            if (!isRoot) {
                builder.enterSection(this.name);
            }
            SimpleConfigCategoryImpl cat = new SimpleConfigCategoryImpl(parent, this.name, this.title, isRoot, this.baker);
            LinkedHashMap<String, SimpleConfigGroupImpl> groups = new LinkedHashMap<String, SimpleConfigGroupImpl>();
            LinkedHashMap entriesByName = new LinkedHashMap();
            this.entries.forEach((name, value) -> {
                if (builder.canBuildEntry((String)name)) {
                    Object entry = value.build(cat, (String)name);
                    entriesByName.put((String)name, (AbstractConfigEntry<?, ?, ?>)entry);
                    this.buildTranslations((AbstractConfigEntry<?, ?, ?>)entry);
                    ((AbstractConfigEntry)entry).backingField = this.getBackingField((String)name);
                    ((AbstractConfigEntry)entry).secondaryBackingFields = this.getSecondaryBackingFields((String)name);
                    builder.build((AbstractConfigEntryBuilder<?, ?, ?, ?, ?, ?>)value, (AbstractConfigEntry<?, ?, ?>)entry);
                }
            });
            boolean forceExpanded = this.groups.size() == 1 && this.entries.isEmpty();
            for (GroupBuilder group2 : this.groups.values()) {
                if (forceExpanded) {
                    group2.expanded = true;
                }
                SimpleConfigGroupImpl g = group2.build(cat, builder);
                groups.put(group2.name, g);
            }
            List<SimpleConfigImpl.IGUIEntry> order = this.guiOrder.keySet().stream().sorted(Comparator.comparing(a -> this.guiOrder.getOrDefault(a, 0))).map(n -> groups.containsKey(n) ? (SimpleConfigImpl.IGUIEntry)groups.get(n) : (SimpleConfigImpl.IGUIEntry)entriesByName.get(n)).toList();
            cat.build(entriesByName, groups, order, this.description, this.icon, this.tint);
            if (!isRoot) {
                builder.exitSection();
            }
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
                cat.decorator = this.decorator;
                cat.background = this.background;
            });
            return cat;
        }

        public String toString() {
            return "Category[" + this.path + "]";
        }
    }

    public static class GroupBuilder
    extends AbstractSimpleConfigEntryHolderBuilder<ConfigGroupBuilder>
    implements ConfigGroupBuilder {
        protected CategoryBuilder category;
        protected final String name;
        protected String title;
        protected String tooltip;
        protected boolean expanded;
        @Nullable
        protected Consumer<SimpleConfigGroup> baker = null;
        protected String path;
        protected String captionName;
        protected AbstractConfigEntryBuilder<?, ?, ?, ?, ?, ?> captionBuilder = null;

        protected GroupBuilder(String name, boolean expanded) {
            this.name = name;
            this.path = name;
            this.expanded = expanded;
        }

        protected void setParent(CategoryBuilder parent) {
            this.category = parent;
            this.path = parent.path + "." + this.name;
            String modId = parent.parent.modId;
            this.title = modId + ".config." + this.path;
            this.tooltip = this.title + ":help";
            for (GroupBuilder group2 : this.groups.values()) {
                group2.setParent(this);
            }
        }

        protected void setParent(GroupBuilder parent) {
            this.category = parent.category;
            this.path = parent.path + "." + this.name;
            String modId = parent.category.parent.modId;
            this.title = modId + ".config." + this.path;
            this.tooltip = this.title + ":help";
            for (GroupBuilder group2 : this.groups.values()) {
                group2.setParent(this);
            }
        }

        @Override
        @Contract(value="_, _ -> this")
        @NotNull
        public GroupBuilder n(ConfigGroupBuilder nested, int index) {
            if (!(nested instanceof GroupBuilder)) {
                throw new IllegalArgumentException("Group must be a GroupBuilder");
            }
            GroupBuilder n = (GroupBuilder)nested;
            if (this.groups.containsKey(n.name)) {
                throw new IllegalArgumentException("Duplicated config group: \"" + n.name + "\"");
            }
            if (this.category != null) {
                n.setParent(this);
            }
            this.groups.put(n.name, n);
            this.guiOrder.put(n.name, index);
            if (this.requireRestart) {
                n.restart();
            }
            return this;
        }

        @Override
        @Contract(value="_ -> this")
        @NotNull
        public GroupBuilder withBaker(Consumer<SimpleConfigGroup> baker) {
            this.baker = baker;
            return this;
        }

        @Override
        @Contract(value="_, _ -> this")
        @NotNull
        public <V, C, G, B extends ConfigEntryBuilder<V, C, G, B> & AtomicEntryBuilder> GroupBuilder caption(String name, B entry) {
            if (this.captionBuilder != null) {
                throw new IllegalArgumentException("Attempt to declare two caption entries for the same config group: " + this.path);
            }
            if (!(entry instanceof AbstractConfigEntryBuilder)) {
                throw new IllegalArgumentException("ConfigEntryBuilder not instance of AbstractConfigEntryBuilder");
            }
            this.captionBuilder = (AbstractConfigEntryBuilder)entry;
            this.captionName = name;
            this.addEntry(0, name, this.captionBuilder);
            this.guiOrder.remove(name);
            return this;
        }

        @Override
        protected void addEntry(int order, String name, AbstractConfigEntryBuilder<?, ?, ?, ?, ?, ?> entry) {
            this.checkName(name);
            if (this.entries.containsKey(name)) {
                throw new IllegalArgumentException("Duplicate config entry name: " + name);
            }
            if (this.requireRestart) {
                entry = (AbstractConfigEntryBuilder)entry.restart();
            }
            this.entries.put(name, entry);
            this.guiOrder.put(name, order);
        }

        @Override
        protected AbstractConfigEntryBuilder<?, ?, ?, ?, ?, ?> getEntry(String name) {
            return (AbstractConfigEntryBuilder)this.entries.get(name);
        }

        @Override
        protected boolean hasEntry(String name) {
            return this.entries.containsKey(name);
        }

        protected String translation(String name) {
            return this.category.parent.modId + ".config." + this.path + "." + name;
        }

        protected String tooltip(String name) {
            return this.translation(name) + ":help";
        }

        @Override
        protected void buildTranslations(AbstractConfigEntry<?, ?, ?> entry) {
            if (entry.getTranslation() == null) {
                entry.setTranslation(this.translation(entry.name));
            }
            if (entry.getTooltipKey() == null) {
                entry.setTooltipKey(this.tooltip(entry.name));
            }
        }

        @ApiStatus.Internal
        public SimpleConfigGroupImpl build(SimpleConfigGroupImpl parent, ConfigValueBuilder builder) {
            return this.build(null, null, parent, builder);
        }

        @ApiStatus.Internal
        public SimpleConfigGroupImpl build(SimpleConfigCategoryImpl parent, ConfigValueBuilder builder) {
            return this.build(null, parent, null, builder);
        }

        @ApiStatus.Internal
        public SimpleConfigGroupImpl build(SimpleConfigImpl root, ConfigValueBuilder builder) {
            return this.build(root, null, null, builder);
        }

        @ApiStatus.Internal
        public SimpleConfigGroupImpl build(ConfigEntryHolder holder, ConfigValueBuilder builder) {
            if (holder instanceof SimpleConfigImpl) {
                return this.build((SimpleConfigImpl)holder, builder);
            }
            if (holder instanceof SimpleConfigCategoryImpl) {
                return this.build((SimpleConfigCategoryImpl)holder, builder);
            }
            if (holder instanceof SimpleConfigGroupImpl) {
                return this.build((SimpleConfigGroupImpl)holder, builder);
            }
            throw new IllegalArgumentException("ConfigEntryHolder is not instance of SimpleConfigImpl, SimpleConfigCategoryImpl, or SimpleConfigGroupImpl");
        }

        private SimpleConfigGroupImpl build(@Nullable SimpleConfigImpl root, @Nullable SimpleConfigCategoryImpl category, @Nullable SimpleConfigGroupImpl groupParent, ConfigValueBuilder builder) {
            AbstractConfigEntry<?, ?, ?> heldEntry;
            assert (root != null || category != null || groupParent != null);
            builder.enterSection(this.name);
            SimpleConfigGroupImpl group2 = category != null ? new SimpleConfigGroupImpl(category, this.name, this.title, this.tooltip, this.expanded, this.baker) : (groupParent != null ? new SimpleConfigGroupImpl(groupParent, this.name, this.title, this.tooltip, this.expanded, this.baker) : new SimpleConfigGroupImpl(root, this.name, this.title, this.tooltip, this.expanded, this.baker));
            LinkedHashMap<String, SimpleConfigGroupImpl> groupMap = new LinkedHashMap<String, SimpleConfigGroupImpl>();
            LinkedHashMap entriesByName = new LinkedHashMap();
            AbstractConfigEntry<?, ?, ?> abstractConfigEntry = heldEntry = this.captionBuilder != null ? (AbstractConfigEntry<?, ?, ?>)this.captionBuilder.build(group2, this.captionName) : null;
            if (heldEntry != null && builder.canBuildEntry(this.captionName)) {
                entriesByName.put(this.captionName, heldEntry);
                this.buildTranslations(heldEntry);
                heldEntry.backingField = this.getBackingField(this.captionName);
                heldEntry.secondaryBackingFields = this.getSecondaryBackingFields(this.captionName);
                builder.build(this.captionBuilder, heldEntry);
            }
            this.entries.forEach((name, b) -> {
                if (b == this.captionBuilder || !builder.canBuildEntry((String)name)) {
                    return;
                }
                Object entry = b.build(group2, (String)name);
                entriesByName.put((String)name, (AbstractConfigEntry<?, ?, ?>)entry);
                this.buildTranslations((AbstractConfigEntry<?, ?, ?>)entry);
                ((AbstractConfigEntry)entry).backingField = this.getBackingField((String)name);
                ((AbstractConfigEntry)entry).secondaryBackingFields = this.getSecondaryBackingFields((String)name);
                builder.build((AbstractConfigEntryBuilder<?, ?, ?, ?, ?, ?>)b, (AbstractConfigEntry<?, ?, ?>)entry);
            });
            boolean forceExpanded = this.groups.size() == 1 && this.entries.isEmpty();
            for (String name2 : this.groups.keySet()) {
                GroupBuilder b2 = (GroupBuilder)this.groups.get(name2);
                if (forceExpanded) {
                    b2.expanded = true;
                }
                if (!builder.canBuildSection(name2)) continue;
                SimpleConfigGroupImpl subGroup = b2.build(group2, builder);
                groupMap.put(name2, subGroup);
            }
            List<SimpleConfigImpl.IGUIEntry> builtOrder = this.guiOrder.keySet().stream().sorted(Comparator.comparing(a -> this.guiOrder.getOrDefault(a, 0))).map(n -> groupMap.containsKey(n) ? (SimpleConfigImpl.IGUIEntry)groupMap.get(n) : (SimpleConfigImpl.IGUIEntry)entriesByName.get(n)).toList();
            group2.build(Collections.unmodifiableMap(entriesByName), Collections.unmodifiableMap(groupMap), builtOrder, heldEntry);
            builder.exitSection();
            return group2;
        }

        public String toString() {
            return "Group[" + this.path + "]";
        }
    }

    protected static class ForgeConfigSpecConfigValueBuilder
    extends ConfigValueBuilder {
        private final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();

        protected ForgeConfigSpecConfigValueBuilder() {
        }

        @Override
        public void buildModConfig(SimpleConfigImpl config) {
            ModContainer modContainer = (ModContainer)ModList.get().getModContainerById(config.getModId()).orElseThrow(() -> new IllegalStateException("Missing mod ID for config: " + config.getModId()));
            SimpleConfigModConfig modConfig = new SimpleConfigModConfig(config, modContainer);
            config.build(modContainer, modConfig);
            modContainer.addConfig((ModConfig)modConfig);
        }

        @Override
        public void build(AbstractConfigEntryBuilder<?, ?, ?, ?, ?, ?> entryBuilder, AbstractConfigEntry<?, ?, ?> entry) {
            entry.buildConfig(this.builder);
        }

        @Override
        public void enterSection(String name) {
            this.builder.push(name);
        }

        @Override
        public void exitSection() {
            this.builder.pop();
        }

        @Override
        public Pair<ForgeConfigSpec, List<ForgeConfigSpec>> build() {
            return Pair.of((Object)this.builder.build(), Collections.emptyList());
        }
    }

    @ApiStatus.Internal
    public static abstract class ConfigValueBuilder {
        public abstract void buildModConfig(SimpleConfigImpl var1);

        public boolean canBuildEntry(String name) {
            return true;
        }

        public boolean canBuildSection(String name) {
            return true;
        }

        public abstract void build(AbstractConfigEntryBuilder<?, ?, ?, ?, ?, ?> var1, AbstractConfigEntry<?, ?, ?> var2);

        public void enterSection(String name) {
        }

        public void exitSection() {
        }

        public abstract Pair<ForgeConfigSpec, List<ForgeConfigSpec>> build();
    }
}

