/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core;

import java.util.IllegalFormatException;
import java.util.Map;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.locale.Language;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeI18n;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ServerI18n {
    public static String format(String translateKey, Object ... parameters) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            return I18n.m_118938_((String)translateKey, (Object[])parameters);
        }
        String s = ForgeI18n.getPattern((String)translateKey);
        try {
            return String.format(s, parameters);
        }
        catch (IllegalFormatException illegalformatexception) {
            return "Format error: " + s;
        }
    }

    public static boolean hasKey(String key) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            return I18n.m_118936_((String)key);
        }
        Map i18n = (Map)ObfuscationReflectionHelper.getPrivateValue(ForgeI18n.class, null, (String)"i18n");
        if (i18n == null) {
            return false;
        }
        return i18n.containsKey(key);
    }

    public static String getCurrentLanguage() {
        String KEY;
        String lang = KEY = "language.code";
        if (FMLEnvironment.dist == Dist.CLIENT) {
            lang = I18n.m_118938_((String)KEY, (Object[])new Object[0]);
        } else if (FMLEnvironment.dist == Dist.DEDICATED_SERVER) {
            lang = Language.m_128107_().m_6834_(KEY);
        }
        return KEY.equals(lang) ? "<not loaded>" : lang;
    }
}

