/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core;

import com.google.gson.internal.Primitives;
import endorh.simpleconfig.api.SimpleConfig;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ReflectionUtil {
    public static String getFieldName(Field field) {
        return field.getDeclaringClass().getName() + "#" + field.getName();
    }

    public static String getFieldTypeName(Field field) {
        return field.getGenericType().getTypeName();
    }

    public static String getMethodName(Method method) {
        return method.getDeclaringClass().getName() + "#" + method.getName();
    }

    public static String getMethodTypeName(Method method) {
        return method.getGenericReturnType().getTypeName();
    }

    public static Class<?> getTypeParameter(Method method, int index) {
        return ReflectionUtil.getTypeParameter((ParameterizedType)method.getGenericReturnType(), index);
    }

    public static Class<?> getTypeParameter(Field field, int index) {
        return ReflectionUtil.getTypeParameter((ParameterizedType)field.getGenericType(), index);
    }

    public static Class<?> getTypeParameter(ParameterizedType type, int index) {
        return (Class)type.getActualTypeArguments()[index];
    }

    public static boolean checkType(Field field, Class<?> type, Class<?> ... types) {
        return Primitives.wrap(field.getType()).equals(Primitives.wrap(type)) && (field.getGenericType() instanceof ParameterizedType ? ReflectionUtil.checkTypeParameters((ParameterizedType)field.getGenericType(), types) : types.length == 0);
    }

    public static boolean checkType(Method method, Class<?> type, Class<?> ... types) {
        return Primitives.wrap(method.getReturnType()).equals(Primitives.wrap(type)) && (method.getGenericReturnType() instanceof ParameterizedType ? ReflectionUtil.checkTypeParameters((ParameterizedType)method.getGenericReturnType(), types) : types.length == 0);
    }

    public static boolean checkTypeParameters(ParameterizedType type, Class<?> ... types) {
        return ReflectionUtil.checkTypeParameters(type, 0, types) == types.length;
    }

    private static int checkTypeParameters(ParameterizedType type, int start, Class<?> ... types) {
        Type[] actualTypes = type.getActualTypeArguments();
        int j = start;
        for (Type actual : actualTypes) {
            if (j >= types.length) {
                return -1;
            }
            if (types[j] != null) {
                if (actual instanceof Class && !types[j].equals(actual)) {
                    return -1;
                }
                if (actual instanceof ParameterizedType) {
                    if (!types[j].equals(((ParameterizedType)actual).getRawType())) {
                        return -1;
                    }
                    if ((j = ReflectionUtil.checkTypeParameters((ParameterizedType)actual, j + 1, types) - 1) < 0) {
                        return -1;
                    }
                }
            }
            ++j;
        }
        return j;
    }

    @Nullable
    public static Method tryGetMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        return ReflectionUtil.tryGetMethod(clazz, name, null, parameterTypes);
    }

    @Nullable
    public static Method tryGetMethod(Class<?> clazz, String name, String suffix, Class<?> ... parameterTypes) {
        String methodName = suffix != null ? name + "$" + suffix : name;
        try {
            Method m = clazz.getDeclaredMethod(methodName, parameterTypes);
            m.setAccessible(true);
            return m;
        }
        catch (NoSuchMethodException ignored) {
            try {
                Object[] parameterTypesAsPrimitives = (Class[])Arrays.stream(parameterTypes).map(Primitives::unwrap).toArray(Class[]::new);
                if (Arrays.equals(parameterTypesAsPrimitives, parameterTypes)) {
                    return null;
                }
                Method m = clazz.getDeclaredMethod(methodName, (Class<?>[])parameterTypesAsPrimitives);
                m.setAccessible(true);
                return m;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static <V> void setBackingField(Field field, V value) throws IllegalAccessException {
        Class type = Primitives.unwrap(field.getType());
        try {
            if (type.isPrimitive()) {
                if (type == Boolean.TYPE) {
                    field.set(null, value);
                    return;
                } else if (type == Character.TYPE) {
                    field.set(null, value);
                    return;
                } else {
                    Number n = (Number)value;
                    if (type == Byte.TYPE) {
                        field.set(null, n.byteValue());
                        return;
                    } else if (type == Short.TYPE) {
                        field.set(null, n.shortValue());
                        return;
                    } else if (type == Integer.TYPE) {
                        field.set(null, n.intValue());
                        return;
                    } else if (type == Long.TYPE) {
                        field.set(null, n.longValue());
                        return;
                    } else if (type == Float.TYPE) {
                        field.set(null, Float.valueOf(n.floatValue()));
                        return;
                    } else {
                        if (type != Double.TYPE) throw new IllegalStateException("Unknown primitive type: " + type.getTypeName());
                        field.set(null, n.doubleValue());
                    }
                }
                return;
            } else {
                field.set(null, value);
            }
            return;
        }
        catch (ClassCastException e) {
            throw new SimpleConfig.InvalidConfigValueTypeException(field.getName(), e);
        }
    }

    protected static Field getFieldOrNull(Class<?> clazz, String name) {
        try {
            Field f = clazz.getDeclaredField(name);
            f.setAccessible(true);
            return f;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    protected static <T> T getFieldValueOrNull(Object object, Field field) {
        if (field == null || object == null) {
            return null;
        }
        try {
            return (T)field.get(object);
        }
        catch (ClassCastException | IllegalAccessException e) {
            return null;
        }
    }
}

