/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core;

import java.util.Random;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class Range
extends Pair<Double, Double> {
    private final double min;
    private final double max;
    public static final Range EMPTY = new Range(1.0, -1.0);
    public static final Range UNIT = new Range(0.0, 1.0);
    public static final Range FULL = new Range(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY){

        @Override
        public double getCenter() {
            return 0.0;
        }
    };

    public static Range of(double min, double max) {
        return new Range(min, max);
    }

    public static Range of(Double min, Double max) {
        return new Range(min != null ? min : Double.NEGATIVE_INFINITY, max != null ? max : Double.POSITIVE_INFINITY);
    }

    public static Range minimum(double min) {
        return Range.of(min, Double.POSITIVE_INFINITY);
    }

    public static Range maximum(double max) {
        return Range.of(Double.NEGATIVE_INFINITY, max);
    }

    public static Range exactly(double value) {
        return Range.of(value, value);
    }

    private Range(double min, double max) {
        this.min = min;
        this.max = max;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public boolean contains(double value) {
        return this.min <= value && value <= this.max;
    }

    public boolean containsStrictly(double value) {
        return this.min < value && value < this.max;
    }

    public double randomValue(Random random) {
        if (this.min > this.max) {
            return Double.NaN;
        }
        double mn = Math.max(this.min, -1.7976931348623157E308);
        double mx = Math.min(this.max, Double.MAX_VALUE);
        return mn + random.nextDouble() * (mx - mn);
    }

    public double getSize() {
        return this.max - this.min;
    }

    public boolean isEmpty() {
        return this.min > this.max;
    }

    public double getCenter() {
        return (this.min + this.max) / 2.0;
    }

    public double getRadius() {
        return (this.max - this.min) / 2.0;
    }

    public Range intersection(Range other) {
        return Range.of(Math.max(this.min, other.min), Math.min(this.max, other.max));
    }

    @NotNull
    public Double getLeft() {
        return this.getMin();
    }

    @NotNull
    public Double getRight() {
        return this.getMax();
    }

    public Double setValue(Double value) {
        throw new UnsupportedOperationException();
    }
}

