/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core;

import com.google.common.collect.ForwardingList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PairList<K, V>
extends ForwardingList<Pair<K, V>> {
    private final List<Pair<K, V>> delegate;

    public PairList() {
        this.delegate = new ArrayList<Pair<K, V>>();
    }

    public PairList(int capacity) {
        this.delegate = new ArrayList<Pair<K, V>>(capacity);
    }

    public PairList(List<Pair<K, V>> delegate) {
        this.delegate = new ArrayList<Pair<K, V>>(delegate);
    }

    @NotNull
    protected List<Pair<K, V>> delegate() {
        return this.delegate;
    }

    public K getKey(int pos) {
        return (K)this.delegate.get(pos).getLeft();
    }

    public V getValue(int pos) {
        return (V)this.delegate.get(pos).getRight();
    }

    public List<V> get(K key) {
        return this.delegate.stream().filter(p -> Objects.equals(key, p.getKey())).map(Pair::getValue).collect(Collectors.toList());
    }

    @Nullable
    public V getFirst(K key) {
        return this.getFirstOrDefault(key, null);
    }

    public V getFirstOrDefault(K key, V def) {
        return (V)this.delegate.stream().filter(p -> Objects.equals(key, p.getKey())).map(Pair::getValue).findFirst().orElse(def);
    }

    public List<K> getKeys(V value) {
        return this.delegate.stream().filter(p -> Objects.equals(value, p.getValue())).map(Pair::getKey).collect(Collectors.toList());
    }

    @Nullable
    public K getFirstKey(V value) {
        return this.getFirstKeyOrDefault(value, null);
    }

    public K getFirstKeyOrDefault(V value, K def) {
        return (K)this.delegate.stream().filter(p -> Objects.equals(value, p.getValue())).map(Pair::getKey).findFirst().orElse(def);
    }

    public int indexOfKey(K key) {
        int i = 0;
        for (Pair<K, V> pair : this.delegate) {
            if (Objects.equals(pair.getKey(), key)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOfValue(V value) {
        int i = 0;
        for (Pair<K, V> pair : this.delegate) {
            if (Objects.equals(pair.getValue(), value)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public List<K> keyList() {
        return this.delegate.stream().map(Pair::getKey).collect(Collectors.toList());
    }

    public List<V> valueList() {
        return this.delegate.stream().map(Pair::getValue).collect(Collectors.toList());
    }

    public Map<K, V> toMap() {
        return this.delegate.stream().collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }

    public Map<K, V> toMap(BinaryOperator<V> mergeFunction) {
        return this.delegate.stream().collect(Collectors.toMap(Pair::getKey, Pair::getValue, mergeFunction));
    }

    public void forEach(BiConsumer<K, V> a) {
        for (Pair<K, V> pair : this.delegate) {
            a.accept(pair.getKey(), pair.getValue());
        }
    }
}

