/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core;

import com.google.gson.internal.Primitives;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.IntStream;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record EntryType<T>(@NotNull Class<T> type, EntryType<?> @Nullable [] args, boolean subClasses) {
    public EntryType(@NotNull Class<T> type, EntryType<?>[] args, boolean subClasses) {
        int expected;
        type = Primitives.wrap(type);
        if (args != null && args.length != (expected = type.getTypeParameters().length)) {
            throw EntryType.argumentCountMismatch(type, expected, args.length);
        }
    }

    public static <T> EntryType<T> of(Class<T> type, EntryType<?> ... args) {
        return new EntryType<T>(type, args, false);
    }

    public static <T> EntryType<T> unchecked(Class<T> type) {
        return new EntryType<T>(type, null, false);
    }

    public static <T> EntryType<T> uncheckedSubClasses(Class<T> type) {
        return new EntryType<T>(type, null, true);
    }

    public static EntryType<Object> wildcard() {
        return EntryType.uncheckedSubClasses(Object.class);
    }

    public static <T> EntryType<T> from(Class<T> type, Class<?> ... args) {
        int n = type.getTypeParameters().length;
        if (n > args.length) {
            throw EntryType.argumentCountMismatch(type, n, args.length);
        }
        EntryType[] a = new EntryType[n];
        int j = 0;
        for (int i = 0; i < n; ++i) {
            if (j > args.length) {
                throw EntryType.argumentCountMismatch(type, n, args.length);
            }
            Class<?> next = args[j];
            a[i] = EntryType.from(next, (Class[])ArrayUtils.subarray((Object[])args, (int)(i + 1), (int)args.length));
            j += 1 + a[i].parameterCount();
        }
        if (j != args.length) {
            throw EntryType.argumentCountMismatch(type, n, args.length);
        }
        return EntryType.of(type, a);
    }

    @Nullable
    public static EntryType<?> fromField(Field field) {
        return EntryType.fromType(field.getGenericType());
    }

    @Nullable
    public static EntryType<?> fromMethod(Method method) {
        return EntryType.fromType(method.getGenericReturnType());
    }

    @Nullable
    public static EntryType<?> fromType(Type type) {
        if (type instanceof Class) {
            Class cls = (Class)type;
            return EntryType.of(cls, new EntryType[0]);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType t = (ParameterizedType)type;
            if (t.getOwnerType() != null) {
                return null;
            }
            EntryType[] args = (EntryType[])Arrays.stream(t.getActualTypeArguments()).map(EntryType::fromType).toArray(EntryType[]::new);
            return EntryType.of((Class)t.getRawType(), args);
        }
        return null;
    }

    public int parameterCount() {
        return this.args != null ? this.args.length : 0;
    }

    public boolean matches(EntryType<?> other) {
        return (this.subClasses ? this.type.isAssignableFrom(other.type) : this.type.equals(other.type)) && (this.args == null || other.args == null || this.args.length == other.args.length && IntStream.range(0, this.args.length).allMatch(i -> this.args[i].matches(other.args[i])));
    }

    @Override
    public String toString() {
        if (this.args == null || this.args.length == 0) {
            return this.type.getSimpleName();
        }
        return this.type.getSimpleName() + "<" + String.join((CharSequence)", ", (CharSequence[])Arrays.stream(this.args).map(EntryType::toString).toArray(String[]::new)) + ">";
    }

    private static IllegalArgumentException argumentCountMismatch(Class<?> type, int expected, int actual) {
        return new IllegalArgumentException("Wrong number of type parameters (" + actual + ") for type " + type.getCanonicalName() + " (expected " + expected + ")");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntryType entryType = (EntryType)o;
        return this.type.equals(entryType.type) && Arrays.equals(this.args, entryType.args);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(this.type);
        result = 31 * result + Arrays.hashCode(this.args);
        return result;
    }
}

