/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core;

import endorh.simpleconfig.api.ConfigEntryBuilder;
import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.EntryTag;
import endorh.simpleconfig.api.entry.EntrySetEntryBuilder;
import endorh.simpleconfig.core.AbstractConfigEntry;
import endorh.simpleconfig.core.AbstractConfigEntryBuilder;
import endorh.simpleconfig.core.CollectionEntryHolder;
import endorh.simpleconfig.core.EntryType;
import endorh.simpleconfig.ui.api.AbstractConfigListEntry;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.EntryListFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.FieldBuilder;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntrySetEntry<V, C, G, B extends AbstractConfigEntryBuilder<V, C, G, ?, ?, B>>
extends AbstractConfigEntry<Set<V>, Set<C>, List<G>> {
    protected static final String TOOLTIP_KEY_SUFFIX = ":help";
    protected static final String SUB_ELEMENTS_KEY_SUFFIX = ":sub";
    protected Class<?> innerType;
    protected Function<V, Optional<Component>> elemErrorSupplier;
    protected boolean expand;
    protected int minSize = 0;
    protected int maxSize = Integer.MAX_VALUE;
    protected final AbstractConfigEntry<V, C, G> entry;
    protected final B entryBuilder;
    protected CollectionEntryHolder holder;

    @ApiStatus.Internal
    public EntrySetEntry(ConfigEntryHolder parent, String name, @Nullable Set<V> value, B entryBuilder) {
        super(parent, name, value);
        this.holder = new CollectionEntryHolder(parent.getRoot());
        this.entryBuilder = entryBuilder;
        this.entry = ((AbstractConfigEntryBuilder)entryBuilder).build(this.holder, name);
        if (!this.entry.canBeNested()) {
            throw new IllegalArgumentException("Entry of type " + this.entry.getClass().getSimpleName() + " can not be nested in a set entry");
        }
        if (this.translation != null) {
            this.setTranslation(this.translation);
        }
        if (this.tooltip != null) {
            this.setTooltipKey(this.tooltip);
        }
    }

    @Override
    public void setTranslation(String translation) {
        super.setTranslation(translation);
        if (translation != null) {
            this.entry.setTranslation(translation + SUB_ELEMENTS_KEY_SUFFIX);
        }
    }

    @Override
    public void setTooltipKey(String translation) {
        super.setTooltipKey(translation);
        if (this.tooltip != null) {
            if (this.tooltip.endsWith(TOOLTIP_KEY_SUFFIX)) {
                this.entry.setTooltipKey(this.tooltip.substring(0, this.tooltip.length() - TOOLTIP_KEY_SUFFIX.length()) + ":sub:help");
            } else {
                this.entry.setTooltipKey(this.tooltip + SUB_ELEMENTS_KEY_SUFFIX);
            }
        }
    }

    @Override
    public Object forActualConfig(@Nullable Set<C> value) {
        if (value == null) {
            return null;
        }
        return value.stream().map(this.entry::forActualConfig).collect(Collectors.toSet());
    }

    @Override
    @Nullable
    public Set<C> fromActualConfig(@Nullable Object value) {
        if (!(value instanceof Collection)) {
            return null;
        }
        HashSet<C> set = new HashSet<C>();
        for (Object elem : (Collection)value) {
            C c = this.entry.fromActualConfig(elem);
            if (c == null) {
                return null;
            }
            set.add(c);
        }
        return set;
    }

    @Override
    public List<G> forGui(Set<V> set) {
        return set.stream().map(this::elemForGui).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public Set<V> fromGui(@Nullable List<G> list) {
        if (list == null) {
            return null;
        }
        HashSet<V> res = new HashSet<V>();
        for (G g : list) {
            V v = this.elemFromGui(g);
            if (v == null) {
                return null;
            }
            res.add(v);
        }
        return res;
    }

    @Override
    public Set<C> forConfig(Set<V> set) {
        return set.stream().map(this::elemForConfig).collect(Collectors.toSet());
    }

    @Override
    @Nullable
    public Set<V> fromConfig(@Nullable Set<C> set) {
        if (set == null) {
            return null;
        }
        HashSet<V> res = new HashSet<V>();
        for (C c : set) {
            V v = this.elemFromConfig(c);
            if (v == null) {
                return null;
            }
            res.add(v);
        }
        return res;
    }

    protected C elemForConfig(V value) {
        return this.entry.forConfig(value);
    }

    @Nullable
    protected V elemFromConfig(C value) {
        return this.entry.fromConfig(value);
    }

    protected G elemForGui(V value) {
        return this.entry.forGui(value);
    }

    @Nullable
    protected V elemFromGui(G value) {
        return this.entry.fromGui(value);
    }

    @Override
    public boolean hasPresentation() {
        return super.hasPresentation() || this.entry.hasPresentation();
    }

    @Override
    protected Set<V> doForPresentation(Set<V> value) {
        return super.doForPresentation(value.stream().map(this.entry::forPresentation).collect(Collectors.toSet()));
    }

    @Override
    protected Set<V> doFromPresentation(Set<V> value) {
        return super.doFromPresentation(value).stream().map(this.entry::fromPresentation).collect(Collectors.toSet());
    }

    protected static Component addIndex(Component message, int index) {
        if (index < 0) {
            return message;
        }
        return message.m_6879_().m_130946_(", ").m_7220_((Component)Component.m_237110_((String)"simpleconfig.config.error.at_index", (Object[])new Object[]{Component.m_237113_((String)String.format("%d", index + 1)).m_130940_(ChatFormatting.DARK_AQUA)}));
    }

    @Override
    public List<Component> getErrorsFromGUI(List<G> value) {
        return Stream.concat(Stream.of(this.getErrorFromGUI(value)).filter(Optional::isPresent).map(Optional::get), IntStream.range(0, value.size()).boxed().flatMap(i -> this.getElementErrors((int)i, (G)value.get((int)i)).stream())).collect(Collectors.toList());
    }

    @Override
    public Optional<Component> getErrorFromGUI(List<G> value) {
        int size = value.size();
        if (size < this.minSize) {
            return Optional.of(Component.m_237110_((String)("simpleconfig.config.error.set." + (this.minSize == 1 ? "empty" : "min_size")), (Object[])new Object[]{Component.m_237113_((String)String.valueOf(this.minSize)).m_130940_(ChatFormatting.DARK_AQUA)}));
        }
        if (size > this.maxSize) {
            return Optional.of(Component.m_237110_((String)"simpleconfig.config.error.set.max_size", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(this.maxSize)).m_130940_(ChatFormatting.DARK_AQUA)}));
        }
        return super.getErrorFromGUI(value);
    }

    public Optional<Component> getElementError(int index, G value) {
        V elem = this.elemFromGui(value);
        if (elem == null) {
            return Optional.of(EntrySetEntry.addIndex((Component)Component.m_237115_((String)"simpleconfig.config.error.missing_value"), index));
        }
        return this.elemErrorSupplier.apply(elem).map(e -> EntrySetEntry.addIndex(e, index));
    }

    public List<Component> getElementErrors(int index, G value) {
        return Stream.concat(Stream.of(this.getElementError(index, value)).filter(Optional::isPresent).map(Optional::get), this.entry.getErrorsFromGUI(value).stream()).toList();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected AbstractConfigListEntry<G> buildCell(ConfigFieldBuilder builder) {
        Object e = ((AbstractConfigEntryBuilder)this.entryBuilder).build(this.holder, this.holder.nextName());
        ((AbstractConfigEntry)e).setSaver((g, h) -> {});
        ((AbstractConfigEntry)e).setDisplayName((Component)Component.m_237113_((String)"\u2022"));
        ((AbstractConfigEntry)e).nonPersistent = true;
        ((AbstractConfigEntry)e).actualValue = ((AbstractConfigEntry)e).defValue;
        AbstractConfigListEntry g2 = ((AbstractConfigEntry)e).buildGUIEntry(builder).map(FieldBuilder::build).orElseThrow(() -> new IllegalStateException("Set config entry's sub-entry did not produce a GUI entry"));
        g2.removeTag(EntryTag.NON_PERSISTENT);
        ((AbstractConfigEntry)e).setGuiEntry(g2);
        return g2;
    }

    @Override
    public List<String> getConfigCommentTooltips() {
        List<String> tooltips = super.getConfigCommentTooltips();
        String typeComment = this.entry.getConfigCommentTooltip();
        if (typeComment != null) {
            tooltips.add("Set: " + typeComment);
        }
        return tooltips;
    }

    @Override
    protected Consumer<List<G>> createSaveConsumer() {
        return super.createSaveConsumer().andThen(l -> this.holder.clear());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<FieldBuilder<List<G>, ?, ?>> buildGUIEntry(ConfigFieldBuilder builder) {
        this.holder.clear();
        EntryListFieldBuilder entryBuilder = (EntryListFieldBuilder)((EntryListFieldBuilder)((EntryListFieldBuilder)((EntryListFieldBuilder)builder.startEntryList(this.getDisplayName(), this.forGui((Set)this.get()), en -> this.buildCell(builder)).setIgnoreOrder(true).setCellErrorSupplier(this::getElementError)).setExpanded(this.expand)).setCaptionControlsEnabled(false)).setInsertInFront(false);
        return Optional.of(this.decorate(entryBuilder));
    }

    public static class Builder<V, C, G, S extends ConfigEntryBuilder<V, C, G, S>, B extends AbstractConfigEntryBuilder<V, C, G, ?, S, B>>
    extends AbstractConfigEntryBuilder<Set<V>, Set<C>, List<G>, EntrySetEntry<V, C, G, B>, EntrySetEntryBuilder<V, C, G, S>, Builder<V, C, G, S, B>>
    implements EntrySetEntryBuilder<V, C, G, S> {
        protected B builder;
        protected Class<?> innerType;
        protected Function<V, Optional<Component>> elemErrorSupplier = v -> Optional.empty();
        protected boolean expand;
        protected int minSize = 0;
        protected int maxSize = Integer.MAX_VALUE;

        public Builder(Set<V> value, ConfigEntryBuilder<V, C, G, ?> builder) {
            this(value, (AbstractConfigEntryBuilder)builder);
        }

        public Builder(Set<V> value, B builder) {
            super(new HashSet<V>(value), EntryType.of(Set.class, ((AbstractConfigEntryBuilder)builder).type));
            this.innerType = ((AbstractConfigEntryBuilder)builder).typeClass;
            this.builder = ((AbstractConfigEntryBuilder)builder).copy();
        }

        @Override
        @NotNull
        public EntrySetEntryBuilder<V, C, G, S> expand() {
            return this.expand(true);
        }

        @Override
        @NotNull
        public EntrySetEntryBuilder<V, C, G, S> expand(boolean expand) {
            Builder copy = (Builder)this.copy();
            copy.expand = true;
            return copy;
        }

        @Override
        @NotNull
        public EntrySetEntryBuilder<V, C, G, S> minSize(int minSize) {
            Builder copy = (Builder)this.copy();
            copy.minSize = minSize;
            return copy;
        }

        @Override
        @NotNull
        public EntrySetEntryBuilder<V, C, G, S> maxSize(int maxSize) {
            Builder copy = (Builder)this.copy();
            copy.maxSize = maxSize;
            return copy;
        }

        @Override
        @NotNull
        public EntrySetEntryBuilder<V, C, G, S> elemError(Function<V, Optional<Component>> errorSupplier) {
            Builder copy = (Builder)this.copy();
            copy.elemErrorSupplier = errorSupplier;
            return copy;
        }

        @Override
        protected EntrySetEntry<V, C, G, B> buildEntry(ConfigEntryHolder parent, String name) {
            EntrySetEntry entry = new EntrySetEntry(parent, name, (Set)this.value, this.builder);
            entry.innerType = this.innerType;
            entry.elemErrorSupplier = this.elemErrorSupplier;
            entry.expand = this.expand;
            entry.minSize = this.minSize;
            entry.maxSize = this.maxSize;
            return entry;
        }

        @Override
        protected Builder<V, C, G, S, B> createCopy(Set<V> value) {
            Builder<V, C, G, S, B> copy = new Builder<V, C, G, S, B>(new HashSet<V>(value), this.builder);
            copy.elemErrorSupplier = this.elemErrorSupplier;
            copy.expand = this.expand;
            copy.minSize = this.minSize;
            copy.maxSize = this.maxSize;
            return copy;
        }
    }
}

