/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigSpec;
import endorh.simpleconfig.api.AtomicEntryBuilder;
import endorh.simpleconfig.api.ConfigEntryBuilder;
import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.EntryTag;
import endorh.simpleconfig.api.entry.EntryPairListEntryBuilder;
import endorh.simpleconfig.core.AbstractConfigEntry;
import endorh.simpleconfig.core.AbstractConfigEntryBuilder;
import endorh.simpleconfig.core.AtomicEntry;
import endorh.simpleconfig.core.CollectionEntryHolder;
import endorh.simpleconfig.core.EntryType;
import endorh.simpleconfig.core.entry.AbstractListEntry;
import endorh.simpleconfig.ui.api.AbstractConfigListEntry;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.EntryPairListBuilder;
import endorh.simpleconfig.ui.impl.builders.FieldBuilder;
import endorh.simpleconfig.yaml.NonConfigMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntryPairListEntry<K, V, KC, C, KG, G, B extends AbstractConfigEntryBuilder<V, C, G, ?, ?, B>, KB extends AbstractConfigEntryBuilder<K, KC, KG, ?, ?, KB>>
extends AbstractListEntry<Pair<K, V>, Pair<KC, C>, Pair<KG, G>, EntryPairListEntry<K, V, KC, C, KG, G, B, KB>> {
    protected final KB keyEntryBuilder;
    protected final AbstractConfigEntry<K, KC, KG> keyEntry;
    protected final B entryBuilder;
    protected final AbstractConfigEntry<V, C, G> entry;
    protected final Class<?> keyEntryTypeClass;
    protected final Class<?> entryTypeClass;
    protected final CollectionEntryHolder holder;

    @ApiStatus.Internal
    public EntryPairListEntry(ConfigEntryHolder parent, String name, List<Pair<K, V>> value, @NotNull B entryBuilder, KB keyEntryBuilder) {
        super(parent, name, value);
        this.holder = new CollectionEntryHolder(parent.getRoot());
        this.entryBuilder = entryBuilder;
        this.entryTypeClass = ((AbstractConfigEntryBuilder)entryBuilder).typeClass;
        this.keyEntryBuilder = keyEntryBuilder;
        this.keyEntryTypeClass = ((AbstractConfigEntryBuilder)keyEntryBuilder).typeClass;
        this.entry = ((AbstractConfigEntryBuilder)entryBuilder).build(this.holder, name + "$ v");
        this.keyEntry = ((AbstractConfigEntryBuilder)keyEntryBuilder).build(this.holder, name + "$ k");
        if (!(this.keyEntry instanceof AtomicEntry)) {
            throw new IllegalStateException("KeyEntryBuilder created non-key entry: " + keyEntryBuilder.getClass().getCanonicalName());
        }
        if (!this.entry.canBeNested()) {
            throw new IllegalArgumentException("Entry of type " + this.entry.getClass().getSimpleName() + " can not be nested in a map entry");
        }
        if (this.entry.defValue == null) {
            throw new IllegalArgumentException("Unsupported value type for map config entry. The values cannot be null");
        }
    }

    @Override
    public boolean hasPresentation() {
        return super.hasPresentation() || this.keyEntry.hasPresentation() || this.entry.hasPresentation();
    }

    @Override
    protected List<Pair<K, V>> doForPresentation(List<Pair<K, V>> value) {
        return super.doForPresentation(value.stream().map(p -> Pair.of((Object)this.keyEntry.forPresentation(p.getLeft()), (Object)this.entry.forPresentation(p.getRight()))).collect(Collectors.toList()));
    }

    @Override
    protected List<Pair<K, V>> doFromPresentation(List<Pair<K, V>> value) {
        return super.doFromPresentation(value).stream().map(p -> Pair.of((Object)this.keyEntry.fromPresentation(p.getLeft()), (Object)this.entry.fromPresentation(p.getRight()))).collect(Collectors.toList());
    }

    public List<Map<Object, Object>> forActualConfig(@Nullable List<Pair<KC, C>> value) {
        if (value == null) {
            return null;
        }
        return value.stream().map(p -> NonConfigMap.singleton(this.keyEntry.forActualConfig(p.getKey()), this.entry.forActualConfig(p.getValue()))).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public List<Pair<KC, C>> fromActualConfig(@Nullable Object value) {
        if (value instanceof List) {
            List seq = (List)value;
            ArrayList<Pair<KC, C>> pairs = new ArrayList<Pair<KC, C>>();
            for (Object o : seq) {
                C val;
                KC key;
                Map.Entry e;
                if (o instanceof Map) {
                    Map map = (Map)o;
                    if (map.entrySet().size() != 1) {
                        return null;
                    }
                    e = (Map.Entry)map.entrySet().stream().findFirst().orElseThrow(IllegalStateException::new);
                    key = this.keyEntry.fromActualConfig(e.getKey());
                    val = this.entry.fromActualConfig(e.getValue());
                    if (key == null || val == null) {
                        return null;
                    }
                    pairs.add(Pair.of(key, val));
                    continue;
                }
                if (!(o instanceof Config)) continue;
                Config config = (Config)o;
                if (config.entrySet().size() != 1) {
                    return null;
                }
                e = (Config.Entry)config.entrySet().stream().findFirst().orElseThrow(IllegalStateException::new);
                key = this.keyEntry.fromActualConfig(e.getKey());
                val = this.entry.fromActualConfig(e.getValue());
                if (key == null || val == null) {
                    return null;
                }
                pairs.add(Pair.of(key, val));
            }
            return pairs;
        }
        return null;
    }

    @Override
    protected Pair<KG, G> elemForGui(Pair<K, V> value) {
        return Pair.of(this.keyEntry.forGui(value.getKey()), this.entry.forGui(value.getValue()));
    }

    @Override
    protected Pair<K, V> elemFromGui(Pair<KG, G> value) {
        K key = this.keyEntry.fromGui(value.getKey());
        V val = this.entry.fromGui(value.getValue());
        return key != null && val != null ? Pair.of(key, val) : null;
    }

    @Override
    protected Pair<KC, C> elemForConfig(Pair<K, V> value) {
        return Pair.of(this.keyEntry.forConfig(value.getKey()), this.entry.forConfig(value.getValue()));
    }

    @Override
    protected Pair<K, V> elemFromConfig(Pair<KC, C> value) {
        K key = this.keyEntry.fromConfig(value.getKey());
        V val = this.entry.fromConfig(value.getValue());
        return key != null && val != null ? Pair.of(key, val) : null;
    }

    @Override
    protected void buildSpec(ConfigSpec spec, String parentPath) {
        spec.define(parentPath + this.name, this.forActualConfig(this.forConfig((List)this.defValue)), this.createConfigValidator());
    }

    @OnlyIn(value=Dist.CLIENT)
    protected <KGE extends AbstractConfigListEntry<KG>> Pair<KGE, AbstractConfigListEntry<G>> buildCell(ConfigFieldBuilder builder) {
        Object ke = ((AbstractConfigEntryBuilder)this.keyEntryBuilder).build(this.holder, this.holder.nextName());
        ((AbstractConfigEntry)ke).setSaver((g, h) -> {});
        ((AbstractConfigEntry)ke).setDisplayName((Component)Component.m_237113_((String)""));
        ((AbstractConfigEntry)ke).nonPersistent = true;
        Object e = ((AbstractConfigEntryBuilder)this.entryBuilder).build(this.holder, this.holder.nextName());
        ((AbstractConfigEntry)e).setSaver((g, h) -> {});
        ((AbstractConfigEntry)e).setDisplayName((Component)Component.m_237113_((String)""));
        ((AbstractConfigEntry)e).nonPersistent = true;
        ((AbstractConfigEntry)ke).actualValue = ((AbstractConfigEntry)ke).defValue;
        ((AbstractConfigEntry)e).actualValue = ((AbstractConfigEntry)e).defValue;
        Object kg = ((FieldBuilder)((AtomicEntry)ke).buildAtomicChildGUIEntry(builder)).build();
        AbstractConfigListEntry g2 = ((AbstractConfigEntry)e).buildGUIEntry(builder).map(FieldBuilder::build).orElseThrow(() -> new IllegalStateException("Map config entry's sub-entry did not produce a GUI entry"));
        g2.removeTag(EntryTag.NON_PERSISTENT);
        ((AbstractConfigEntry)ke).setGuiEntry(kg);
        ((AbstractConfigEntry)e).setGuiEntry(g2);
        return Pair.of(kg, (Object)g2);
    }

    @Override
    public List<Component> getElementErrors(int index, Pair<KG, G> value) {
        List<Component> errors = super.getElementErrors(index, value);
        this.keyEntry.getErrorsFromGUI(value.getKey()).stream().map(e -> EntryPairListEntry.addIndex(e, index)).forEach(errors::add);
        this.entry.getErrorsFromGUI(value.getValue()).stream().map(e -> EntryPairListEntry.addIndex(e, index)).forEach(errors::add);
        return errors;
    }

    @Override
    @Nullable
    protected String getListTypeComment() {
        String keyComment = this.keyEntry.getConfigCommentTooltip();
        String valueComment = this.entry.getConfigCommentTooltip();
        return (keyComment.isEmpty() ? "?" : keyComment) + " >> " + (valueComment.isEmpty() ? "?" : valueComment);
    }

    @Override
    public List<String> getConfigCommentTooltips() {
        List<String> tooltips = super.getConfigCommentTooltips();
        tooltips.remove(tooltips.size() - 1);
        String typeComment = this.getListTypeComment();
        if (typeComment != null) {
            tooltips.add("Sorted Map: " + typeComment);
        }
        return tooltips;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<FieldBuilder<List<Pair<KG, G>>, ?, ?>> buildGUIEntry(ConfigFieldBuilder builder) {
        EntryPairListBuilder entryBuilder = (EntryPairListBuilder)((EntryPairListBuilder)builder.startEntryPairList(this.getDisplayName(), this.forGui((List)this.get()), en -> this.buildCell(builder)).setIgnoreOrder(false).setCellErrorSupplier(this::getElementError)).setExpanded(this.expand);
        return Optional.of(this.decorate(entryBuilder));
    }

    public static class Builder<K, V, KC, C, KG, G, S extends ConfigEntryBuilder<V, C, G, S>, B extends AbstractConfigEntryBuilder<V, C, G, ?, S, B>, KS extends ConfigEntryBuilder<K, KC, KG, KS> & AtomicEntryBuilder, KB extends AbstractConfigEntryBuilder<K, KC, KG, ?, KS, KB>>
    extends AbstractListEntry.Builder<Pair<K, V>, Pair<KC, C>, Pair<KG, G>, EntryPairListEntry<K, V, KC, C, KG, G, B, KB>, EntryPairListEntryBuilder<K, V, KC, C, KG, G, S, KS>, Builder<K, V, KC, C, KG, G, S, B, KS, KB>>
    implements EntryPairListEntryBuilder<K, V, KC, C, KG, G, S, KS> {
        protected final KB keyEntryBuilder;
        protected B entryBuilder;

        public <KBB extends ConfigEntryBuilder<K, KC, KG, KBB> & AtomicEntryBuilder> Builder(List<Pair<K, V>> value, KBB keyEntryBuilder, ConfigEntryBuilder<V, C, G, ?> entryBuilder) {
            this(value, (AbstractConfigEntryBuilder)keyEntryBuilder, (AbstractConfigEntryBuilder)entryBuilder);
        }

        public Builder(List<Pair<K, V>> value, KB keyEntryBuilder, B entryBuilder) {
            super(value, EntryType.of(Pair.class, Builder.getEntryType(keyEntryBuilder), Builder.getEntryType(entryBuilder)));
            this.entryBuilder = entryBuilder;
            this.keyEntryBuilder = keyEntryBuilder;
        }

        @Override
        protected EntryPairListEntry<K, V, KC, C, KG, G, B, KB> buildEntry(ConfigEntryHolder parent, String name) {
            return new EntryPairListEntry(parent, name, (List)this.value, this.entryBuilder, this.keyEntryBuilder);
        }

        @Override
        protected Builder<K, V, KC, C, KG, G, S, B, KS, KB> createCopy(List<Pair<K, V>> value) {
            return new Builder((List)value.stream().map(Pair::of).collect(Collectors.toCollection(ArrayList::new)), ((AbstractConfigEntryBuilder)this.keyEntryBuilder).copy(), ((AbstractConfigEntryBuilder)this.entryBuilder).copy());
        }
    }
}

