/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigSpec;
import endorh.simpleconfig.api.AtomicEntryBuilder;
import endorh.simpleconfig.api.ConfigEntryBuilder;
import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.EntryTag;
import endorh.simpleconfig.api.entry.EntryMapEntryBuilder;
import endorh.simpleconfig.core.AbstractConfigEntry;
import endorh.simpleconfig.core.AbstractConfigEntryBuilder;
import endorh.simpleconfig.core.AtomicEntry;
import endorh.simpleconfig.core.CollectionEntryHolder;
import endorh.simpleconfig.core.EntryType;
import endorh.simpleconfig.ui.api.AbstractConfigListEntry;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.EntryPairListBuilder;
import endorh.simpleconfig.ui.impl.builders.FieldBuilder;
import endorh.simpleconfig.yaml.NonConfigMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntryMapEntry<K, V, KC, C, KG, G, B extends AbstractConfigEntryBuilder<V, C, G, ?, ?, B>, KB extends AbstractConfigEntryBuilder<K, KC, KG, ?, ?, KB>>
extends AbstractConfigEntry<Map<K, V>, Map<KC, C>, List<Pair<KG, G>>> {
    protected final KB keyEntryBuilder;
    protected final AbstractConfigEntry<K, KC, KG> keyEntry;
    protected final B entryBuilder;
    protected final AbstractConfigEntry<V, C, G> entry;
    @Nullable
    protected List<Pair<KG, G>> guiCache;
    protected final Class<?> keyEntryTypeClass;
    protected final Class<?> entryTypeClass;
    protected final CollectionEntryHolder holder;
    protected BiFunction<K, V, Optional<Component>> elemErrorSupplier = (k, v) -> Optional.empty();
    protected int minSize = 0;
    protected int maxSize = Integer.MAX_VALUE;
    protected boolean expand;
    protected boolean linked;

    @ApiStatus.Internal
    public EntryMapEntry(ConfigEntryHolder parent, String name, Map<K, V> value, @NotNull B entryBuilder, KB keyEntryBuilder) {
        super(parent, name, value);
        this.holder = new CollectionEntryHolder(parent.getRoot());
        this.entryBuilder = entryBuilder;
        this.entryTypeClass = ((AbstractConfigEntryBuilder)entryBuilder).typeClass;
        this.keyEntryBuilder = keyEntryBuilder;
        this.keyEntryTypeClass = ((AbstractConfigEntryBuilder)keyEntryBuilder).typeClass;
        this.entry = ((AbstractConfigEntryBuilder)entryBuilder).build(this.holder, name + "$ v");
        this.keyEntry = ((AbstractConfigEntryBuilder)keyEntryBuilder).build(this.holder, name + "$ k");
        if (!(this.keyEntry instanceof AtomicEntry)) {
            throw new IllegalStateException("KeyEntryBuilder created a non-key entry: " + keyEntryBuilder.getClass().getCanonicalName());
        }
        if (!this.entry.canBeNested()) {
            throw new IllegalArgumentException("Entry of type " + this.entry.getClass().getSimpleName() + " can not be nested in a map entry");
        }
        if (this.entry.defValue == null) {
            throw new IllegalArgumentException("Unsupported value type for map config entry. The values cannot be null");
        }
    }

    @Override
    public Object forActualConfig(@Nullable Map<KC, C> value) {
        if (value == null) {
            return null;
        }
        if (this.linked) {
            ArrayList list = new ArrayList();
            value.forEach((k, v) -> list.add(NonConfigMap.singleton(this.keyEntry.forActualConfig(k), this.entry.forActualConfig(v))));
            return list;
        }
        NonConfigMap map = NonConfigMap.ofHashMap(value.size());
        value.forEach((k, v) -> map.put(this.keyEntry.forActualConfig(k), this.entry.forActualConfig(v)));
        return map;
    }

    @Override
    @Nullable
    public Map<KC, C> fromActualConfig(@Nullable Object value) {
        if (value instanceof List) {
            List seq = (List)value;
            LinkedHashMap<KC, C> map = new LinkedHashMap<KC, C>();
            for (Object o : seq) {
                C val;
                KC key;
                Map.Entry e;
                if (o instanceof Map) {
                    Map mm = (Map)o;
                    if (mm.entrySet().size() != 1) {
                        return null;
                    }
                    e = (Map.Entry)mm.entrySet().stream().findFirst().orElseThrow(IllegalStateException::new);
                    key = this.keyEntry.fromActualConfig(e.getKey());
                    val = this.entry.fromActualConfig(e.getValue());
                    if (key == null || val == null) {
                        return null;
                    }
                    map.put(key, val);
                    continue;
                }
                if (!(o instanceof Config)) continue;
                Config config = (Config)o;
                if (config.entrySet().size() != 1) {
                    return null;
                }
                e = (Config.Entry)config.entrySet().stream().findFirst().orElseThrow(IllegalStateException::new);
                key = this.keyEntry.fromActualConfig(e.getKey());
                val = this.entry.fromActualConfig(e.getValue());
                if (key == null || val == null) {
                    return null;
                }
                map.put(key, val);
            }
            return map;
        }
        if (value instanceof Config) {
            LinkedHashMap<KC, C> map = new LinkedHashMap<KC, C>();
            for (CommentedConfig.Entry e : ((CommentedConfig)value).entrySet()) {
                KC key = this.keyEntry.fromActualConfig(e.getKey());
                C val = this.entry.fromActualConfig(e.getValue());
                if (key == null || val == null) {
                    return null;
                }
                map.put(key, val);
            }
            return map;
        }
        if (value instanceof Map) {
            LinkedHashMap<KC, C> map = new LinkedHashMap<KC, C>();
            for (Map.Entry e : ((Map)value).entrySet()) {
                KC key = this.keyEntry.fromActualConfig(e.getKey());
                C val = this.entry.fromActualConfig(e.getValue());
                if (key == null || val == null) {
                    return null;
                }
                map.put(key, val);
            }
            return map;
        }
        return null;
    }

    @Override
    public Map<KC, C> forConfig(Map<K, V> value) {
        LinkedHashMap<KC, C> m = new LinkedHashMap<KC, C>();
        for (Map.Entry<K, V> e : value.entrySet()) {
            m.put(this.keyEntry.forConfig(e.getKey()), this.entry.forConfig(e.getValue()));
        }
        return m;
    }

    @Override
    @Nullable
    @Contract(value="null->null")
    public Map<K, V> fromConfig(@Nullable Map<KC, C> value) {
        if (value == null) {
            return null;
        }
        List<Pair> pairs = value.entrySet().stream().map(e -> Pair.of(this.keyEntry.fromConfig(e.getKey()), this.entry.fromConfig(e.getValue()))).toList();
        if (pairs.stream().anyMatch(p -> p.getLeft() == null || p.getRight() == null)) {
            return null;
        }
        LinkedHashMap m = new LinkedHashMap();
        pairs.forEach(p -> m.put(p.getKey(), p.getValue()));
        return m;
    }

    @Override
    public boolean hasPresentation() {
        return super.hasPresentation() || this.keyEntry.hasPresentation() || this.entry.hasPresentation();
    }

    @Override
    protected Map<K, V> doForPresentation(Map<K, V> value) {
        Map mapped = value.entrySet().stream().collect(Collectors.toMap(e -> this.keyEntry.forPresentation(e.getKey()), e -> this.entry.forPresentation(e.getValue()), (a, b) -> b, LinkedHashMap::new));
        return super.doForPresentation(mapped);
    }

    @Override
    protected Map<K, V> doFromPresentation(Map<K, V> value) {
        value = super.doFromPresentation(value);
        return value.entrySet().stream().collect(Collectors.toMap(e -> this.keyEntry.fromPresentation(e.getKey()), e -> this.entry.fromPresentation(e.getValue()), (a, b) -> b, LinkedHashMap::new));
    }

    @Override
    public List<Pair<KG, G>> forGui(Map<K, V> value) {
        return value.entrySet().stream().map(e -> Pair.of(this.keyEntry.forGui(e.getKey()), this.entry.forGui(e.getValue()))).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public Map<K, V> fromGui(@Nullable List<Pair<KG, G>> value) {
        if (value == null) {
            return null;
        }
        List<Pair> pairs = value.stream().map(e -> Pair.of(this.keyEntry.fromGui(e.getKey()), this.entry.fromGui(e.getValue()))).toList();
        if (pairs.stream().anyMatch(e -> e.getKey() == null || e.getValue() == null)) {
            return null;
        }
        return pairs.stream().collect(Collectors.toMap(Pair::getKey, Pair::getValue, (a, b) -> b, LinkedHashMap::new));
    }

    @Nullable
    protected String getMapTypeComment() {
        String keyComment = this.keyEntry.getConfigCommentTooltip();
        String valueComment = this.entry.getConfigCommentTooltip();
        return (keyComment.isEmpty() ? "?" : keyComment) + " >> " + (valueComment.isEmpty() ? "?" : valueComment);
    }

    @Override
    public List<String> getConfigCommentTooltips() {
        List<String> tooltips = super.getConfigCommentTooltips();
        String typeComment = this.getMapTypeComment();
        if (typeComment != null) {
            tooltips.add((this.linked ? "Sorted Map: " : "Map: ") + typeComment);
        }
        return tooltips;
    }

    @Override
    protected void buildSpec(ConfigSpec spec, String parentPath) {
        spec.define(parentPath + this.name, this.forActualConfig(this.forConfig((Map)this.defValue)), this.createConfigValidator());
    }

    @OnlyIn(value=Dist.CLIENT)
    protected <KGE extends AbstractConfigListEntry<KG>> Pair<KGE, AbstractConfigListEntry<G>> buildCell(ConfigFieldBuilder builder) {
        Object ke = ((AbstractConfigEntryBuilder)this.keyEntryBuilder).build(this.holder, this.holder.nextName());
        ((AbstractConfigEntry)ke).setSaver((g, h) -> {});
        ((AbstractConfigEntry)ke).setDisplayName((Component)Component.m_237113_((String)""));
        ((AbstractConfigEntry)ke).nonPersistent = true;
        Object e = ((AbstractConfigEntryBuilder)this.entryBuilder).build(this.holder, this.holder.nextName());
        ((AbstractConfigEntry)e).setSaver((g, h) -> {});
        ((AbstractConfigEntry)e).setDisplayName((Component)Component.m_237113_((String)""));
        ((AbstractConfigEntry)e).nonPersistent = true;
        ((AbstractConfigEntry)ke).actualValue = ((AbstractConfigEntry)ke).defValue;
        ((AbstractConfigEntry)e).actualValue = ((AbstractConfigEntry)e).defValue;
        Object kg = ((FieldBuilder)((AtomicEntry)ke).buildAtomicChildGUIEntry(builder)).build();
        AbstractConfigListEntry g2 = ((AbstractConfigEntry)e).buildGUIEntry(builder).map(FieldBuilder::build).orElseThrow(() -> new IllegalStateException("Map config entry's sub-entry did not produce a GUI entry"));
        g2.removeTag(EntryTag.NON_PERSISTENT);
        ((AbstractConfigEntry)ke).setGuiEntry(kg);
        ((AbstractConfigEntry)e).setGuiEntry(g2);
        return Pair.of(kg, (Object)g2);
    }

    @Override
    public Optional<Component> getErrorFromGUI(List<Pair<KG, G>> value) {
        if (value.size() < this.minSize) {
            return Optional.of(Component.m_237110_((String)("simpleconfig.config.error.list." + (this.minSize == 1 ? "empty" : "min_size")), (Object[])new Object[]{EntryMapEntry.coloredNumber(this.minSize)}));
        }
        if (value.size() > this.maxSize) {
            return Optional.of(Component.m_237110_((String)"simpleconfig.config.error.list.max_size", (Object[])new Object[]{EntryMapEntry.coloredNumber(this.maxSize)}));
        }
        return super.getErrorFromGUI(value);
    }

    protected static MutableComponent coloredNumber(int minSize) {
        return Component.m_237113_((String)String.valueOf(minSize)).m_130940_(ChatFormatting.DARK_AQUA);
    }

    @Override
    public List<Component> getErrorsFromGUI(List<Pair<KG, G>> value) {
        return Stream.concat(Stream.of(this.getErrorFromGUI(value), this.getDuplicateError(value)).filter(Optional::isPresent).map(Optional::get), value.stream().flatMap(p -> this.getElementErrors((Pair<KG, G>)p).stream())).collect(Collectors.toList());
    }

    protected Optional<Component> getDuplicateError(List<Pair<KG, G>> value) {
        HashSet<Object> set = new HashSet<Object>();
        for (Pair<KG, G> pair : value) {
            Object key = pair.getKey();
            if (set.add(key)) continue;
            return Optional.of(Component.m_237110_((String)"simpleconfig.config.error.duplicate_key", (Object[])new Object[]{key}));
        }
        return Optional.empty();
    }

    public Optional<Component> getCellError(int index, Pair<KG, G> p) {
        K key = this.keyEntry.fromGui(p.getKey());
        V value = this.entry.fromGui(p.getValue());
        if (key == null || value == null) {
            return Optional.of(Component.m_237115_((String)"simpleconfig.config.error.missing_value"));
        }
        return this.elemErrorSupplier.apply(key, value);
    }

    public List<Optional<Component>> getMultiCellError(List<Pair<KG, G>> gui) {
        Map<Object, List> groups = IntStream.range(0, gui.size()).mapToObj(i -> Pair.of(this.keyEntry.fromGui(((Pair)gui.get(i)).getKey()), (Object)i)).collect(Collectors.toMap(Pair::getKey, p -> Collections.singletonList((Integer)p.getValue()), (a, b) -> {
            ArrayList indices = new ArrayList(a);
            indices.addAll(b);
            return indices;
        }));
        List<Optional<Component>> errors = gui.stream().map(p -> Optional.empty()).collect(Collectors.toList());
        groups.values().stream().filter(l -> l.size() > 1).forEach(g -> g.forEach(i -> errors.set((int)i, Optional.of(Component.m_237110_((String)"simpleconfig.config.error.duplicate_key", (Object[])new Object[]{((Pair)gui.get((int)i)).getKey()})))));
        return errors;
    }

    public List<Component> getElementErrors(Pair<KG, G> p) {
        List<Component> errors = this.keyEntry.getErrorsFromGUI(p.getKey());
        errors.addAll(this.entry.getErrorsFromGUI(p.getValue()));
        return errors;
    }

    @Override
    protected Consumer<List<Pair<KG, G>>> createSaveConsumer() {
        return super.createSaveConsumer().andThen(g -> {
            this.guiCache = g;
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<FieldBuilder<List<Pair<KG, G>>, ?, ?>> buildGUIEntry(ConfigFieldBuilder builder) {
        List<Object> guiValue = this.forGui((Map)this.get());
        if (this.guiCache != null && Objects.equals(this.fromGui(guiValue), this.fromGui(this.guiCache))) {
            guiValue = this.guiCache;
        }
        EntryPairListBuilder entryBuilder = (EntryPairListBuilder)((EntryPairListBuilder)((EntryPairListBuilder)builder.startEntryPairList(this.getDisplayName(), guiValue, en -> this.buildCell(builder)).setIgnoreOrder(!this.linked).setCellErrorSupplier(this::getCellError)).setMultiCellErrorSupplier(this::getMultiCellError)).setExpanded(this.expand);
        return Optional.of(this.decorate(entryBuilder));
    }

    public static class Builder<K, V, KC, C, KG, G, S extends ConfigEntryBuilder<V, C, G, S>, B extends AbstractConfigEntryBuilder<V, C, G, ?, S, B>, KS extends ConfigEntryBuilder<K, KC, KG, KS> & AtomicEntryBuilder, KB extends AbstractConfigEntryBuilder<K, KC, KG, ?, KS, KB>>
    extends AbstractConfigEntryBuilder<Map<K, V>, Map<KC, C>, List<Pair<KG, G>>, EntryMapEntry<K, V, KC, C, KG, G, B, KB>, EntryMapEntryBuilder<K, V, KC, C, KG, G, S, KS>, Builder<K, V, KC, C, KG, G, S, B, KS, KB>>
    implements EntryMapEntryBuilder<K, V, KC, C, KG, G, S, KS> {
        protected final KB keyEntryBuilder;
        protected B entryBuilder;
        protected boolean expand;
        protected boolean linked;
        protected BiFunction<K, V, Optional<Component>> elemErrorSupplier = (k, v) -> Optional.empty();
        protected int minSize = 0;
        protected int maxSize = Integer.MAX_VALUE;

        public <KBB extends ConfigEntryBuilder<K, KC, KG, KBB> & AtomicEntryBuilder> Builder(Map<K, V> value, KBB keyEntryBuilder, ConfigEntryBuilder<V, C, G, ?> entryBuilder) {
            this(value, (AbstractConfigEntryBuilder)keyEntryBuilder, (AbstractConfigEntryBuilder)entryBuilder);
        }

        public Builder(Map<K, V> value, KB keyEntryBuilder, B entryBuilder) {
            super(new LinkedHashMap<K, V>(value), EntryType.of(Map.class, ((AbstractConfigEntryBuilder)keyEntryBuilder).type, ((AbstractConfigEntryBuilder)entryBuilder).type));
            this.entryBuilder = ((AbstractConfigEntryBuilder)entryBuilder).copy();
            this.keyEntryBuilder = ((AbstractConfigEntryBuilder)keyEntryBuilder).copy();
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Builder<K, V, KC, C, KG, G, S, B, KS, KB> expand() {
            return this.expand(true);
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Builder<K, V, KC, C, KG, G, S, B, KS, KB> expand(boolean expand) {
            Builder copy = (Builder)this.copy();
            copy.expand = expand;
            return copy;
        }

        @Contract(pure=true)
        @NotNull
        public Builder<K, V, KC, C, KG, G, S, B, KS, KB> linked() {
            return this.linked(true);
        }

        @Contract(pure=true)
        @NotNull
        public Builder<K, V, KC, C, KG, G, S, B, KS, KB> linked(boolean linked) {
            Builder copy = (Builder)this.copy();
            copy.linked = linked;
            return copy;
        }

        @Contract(pure=true)
        @NotNull
        public Builder<K, V, KC, C, KG, G, S, B, KS, KB> entryError(BiFunction<K, V, Optional<Component>> supplier) {
            Builder copy = (Builder)this.copy();
            copy.elemErrorSupplier = supplier;
            return copy;
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Builder<K, V, KC, C, KG, G, S, B, KS, KB> minSize(int minSize) {
            Builder copy = (Builder)this.copy();
            copy.minSize = minSize;
            return copy;
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Builder<K, V, KC, C, KG, G, S, B, KS, KB> maxSize(int maxSize) {
            Builder copy = (Builder)this.copy();
            copy.maxSize = maxSize;
            return copy;
        }

        @Override
        protected EntryMapEntry<K, V, KC, C, KG, G, B, KB> buildEntry(ConfigEntryHolder parent, String name) {
            EntryMapEntry e = new EntryMapEntry(parent, name, new LinkedHashMap((Map)this.value), this.entryBuilder, this.keyEntryBuilder);
            e.expand = this.expand;
            e.linked = this.linked;
            e.elemErrorSupplier = this.elemErrorSupplier;
            e.minSize = this.minSize;
            e.maxSize = this.maxSize;
            return e;
        }

        @Override
        @Contract(value="_ -> new", pure=true)
        protected Builder<K, V, KC, C, KG, G, S, B, KS, KB> createCopy(Map<K, V> value) {
            Builder<K, V, KC, C, KG, G, S, B, KS, KB> copy = new Builder<K, V, KC, C, KG, G, S, B, KS, KB>(new LinkedHashMap<K, V>(value), this.keyEntryBuilder, this.entryBuilder);
            copy.expand = this.expand;
            copy.linked = this.linked;
            copy.elemErrorSupplier = this.elemErrorSupplier;
            copy.minSize = this.minSize;
            copy.maxSize = this.maxSize;
            return copy;
        }
    }
}

