/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core;

import endorh.simpleconfig.api.ConfigEntryBuilder;
import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.EntryTag;
import endorh.simpleconfig.api.entry.EntryListEntryBuilder;
import endorh.simpleconfig.core.AbstractConfigEntry;
import endorh.simpleconfig.core.AbstractConfigEntryBuilder;
import endorh.simpleconfig.core.CollectionEntryHolder;
import endorh.simpleconfig.core.entry.AbstractListEntry;
import endorh.simpleconfig.ui.api.AbstractConfigListEntry;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.EntryListFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.FieldBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class EntryListEntry<V, C, G, B extends AbstractConfigEntryBuilder<V, C, G, ?, ?, B>>
extends AbstractListEntry<V, C, G, EntryListEntry<V, C, G, B>> {
    protected static final String TOOLTIP_KEY_SUFFIX = ":help";
    protected static final String SUB_ELEMENTS_KEY_SUFFIX = ":sub";
    protected final AbstractConfigEntry<V, C, G> entry;
    protected final B entryBuilder;
    protected CollectionEntryHolder holder;

    @ApiStatus.Internal
    public EntryListEntry(ConfigEntryHolder parent, String name, @Nullable List<V> value, B entryBuilder) {
        super(parent, name, value);
        this.holder = new CollectionEntryHolder(parent.getRoot());
        this.entryBuilder = entryBuilder;
        this.entry = ((AbstractConfigEntryBuilder)entryBuilder).build(this.holder, name);
        if (!this.entry.canBeNested()) {
            throw new IllegalArgumentException("Entry of type " + this.entry.getClass().getSimpleName() + " can not be nested in a list entry");
        }
        if (this.translation != null) {
            this.setTranslation(this.translation);
        }
        if (this.tooltip != null) {
            this.setTooltipKey(this.tooltip);
        }
    }

    @Override
    public void setTranslation(String translation) {
        super.setTranslation(translation);
        if (translation != null) {
            this.entry.setTranslation(translation + SUB_ELEMENTS_KEY_SUFFIX);
        }
    }

    @Override
    public void setTooltipKey(String translation) {
        super.setTooltipKey(translation);
        if (this.tooltip != null) {
            if (this.tooltip.endsWith(TOOLTIP_KEY_SUFFIX)) {
                this.entry.setTooltipKey(this.tooltip.substring(0, this.tooltip.length() - TOOLTIP_KEY_SUFFIX.length()) + ":sub:help");
            } else {
                this.entry.setTooltipKey(this.tooltip + SUB_ELEMENTS_KEY_SUFFIX);
            }
        }
    }

    @Override
    public Object forActualConfig(@Nullable List<C> value) {
        if (value == null) {
            return null;
        }
        return value.stream().map(this.entry::forActualConfig).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public List<C> fromActualConfig(@Nullable Object value) {
        if (!(value instanceof List)) {
            return null;
        }
        ArrayList<C> list = new ArrayList<C>();
        for (Object elem : (List)value) {
            C c = this.entry.fromActualConfig(elem);
            if (c == null) {
                return null;
            }
            list.add(c);
        }
        return list;
    }

    @Override
    protected C elemForConfig(V value) {
        return this.entry.forConfig(value);
    }

    @Override
    @Nullable
    protected V elemFromConfig(C value) {
        return this.entry.fromConfig(value);
    }

    @Override
    protected G elemForGui(V value) {
        return this.entry.forGui(value);
    }

    @Override
    @Nullable
    protected V elemFromGui(G value) {
        return this.entry.fromGui(value);
    }

    @Override
    public boolean hasPresentation() {
        return super.hasPresentation() || this.entry.hasPresentation();
    }

    @Override
    protected List<V> doForPresentation(List<V> value) {
        return super.doForPresentation(value.stream().map(this.entry::forPresentation).collect(Collectors.toList()));
    }

    @Override
    protected List<V> doFromPresentation(List<V> value) {
        return super.doFromPresentation(value).stream().map(this.entry::fromPresentation).collect(Collectors.toList());
    }

    @Override
    public List<Component> getElementErrors(int index, G value) {
        List<Component> errors = super.getElementErrors(index, value);
        this.entry.getErrorsFromGUI(value).stream().map(e -> EntryListEntry.addIndex(e, index)).forEach(errors::add);
        return errors;
    }

    @Override
    @Nullable
    protected String getListTypeComment() {
        return this.entry.getConfigCommentTooltip();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected AbstractConfigListEntry<G> buildCell(ConfigFieldBuilder builder) {
        Object e = ((AbstractConfigEntryBuilder)this.entryBuilder).build(this.holder, this.holder.nextName());
        ((AbstractConfigEntry)e).setSaver((g, h) -> {});
        ((AbstractConfigEntry)e).setDisplayName((Component)Component.m_237113_((String)"\u2022"));
        ((AbstractConfigEntry)e).nonPersistent = true;
        ((AbstractConfigEntry)e).actualValue = ((AbstractConfigEntry)e).defValue;
        AbstractConfigListEntry g2 = ((AbstractConfigEntry)e).buildGUIEntry(builder).map(FieldBuilder::build).orElseThrow(() -> new IllegalStateException("List config entry's sub-entry did not produce a GUI entry"));
        g2.removeTag(EntryTag.NON_PERSISTENT);
        ((AbstractConfigEntry)e).setGuiEntry(g2);
        return g2;
    }

    @Override
    protected Consumer<List<G>> createSaveConsumer() {
        return super.createSaveConsumer().andThen(l -> this.holder.clear());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<FieldBuilder<List<G>, ?, ?>> buildGUIEntry(ConfigFieldBuilder builder) {
        this.holder.clear();
        EntryListFieldBuilder valBuilder = builder.startEntryList(this.getDisplayName(), this.forGui((List)this.get()), en -> this.buildCell(builder));
        return Optional.of(this.decorate(valBuilder));
    }

    public static class Builder<V, C, G, S extends ConfigEntryBuilder<V, C, G, S>, B extends AbstractConfigEntryBuilder<V, C, G, ?, S, B>>
    extends AbstractListEntry.Builder<V, C, G, EntryListEntry<V, C, G, B>, EntryListEntryBuilder<V, C, G, S>, Builder<V, C, G, S, B>>
    implements EntryListEntryBuilder<V, C, G, S> {
        protected B builder;

        public Builder(List<V> value, ConfigEntryBuilder<V, C, G, ?> builder) {
            this(value, (AbstractConfigEntryBuilder)builder);
        }

        public Builder(List<V> value, B builder) {
            super(new ArrayList<V>(value), Builder.getEntryType(builder));
            this.builder = ((AbstractConfigEntryBuilder)builder).copy();
        }

        @Override
        protected EntryListEntry<V, C, G, B> buildEntry(ConfigEntryHolder parent, String name) {
            return new EntryListEntry(parent, name, (List)this.value, this.builder);
        }

        @Override
        protected Builder<V, C, G, S, B> createCopy(List<V> value) {
            return new Builder<V, C, G, S, B>(new ArrayList<V>(value), this.builder);
        }
    }
}

