/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core;

import endorh.simpleconfig.api.AtomicEntryBuilder;
import endorh.simpleconfig.api.ConfigEntryBuilder;
import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.entry.EntryButtonEntryBuilder;
import endorh.simpleconfig.core.AbstractConfigEntry;
import endorh.simpleconfig.core.AbstractConfigEntryBuilder;
import endorh.simpleconfig.core.AtomicEntry;
import endorh.simpleconfig.core.DummyEntryHolder;
import endorh.simpleconfig.core.entry.GUIOnlyEntry;
import endorh.simpleconfig.ui.api.AbstractConfigListEntry;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.EntryButtonFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.FieldBuilder;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntryButtonEntry<V, Gui>
extends GUIOnlyEntry<V, Gui, EntryButtonEntry<V, Gui>> {
    protected AbstractConfigEntry<V, ?, Gui> inner;
    protected BiConsumer<V, ConfigEntryHolder> action;
    protected Supplier<Component> buttonLabelSupplier;

    public EntryButtonEntry(ConfigEntryHolder parent, String name, AbstractConfigEntry<V, ?, Gui> inner, V value, BiConsumer<V, ConfigEntryHolder> action, Class<?> typeClass) {
        super(parent, name, value, false, typeClass);
        if (!(inner instanceof AtomicEntry)) {
            throw new IllegalArgumentException("Inner entry must be a key entry");
        }
        this.inner = inner;
        this.action = action;
    }

    protected <E extends AbstractConfigEntry<V, ?, Gui>> E getInner() {
        return (E)this.inner;
    }

    @Override
    public Gui forGui(V value) {
        return this.inner.forGui(value);
    }

    @Override
    @Nullable
    public V fromGui(@Nullable Gui value) {
        return this.inner.fromGui(value);
    }

    @Override
    public boolean hasPresentation() {
        return super.hasPresentation() || this.inner.hasPresentation();
    }

    @Override
    protected V doForPresentation(V value) {
        return super.doForPresentation(this.inner.forPresentation(value));
    }

    @Override
    protected V doFromPresentation(V value) {
        return this.inner.fromPresentation(super.doFromPresentation(value));
    }

    public <E extends AbstractConfigListEntry<Gui>, B extends FieldBuilder<Gui, E, B>> EntryButtonFieldBuilder<Gui, E, B> makeGUIEntry(ConfigFieldBuilder builder, FieldBuilder<Gui, ?, ?> entryBuilder, Consumer<Gui> action) {
        return builder.startButton(this.getDisplayName(), entryBuilder, action);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<FieldBuilder<Gui, ?, ?>> buildGUIEntry(ConfigFieldBuilder builder) {
        EntryButtonFieldBuilder entryBuilder = (EntryButtonFieldBuilder)this.makeGUIEntry(builder, (FieldBuilder<Gui, ?, ?>)((AtomicEntry)this.getInner()).buildAtomicChildGUIEntry(builder), (Consumer<Gui>)((Consumer<Object>)g -> this.action.accept(this.fromGuiOrDefault(g), this.parent))).withButtonLabel(this.buttonLabelSupplier).setIgnoreEdits(true);
        return Optional.of(entryBuilder);
    }

    public static class Builder<V, Gui, S extends ConfigEntryBuilder<V, ?, Gui, S> & AtomicEntryBuilder, B extends AbstractConfigEntryBuilder<V, ?, Gui, ?, S, B>>
    extends GUIOnlyEntry.Builder<V, Gui, EntryButtonEntry<V, Gui>, EntryButtonEntryBuilder<V, Gui, S>, Builder<V, Gui, S, B>>
    implements EntryButtonEntryBuilder<V, Gui, S> {
        protected B inner;
        protected BiConsumer<V, ConfigEntryHolder> action;
        protected Supplier<Component> buttonLabelSupplier = () -> Component.m_237113_((String)"\u2713");

        public Builder(S inner, BiConsumer<V, ConfigEntryHolder> action) {
            this((AbstractConfigEntryBuilder)inner, action);
        }

        public Builder(B inner, BiConsumer<V, ConfigEntryHolder> action) {
            super(((AbstractConfigEntryBuilder)inner).value, ((AbstractConfigEntryBuilder)inner).type);
            this.inner = inner;
            this.action = action;
        }

        @Contract(pure=true)
        @NotNull
        public Builder<V, Gui, S, B> withAction(BiConsumer<V, ConfigEntryHolder> action) {
            this.action = action;
            return this;
        }

        @Contract(pure=true)
        @NotNull
        public Builder<V, Gui, S, B> withAction(Consumer<V> action) {
            return this.withAction((T v, U h) -> action.accept(v));
        }

        @Contract(pure=true)
        @NotNull
        public Builder<V, Gui, S, B> label(String translation) {
            Builder copy = (Builder)this.copy();
            MutableComponent ttc = Component.m_237115_((String)translation);
            copy.buttonLabelSupplier = () -> ttc;
            return copy;
        }

        @Contract(pure=true)
        @NotNull
        public Builder<V, Gui, S, B> label(Component label) {
            Builder copy = (Builder)this.copy();
            copy.buttonLabelSupplier = () -> label;
            return copy;
        }

        @Contract(pure=true)
        @NotNull
        public Builder<V, Gui, S, B> label(Supplier<Component> label) {
            Builder copy = (Builder)this.copy();
            copy.buttonLabelSupplier = label;
            return copy;
        }

        @Override
        protected final EntryButtonEntry<V, Gui> buildEntry(ConfigEntryHolder parent, String name) {
            EntryButtonEntry entry = new EntryButtonEntry(parent, name, DummyEntryHolder.build(parent, this.inner), this.value, (BiConsumer<Object, ConfigEntryHolder>)this.action, this.typeClass);
            entry.buttonLabelSupplier = this.buttonLabelSupplier;
            return entry;
        }

        @Override
        protected Builder<V, Gui, S, B> createCopy(V value) {
            Builder copy = new Builder(((AbstractConfigEntryBuilder)this.inner).copy(value), this.action);
            copy.buttonLabelSupplier = this.buttonLabelSupplier;
            return copy;
        }
    }
}

