/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import endorh.simpleconfig.api.AtomicEntryBuilder;
import endorh.simpleconfig.api.ConfigBuilderFactory;
import endorh.simpleconfig.api.ConfigCategoryBuilder;
import endorh.simpleconfig.api.ConfigEntryBuilder;
import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.ConfigGroupBuilder;
import endorh.simpleconfig.api.SimpleConfig;
import endorh.simpleconfig.api.SimpleConfigBuilder;
import endorh.simpleconfig.api.command.ParsedArgument;
import endorh.simpleconfig.api.entry.BeanEntryBuilder;
import endorh.simpleconfig.api.entry.BooleanEntryBuilder;
import endorh.simpleconfig.api.entry.ByteEntryBuilder;
import endorh.simpleconfig.api.entry.CaptionedCollectionEntryBuilder;
import endorh.simpleconfig.api.entry.CommandArgumentEntryBuilder;
import endorh.simpleconfig.api.entry.CommentedConfigEntryBuilder;
import endorh.simpleconfig.api.entry.ConfigEntrySerializer;
import endorh.simpleconfig.api.entry.DoubleEntryBuilder;
import endorh.simpleconfig.api.entry.EntryButtonEntryBuilder;
import endorh.simpleconfig.api.entry.EntryListEntryBuilder;
import endorh.simpleconfig.api.entry.EntryMapEntryBuilder;
import endorh.simpleconfig.api.entry.EntryPairEntryBuilder;
import endorh.simpleconfig.api.entry.EntryPairListEntryBuilder;
import endorh.simpleconfig.api.entry.EntrySetEntryBuilder;
import endorh.simpleconfig.api.entry.EntryTripleEntryBuilder;
import endorh.simpleconfig.api.entry.FloatEntryBuilder;
import endorh.simpleconfig.api.entry.ISerializableConfigEntry;
import endorh.simpleconfig.api.entry.IntegerEntryBuilder;
import endorh.simpleconfig.api.entry.ListEntryBuilder;
import endorh.simpleconfig.api.entry.LongEntryBuilder;
import endorh.simpleconfig.api.entry.OptionEntryBuilder;
import endorh.simpleconfig.api.entry.ShortEntryBuilder;
import endorh.simpleconfig.api.entry.StringEntryBuilder;
import endorh.simpleconfig.api.range.DoubleRange;
import endorh.simpleconfig.api.range.FloatRange;
import endorh.simpleconfig.api.range.IntRange;
import endorh.simpleconfig.api.range.LongRange;
import endorh.simpleconfig.api.ui.hotkey.ExtendedKeyBind;
import endorh.simpleconfig.api.ui.hotkey.KeyBindMapping;
import endorh.simpleconfig.core.CaptionedCollectionEntry;
import endorh.simpleconfig.core.EntryButtonEntry;
import endorh.simpleconfig.core.EntryListEntry;
import endorh.simpleconfig.core.EntryMapEntry;
import endorh.simpleconfig.core.EntryPairListEntry;
import endorh.simpleconfig.core.EntrySetEntry;
import endorh.simpleconfig.core.SimpleConfigBuilderImpl;
import endorh.simpleconfig.core.entry.BeanEntry;
import endorh.simpleconfig.core.entry.BlockEntry;
import endorh.simpleconfig.core.entry.BlockNameEntry;
import endorh.simpleconfig.core.entry.BooleanEntry;
import endorh.simpleconfig.core.entry.ButtonEntry;
import endorh.simpleconfig.core.entry.ByteEntry;
import endorh.simpleconfig.core.entry.ByteListEntry;
import endorh.simpleconfig.core.entry.ColorEntry;
import endorh.simpleconfig.core.entry.CommandArgumentEntry;
import endorh.simpleconfig.core.entry.CommentedConfigEntry;
import endorh.simpleconfig.core.entry.CompoundTagEntry;
import endorh.simpleconfig.core.entry.DoubleEntry;
import endorh.simpleconfig.core.entry.DoubleListEntry;
import endorh.simpleconfig.core.entry.DoubleRangeEntry;
import endorh.simpleconfig.core.entry.EntryPairEntry;
import endorh.simpleconfig.core.entry.EntryTripleEntry;
import endorh.simpleconfig.core.entry.EnumEntry;
import endorh.simpleconfig.core.entry.FloatEntry;
import endorh.simpleconfig.core.entry.FloatListEntry;
import endorh.simpleconfig.core.entry.FloatRangeEntry;
import endorh.simpleconfig.core.entry.FluidEntry;
import endorh.simpleconfig.core.entry.FluidNameEntry;
import endorh.simpleconfig.core.entry.IntegerEntry;
import endorh.simpleconfig.core.entry.IntegerListEntry;
import endorh.simpleconfig.core.entry.IntegerRangeEntry;
import endorh.simpleconfig.core.entry.ItemEntry;
import endorh.simpleconfig.core.entry.ItemNameEntry;
import endorh.simpleconfig.core.entry.KeyBindEntry;
import endorh.simpleconfig.core.entry.LongEntry;
import endorh.simpleconfig.core.entry.LongListEntry;
import endorh.simpleconfig.core.entry.LongRangeEntry;
import endorh.simpleconfig.core.entry.OptionEntry;
import endorh.simpleconfig.core.entry.PatternEntry;
import endorh.simpleconfig.core.entry.PresetSwitcherEntry;
import endorh.simpleconfig.core.entry.ResourceLocationEntry;
import endorh.simpleconfig.core.entry.SerializableEntry;
import endorh.simpleconfig.core.entry.ShortEntry;
import endorh.simpleconfig.core.entry.ShortListEntry;
import endorh.simpleconfig.core.entry.StringEntry;
import endorh.simpleconfig.core.entry.StringListEntry;
import endorh.simpleconfig.core.entry.TagEntry;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class ConfigBuilderFactoryImpl
implements ConfigBuilderFactory {
    @ApiStatus.Internal
    public ConfigBuilderFactoryImpl() {
    }

    private static String getThreadModID() {
        String modId = ModLoadingContext.get().getActiveContainer().getModId();
        if ("minecraft".equals(modId)) {
            throw new IllegalStateException("Cannot get mod ID from thread at this point. Register your config earlier, or specify your mod ID explicitly");
        }
        return modId;
    }

    @Override
    @NotNull
    public SimpleConfigBuilder config(SimpleConfig.Type type) {
        return this.config(ConfigBuilderFactoryImpl.getThreadModID(), type);
    }

    @Override
    @NotNull
    public SimpleConfigBuilder config(SimpleConfig.Type type, Class<?> configClass) {
        return this.config(ConfigBuilderFactoryImpl.getThreadModID(), type, configClass);
    }

    @Override
    @NotNull
    public SimpleConfigBuilder config(String modId, SimpleConfig.Type type) {
        if (modId == null) {
            modId = ConfigBuilderFactoryImpl.getThreadModID();
        }
        return new SimpleConfigBuilderImpl(modId, type);
    }

    @Override
    @NotNull
    public SimpleConfigBuilder config(String modId, SimpleConfig.Type type, Class<?> configClass) {
        if (modId == null) {
            modId = ConfigBuilderFactoryImpl.getThreadModID();
        }
        return new SimpleConfigBuilderImpl(modId, type, configClass);
    }

    @Override
    @NotNull
    public ConfigGroupBuilder group(String name) {
        return this.group(name, false);
    }

    @Override
    @NotNull
    public ConfigGroupBuilder group(String name, boolean expand) {
        return new SimpleConfigBuilderImpl.GroupBuilder(name, expand);
    }

    @Override
    @NotNull
    public ConfigCategoryBuilder category(String name) {
        return new SimpleConfigBuilderImpl.CategoryBuilder(name);
    }

    @Override
    @NotNull
    public ConfigCategoryBuilder category(String name, Class<?> configClass) {
        return new SimpleConfigBuilderImpl.CategoryBuilder(name, configClass);
    }

    @Override
    @NotNull
    public BooleanEntry.Builder bool(boolean value) {
        return new BooleanEntry.Builder(value);
    }

    @Override
    @NotNull
    public BooleanEntry.Builder yesNo(boolean value) {
        return new BooleanEntry.Builder(value).text(BooleanEntryBuilder.BooleanDisplayer.YES_NO);
    }

    @Override
    @NotNull
    public BooleanEntry.Builder enable(boolean value) {
        return this.bool(value).text(BooleanEntryBuilder.BooleanDisplayer.ENABLED_DISABLED);
    }

    @Override
    @NotNull
    public BooleanEntry.Builder onOff(boolean value) {
        return this.bool(value).text(BooleanEntryBuilder.BooleanDisplayer.ON_OFF);
    }

    @Override
    @NotNull
    public StringEntry.Builder string(String value) {
        return new StringEntry.Builder(value);
    }

    @Deprecated
    public <E extends Enum<E>>  @NotNull EnumEntry.Builder<E> enum_(E value) {
        return new EnumEntry.Builder<E>(value);
    }

    public <E extends Enum<E>>  @NotNull EnumEntry.Builder<E> option(E value) {
        return new EnumEntry.Builder<E>(value);
    }

    @Override
    @NotNull
    public <T> @NotNull OptionEntryBuilder<@NotNull T> option(T value, List<T> options) {
        return new OptionEntry.Builder<T>(value).withOptions(options);
    }

    @Override
    @NotNull
    public <T> @NotNull OptionEntryBuilder<@NotNull T> option(T value, Supplier<List<T>> options) {
        return new OptionEntry.Builder<T>(value).withOptions(options);
    }

    @Override
    @SafeVarargs
    @NotNull
    public final <T> @NotNull OptionEntryBuilder<@NotNull T> option(T value, T ... options) {
        return new OptionEntry.Builder<T>(value).withOptions(options);
    }

    @Override
    @NotNull
    public ButtonEntry.Builder button(Runnable action) {
        return new ButtonEntry.Builder(h -> action.run());
    }

    @Override
    @NotNull
    public ButtonEntry.Builder button(Consumer<ConfigEntryHolder> action) {
        return new ButtonEntry.Builder(action);
    }

    @Override
    @NotNull
    public <V, Gui, B extends ConfigEntryBuilder<V, ?, Gui, B> & AtomicEntryBuilder> EntryButtonEntryBuilder<V, Gui, B> button(B inner, Consumer<V> action) {
        return this.button(inner, (BiConsumer<V, ConfigEntryHolder>)((BiConsumer<Object, ConfigEntryHolder>)(v, h) -> action.accept(v)));
    }

    @Override
    @NotNull
    public <V, Gui, B extends ConfigEntryBuilder<V, ?, Gui, B> & AtomicEntryBuilder> EntryButtonEntryBuilder<V, Gui, B> button(B inner, BiConsumer<V, ConfigEntryHolder> action) {
        return new EntryButtonEntry.Builder(inner, action);
    }

    @Override
    @NotNull
    public PresetSwitcherEntry.Builder globalPresetSwitcher(Map<String, Map<String, Object>> presets, String path) {
        return new PresetSwitcherEntry.Builder(presets, path, true);
    }

    @Override
    @NotNull
    public PresetSwitcherEntry.Builder localPresetSwitcher(Map<String, Map<String, Object>> presets, String path) {
        return new PresetSwitcherEntry.Builder(presets, path, false);
    }

    @Override
    @Deprecated
    @NotNull
    public ByteEntry.Builder number(byte value) {
        return new ByteEntry.Builder(value);
    }

    @Override
    @Deprecated
    @NotNull
    public ByteEntryBuilder number(byte value, byte max) {
        return this.number(value, (byte)0, max);
    }

    @Override
    @Deprecated
    @NotNull
    public ByteEntryBuilder number(byte value, byte min, byte max) {
        return new ByteEntry.Builder(value).range(min, max);
    }

    @Override
    @Deprecated
    @NotNull
    public ShortEntry.Builder number(short value) {
        return new ShortEntry.Builder(value);
    }

    @Override
    @Deprecated
    @NotNull
    public ShortEntryBuilder number(short value, short max) {
        return this.number(value, (short)0, max);
    }

    @Override
    @Deprecated
    @NotNull
    public ShortEntryBuilder number(short value, short min, short max) {
        return new ShortEntry.Builder(value).range(min, max);
    }

    @Override
    @NotNull
    public IntegerEntry.Builder number(int value) {
        return new IntegerEntry.Builder(value);
    }

    @Override
    @NotNull
    public IntegerEntryBuilder number(int value, int max) {
        return this.number(value, 0, max);
    }

    @Override
    @NotNull
    public IntegerEntryBuilder number(int value, int min, int max) {
        return new IntegerEntry.Builder(value).range(min, max);
    }

    @Override
    @NotNull
    public IntegerEntryBuilder percent(int value) {
        return (IntegerEntryBuilder)this.number(value, 0, 100).slider("simpleconfig.format.slider.percentage");
    }

    @Override
    @NotNull
    public LongEntry.Builder number(long value) {
        return new LongEntry.Builder(value);
    }

    @Override
    @NotNull
    public LongEntryBuilder number(long value, long max) {
        return this.number(value, 0L, max);
    }

    @Override
    @NotNull
    public LongEntryBuilder number(long value, long min, long max) {
        return new LongEntry.Builder(value).range(min, max);
    }

    @Override
    @NotNull
    public FloatEntry.Builder number(float value) {
        return new FloatEntry.Builder(Float.valueOf(value));
    }

    @Override
    @NotNull
    public FloatEntryBuilder number(float value, float max) {
        return this.number(value, 0.0f, max);
    }

    @Override
    @NotNull
    public FloatEntryBuilder number(float value, float min, float max) {
        return new FloatEntry.Builder(Float.valueOf(value)).range(min, max);
    }

    @Override
    @NotNull
    public FloatEntryBuilder percent(float value) {
        return ((FloatEntryBuilder)this.number(value, 0.0f, 100.0f).slider("simpleconfig.format.slider.percentage.float")).fieldScale(0.01f);
    }

    @Override
    @NotNull
    public DoubleEntry.Builder number(double value) {
        return new DoubleEntry.Builder(value);
    }

    @Override
    @NotNull
    public DoubleEntryBuilder number(double value, double max) {
        return this.number(value, 0.0, max);
    }

    @Override
    @NotNull
    public DoubleEntryBuilder number(double value, double min, double max) {
        return new DoubleEntry.Builder(value).range(min, max);
    }

    @Override
    @NotNull
    public DoubleEntryBuilder percent(double value) {
        return ((DoubleEntryBuilder)this.number(value, 0.0, 100.0).slider("simpleconfig.format.slider.percentage.float")).fieldScale(0.01);
    }

    @Override
    @NotNull
    public FloatEntryBuilder fraction(float value) {
        if (0.0f > value || value > 1.0f) {
            throw new IllegalArgumentException("Fraction values must be within [0, 1], passed " + value);
        }
        return (FloatEntryBuilder)this.number(value).range(0.0f, 1.0f).slider();
    }

    @Override
    @NotNull
    public DoubleEntryBuilder fraction(double value) {
        if (0.0 > value || value > 1.0) {
            throw new IllegalArgumentException("Fraction values must be within [0, 1], passed " + value);
        }
        return (DoubleEntryBuilder)this.number(value).range(0.0, 1.0).slider();
    }

    @Override
    @NotNull
    public FloatEntryBuilder volume(float value) {
        return (FloatEntryBuilder)this.fraction(value).slider(v -> Component.m_237110_((String)"simpleconfig.format.slider.volume", (Object[])new Object[]{Math.round(v.floatValue() * 100.0f)}));
    }

    @Override
    @NotNull
    public FloatEntryBuilder volume() {
        return this.volume(1.0f);
    }

    @Override
    @NotNull
    public DoubleEntryBuilder volume(double value) {
        return (DoubleEntryBuilder)this.fraction(value).slider(v -> Component.m_237110_((String)"simpleconfig.format.slider.volume", (Object[])new Object[]{Math.round(v * 100.0)}));
    }

    @Override
    @NotNull
    public DoubleRangeEntry.Builder range(DoubleRange range) {
        return new DoubleRangeEntry.Builder(range);
    }

    @Override
    @NotNull
    public DoubleRangeEntry.Builder range(double min, double max) {
        return this.range(DoubleRange.inclusive(min, max));
    }

    @Override
    @NotNull
    public FloatRangeEntry.Builder range(FloatRange range) {
        return new FloatRangeEntry.Builder(range);
    }

    @Override
    @NotNull
    public FloatRangeEntry.Builder range(float min, float max) {
        return this.range(FloatRange.inclusive(min, max));
    }

    @Override
    @NotNull
    public LongRangeEntry.Builder range(LongRange range) {
        return new LongRangeEntry.Builder(range);
    }

    @Override
    @NotNull
    public LongRangeEntry.Builder range(long min, long max) {
        return this.range(LongRange.inclusive(min, max));
    }

    @Override
    @NotNull
    public IntegerRangeEntry.Builder range(IntRange range) {
        return new IntegerRangeEntry.Builder(range);
    }

    @Override
    @NotNull
    public IntegerRangeEntry.Builder range(int min, int max) {
        return this.range(IntRange.inclusive(min, max));
    }

    @Override
    @NotNull
    public ColorEntry.Builder color(Color value) {
        return new ColorEntry.Builder(value);
    }

    @Override
    @NotNull
    public PatternEntry.Builder pattern(Pattern pattern) {
        return new PatternEntry.Builder(pattern);
    }

    @Override
    @NotNull
    public PatternEntry.Builder pattern(String pattern) {
        return new PatternEntry.Builder(pattern);
    }

    @Override
    @NotNull
    public PatternEntry.Builder pattern(String pattern, int flags) {
        return new PatternEntry.Builder(pattern, flags);
    }

    public <V>  @NotNull SerializableEntry.Builder<V> entry(V value, Function<V, String> serializer, Function<String, Optional<V>> deserializer) {
        return new SerializableEntry.Builder<V>(value, serializer, deserializer);
    }

    public <V>  @NotNull SerializableEntry.Builder<V> entry(V value, ConfigEntrySerializer<V> serializer) {
        return new SerializableEntry.Builder<V>(value, serializer);
    }

    public <V extends ISerializableConfigEntry<V>>  @NotNull SerializableEntry.Builder<V> entry(V value) {
        return new SerializableEntry.Builder<V>(value, value.getConfigSerializer());
    }

    @Override
    @NotNull
    public <B> BeanEntryBuilder<B> bean(B value) {
        return BeanEntry.Builder.create(value);
    }

    @Override
    @NotNull
    public CommentedConfigEntryBuilder nightConfig(CommentedConfig config) {
        return new CommentedConfigEntry.Builder(config);
    }

    @Override
    @NotNull
    public TagEntry.Builder tag(Tag value) {
        return new TagEntry.Builder(value);
    }

    @Override
    @NotNull
    public CompoundTagEntry.Builder compoundTag(CompoundTag value) {
        return new CompoundTagEntry.Builder(value);
    }

    @Override
    @NotNull
    public ResourceLocationEntry.Builder resource(String resourceName) {
        return new ResourceLocationEntry.Builder(new ResourceLocation(resourceName));
    }

    @Override
    @NotNull
    public ResourceLocationEntry.Builder resource(ResourceLocation value) {
        return new ResourceLocationEntry.Builder(value);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public KeyBindEntry.Builder key(ExtendedKeyBind keyBind) {
        return this.key(keyBind.getDefinition()).bakeTo(keyBind).withDefaultSettings(keyBind.getDefinition().getSettings());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public KeyBindEntry.Builder key(KeyBindMapping key) {
        return new KeyBindEntry.Builder(key);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public KeyBindEntry.Builder key(String key) {
        return new KeyBindEntry.Builder(key);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public KeyBindEntry.Builder key() {
        return new KeyBindEntry.Builder();
    }

    @Override
    @NotNull
    public ItemEntry.Builder item(@Nullable Item value) {
        return new ItemEntry.Builder(value);
    }

    @Override
    @NotNull
    public ItemNameEntry.Builder itemName(@Nullable ResourceLocation value) {
        return new ItemNameEntry.Builder(value);
    }

    @Override
    @NotNull
    public ItemNameEntry.Builder itemName(Item value) {
        return this.itemName(ForgeRegistries.ITEMS.getKey((Object)value));
    }

    @Override
    @NotNull
    public BlockEntry.Builder block(@Nullable Block value) {
        return new BlockEntry.Builder(value);
    }

    @Override
    @NotNull
    public BlockNameEntry.Builder blockName(@Nullable ResourceLocation value) {
        return new BlockNameEntry.Builder(value);
    }

    @Override
    @NotNull
    public BlockNameEntry.Builder blockName(Block value) {
        return this.blockName(ForgeRegistries.BLOCKS.getKey((Object)value));
    }

    @Override
    @NotNull
    public FluidEntry.Builder fluid(@Nullable Fluid value) {
        return new FluidEntry.Builder(value);
    }

    @Override
    @NotNull
    public FluidNameEntry.Builder fluidName(@Nullable ResourceLocation value) {
        return new FluidNameEntry.Builder(value);
    }

    @Override
    @NotNull
    public FluidNameEntry.Builder fluidName(Fluid value) {
        return this.fluidName(ForgeRegistries.FLUIDS.getKey((Object)value));
    }

    @Override
    @NotNull
    public <A, T extends ArgumentType<A>> CommandArgumentEntryBuilder<A, T> commandArgument(T type, ParsedArgument<A> value) {
        return new CommandArgumentEntry.Builder(value, type);
    }

    @Override
    @NotNull
    public <A, T extends ArgumentType<A>> CommandArgumentEntryBuilder<A, T> commandArgument(T type, @NotNull String value) {
        try {
            return this.commandArgument(type, ParsedArgument.parse(type, value));
        }
        catch (CommandSyntaxException e) {
            throw new IllegalArgumentException("Invalid default value for entry: \"" + value + "\" (" + e.getMessage() + ")", e);
        }
    }

    @Override
    @NotNull
    public StringListEntry.Builder stringList(List<String> value) {
        return new StringListEntry.Builder(value);
    }

    @Override
    @Deprecated
    @NotNull
    public ByteListEntry.Builder byteList(List<Byte> value) {
        return new ByteListEntry.Builder(value);
    }

    @Override
    @Deprecated
    @NotNull
    public ShortListEntry.Builder shortList(List<Short> value) {
        return new ShortListEntry.Builder(value);
    }

    @Override
    @NotNull
    public IntegerListEntry.Builder intList(List<Integer> value) {
        return new IntegerListEntry.Builder(value);
    }

    @Override
    @NotNull
    public LongListEntry.Builder longList(List<Long> value) {
        return new LongListEntry.Builder(value);
    }

    @Override
    @NotNull
    public FloatListEntry.Builder floatList(List<Float> value) {
        return new FloatListEntry.Builder(value);
    }

    @Override
    @NotNull
    public DoubleListEntry.Builder doubleList(List<Double> value) {
        return new DoubleListEntry.Builder(value);
    }

    @Override
    @NotNull
    public <V, C, G, Builder extends ConfigEntryBuilder<V, C, G, Builder>> EntryListEntryBuilder<V, C, G, Builder> list(Builder entry) {
        return this.list(entry, Collections.emptyList());
    }

    @Override
    @NotNull
    public <V, C, G, Builder extends ConfigEntryBuilder<V, C, G, Builder>> EntryListEntryBuilder<V, C, G, Builder> list(Builder entry, List<V> value) {
        return new EntryListEntry.Builder(value, entry);
    }

    @Override
    @SafeVarargs
    @NotNull
    public final <V, C, G, Builder extends ConfigEntryBuilder<V, C, G, Builder>> EntryListEntryBuilder<V, C, G, Builder> list(Builder entry, V ... values) {
        return this.list(entry, Lists.newArrayList((Object[])values));
    }

    @Override
    @NotNull
    public <V, C, G, Builder extends ConfigEntryBuilder<V, C, G, Builder>> EntrySetEntryBuilder<V, C, G, Builder> set(Builder entry) {
        return this.set(entry, Collections.emptySet());
    }

    @Override
    @NotNull
    public <V, C, G, Builder extends ConfigEntryBuilder<V, C, G, Builder>> EntrySetEntryBuilder<V, C, G, Builder> set(Builder entry, Set<V> value) {
        return new EntrySetEntry.Builder(value, entry);
    }

    @Override
    @SafeVarargs
    @NotNull
    public final <V, C, G, Builder extends ConfigEntryBuilder<V, C, G, Builder>> EntrySetEntryBuilder<V, C, G, Builder> set(Builder entry, V ... values) {
        return this.set(entry, Sets.newHashSet((Object[])values));
    }

    @Override
    @NotNull
    public <K, V, KC, C, KG, G, Builder extends ConfigEntryBuilder<V, C, G, Builder>, KeyBuilder extends ConfigEntryBuilder<K, KC, KG, KeyBuilder> & AtomicEntryBuilder> EntryMapEntryBuilder<K, V, KC, C, KG, G, Builder, KeyBuilder> map(KeyBuilder keyEntry, Builder entry) {
        return this.map(keyEntry, entry, new LinkedHashMap());
    }

    @Override
    @NotNull
    public <K, V, KC, C, KG, G, Builder extends ConfigEntryBuilder<V, C, G, Builder>, KeyBuilder extends ConfigEntryBuilder<K, KC, KG, KeyBuilder> & AtomicEntryBuilder> EntryMapEntryBuilder<K, V, KC, C, KG, G, Builder, KeyBuilder> map(KeyBuilder keyEntry, Builder entry, Map<K, V> value) {
        return new EntryMapEntry.Builder(value, keyEntry, entry);
    }

    @Override
    @NotNull
    public <V, C, G, Builder extends ConfigEntryBuilder<V, C, G, Builder>> EntryMapEntryBuilder<String, V, String, C, String, G, Builder, StringEntryBuilder> map(Builder entry) {
        return this.map(entry, new LinkedHashMap());
    }

    @Override
    @NotNull
    public <V, C, G, Builder extends ConfigEntryBuilder<V, C, G, Builder>> EntryMapEntryBuilder<String, V, String, C, String, G, Builder, StringEntryBuilder> map(Builder entry, Map<String, V> value) {
        return this.map(this.string(""), entry, value);
    }

    @Override
    @NotNull
    public <K, V, KC, C, KG, G, Builder extends ConfigEntryBuilder<V, C, G, Builder>, KeyBuilder extends ConfigEntryBuilder<K, KC, KG, KeyBuilder> & AtomicEntryBuilder> EntryPairListEntryBuilder<K, V, KC, C, KG, G, Builder, KeyBuilder> pairList(KeyBuilder keyEntry, Builder entry) {
        return this.pairList(keyEntry, entry, (List<Pair<K, V>>)new ArrayList<Pair<K, V>>());
    }

    @Override
    @NotNull
    public <K, V, KC, C, KG, G, Builder extends ConfigEntryBuilder<V, C, G, Builder>, KeyBuilder extends ConfigEntryBuilder<K, KC, KG, KeyBuilder> & AtomicEntryBuilder> EntryPairListEntryBuilder<K, V, KC, C, KG, G, Builder, KeyBuilder> pairList(KeyBuilder keyEntry, Builder entry, List<Pair<K, V>> value) {
        return new EntryPairListEntry.Builder(value, keyEntry, entry);
    }

    @Override
    @NotNull
    public <V, C, G, B extends ListEntryBuilder<V, C, G, B>, CV, CC, CG, CB extends ConfigEntryBuilder<CV, CC, CG, CB> & AtomicEntryBuilder> CaptionedCollectionEntryBuilder<List<V>, List<C>, G, B, CV, CC, CG, CB> caption(CB caption, B list) {
        return new CaptionedCollectionEntry.Builder(Pair.of(caption.getValue(), (Object)((List)list.getValue())), list, caption);
    }

    @Override
    @NotNull
    public <V, C, G, B extends ConfigEntryBuilder<V, C, G, B>, CV, CC, CG, CB extends ConfigEntryBuilder<CV, CC, CG, CB> & AtomicEntryBuilder> CaptionedCollectionEntryBuilder<Set<V>, Set<C>, G, EntrySetEntryBuilder<V, C, G, B>, CV, CC, CG, CB> caption(CB caption, EntrySetEntryBuilder<V, C, G, B> set) {
        return new CaptionedCollectionEntry.Builder(Pair.of(caption.getValue(), (Object)((Set)set.getValue())), set, caption);
    }

    @Override
    @NotNull
    public <K, V, KC, C, KG, G, KB extends ConfigEntryBuilder<K, KC, KG, KB> & AtomicEntryBuilder, B extends ConfigEntryBuilder<V, C, G, B>, CV, CC, CG, CB extends ConfigEntryBuilder<CV, CC, CG, CB> & AtomicEntryBuilder> CaptionedCollectionEntryBuilder<Map<K, V>, Map<KC, C>, Pair<KG, G>, EntryMapEntryBuilder<K, V, KC, C, KG, G, B, KB>, CV, CC, CG, CB> caption(CB caption, EntryMapEntryBuilder<K, V, KC, C, KG, G, B, KB> map) {
        return new CaptionedCollectionEntry.Builder(Pair.of(caption.getValue(), (Object)((Map)map.getValue())), map, caption);
    }

    @Override
    @NotNull
    public <K, V, KC, C, KG, G, KB extends ConfigEntryBuilder<K, KC, KG, KB> & AtomicEntryBuilder, B extends ConfigEntryBuilder<V, C, G, B>, CV, CC, CG, CB extends ConfigEntryBuilder<CV, CC, CG, CB> & AtomicEntryBuilder> CaptionedCollectionEntryBuilder<List<Pair<K, V>>, List<Pair<KC, C>>, Pair<KG, G>, EntryPairListEntryBuilder<K, V, KC, C, KG, G, B, KB>, CV, CC, CG, CB> caption(CB caption, EntryPairListEntryBuilder<K, V, KC, C, KG, G, B, KB> pairList) {
        return new CaptionedCollectionEntry.Builder(Pair.of(caption.getValue(), (Object)((List)pairList.getValue())), pairList, caption);
    }

    @Override
    @NotNull
    public <L, R, LC, RC, LG, RG, LB extends ConfigEntryBuilder<L, LC, LG, LB> & AtomicEntryBuilder, RB extends ConfigEntryBuilder<R, RC, RG, RB> & AtomicEntryBuilder> EntryPairEntryBuilder<L, R, LC, RC, LG, RG> pair(LB leftEntry, RB rightEntry) {
        return this.pair(leftEntry, rightEntry, (Pair<L, R>)Pair.of(leftEntry.getValue(), rightEntry.getValue()));
    }

    @Override
    @NotNull
    public <L, R, LC, RC, LG, RG, LB extends ConfigEntryBuilder<L, LC, LG, LB> & AtomicEntryBuilder, RB extends ConfigEntryBuilder<R, RC, RG, RB> & AtomicEntryBuilder> EntryPairEntryBuilder<L, R, LC, RC, LG, RG> pair(LB leftEntry, RB rightEntry, Pair<L, R> value) {
        return new EntryPairEntry.Builder(value, leftEntry, rightEntry);
    }

    @Override
    @NotNull
    public <L, M, R, LC, MC, RC, LG, MG, RG, LB extends ConfigEntryBuilder<L, LC, LG, LB> & AtomicEntryBuilder, MB extends ConfigEntryBuilder<M, MC, MG, MB> & AtomicEntryBuilder, RB extends ConfigEntryBuilder<R, RC, RG, RB> & AtomicEntryBuilder> EntryTripleEntryBuilder<L, M, R, LC, MC, RC, LG, MG, RG> triple(LB leftEntry, MB middleEntry, RB rightEntry) {
        return this.triple(leftEntry, middleEntry, rightEntry, (Triple<L, M, R>)Triple.of(leftEntry.getValue(), middleEntry.getValue(), rightEntry.getValue()));
    }

    @Override
    @NotNull
    public <L, M, R, LC, MC, RC, LG, MG, RG, LB extends ConfigEntryBuilder<L, LC, LG, LB> & AtomicEntryBuilder, MB extends ConfigEntryBuilder<M, MC, MG, MB> & AtomicEntryBuilder, RB extends ConfigEntryBuilder<R, RC, RG, RB> & AtomicEntryBuilder> EntryTripleEntryBuilder<L, M, R, LC, MC, RC, LG, MG, RG> triple(LB leftEntry, MB middleEntry, RB rightEntry, Triple<L, M, R> value) {
        return new EntryTripleEntry.Builder(value, leftEntry, middleEntry, rightEntry);
    }
}

