/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core;

import com.electronwill.nightconfig.core.Config;
import endorh.simpleconfig.api.AtomicEntryBuilder;
import endorh.simpleconfig.api.ConfigEntryBuilder;
import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.EntryTag;
import endorh.simpleconfig.api.entry.CaptionedCollectionEntryBuilder;
import endorh.simpleconfig.core.AbstractConfigEntry;
import endorh.simpleconfig.core.AbstractConfigEntryBuilder;
import endorh.simpleconfig.core.AtomicEntry;
import endorh.simpleconfig.core.BackingField;
import endorh.simpleconfig.core.DummyEntryHolder;
import endorh.simpleconfig.core.EntryType;
import endorh.simpleconfig.ui.api.AbstractConfigListEntry;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.gui.entries.AbstractListListEntry;
import endorh.simpleconfig.ui.impl.builders.CaptionedListEntryBuilder;
import endorh.simpleconfig.ui.impl.builders.FieldBuilder;
import endorh.simpleconfig.yaml.NonConfigMap;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaptionedCollectionEntry<V, C, G, CV, CC, CG>
extends AbstractConfigEntry<Pair<CV, V>, Pair<CC, C>, Pair<CG, List<G>>> {
    protected final AbstractConfigEntry<V, C, List<G>> listEntry;
    protected final AbstractConfigEntry<CV, CC, CG> captionEntry;

    protected CaptionedCollectionEntry(ConfigEntryHolder parent, String name, Pair<CV, V> value, AbstractConfigEntry<V, C, List<G>> listEntry, AbstractConfigEntry<CV, CC, CG> captionEntry) {
        super(parent, name, value);
        this.listEntry = listEntry;
        this.captionEntry = captionEntry;
    }

    protected <E extends AbstractConfigEntry<CV, CC, CG>> E getCaptionEntry() {
        return (E)this.captionEntry;
    }

    public Map<Object, Object> forActualConfig(@Nullable Pair<CC, C> value) {
        if (value == null) {
            return null;
        }
        return NonConfigMap.singleton(this.captionEntry.forActualConfig(value.getKey()), this.listEntry.forActualConfig(value.getValue()));
    }

    @Override
    @Nullable
    public Pair<CC, C> fromActualConfig(@Nullable Object value) {
        if (value instanceof Map) {
            Map m = (Map)value;
            if (m.size() != 1) {
                return null;
            }
            Map.Entry entry = (Map.Entry)m.entrySet().stream().findFirst().orElseThrow(ConcurrentModificationException::new);
            CC key = this.captionEntry.fromActualConfig(entry.getKey());
            C col = this.listEntry.fromActualConfig(entry.getValue());
            return key != null && col != null ? Pair.of(key, col) : null;
        }
        if (value instanceof Config) {
            Optional opt = ((Config)value).entrySet().stream().findFirst();
            if (opt.isEmpty()) {
                return null;
            }
            Config.Entry entry = (Config.Entry)opt.get();
            CC key = this.captionEntry.fromActualConfig(entry.getKey());
            C col = this.listEntry.fromActualConfig(entry.getValue());
            return key != null && col != null ? Pair.of(key, col) : null;
        }
        return null;
    }

    @Override
    public List<Component> getErrorsFromGUI(Pair<CG, List<G>> value) {
        List<Component> errors = super.getErrorsFromGUI(value);
        errors.addAll(this.captionEntry.getErrorsFromGUI(value.getKey()));
        errors.addAll(this.listEntry.getErrorsFromGUI((List)value.getValue()));
        return errors;
    }

    @Override
    public Pair<CC, C> forConfig(Pair<CV, V> value) {
        return Pair.of(this.captionEntry.forConfig(value.getKey()), this.listEntry.forConfig(value.getValue()));
    }

    @Override
    @Nullable
    public Pair<CV, V> fromConfig(@Nullable Pair<CC, C> value) {
        if (value == null) {
            return null;
        }
        CV caption = this.captionEntry.fromConfig(value.getKey());
        V col = this.listEntry.fromConfig(value.getValue());
        return caption != null && col != null ? Pair.of(caption, col) : null;
    }

    @Override
    public boolean hasPresentation() {
        return super.hasPresentation() || this.captionEntry.hasPresentation() || this.listEntry.hasPresentation();
    }

    @Override
    protected Pair<CV, V> doForPresentation(Pair<CV, V> value) {
        return super.doForPresentation(Pair.of((Object)this.captionEntry.forPresentation(value.getKey()), (Object)this.listEntry.forPresentation(value.getValue())));
    }

    @Override
    protected Pair<CV, V> doFromPresentation(Pair<CV, V> value) {
        value = super.doFromPresentation(value);
        return Pair.of((Object)this.captionEntry.fromPresentation(value.getKey()), (Object)this.listEntry.fromPresentation(value.getValue()));
    }

    @Override
    public Pair<CG, List<G>> forGui(Pair<CV, V> value) {
        return Pair.of(this.captionEntry.forGui(value.getKey()), this.listEntry.forGui(value.getValue()));
    }

    @Override
    @Nullable
    public Pair<CV, V> fromGui(@Nullable Pair<CG, List<G>> value) {
        if (value == null) {
            return null;
        }
        CV caption = this.captionEntry.fromGui(value.getKey());
        V col = this.listEntry.fromGui((List)value.getValue());
        return caption != null && col != null ? Pair.of(caption, col) : null;
    }

    @Override
    public List<String> getConfigCommentTooltips() {
        List<String> tooltips = super.getConfigCommentTooltips();
        String captionTooltip = this.captionEntry.getConfigCommentTooltip();
        if (!captionTooltip.isEmpty()) {
            tooltips.add("Caption: " + captionTooltip);
        }
        tooltips.addAll(this.listEntry.getConfigCommentTooltips());
        return tooltips;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected <LGE extends AbstractListListEntry<G, ?, LGE>, CGE extends AbstractConfigListEntry<CG>> CaptionedListEntryBuilder<G, LGE, ?, CG, CGE, ?> makeGUIEntry(ConfigFieldBuilder builder, Component name, FieldBuilder<List<G>, ?, ?> listEntry, Pair<CG, List<G>> value) {
        Object cge = ((AtomicEntry)this.getCaptionEntry()).buildAtomicChildGUIEntry(builder);
        ((FieldBuilder)cge).setOriginal((Object)value.getKey());
        return new CaptionedListEntryBuilder(builder, name, value, listEntry, cge);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<FieldBuilder<Pair<CG, List<G>>, ?, ?>> buildGUIEntry(ConfigFieldBuilder builder) {
        this.listEntry.setDisplayName(this.getDisplayName());
        CaptionedListEntryBuilder entryBuilder = this.makeGUIEntry(builder, this.getDisplayName(), this.listEntry.buildGUIEntry(builder).map(l -> l.withoutTags(EntryTag.NON_PERSISTENT)).orElseThrow(() -> new IllegalStateException("List entry has no GUI entry")), this.forGui((Pair)this.get()));
        return Optional.of(this.decorate(entryBuilder));
    }

    public static class Builder<V, C, G, S extends ConfigEntryBuilder<V, C, List<G>, S>, CV, CC, CG, CS extends ConfigEntryBuilder<CV, CC, CG, CS> & AtomicEntryBuilder>
    extends AbstractConfigEntryBuilder<Pair<CV, V>, Pair<CC, C>, Pair<CG, List<G>>, CaptionedCollectionEntry<V, C, G, CV, CC, CG>, CaptionedCollectionEntryBuilder<V, C, G, S, CV, CC, CG, CS>, Builder<V, C, G, S, CV, CC, CG, CS>>
    implements CaptionedCollectionEntryBuilder<V, C, G, S, CV, CC, CG, CS> {
        protected AbstractConfigEntryBuilder<V, C, List<G>, ?, S, ?> collectionBuilder;
        protected AbstractConfigEntryBuilder<CV, CC, CG, ?, CS, ?> captionBuilder;

        public Builder(Pair<CV, V> value, S collectionBuilder, CS captionBuilder) {
            super(value, EntryType.of(Pair.class, Builder.getEntryType(captionBuilder), Builder.getEntryType(collectionBuilder)));
            if (!(collectionBuilder instanceof AbstractConfigEntryBuilder)) {
                throw new IllegalArgumentException("`collectionBuilder` is not an `AbstractConfigEntryBuilder`!");
            }
            if (!(captionBuilder instanceof AbstractConfigEntryBuilder)) {
                throw new IllegalArgumentException("`captionBuilder` is not an `AbstractConfigEntryBuilder`!");
            }
            this.collectionBuilder = (AbstractConfigEntryBuilder)collectionBuilder;
            this.captionBuilder = (AbstractConfigEntryBuilder)captionBuilder;
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public CaptionedCollectionEntryBuilder<V, C, G, S, CV, CC, CG, CS> captionField(String name) {
            return (CaptionedCollectionEntryBuilder)this.field(name, Pair::getKey, this.captionBuilder.typeClass);
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public CaptionedCollectionEntryBuilder<V, C, G, S, CV, CC, CG, CS> collectionField(String name) {
            return (CaptionedCollectionEntryBuilder)this.field(name, Pair::getValue, this.collectionBuilder.typeClass);
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public CaptionedCollectionEntryBuilder<V, C, G, S, CV, CC, CG, CS> collectionField() {
            Builder copy = (Builder)this.copy();
            copy.backingFieldBuilder = BackingField.BackingFieldBuilder.of(Pair::getValue, this.collectionBuilder.type);
            return copy;
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public CaptionedCollectionEntryBuilder<V, C, G, S, CV, CC, CG, CS> splitFields(String captionSuffix) {
            return ((CaptionedCollectionEntryBuilder)this.addField(captionSuffix, Pair::getKey, this.captionBuilder.typeClass)).collectionField();
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public CaptionedCollectionEntryBuilder<V, C, G, S, CV, CC, CG, CS> splitFields(String captionField, boolean fullFieldName) {
            if (!fullFieldName) {
                return this.splitFields(captionField);
            }
            return this.captionField(captionField).collectionField();
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public CaptionedCollectionEntryBuilder<V, C, G, S, CV, CC, CG, CS> split_fields(String caption_suffix) {
            return ((CaptionedCollectionEntryBuilder)this.add_field(caption_suffix, Pair::getKey, this.captionBuilder.typeClass)).collectionField();
        }

        @Override
        protected CaptionedCollectionEntry<V, C, G, CV, CC, CG> buildEntry(ConfigEntryHolder parent, String name) {
            Object le = DummyEntryHolder.build(parent, this.collectionBuilder);
            Object ce = DummyEntryHolder.build(parent, this.captionBuilder);
            if (!(ce instanceof AtomicEntry)) {
                throw new IllegalStateException("KeyEntryBuilder created non-key entry: " + this.captionBuilder.getClass().getCanonicalName());
            }
            return new CaptionedCollectionEntry(parent, name, (Pair)this.value, le, ce);
        }

        @Override
        protected Builder<V, C, G, S, CV, CC, CG, CS> createCopy(Pair<CV, V> value) {
            return new Builder(value, this.collectionBuilder.copy(), this.captionBuilder.copy());
        }
    }
}

