/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core;

import endorh.simpleconfig.api.SimpleConfig;
import endorh.simpleconfig.core.EntryType;
import endorh.simpleconfig.core.ReflectionUtil;
import endorh.simpleconfig.core.SimpleConfigClassParser;
import java.lang.reflect.Field;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;

public class BackingField<V, F> {
    private final Field field;
    private final Function<V, F> fieldMapper;
    private final Function<F, V> committer;

    public static <V, F> BackingFieldBuilder<V, F> field(Function<V, F> mapper, Class<F> type) {
        return BackingFieldBuilder.of(mapper, EntryType.unchecked(type));
    }

    private BackingField(Field field, Function<V, F> fieldMapper, Function<F, V> committer) {
        this.field = field;
        this.fieldMapper = fieldMapper;
        this.committer = committer;
    }

    public F transformValue(V value) {
        return this.fieldMapper.apply(value);
    }

    public void setValue(V value) throws IllegalAccessException {
        ReflectionUtil.setBackingField(this.getField(), this.transformValue(value));
    }

    public V readValue() throws IllegalAccessException {
        if (this.committer == null) {
            throw new IllegalStateException("Cannot commit field " + this.field.getDeclaringClass().getCanonicalName() + "." + this.field.getName());
        }
        try {
            return (V)this.field.get(null);
        }
        catch (ClassCastException e) {
            throw new SimpleConfig.InvalidConfigValueTypeException("", e);
        }
    }

    public boolean canBeRead() {
        return this.committer != null;
    }

    public Field getField() {
        return this.field;
    }

    public static class BackingFieldBuilder<V, F> {
        private final Function<V, F> fieldMapper;
        private final Function<F, V> committer;
        private final EntryType<?> type;

        @ApiStatus.Internal
        public static <V, F> BackingFieldBuilder<V, F> of(Function<V, F> mapper, EntryType<?> type) {
            return new BackingFieldBuilder<V, F>(mapper, null, type);
        }

        private BackingFieldBuilder(Function<V, F> fieldMapper, Function<F, V> committer, EntryType<?> type) {
            this.fieldMapper = fieldMapper;
            this.committer = committer;
            this.type = type;
        }

        public BackingFieldBuilder<V, F> withCommitter(Function<F, V> committer) {
            return new BackingFieldBuilder<V, F>(this.fieldMapper, committer, this.type);
        }

        @ApiStatus.Internal
        protected BackingField<V, F> build(Field field) {
            if (!this.matchesType(field)) {
                throw new SimpleConfigClassParser.SimpleConfigClassParseException(field.getDeclaringClass(), "Backing field " + field.getDeclaringClass().getCanonicalName() + "." + field.getName() + " doesn't match its expected type: " + this.type.type().getSimpleName() + "\nIf this is the default field for this entry, you may annotate it with @NotEntry to suppress this error");
            }
            return new BackingField<V, F>(field, this.fieldMapper, this.committer);
        }

        @ApiStatus.Internal
        protected boolean matchesType(Field field) {
            return this.type == null || this.type.matches(EntryType.fromField(field));
        }
    }

    public static class BackingFieldBinding<V, F> {
        private final String name;
        private final String suffix;
        private final BackingFieldBuilder<V, F> builder;

        public static <V, F> BackingFieldBinding<V, F> sameName(BackingFieldBuilder<V, F> builder) {
            return new BackingFieldBinding<V, F>(null, "", builder);
        }

        public static <V, F> BackingFieldBinding<V, F> withName(String name, BackingFieldBuilder<V, F> builder) {
            return new BackingFieldBinding<V, F>(name, null, builder);
        }

        public static <V, F> BackingFieldBinding<V, F> withSuffix(String suffix, BackingFieldBuilder<V, F> builder) {
            return new BackingFieldBinding<V, F>(null, suffix, builder);
        }

        private BackingFieldBinding(String name, String suffix, BackingFieldBuilder<V, F> builder) {
            this.name = name;
            this.suffix = suffix;
            this.builder = builder;
        }

        @ApiStatus.Internal
        public String buildName(String name) {
            return this.suffix != null ? name + this.suffix : (this.name != null ? this.name : name);
        }

        @ApiStatus.Internal
        public BackingField<V, F> build(Field field) {
            return this.builder.build(field);
        }
    }
}

