/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core;

import endorh.simpleconfig.api.ConfigEntryBuilder;
import endorh.simpleconfig.api.ConfigEntryHolderBuilder;
import endorh.simpleconfig.api.ConfigGroupBuilder;
import endorh.simpleconfig.core.AbstractConfigEntry;
import endorh.simpleconfig.core.AbstractConfigEntryBuilder;
import endorh.simpleconfig.core.BackingField;
import endorh.simpleconfig.core.SimpleConfigBuilderImpl;
import endorh.simpleconfig.core.entry.TextEntry;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;

public abstract class AbstractSimpleConfigEntryHolderBuilder<Builder extends ConfigEntryHolderBuilder<Builder>>
implements ConfigEntryHolderBuilder<Builder> {
    protected final Map<String, SimpleConfigBuilderImpl.GroupBuilder> groups = new LinkedHashMap<String, SimpleConfigBuilderImpl.GroupBuilder>();
    protected final Map<String, AbstractConfigEntryBuilder<?, ?, ?, ?, ?, ?>> entries = new LinkedHashMap();
    protected final Map<String, Integer> guiOrder = new LinkedHashMap<String, Integer>();
    protected boolean requireRestart = false;
    protected final Map<String, BackingField<?, ?>> backingFields = new HashMap();
    protected final Map<String, List<BackingField<?, ?>>> secondaryBackingFields = new HashMap();
    private int textIDGen = 0;

    protected abstract void addEntry(int var1, String var2, AbstractConfigEntryBuilder<?, ?, ?, ?, ?, ?> var3);

    protected abstract AbstractConfigEntryBuilder<?, ?, ?, ?, ?, ?> getEntry(String var1);

    protected abstract boolean hasEntry(String var1);

    @ApiStatus.Internal
    protected void setBackingField(String name, BackingField<?, ?> field) {
        this.backingFields.put(name, field);
    }

    @ApiStatus.Internal
    protected List<? extends BackingField.BackingFieldBinding<?, ?>> getSecondaryBackingFieldBindings(String name) {
        return this.getEntry((String)name).backingFieldBindings;
    }

    @ApiStatus.Internal
    protected void setSecondaryBackingFields(String name, List<BackingField<?, ?>> fields) {
        if (this.secondaryBackingFields.containsKey(name)) {
            throw new IllegalStateException("Secondary backing fields already set for entry: " + name);
        }
        this.secondaryBackingFields.put(name, fields);
    }

    protected <T> BackingField<T, ?> getBackingField(String name) {
        return this.backingFields.get(name);
    }

    protected <T> List<BackingField<T, ?>> getSecondaryBackingFields(String name) {
        return this.secondaryBackingFields.get(name);
    }

    @ApiStatus.Internal
    public ConfigEntryHolderBuilder<?> getOrCreateHolderBuilder(String name) {
        return this.getOrCreateHolderBuilder(name, false);
    }

    @ApiStatus.Internal
    public ConfigEntryHolderBuilder<?> getOrCreateHolderBuilder(String name, boolean preferCreateCategory) {
        return this.getOrCreateHolderBuilder(name, preferCreateCategory, false);
    }

    @ApiStatus.Internal
    public ConfigEntryHolderBuilder<?> getOrCreateHolderBuilder(String name, boolean preferCreateCategory, boolean createExpanded) {
        return this.getOrCreateHolderBuilder(name, preferCreateCategory, createExpanded, 0);
    }

    @ApiStatus.Internal
    public ConfigEntryHolderBuilder<?> getOrCreateHolderBuilder(String name, boolean preferCreateCategory, boolean createExpanded, int createIndex) {
        String[] split = name.split("\\.", 2);
        SimpleConfigBuilderImpl.GroupBuilder group2 = this.groups.get(split[0]);
        if (group2 == null) {
            if (this.entries.containsKey(split[0])) {
                throw new IllegalArgumentException("Cannot create config group \"" + split[0] + "\" as an entry with the same name already exists!");
            }
            group2 = new SimpleConfigBuilderImpl.GroupBuilder(split[0], createExpanded);
            this.n(group2, createIndex);
        }
        return split.length == 2 ? group2.getOrCreateHolderBuilder(split[1], false, createExpanded, createIndex) : group2;
    }

    protected void checkName(String name) {
        if (name.contains(".")) {
            throw new IllegalArgumentException("Config entry names cannot contain dots: " + name);
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Config entry names cannot be empty");
        }
        if (this.entries.containsKey(name) || this.groups.containsKey(name)) {
            throw new IllegalArgumentException("Duplicate config entry name: " + name);
        }
    }

    @Override
    @Contract(value="-> this")
    public Builder restart() {
        this.requireRestart = true;
        this.groups.values().forEach(AbstractSimpleConfigEntryHolderBuilder::restart);
        for (Map.Entry<String, AbstractConfigEntryBuilder<?, ?, ?, ?, ?, ?>> entry : this.entries.entrySet()) {
            entry.setValue((AbstractConfigEntryBuilder)entry.getValue().restart());
        }
        return this.self();
    }

    @Contract(value="-> this")
    protected Builder self() {
        return (Builder)this;
    }

    @Override
    @Contract(value="_, _ -> this")
    public Builder add(String name, ConfigEntryBuilder<?, ?, ?, ?> entryBuilder) {
        if (!(entryBuilder instanceof AbstractConfigEntryBuilder)) {
            throw new IllegalArgumentException("Entry builder not instance of AbstractConfigEntryBuilder");
        }
        return this.add(0, name, entryBuilder);
    }

    @Contract(value="_, _, _ -> this")
    @ApiStatus.Internal
    public Builder add(int order, String name, ConfigEntryBuilder<?, ?, ?, ?> entryBuilder) {
        if (!(entryBuilder instanceof AbstractConfigEntryBuilder)) {
            throw new IllegalArgumentException("Entry builder not instance of AbstractConfigEntryBuilder");
        }
        this.addEntry(order, name, (AbstractConfigEntryBuilder)entryBuilder);
        return this.self();
    }

    @Override
    @Contract(value="_, _ -> this")
    public Builder text(String name, Object ... args) {
        this.add(name, new TextEntry.Builder().args(args));
        return this.self();
    }

    @Override
    @Contract(value="_ -> this")
    public Builder text(Component text) {
        this.add("_text$" + this.textIDGen++, new TextEntry.Builder(() -> text));
        return this.self();
    }

    @Override
    @Contract(value="_ -> this")
    public Builder text(Supplier<Component> textSupplier) {
        this.add("_text$" + this.textIDGen++, new TextEntry.Builder(textSupplier));
        return this.self();
    }

    protected abstract void buildTranslations(AbstractConfigEntry<?, ?, ?> var1);

    @Contract(value="_, _ -> this")
    @ApiStatus.Internal
    public abstract Builder n(ConfigGroupBuilder var1, int var2);

    @Override
    @Contract(value="_ -> this")
    public Builder n(ConfigGroupBuilder group2) {
        return this.n(group2, 0);
    }
}

