/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.ConfigSpec;
import com.google.common.collect.Lists;
import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.SimpleConfig;
import endorh.simpleconfig.core.AbstractConfigEntry;
import endorh.simpleconfig.core.SimpleConfigImpl;
import endorh.simpleconfig.core.entry.GUIOnlyEntry;
import endorh.simpleconfig.core.entry.TextEntry;
import endorh.simpleconfig.ui.gui.AbstractConfigScreen;
import endorh.simpleconfig.yaml.NodeComments;
import endorh.simpleconfig.yaml.SimpleConfigCommentedYamlWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSimpleConfigEntryHolder
implements ConfigEntryHolder {
    protected static final Pattern DOT = Pattern.compile("\\.");
    private static final Pattern LINE_BREAK = Pattern.compile("\\R");
    private static final Logger LOGGER = LogManager.getLogger();
    protected SimpleConfigImpl root;
    protected Map<String, AbstractConfigEntry<?, ?, ?>> entries;
    protected Map<String, ? extends AbstractSimpleConfigEntryHolder> children;
    protected boolean dirty = false;

    @Override
    @NotNull
    public SimpleConfigImpl getRoot() {
        return this.root;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public AbstractConfigScreen getGUI() {
        return this.root.gui;
    }

    public abstract String getPath();

    @ApiStatus.Internal
    public String getPathPart() {
        return this.getPath() + ".";
    }

    public String getGlobalPath() {
        return this.getRoot().getName() + "." + this.getPath();
    }

    protected abstract String getName();

    protected String getConfigComment() {
        return "";
    }

    @Nullable
    protected NodeComments getNodeComments(@Nullable NodeComments previous) {
        if (previous == null) {
            previous = new NodeComments();
        }
        ArrayList blockComments = previous.getBlockComments();
        String configComment = this.getConfigComment();
        if (configComment.endsWith("\n")) {
            configComment = configComment.substring(0, configComment.length() - 1);
        }
        if (blockComments == null) {
            blockComments = Lists.newArrayList();
        }
        blockComments.removeIf(l -> l.getValue().startsWith("#"));
        if (!configComment.isEmpty()) {
            Arrays.stream(LINE_BREAK.split(configComment)).map(line -> SimpleConfigCommentedYamlWriter.commentLine("# " + line)).forEach(blockComments::add);
        }
        if (blockComments.isEmpty()) {
            blockComments = null;
        }
        previous.setBlockComments(blockComments);
        return previous.isNotEmpty() ? previous : null;
    }

    @Override
    public AbstractSimpleConfigEntryHolder markDirty() {
        this.markDirty(true);
        return this;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    protected void removeGUI() {
        this.entries.values().forEach(AbstractConfigEntry::removeGUI);
        this.children.values().forEach(AbstractSimpleConfigEntryHolder::removeGUI);
    }

    protected void saveSnapshot(CommentedConfig config, boolean fromGUI, boolean fromRemote, @Nullable Predicate<String> selectedPaths) {
        for (Map.Entry<String, ? extends AbstractSimpleConfigEntryHolder> entry : this.children.entrySet()) {
            CommentedConfig subConfig = config.createSubConfig();
            entry.getValue().saveSnapshot(subConfig, fromGUI, fromRemote, selectedPaths);
            if (subConfig.isEmpty()) continue;
            config.set(entry.getKey(), (Object)subConfig);
        }
        for (Map.Entry<String, Object> entry : this.entries.entrySet()) {
            AbstractConfigEntry entry2 = (AbstractConfigEntry)entry.getValue();
            if (selectedPaths != null && !selectedPaths.test(entry2.getPath()) || entry2.nonPersistent) continue;
            entry2.put(config, fromGUI ? entry2.apply(ee -> ee.forConfig(ee.fromGuiOrDefault(ee.getGUI(fromRemote)))) : entry2.apply(ee -> ee.forConfig(ee.get())));
        }
    }

    protected void loadSnapshot(CommentedConfig config, boolean intoGUI, boolean forRemote, @Nullable Predicate<String> selectedPaths) {
        for (Map.Entry<String, ? extends AbstractSimpleConfigEntryHolder> entry : this.children.entrySet()) {
            Object sub;
            if (!config.contains(entry.getKey()) || !((sub = config.get(entry.getKey())) instanceof CommentedConfig)) continue;
            entry.getValue().loadSnapshot((CommentedConfig)sub, intoGUI, forRemote, selectedPaths);
        }
        for (Map.Entry<String, Object> entry : this.entries.entrySet()) {
            AbstractConfigEntry entry2 = (AbstractConfigEntry)entry.getValue();
            if (selectedPaths != null && !selectedPaths.test(entry2.getPath()) || !config.contains(entry.getKey()) || entry2.nonPersistent) continue;
            try {
                if (intoGUI) {
                    entry2.accept(ee -> ee.setGUI(ee.forGui(ee.fromConfigOrDefault(ee.get(config))), forRemote));
                    continue;
                }
                entry2.accept(ee -> ee.set(ee.fromConfig(ee.get(config))));
            }
            catch (SimpleConfig.InvalidConfigValueTypeException ignored) {
                LOGGER.error("Error loading config snapshot. Invalid value type for entry " + entry2.getGlobalPath());
            }
            catch (SimpleConfig.InvalidConfigValueException ignored) {
                LOGGER.error("Error loading config snapshot. Invalid value for entry " + entry2.getGlobalPath());
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void loadGUIExternalChanges() {
        this.children.values().forEach(AbstractSimpleConfigEntryHolder::loadGUIExternalChanges);
        this.entries.values().forEach(entry -> entry.accept(e -> e.setGUIAsExternal(e.forGui(e.get()), false)));
    }

    protected void loadGUIRemoteExternalChanges(CommentedConfig config) {
        this.children.forEach((k, child) -> {
            Object sub = config.get(k);
            if (sub instanceof CommentedConfig) {
                child.loadGUIRemoteExternalChanges((CommentedConfig)sub);
            }
        });
        this.entries.forEach((k, entry) -> {
            if (config.contains(k) && !entry.nonPersistent) {
                Object v = config.get(k);
                entry.accept(e -> e.setGUIAsExternal(e.forGui(e.fromConfigOrDefault(e.fromActualConfig(v))), true));
            }
        });
    }

    protected void updateComments(Map<String, NodeComments> comments) {
        NodeComments nodeComments;
        String path;
        String type = this.root.getType().getAlias();
        boolean first = true;
        for (AbstractConfigEntry<?, ?, ?> abstractConfigEntry : this.entries.values()) {
            path = abstractConfigEntry.getPath();
            if (path.startsWith(type + ".")) {
                path = path.substring(type.length() + 1);
            }
            if ((nodeComments = abstractConfigEntry.getNodeComments(comments.get(path))) != null) {
                first = false;
                comments.put(path, nodeComments);
                continue;
            }
            comments.remove(path);
        }
        for (AbstractSimpleConfigEntryHolder abstractSimpleConfigEntryHolder : this.children.values()) {
            path = abstractSimpleConfigEntryHolder.getPath();
            if (path.startsWith(type + ".")) {
                path = path.substring(type.length() + 1);
            }
            nodeComments = abstractSimpleConfigEntryHolder.getNodeComments(comments.get(path));
            if (first) {
                first = false;
            } else {
                if (nodeComments == null) {
                    nodeComments = new NodeComments();
                }
                nodeComments.addSeparatorLine();
            }
            if (nodeComments != null && nodeComments.isNotEmpty()) {
                comments.put(path, nodeComments);
            } else {
                comments.remove(path);
            }
            abstractSimpleConfigEntryHolder.updateComments(comments);
        }
    }

    protected void buildConfigSpec(ConfigSpec spec, String path) {
        String thisPath = path + this.getName() + ".";
        for (AbstractConfigEntry<?, ?, ?> abstractConfigEntry : this.entries.values()) {
            abstractConfigEntry.buildSpec(spec, thisPath);
        }
        for (AbstractSimpleConfigEntryHolder abstractSimpleConfigEntryHolder : this.children.values()) {
            abstractSimpleConfigEntryHolder.buildConfigSpec(spec, thisPath);
        }
    }

    protected abstract void bake();

    @Override
    @ApiStatus.Internal
    public void markDirty(boolean dirty) {
        this.dirty = dirty;
        if (!dirty) {
            this.children.values().forEach(c -> c.markDirty(false));
            this.entries.values().forEach(e -> e.dirty(false));
        }
    }

    public boolean anyDirtyRequiresRestart() {
        return this.entries.values().stream().anyMatch(e -> e.dirty && e.requireRestart) || this.children.values().stream().anyMatch(AbstractSimpleConfigEntryHolder::anyDirtyRequiresRestart);
    }

    @Nullable
    public AbstractSimpleConfigEntryHolder getChildOrNull(String path) {
        if (path == null || path.isEmpty()) {
            return this;
        }
        String[] split = DOT.split(path, 2);
        if (split.length < 2) {
            return this.children.get(path);
        }
        if (this.children.containsKey(split[0])) {
            return this.children.get(split[0]).getChildOrNull(split[1]);
        }
        return null;
    }

    @Override
    @NotNull
    public AbstractSimpleConfigEntryHolder getChild(String path) {
        AbstractSimpleConfigEntryHolder child = this.getChildOrNull(path);
        if (child == null) {
            throw new SimpleConfig.NoSuchConfigGroupError(this.getPath() + "." + path);
        }
        return child;
    }

    @ApiStatus.Internal
    public void removeEntry(String name) {
        String[] split = DOT.split(name, 2);
        if (split.length == 1) {
            this.entries.remove(name);
        } else if (this.children.containsKey(split[0])) {
            this.children.get(split[0]).removeEntry(split[1]);
        } else {
            throw new SimpleConfig.NoSuchConfigGroupError(this.getPath() + "." + split[0]);
        }
    }

    @ApiStatus.Internal
    public void removeChild(String name) {
        String[] split = DOT.split(name, 2);
        if (split.length == 1) {
            this.children.remove(name);
        } else if (this.children.containsKey(split[0])) {
            this.children.get(split[0]).removeChild(split[1]);
        } else {
            throw new SimpleConfig.NoSuchConfigGroupError(this.getPath() + "." + split[0]);
        }
    }

    @ApiStatus.Internal
    @Nullable
    public <T, C, Gui> AbstractConfigEntry<T, C, Gui> getEntryOrNull(String path) {
        AbstractConfigEntry<Object, ?, ?> entry = this.entries.get(path);
        if (entry == null) {
            entry = this.getSubEntry(path);
        }
        return entry;
    }

    @ApiStatus.Internal
    @NotNull
    public <T, C, Gui> AbstractConfigEntry<T, C, Gui> getEntry(String path) {
        AbstractConfigEntry<T, C, Gui> entry = this.getEntryOrNull(path);
        if (entry == null) {
            throw new SimpleConfig.NoSuchConfigEntryError(this.getPath() + "." + path);
        }
        return entry;
    }

    protected <T> AbstractConfigEntry<T, ?, ?> getSubEntry(String path) {
        String[] split = DOT.split(path, 2);
        if (split.length < 2) {
            return null;
        }
        AbstractSimpleConfigEntryHolder child = this.getChildOrNull(split[0]);
        if (child == null) {
            return null;
        }
        return child.getEntryOrNull(split[1]);
    }

    @ApiStatus.Internal
    public boolean hasEntry(String path) {
        AbstractConfigEntry entry = this.getEntryOrNull(path);
        return entry != null && !(entry instanceof TextEntry);
    }

    @ApiStatus.Internal
    public boolean hasChild(String path) {
        return this.getChildOrNull(path) != null;
    }

    @ApiStatus.Internal
    public Collection<String> getPaths(boolean includeGroups) {
        ArrayList<String> list = new ArrayList<String>();
        this.gatherPaths(list, "", includeGroups);
        return list;
    }

    protected void gatherPaths(List<String> paths, String prefix, boolean includeGroups) {
        this.entries.forEach((k, e) -> {
            if (!(e instanceof TextEntry) && !(e instanceof GUIOnlyEntry)) {
                paths.add(prefix + k);
            }
        });
        this.children.forEach((key, child) -> {
            if (includeGroups) {
                paths.add(prefix + key);
            }
            child.gatherPaths(paths, prefix + key + ".", includeGroups);
        });
    }

    protected abstract void commitFields();

    protected void commitFields(String path) {
        if (path == null || path.isEmpty()) {
            this.commitFields();
        }
        this.getChild(path).commitFields();
    }

    @Override
    public <T> T get(String path) {
        return this.getEntry(path).get();
    }

    @Override
    public <T> T getBaked(String path) {
        return this.getEntry(path).getPresented();
    }

    @Override
    public <V> void set(String path, V value) {
        if (value instanceof Number) {
            try {
                this.set(path, (Number)value);
                return;
            }
            catch (SimpleConfig.InvalidConfigValueTypeException invalidConfigValueTypeException) {
                // empty catch block
            }
        }
        this.doSet(path, value);
    }

    public void set(String path, Number number) {
        boolean pre = number instanceof Byte;
        if (pre) {
            try {
                this.doSet(path, number.byteValue());
                return;
            }
            catch (SimpleConfig.InvalidConfigValueTypeException invalidConfigValueTypeException) {
                // empty catch block
            }
        }
        if (pre |= number instanceof Short) {
            try {
                this.doSet(path, number.shortValue());
                return;
            }
            catch (SimpleConfig.InvalidConfigValueTypeException invalidConfigValueTypeException) {
                // empty catch block
            }
        }
        if (pre |= number instanceof Integer) {
            try {
                this.doSet(path, number.intValue());
                return;
            }
            catch (SimpleConfig.InvalidConfigValueTypeException invalidConfigValueTypeException) {
                // empty catch block
            }
        }
        if (pre || number instanceof Long) {
            try {
                this.doSet(path, number.longValue());
                return;
            }
            catch (SimpleConfig.InvalidConfigValueTypeException invalidConfigValueTypeException) {
                // empty catch block
            }
        }
        if (number instanceof Float) {
            try {
                this.doSet(path, Float.valueOf(number.floatValue()));
                return;
            }
            catch (SimpleConfig.InvalidConfigValueTypeException invalidConfigValueTypeException) {
                // empty catch block
            }
        }
        this.doSet(path, number.doubleValue());
    }

    @ApiStatus.Internal
    public <V> void doSet(String path, V value) {
        try {
            AbstractConfigEntry entry = this.getEntry(path);
            if (!entry.typeClass.isInstance(value)) {
                throw new SimpleConfig.InvalidConfigValueTypeException(this.getPath() + "." + path);
            }
            entry.set(value);
        }
        catch (ClassCastException e) {
            throw new SimpleConfig.InvalidConfigValueTypeException(this.getPath() + "." + path, e);
        }
    }

    @Override
    public <V> void setBaked(String path, V value) {
        if (value instanceof Number) {
            try {
                this.setBaked(path, (Number)value);
                return;
            }
            catch (SimpleConfig.InvalidConfigValueTypeException invalidConfigValueTypeException) {
                // empty catch block
            }
        }
        this.doSetBaked(path, value);
    }

    public void setBaked(String path, Number number) {
        boolean pre = number instanceof Byte;
        if (pre) {
            try {
                this.doSetBaked(path, number.byteValue());
                return;
            }
            catch (SimpleConfig.InvalidConfigValueTypeException invalidConfigValueTypeException) {
                // empty catch block
            }
        }
        if (pre |= number instanceof Short) {
            try {
                this.doSetBaked(path, number.shortValue());
                return;
            }
            catch (SimpleConfig.InvalidConfigValueTypeException invalidConfigValueTypeException) {
                // empty catch block
            }
        }
        if (pre |= number instanceof Integer) {
            try {
                this.doSetBaked(path, number.intValue());
                return;
            }
            catch (SimpleConfig.InvalidConfigValueTypeException invalidConfigValueTypeException) {
                // empty catch block
            }
        }
        if (pre || number instanceof Long) {
            try {
                this.doSetBaked(path, number.longValue());
                return;
            }
            catch (SimpleConfig.InvalidConfigValueTypeException invalidConfigValueTypeException) {
                // empty catch block
            }
        }
        if (number instanceof Float) {
            try {
                this.doSetBaked(path, Float.valueOf(number.floatValue()));
                return;
            }
            catch (SimpleConfig.InvalidConfigValueTypeException invalidConfigValueTypeException) {
                // empty catch block
            }
        }
        this.doSetBaked(path, number.doubleValue());
    }

    @ApiStatus.Internal
    public <V> void doSetBaked(String path, V value) {
        try {
            AbstractConfigEntry entry = this.getEntry(path);
            if (!entry.typeClass.isInstance(value)) {
                throw new SimpleConfig.InvalidConfigValueTypeException(this.getPath() + "." + path);
            }
            entry.setPresented(value);
        }
        catch (ClassCastException e) {
            throw new SimpleConfig.InvalidConfigValueTypeException(this.getPath() + "." + path, e);
        }
    }

    @Override
    public <G> void setGUI(String path, G value) {
        if (value instanceof Number) {
            try {
                this.setGUI(path, (Number)value);
                return;
            }
            catch (SimpleConfig.InvalidConfigValueTypeException invalidConfigValueTypeException) {
                // empty catch block
            }
        }
        this.doSetGUI(path, value);
    }

    public void setGUI(String path, Number number) {
        boolean pre = number instanceof Byte;
        if (pre) {
            try {
                this.doSetGUI(path, number.byteValue());
                return;
            }
            catch (SimpleConfig.InvalidConfigValueTypeException invalidConfigValueTypeException) {
                // empty catch block
            }
        }
        if (pre |= number instanceof Short) {
            try {
                this.doSetGUI(path, number.shortValue());
                return;
            }
            catch (SimpleConfig.InvalidConfigValueTypeException invalidConfigValueTypeException) {
                // empty catch block
            }
        }
        if (pre |= number instanceof Integer) {
            try {
                this.doSetGUI(path, number.intValue());
                return;
            }
            catch (SimpleConfig.InvalidConfigValueTypeException invalidConfigValueTypeException) {
                // empty catch block
            }
        }
        if (pre || number instanceof Long) {
            try {
                this.doSetGUI(path, number.longValue());
                return;
            }
            catch (SimpleConfig.InvalidConfigValueTypeException invalidConfigValueTypeException) {
                // empty catch block
            }
        }
        if (number instanceof Float) {
            try {
                this.doSetGUI(path, Float.valueOf(number.floatValue()));
                return;
            }
            catch (SimpleConfig.InvalidConfigValueTypeException invalidConfigValueTypeException) {
                // empty catch block
            }
        }
        this.doSetGUI(path, number.doubleValue());
    }

    @ApiStatus.Internal
    public <G> void doSetGUI(String path, G value) {
        try {
            this.getEntry(path).setGUI(value);
        }
        catch (ClassCastException e) {
            throw new SimpleConfig.InvalidConfigValueTypeException(this.getPath() + "." + path, e);
        }
    }

    protected <V> void doSetForGUI(String path, V value) {
        try {
            this.getEntry(path).accept(e -> e.setGUI(e.forGui(value)));
        }
        catch (ClassCastException e2) {
            throw new SimpleConfig.InvalidConfigValueTypeException(this.getPath() + "." + path, e2);
        }
    }

    @Override
    public <V> void setForGUI(String path, V value) {
        if (value instanceof Number) {
            try {
                this.setForGUI(path, (Number)value);
                return;
            }
            catch (SimpleConfig.InvalidConfigValueTypeException invalidConfigValueTypeException) {
                // empty catch block
            }
        }
        this.doSetForGUI(path, value);
    }

    @Override
    public void setForGUI(String path, Number number) {
        boolean pre = number instanceof Byte;
        if (pre) {
            try {
                this.doSetForGUI(path, number.byteValue());
                return;
            }
            catch (SimpleConfig.InvalidConfigValueTypeException invalidConfigValueTypeException) {
                // empty catch block
            }
        }
        if (pre |= number instanceof Short) {
            try {
                this.doSetForGUI(path, number.shortValue());
                return;
            }
            catch (SimpleConfig.InvalidConfigValueTypeException invalidConfigValueTypeException) {
                // empty catch block
            }
        }
        if (pre |= number instanceof Integer) {
            try {
                this.doSetForGUI(path, number.intValue());
                return;
            }
            catch (SimpleConfig.InvalidConfigValueTypeException invalidConfigValueTypeException) {
                // empty catch block
            }
        }
        if (pre || number instanceof Long) {
            try {
                this.doSetForGUI(path, number.longValue());
                return;
            }
            catch (SimpleConfig.InvalidConfigValueTypeException invalidConfigValueTypeException) {
                // empty catch block
            }
        }
        if (number instanceof Float) {
            try {
                this.doSetForGUI(path, Float.valueOf(number.floatValue()));
                return;
            }
            catch (SimpleConfig.InvalidConfigValueTypeException invalidConfigValueTypeException) {
                // empty catch block
            }
        }
        this.doSetForGUI(path, number.doubleValue());
    }

    @Override
    public boolean hasGUI(String path) {
        return this.getEntry(path).hasGUI();
    }

    @Override
    public <G> G getGUI(String path) {
        try {
            return (G)this.getEntry(path).getGUI();
        }
        catch (ClassCastException e) {
            throw new SimpleConfig.InvalidConfigValueTypeException(this.getPath() + "." + path, e);
        }
    }

    @Override
    public <V> V getFromGUI(String path) {
        return (V)this.getEntry(path).apply(e -> e.fromGui(e.getGUI()));
    }

    @Override
    public void reset() {
        Iterator<Object> iterator = this.entries.values().iterator();
        while (iterator.hasNext()) {
            AbstractConfigEntry<?, ?, ?> abstractConfigEntry;
            AbstractConfigEntry<?, ?, ?> e = abstractConfigEntry = iterator.next();
            e.set(e.defValue);
        }
        for (AbstractSimpleConfigEntryHolder abstractSimpleConfigEntryHolder : this.children.values()) {
            abstractSimpleConfigEntryHolder.reset();
        }
    }

    @Override
    public void reset(String path) {
        AbstractSimpleConfigEntryHolder child = this.getChildOrNull(path);
        if (child != null) {
            child.reset();
        } else {
            AbstractConfigEntry entry = this.getEntry(path);
            entry.set(entry.defValue);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean resetInGUI(String path) {
        AbstractConfigEntry entry = this.getEntry(path);
        if (entry.hasGUI()) {
            entry.resetGuiEntry();
            return true;
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean restoreInGUI(String path) {
        AbstractConfigEntry entry = this.getEntry(path);
        if (entry.hasGUI()) {
            entry.restoreGuiEntry();
            return true;
        }
        return false;
    }
}

