/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core;

import endorh.simpleconfig.api.ConfigEntryBuilder;
import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.EntryTag;
import endorh.simpleconfig.core.AbstractConfigEntry;
import endorh.simpleconfig.core.BackingField;
import endorh.simpleconfig.core.EntryType;
import endorh.simpleconfig.core.ValuePresentation;
import endorh.simpleconfig.core.wrap.ConfigEntryDelegate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractConfigEntryBuilder<V, Config, Gui, Entry extends AbstractConfigEntry<V, Config, Gui>, Self extends ConfigEntryBuilder<V, Config, Gui, Self>, SelfImpl extends AbstractConfigEntryBuilder<V, Config, Gui, Entry, Self, SelfImpl>>
implements ConfigEntryBuilder<V, Config, Gui, Self> {
    protected V value;
    @Nullable
    protected Consumer<AbstractConfigEntry<V, Config, Gui>> buildListener = null;
    @Nullable
    protected BiFunction<AbstractConfigEntry<V, Config, Gui>, Gui, Optional<Component>> errorSupplier = null;
    @Nullable
    protected BiFunction<AbstractConfigEntry<V, Config, Gui>, Gui, List<Component>> tooltipSupplier = null;
    @Nullable
    protected Function<ConfigEntryHolder, Boolean> editableSupplier = null;
    @Nullable
    protected ValuePresentation<V, V> presentation = null;
    @Nullable
    protected String translation = null;
    protected List<Object> nameArgs = new ArrayList<Object>();
    protected List<Object> tooltipArgs = new ArrayList<Object>();
    protected boolean requireRestart = false;
    protected boolean experimental = false;
    protected Class<?> typeClass;
    protected EntryType<?> type;
    protected boolean nonPersistent = false;
    protected boolean ignored = false;
    protected Set<EntryTag> tags = new HashSet<EntryTag>();
    protected BackingField.BackingFieldBuilder<V, ?> backingFieldBuilder;
    protected List<BackingField.BackingFieldBinding<V, ?>> backingFieldBindings = new ArrayList();
    @Nullable
    protected ConfigEntryDelegate<V> delegate = null;

    protected AbstractConfigEntryBuilder(V value, EntryType<?> type) {
        this.value = value;
        this.type = type;
        this.typeClass = type != null ? type.type() : null;
        this.backingFieldBuilder = type != null ? BackingField.BackingFieldBuilder.of(Function.identity(), type).withCommitter(Function.identity()) : null;
    }

    @ApiStatus.Internal
    public static EntryType<?> getEntryType(ConfigEntryBuilder<?, ?, ?, ?> builder) {
        return ((AbstractConfigEntryBuilder)builder).type;
    }

    @Contract(pure=true)
    @ApiStatus.Internal
    public SelfImpl withBuildListener(Consumer<AbstractConfigEntry<V, Config, Gui>> buildListener) {
        SelfImpl copy = this.copy();
        ((AbstractConfigEntryBuilder)copy).buildListener = buildListener;
        return copy;
    }

    @Contract(pure=true)
    protected abstract Entry buildEntry(ConfigEntryHolder var1, String var2);

    private static <T> Optional<T> or(Optional<T> a, Supplier<Optional<T>> b) {
        return a.isPresent() ? a : b.get();
    }

    protected Self castSelf() {
        return (Self)this;
    }

    @Override
    @ApiStatus.Internal
    public V getValue() {
        return this.value;
    }

    @ApiStatus.Internal
    public Class<?> getTypeClass() {
        return this.typeClass;
    }

    @ApiStatus.Internal
    public EntryType<?> getEntryType() {
        return this.type;
    }

    @ApiStatus.Internal
    @Nullable
    public ValuePresentation<V, V> getPresentation() {
        return this.presentation;
    }

    @ApiStatus.Internal
    @Nullable
    public BiFunction<AbstractConfigEntry<V, Config, Gui>, Gui, Optional<Component>> getErrorSupplier() {
        return this.errorSupplier;
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Self withValue(V value) {
        return ((AbstractConfigEntryBuilder)this.copy(value)).castSelf();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Self guiError(Function<Gui, Optional<Component>> guiErrorSupplier) {
        SelfImpl copy = this.copy();
        BiFunction prev = ((AbstractConfigEntryBuilder)copy).errorSupplier == null ? (e, g) -> Optional.empty() : ((AbstractConfigEntryBuilder)copy).errorSupplier;
        ((AbstractConfigEntryBuilder)copy).errorSupplier = (e, g) -> AbstractConfigEntryBuilder.or((Optional)prev.apply(e, g), () -> (Optional)guiErrorSupplier.apply(g));
        return ((AbstractConfigEntryBuilder)copy).castSelf();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Self error(Function<V, Optional<Component>> errorSupplier) {
        SelfImpl copy = this.copy();
        BiFunction prev = ((AbstractConfigEntryBuilder)copy).errorSupplier == null ? (e, g) -> Optional.empty() : ((AbstractConfigEntryBuilder)copy).errorSupplier;
        ((AbstractConfigEntryBuilder)copy).errorSupplier = (e, g) -> AbstractConfigEntryBuilder.or((Optional)prev.apply(e, g), () -> {
            Object v = e.fromGui(g);
            if (v == null) {
                return Optional.of(Component.m_237115_((String)"simpleconfig.config.error.missing_value"));
            }
            return (Optional)errorSupplier.apply(v);
        });
        return ((AbstractConfigEntryBuilder)copy).castSelf();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Self configError(Function<Config, Optional<Component>> configErrorSupplier) {
        SelfImpl copy = this.copy();
        BiFunction prev = ((AbstractConfigEntryBuilder)copy).errorSupplier == null ? (e, g) -> Optional.empty() : ((AbstractConfigEntryBuilder)copy).errorSupplier;
        ((AbstractConfigEntryBuilder)copy).errorSupplier = (e, g) -> AbstractConfigEntryBuilder.or((Optional)prev.apply(e, g), () -> {
            Object v = e.fromGui(g);
            if (v == null) {
                return Optional.of(Component.m_237115_((String)"simpleconfig.config.error.missing_value"));
            }
            return (Optional)configErrorSupplier.apply(e.forConfig(v));
        });
        return ((AbstractConfigEntryBuilder)copy).castSelf();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Self withoutError() {
        SelfImpl copy = this.copy();
        ((AbstractConfigEntryBuilder)copy).errorSupplier = null;
        return ((AbstractConfigEntryBuilder)copy).castSelf();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Self guiTooltip(Function<Gui, List<Component>> tooltipSupplier) {
        SelfImpl copy = this.copy();
        ((AbstractConfigEntryBuilder)copy).tooltipSupplier = (e, g) -> (List)tooltipSupplier.apply(g);
        return ((AbstractConfigEntryBuilder)copy).castSelf();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Self tooltip(Function<V, List<Component>> tooltipSupplier) {
        SelfImpl copy = this.copy();
        ((AbstractConfigEntryBuilder)copy).tooltipSupplier = (e, g) -> {
            Object v = e.fromGui(g);
            if (v == null) {
                return Collections.emptyList();
            }
            return (List)tooltipSupplier.apply(v);
        };
        return ((AbstractConfigEntryBuilder)copy).castSelf();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Self withoutTooltip() {
        SelfImpl copy = this.copy();
        ((AbstractConfigEntryBuilder)copy).tooltipSupplier = null;
        return ((AbstractConfigEntryBuilder)copy).castSelf();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Self tooltipArgs(Object ... args) {
        SelfImpl copy = this.copy();
        ((AbstractConfigEntryBuilder)copy).tooltipArgs.clear();
        ((AbstractConfigEntryBuilder)copy).tooltipArgs.addAll(Arrays.asList(args));
        return ((AbstractConfigEntryBuilder)copy).castSelf();
    }

    @Override
    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public final Self tooltipArgs(Supplier<Object> ... args) {
        return this.tooltipArgs((Object[])args);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Self nameArgs(Object ... args) {
        SelfImpl copy = this.copy();
        ((AbstractConfigEntryBuilder)copy).nameArgs.clear();
        ((AbstractConfigEntryBuilder)copy).nameArgs.addAll(Arrays.asList(args));
        return ((AbstractConfigEntryBuilder)copy).castSelf();
    }

    @Override
    @NotNull
    public Self baked(Function<V, V> presentation) {
        SelfImpl copy = this.copy();
        ((AbstractConfigEntryBuilder)copy).presentation = ValuePresentation.of(presentation);
        return ((AbstractConfigEntryBuilder)copy).castSelf();
    }

    @Override
    @NotNull
    public Self baked(Function<V, V> presentation, Function<V, V> inverse) {
        SelfImpl copy = this.copy();
        ((AbstractConfigEntryBuilder)copy).presentation = ValuePresentation.of(presentation, inverse);
        return ((AbstractConfigEntryBuilder)copy).castSelf();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public <F> Self addField(String suffix, Function<V, F> mapper, Class<?> type) {
        return this.addField(BackingField.BackingFieldBinding.withSuffix(suffix, BackingField.BackingFieldBuilder.of(mapper, EntryType.unchecked(type))));
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public <F> Self add_field(String suffix, Function<V, F> mapper, Class<?> type) {
        return this.addField("_" + suffix, mapper, type);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public <F> Self field(Function<V, F> mapper, Function<F, V> reader, Class<?> type) {
        SelfImpl copy = this.copy();
        ((AbstractConfigEntryBuilder)copy).backingFieldBuilder = BackingField.BackingFieldBuilder.of(mapper, EntryType.unchecked(type)).withCommitter(reader);
        return ((AbstractConfigEntryBuilder)copy).castSelf();
    }

    @Override
    @NotNull
    public <F> Self field(String name, Function<V, F> mapper, Class<?> type) {
        return this.addField(BackingField.BackingFieldBinding.withName(name, BackingField.BackingFieldBuilder.of(mapper, EntryType.unchecked(type))));
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public <F> Self field(Function<V, F> mapper, Class<?> type) {
        SelfImpl copy = this.copy();
        ((AbstractConfigEntryBuilder)copy).backingFieldBuilder = BackingField.BackingFieldBuilder.of(mapper, EntryType.unchecked(type));
        return ((AbstractConfigEntryBuilder)copy).castSelf();
    }

    @Contract(pure=true)
    @ApiStatus.Internal
    public <F> Self addField(BackingField.BackingFieldBinding<V, F> binding) {
        SelfImpl copy = this.copy();
        ((AbstractConfigEntryBuilder)copy).backingFieldBindings.add(binding);
        return ((AbstractConfigEntryBuilder)copy).castSelf();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Self restart() {
        return this.restart(true);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Self restart(boolean requireRestart) {
        SelfImpl copy = this.copy();
        ((AbstractConfigEntryBuilder)copy).requireRestart = requireRestart;
        return ((AbstractConfigEntryBuilder)copy).castSelf();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Self experimental() {
        return this.experimental(true);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Self experimental(boolean experimental) {
        SelfImpl copy = this.copy();
        ((AbstractConfigEntryBuilder)copy).experimental = experimental;
        return ((AbstractConfigEntryBuilder)copy).castSelf();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Self editable(Supplier<Boolean> editable) {
        SelfImpl copy = this.copy();
        ((AbstractConfigEntryBuilder)copy).editableSupplier = h -> (Boolean)editable.get();
        return ((AbstractConfigEntryBuilder)copy).castSelf();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Self editable(Function<ConfigEntryHolder, Boolean> editable) {
        SelfImpl copy = this.copy();
        ((AbstractConfigEntryBuilder)copy).editableSupplier = editable;
        return ((AbstractConfigEntryBuilder)copy).castSelf();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Self temp() {
        return this.temp(true);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Self temp(boolean nonPersistent) {
        SelfImpl copy = this.copy();
        ((AbstractConfigEntryBuilder)copy).nonPersistent = nonPersistent;
        if (!nonPersistent) {
            ((AbstractConfigEntryBuilder)copy).ignored = false;
        }
        return ((AbstractConfigEntryBuilder)copy).castSelf();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Self ignored() {
        return this.ignored(true);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Self ignored(boolean ignored) {
        SelfImpl copy = this.copy();
        ((AbstractConfigEntryBuilder)copy).ignored = ignored;
        if (ignored) {
            ((AbstractConfigEntryBuilder)copy).nonPersistent = true;
        }
        return ((AbstractConfigEntryBuilder)copy).castSelf();
    }

    @Contract(pure=true)
    @ApiStatus.Internal
    public SelfImpl translation(@Nullable String translation) {
        SelfImpl copy = this.copy();
        ((AbstractConfigEntryBuilder)copy).translation = translation;
        return copy;
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Self withTags(EntryTag ... tags) {
        SelfImpl copy = this.copy();
        ((AbstractConfigEntryBuilder)copy).tags.addAll(Arrays.asList(tags));
        return ((AbstractConfigEntryBuilder)copy).castSelf();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Self withoutTags(EntryTag ... tags) {
        SelfImpl copy = this.copy();
        Arrays.stream(tags).forEach(((AbstractConfigEntryBuilder)copy).tags::remove);
        return ((AbstractConfigEntryBuilder)copy).castSelf();
    }

    @ApiStatus.Internal
    public SelfImpl withDelegate(@Nullable ConfigEntryDelegate<V> delegate) {
        SelfImpl copy = this.copy();
        ((AbstractConfigEntryBuilder)copy).delegate = delegate;
        return copy;
    }

    @Contract(value="_, _ -> new", pure=true)
    @MustBeInvokedByOverriders
    protected Entry build(@NotNull ConfigEntryHolder parent, String name) {
        Entry e = this.buildEntry(parent, name);
        ((AbstractConfigEntry)e).requireRestart = this.requireRestart;
        ((AbstractConfigEntry)e).experimental = this.experimental;
        ((AbstractConfigEntry)e).errorSupplier = this.errorSupplier;
        ((AbstractConfigEntry)e).tooltipSupplier = this.tooltipSupplier;
        ((AbstractConfigEntry)e).translation = this.translation;
        ((AbstractConfigEntry)e).nameArgs = this.nameArgs;
        ((AbstractConfigEntry)e).tooltipArgs = this.tooltipArgs;
        ((AbstractConfigEntry)e).typeClass = this.typeClass;
        ((AbstractConfigEntry)e).editableSupplier = this.editableSupplier;
        ((AbstractConfigEntry)e).nonPersistent = this.nonPersistent;
        if (this.nonPersistent) {
            ((AbstractConfigEntry)e).actualValue = ((AbstractConfigEntry)e).defValue;
        }
        ((AbstractConfigEntry)e).ignored = this.ignored;
        ((AbstractConfigEntry)e).tags.clear();
        ((AbstractConfigEntry)e).tags.addAll(this.tags);
        ((AbstractConfigEntry)e).setPresentation(this.presentation);
        if (this.buildListener != null) {
            this.buildListener.accept((AbstractConfigEntry<V, Config, Gui>)e);
        }
        if (this.delegate != null) {
            ((AbstractConfigEntry)e).setDelegate(this.delegate);
        }
        return e;
    }

    @Contract(value="_ -> new", pure=true)
    protected abstract SelfImpl createCopy(V var1);

    @Contract(value="-> new", pure=true)
    @MustBeInvokedByOverriders
    @ApiStatus.Internal
    public SelfImpl copy() {
        return this.copy(this.value);
    }

    @Contract(value="_ -> new", pure=true)
    @MustBeInvokedByOverriders
    @ApiStatus.Internal
    public SelfImpl copy(V value) {
        SelfImpl copy = this.createCopy(value);
        ((AbstractConfigEntryBuilder)copy).value = value;
        ((AbstractConfigEntryBuilder)copy).translation = this.translation;
        ((AbstractConfigEntryBuilder)copy).buildListener = this.buildListener;
        ((AbstractConfigEntryBuilder)copy).errorSupplier = this.errorSupplier;
        ((AbstractConfigEntryBuilder)copy).tooltipSupplier = this.tooltipSupplier;
        ((AbstractConfigEntryBuilder)copy).nameArgs = new ArrayList<Object>(this.nameArgs);
        ((AbstractConfigEntryBuilder)copy).tooltipArgs = new ArrayList<Object>(this.tooltipArgs);
        ((AbstractConfigEntryBuilder)copy).requireRestart = this.requireRestart;
        ((AbstractConfigEntryBuilder)copy).experimental = this.experimental;
        ((AbstractConfigEntryBuilder)copy).typeClass = this.typeClass;
        ((AbstractConfigEntryBuilder)copy).type = this.type;
        ((AbstractConfigEntryBuilder)copy).editableSupplier = this.editableSupplier;
        ((AbstractConfigEntryBuilder)copy).nonPersistent = this.nonPersistent;
        ((AbstractConfigEntryBuilder)copy).ignored = this.ignored;
        ((AbstractConfigEntryBuilder)copy).presentation = this.presentation;
        ((AbstractConfigEntryBuilder)copy).backingFieldBuilder = this.backingFieldBuilder;
        ((AbstractConfigEntryBuilder)copy).backingFieldBindings = new ArrayList(this.backingFieldBindings);
        ((AbstractConfigEntryBuilder)copy).tags = new HashSet<EntryTag>(this.tags);
        ((AbstractConfigEntryBuilder)copy).delegate = this.delegate;
        return copy;
    }
}

