/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.ConfigSpec;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.EntryTag;
import endorh.simpleconfig.api.SimpleConfig;
import endorh.simpleconfig.api.SimpleConfigTextUtil;
import endorh.simpleconfig.config.ClientConfig;
import endorh.simpleconfig.core.AbstractSimpleConfigEntryHolder;
import endorh.simpleconfig.core.BackingField;
import endorh.simpleconfig.core.ServerI18n;
import endorh.simpleconfig.core.SimpleConfigImpl;
import endorh.simpleconfig.core.ValuePresentation;
import endorh.simpleconfig.core.wrap.ConfigEntryDelegate;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.DumperOptions;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.Yaml;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.error.YAMLException;
import endorh.simpleconfig.ui.api.AbstractConfigListEntry;
import endorh.simpleconfig.ui.api.ConfigCategoryBuilder;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.gui.AbstractConfigScreen;
import endorh.simpleconfig.ui.impl.builders.CaptionedSubCategoryBuilder;
import endorh.simpleconfig.ui.impl.builders.FieldBuilder;
import endorh.simpleconfig.yaml.NodeComments;
import endorh.simpleconfig.yaml.SimpleConfigCommentedYamlFormat;
import endorh.simpleconfig.yaml.SimpleConfigCommentedYamlWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractConfigEntry<V, Config, Gui>
implements SimpleConfigImpl.IGUIEntry {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Pattern LINE_BREAK = Pattern.compile("\\R");
    private static final Component[] EMPTY_TEXT_ARRAY = new Component[0];
    public final V defValue;
    @Nullable
    private ValuePresentation<V, V> presentation;
    protected final ConfigEntryHolder parent;
    protected String name;
    protected Class<?> typeClass;
    @Nullable
    protected String translation = null;
    @Nullable
    protected String tooltip = null;
    protected boolean requireRestart = false;
    protected boolean experimental;
    @Nullable
    protected BiFunction<AbstractConfigEntry<V, Config, Gui>, Gui, Optional<Component>> errorSupplier = null;
    @Nullable
    protected BiFunction<AbstractConfigEntry<V, Config, Gui>, Gui, List<Component>> tooltipSupplier = null;
    @Nullable
    protected BiFunction<AbstractConfigEntry<V, Config, Gui>, Gui, List<Component>> warningSupplier = null;
    @Nullable
    protected BiConsumer<Gui, ConfigEntryHolder> saver = null;
    @Nullable
    protected Function<ConfigEntryHolder, Boolean> editableSupplier = null;
    @Nullable
    protected BackingField<V, ?> backingField;
    @Nullable
    protected List<BackingField<V, ?>> secondaryBackingFields;
    protected boolean dirty = false;
    @Nullable
    protected Component displayName = null;
    protected List<Object> nameArgs = new ArrayList<Object>();
    protected List<Object> tooltipArgs = new ArrayList<Object>();
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    private AbstractConfigListEntry<Gui> guiEntry;
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    private AbstractConfigListEntry<Gui> remoteGuiEntry;
    protected boolean nonPersistent = false;
    protected final Set<EntryTag> tags = new HashSet<EntryTag>();
    protected final Set<EntryTag> builtInTags = new HashSet<EntryTag>();
    protected final Set<EntryTag> allTags = Sets.union(this.tags, this.builtInTags);
    @ApiStatus.Internal
    public EntryTag copyTag;
    protected V actualValue = null;
    @Nullable
    protected ForgeConfigSpec.ConfigValue<?> configValue = null;
    protected boolean ignored = false;
    @Nullable
    protected ConfigEntryDelegate<V> delegate = null;

    protected AbstractConfigEntry(ConfigEntryHolder parent, String name, V defValue) {
        this.parent = parent;
        this.defValue = defValue;
        this.name = name;
    }

    @ApiStatus.Internal
    public ConfigEntryHolder getParent() {
        return this.parent;
    }

    @ApiStatus.Internal
    public SimpleConfig getRoot() {
        return this.getParent().getRoot();
    }

    @Nullable
    public ConfigEntryDelegate<V> getDelegate() {
        return this.delegate;
    }

    public void setDelegate(@Nullable ConfigEntryDelegate<V> delegate) {
        this.delegate = delegate;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static void addTranslationsDebugSuffix(List<Component> tooltip) {
        tooltip.add((Component)Component.m_237113_((String)" "));
        tooltip.add((Component)Component.m_237113_((String)" \u26a0 Simple Config translation debug mode active").m_130940_(ChatFormatting.GOLD));
    }

    public String getPath() {
        if (this.parent instanceof SimpleConfigImpl) {
            return this.name;
        }
        if (this.parent instanceof AbstractSimpleConfigEntryHolder) {
            return ((AbstractSimpleConfigEntryHolder)this.parent).getPathPart() + this.name;
        }
        return this.name;
    }

    public String getGlobalPath() {
        if (this.parent instanceof AbstractSimpleConfigEntryHolder) {
            return ((AbstractSimpleConfigEntryHolder)this.parent).getGlobalPath() + "." + this.name;
        }
        return this.name;
    }

    @ApiStatus.Internal
    @Nullable
    public String getTranslation() {
        return this.translation;
    }

    @ApiStatus.Internal
    public void setTranslation(@Nullable String translation) {
        this.translation = translation;
    }

    @ApiStatus.Internal
    @Nullable
    public String getTooltipKey() {
        return this.tooltip;
    }

    @ApiStatus.Internal
    public void setTooltipKey(@Nullable String translation) {
        this.tooltip = translation;
    }

    @ApiStatus.Internal
    public String getName() {
        return this.name;
    }

    @ApiStatus.Internal
    public void setName(String name) {
        this.name = name;
    }

    @ApiStatus.Internal
    @Nullable
    public ValuePresentation<V, V> getPresentation() {
        return this.presentation;
    }

    @ApiStatus.Internal
    public void setPresentation(@Nullable ValuePresentation<V, V> presentation) {
        if (this.presentation != null) {
            throw new IllegalStateException("Cannot set presentation twice");
        }
        this.presentation = presentation;
    }

    @ApiStatus.Internal
    public boolean hasPresentation() {
        return this.presentation != null;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected String fillArgs(String translation, V value, List<Object> args) {
        return I18n.m_118938_((String)translation, (Object[])this.formatArgs(value, args));
    }

    protected Object[] formatArgs(V value, List<Object> args) {
        return args.stream().map(a -> {
            if (a instanceof Supplier) {
                try {
                    return ((Supplier)a).get();
                }
                catch (RuntimeException e) {
                    return Component.m_237113_((String)"<null>").m_130940_(ChatFormatting.RED);
                }
            }
            return a;
        }).toArray();
    }

    @ApiStatus.Internal
    public void setSaver(@Nullable BiConsumer<Gui, ConfigEntryHolder> saver) {
        this.saver = saver;
    }

    @ApiStatus.Internal
    public void setDisplayName(@Nullable Component name) {
        this.displayName = name;
    }

    private <T> void toggle(Set<T> set, T value, boolean include) {
        if (set.contains(value) != include) {
            if (include) {
                set.add(value);
            } else {
                set.remove(value);
            }
        }
    }

    @ApiStatus.Internal
    protected Set<EntryTag> getTags() {
        this.toggle(this.builtInTags, EntryTag.REQUIRES_RESTART, this.requireRestart);
        this.toggle(this.builtInTags, EntryTag.EXPERIMENTAL, this.experimental);
        this.toggle(this.builtInTags, EntryTag.NON_PERSISTENT, this.nonPersistent);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            this.builtInTags.remove(this.copyTag);
            if (ClientConfig.advanced.show_copy_path_button) {
                String path = this.getPath();
                List tooltip = SimpleConfigTextUtil.splitTtc("simpleconfig.config.tag.copy_path", path).stream().map(l -> l.m_6881_().m_130940_(ChatFormatting.GRAY)).collect(Collectors.toList());
                this.copyTag = EntryTag.copyTag(-1000, path, () -> tooltip);
                this.builtInTags.add(this.copyTag);
            }
        });
        return this.allTags;
    }

    protected boolean debugTranslations() {
        return ClientConfig.advanced.translation_debug_mode;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected Component getDisplayName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        if (this.debugTranslations()) {
            return this.getDebugDisplayName();
        }
        if (this.translation != null && I18n.m_118936_((String)this.translation)) {
            return Component.m_237110_((String)this.translation, (Object[])this.formatArgs(null, this.nameArgs));
        }
        return Component.m_237113_((String)this.name);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected Component getDebugDisplayName() {
        if (this.translation != null) {
            MutableComponent status;
            MutableComponent mutableComponent = status = I18n.m_118936_((String)this.translation) ? Component.m_237113_((String)"\u2714 ") : Component.m_237113_((String)"\u2718 ");
            if (this.tooltip != null) {
                status = status.m_7220_((Component)(I18n.m_118936_((String)this.tooltip) ? Component.m_237113_((String)"\u2714 ").m_130940_(ChatFormatting.DARK_AQUA) : Component.m_237113_((String)"_ ").m_130940_(ChatFormatting.DARK_AQUA)));
            }
            ChatFormatting format = I18n.m_118936_((String)this.translation) ? ChatFormatting.DARK_GREEN : ChatFormatting.RED;
            return Component.m_237113_((String)"").m_7220_((Component)status.m_7220_((Component)Component.m_237113_((String)this.translation)).m_130940_(format));
        }
        return Component.m_237113_((String)"").m_7220_((Component)Component.m_237113_((String)("\u26a0 " + this.name)).m_130940_(ChatFormatting.DARK_RED));
    }

    public Gui forGui(V value) {
        return (Gui)value;
    }

    @Nullable
    public V fromGui(@Nullable Gui value) {
        return (V)value;
    }

    public V fromGuiOrDefault(Gui value) {
        V v = this.fromGui(value);
        return v != null ? v : this.defValue;
    }

    public Config forConfig(V value) {
        return (Config)value;
    }

    @Nullable
    public V fromConfig(@Nullable Config value) {
        return (V)(this.typeClass.isInstance(value) ? value : null);
    }

    public V fromConfigOrDefault(Config value) {
        try {
            V v = this.fromConfig(value);
            return v != null ? v : this.defValue;
        }
        catch (ClassCastException ignored) {
            return this.defValue;
        }
    }

    public final V forPresentation(V value) {
        return this.hasPresentation() ? this.doForPresentation(value) : value;
    }

    protected V doForPresentation(V value) {
        return this.presentation != null ? this.presentation.apply(value) : value;
    }

    public final V fromPresentation(V value) {
        return this.hasPresentation() ? this.doFromPresentation(value) : value;
    }

    protected V doFromPresentation(V value) {
        if (this.presentation == null) {
            return value;
        }
        if (!this.presentation.isInvertible()) {
            throw new SimpleConfig.UnInvertibleBakingTransformationException(this.getGlobalPath());
        }
        return this.presentation.recover(value);
    }

    @ApiStatus.Internal
    public void put(CommentedConfig config, Config value) {
        config.set(this.name, this.forActualConfig(value));
    }

    @ApiStatus.Internal
    public Config get(CommentedConfig config) {
        return this.fromActualConfig(config.getOrElse(this.name, this.forActualConfig(this.forConfig(this.defValue))));
    }

    public Object forActualConfig(@Nullable Config value) {
        return value;
    }

    @Nullable
    public Config fromActualConfig(@Nullable Object value) {
        try {
            return (Config)value;
        }
        catch (ClassCastException e) {
            throw new SimpleConfig.InvalidConfigValueTypeException(this.getGlobalPath(), e);
        }
    }

    protected boolean canBeNested() {
        return !this.nonPersistent;
    }

    protected void dirty() {
        this.dirty(true);
    }

    protected void dirty(boolean dirty) {
        this.dirty = dirty;
        if (dirty) {
            this.parent.markDirty();
        }
    }

    protected Consumer<Gui> createSaveConsumer() {
        if (this.saver != null) {
            return g -> this.saver.accept(g, this.parent);
        }
        if (this.ignored) {
            return g -> {};
        }
        return g -> {
            V v = this.fromGuiOrDefault(g);
            if (!this.areEqual(this.get(), v)) {
                if (this.trySet(v)) {
                    this.dirty();
                } else {
                    LOGGER.error("Unexpected error saving config entry \"" + this.getGlobalPath() + "\"");
                }
            }
        };
    }

    @ApiStatus.Internal
    public boolean areEqual(V current, V candidate) {
        return Objects.equals(current, candidate);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected Optional<Component[]> getTooltip(Gui value) {
        List<Component> l;
        if (this.debugTranslations()) {
            return this.supplyDebugTooltip(value);
        }
        if (this.tooltipSupplier != null && !(l = this.tooltipSupplier.apply(this, value)).isEmpty()) {
            return Optional.of(this.addExtraTooltip(l.toArray(EMPTY_TEXT_ARRAY), value));
        }
        V v = this.fromGui(value);
        if (this.tooltip != null && I18n.m_118936_((String)this.tooltip)) {
            return Optional.of(SimpleConfigTextUtil.splitTtc(this.tooltip, this.formatArgs(v, this.tooltipArgs)).toArray(EMPTY_TEXT_ARRAY)).map(t -> this.addExtraTooltip((Component[])t, value));
        }
        List<Component> extra = this.addExtraTooltip(value);
        return extra.isEmpty() ? Optional.empty() : Optional.of(extra.toArray(EMPTY_TEXT_ARRAY));
    }

    protected Component[] addExtraTooltip(Component[] tooltip, Gui value) {
        return (Component[])ArrayUtils.addAll((Object[])tooltip, (Object[])this.addExtraTooltip(value).toArray(new Component[0]));
    }

    protected List<Component> addExtraTooltip(Gui value) {
        return Lists.newArrayList();
    }

    public List<Component> getErrorsFromGUI(Gui value) {
        return Stream.of(this.getErrorFromGUI(value)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public Optional<Component> getErrorFromGUI(Gui value) {
        Optional<Component> o;
        if (this.errorSupplier != null && (o = this.errorSupplier.apply(this, value)).isPresent()) {
            return o;
        }
        return Optional.empty();
    }

    public Optional<Component> getError(@NotNull V value) {
        return this.getErrorFromGUI(this.forGui(value));
    }

    public Optional<Component> getErrorFromCommand(String command) {
        try {
            V value = this.fromCommand(command);
            if (value == null) {
                return Optional.of(Component.m_237110_((String)"simpleconfig.config.error.invalid_value_generic", (Object[])new Object[]{command}));
            }
            return this.getErrorsFromGUI(this.forGui(value)).stream().findFirst();
        }
        catch (SimpleConfig.InvalidConfigValueTypeException e) {
            return Optional.empty();
        }
        catch (SimpleConfig.InvalidConfigValueException e) {
            return Optional.of(Component.m_237110_((String)"simpleconfig.command.error.invalid_yaml", (Object[])new Object[]{e.getLocalizedMessage()}));
        }
    }

    @Nullable
    protected NodeComments getNodeComments(@Nullable NodeComments previous) {
        if (previous == null) {
            previous = new NodeComments();
        }
        ArrayList blockComments = previous.getBlockComments();
        String configComment = this.getConfigComment();
        if (configComment.endsWith("\n")) {
            configComment = configComment.substring(0, configComment.length() - 1);
        }
        if (blockComments == null) {
            blockComments = Lists.newArrayList();
        }
        blockComments.removeIf(l -> l.getValue().startsWith("#"));
        if (!configComment.isEmpty()) {
            Arrays.stream(LINE_BREAK.split(configComment)).map(line -> SimpleConfigCommentedYamlWriter.commentLine("# " + line)).forEach(blockComments::add);
        }
        if (blockComments.isEmpty()) {
            blockComments = null;
        }
        previous.setBlockComments(blockComments);
        return previous.isNotEmpty() ? previous : null;
    }

    @ApiStatus.Internal
    public List<String> getConfigCommentTooltips() {
        ArrayList tooltips = Lists.newArrayList();
        this.getTags().stream().map(EntryTag::getComment).filter(Objects::nonNull).forEach(tooltips::add);
        return tooltips;
    }

    @ApiStatus.Internal
    public String getConfigCommentTooltip() {
        return this.getConfigCommentTooltips().stream().map(t -> "[" + t + "]").collect(Collectors.joining(" "));
    }

    @ApiStatus.Internal
    public String getConfigComment() {
        StringBuilder builder = new StringBuilder();
        if (this.translation != null && ServerI18n.hasKey(this.translation)) {
            String name = SimpleConfigTextUtil.stripFormattingCodes(ServerI18n.format(this.translation, this.formatArgs(null, this.nameArgs)).trim());
            builder.append(name).append('\n');
            if (this.tooltip != null && ServerI18n.hasKey(this.tooltip)) {
                String tooltip = "  " + SimpleConfigTextUtil.stripFormattingCodes(ServerI18n.format(this.tooltip, this.formatArgs(this.get(), this.tooltipArgs)).trim().replace("\n", "\n  "));
                builder.append(tooltip).append('\n');
            }
        }
        builder.append(this.getConfigCommentTooltip()).append('\n');
        return builder.toString();
    }

    @MustBeInvokedByOverriders
    protected ForgeConfigSpec.Builder decorate(ForgeConfigSpec.Builder builder) {
        return builder;
    }

    @OnlyIn(value=Dist.CLIENT)
    @MustBeInvokedByOverriders
    protected <F extends FieldBuilder<Gui, ?, F>> F decorate(F builder) {
        ((FieldBuilder)((FieldBuilder)((FieldBuilder)((FieldBuilder)((FieldBuilder)((FieldBuilder)((FieldBuilder)((FieldBuilder)((FieldBuilder)builder.requireRestart(this.requireRestart)).nonPersistent(this.nonPersistent)).setDefaultValue(() -> this.forGui(this.defValue))).setTooltipSupplier(this::getTooltip)).setErrorSupplier(this::getErrorFromGUI)).withSaveConsumer(this.createSaveConsumer())).setEditableSupplier(() -> this.editableSupplier == null || this.editableSupplier.apply(this.parent) != false)).withTags(this.getTags())).setName(this.name)).setIgnoreEdits(this.ignored);
        return builder;
    }

    public boolean isValidValue(V value) {
        if (value == null) {
            return false;
        }
        return this.getErrorsFromGUI(this.forGui(value)).isEmpty();
    }

    protected Predicate<Object> createConfigValidator() {
        return o -> {
            try {
                Config c = this.fromActualConfig(o);
                V v = this.fromConfig(c);
                return v != null && this.isValidValue(v);
            }
            catch (ClassCastException e) {
                return false;
            }
        };
    }

    protected Optional<ForgeConfigSpec.ConfigValue<?>> buildConfigEntry(ForgeConfigSpec.Builder builder) {
        return Optional.of(this.decorate(builder).define(this.name, this.forActualConfig(this.forConfig(this.defValue)), this.createConfigValidator()));
    }

    protected void buildConfig(ForgeConfigSpec.Builder builder) {
        if (!this.nonPersistent) {
            this.buildConfigEntry(builder).ifPresent(this::setConfigValue);
        }
    }

    protected void buildSpec(ConfigSpec spec, String parentPath) {
        spec.define(parentPath + this.name, this.forConfig(this.defValue), this.createConfigValidator());
    }

    @OnlyIn(value=Dist.CLIENT)
    public Optional<FieldBuilder<Gui, ?, ?>> buildGUIEntry(ConfigFieldBuilder builder) {
        return Optional.empty();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void decorateGUIBuilder(FieldBuilder<Gui, ?, ?> builder, boolean forRemote) {
        if (forRemote) {
            builder.withSaveConsumer(g -> {});
        }
        builder.withBuildListener(forRemote ? this::setRemoteGuiEntry : this::setGuiEntry);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void buildGUI(CaptionedSubCategoryBuilder<?, ?, ?> group2, ConfigFieldBuilder entryBuilder, boolean forRemote) {
        this.buildGUIEntry(entryBuilder).ifPresent(b -> {
            this.decorateGUIBuilder((FieldBuilder<Gui, ?, ?>)b, forRemote);
            group2.add((FieldBuilder<?, ?, ?>)b);
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @ApiStatus.Internal
    public void buildGUI(ConfigCategoryBuilder category, ConfigFieldBuilder entryBuilder, boolean forRemote) {
        this.buildGUIEntry(entryBuilder).ifPresent(b -> {
            this.decorateGUIBuilder((FieldBuilder<Gui, ?, ?>)b, forRemote);
            category.addEntry((FieldBuilder<?, ?, ?>)b);
        });
    }

    @ApiStatus.Internal
    @Nullable
    protected AbstractConfigListEntry<Gui> getGuiEntry() {
        AbstractConfigScreen screen;
        if (this.remoteGuiEntry != null && (screen = (AbstractConfigScreen)this.parent.getRoot().getGUI()) != null && screen.isEditingServer()) {
            return this.remoteGuiEntry;
        }
        return this.guiEntry;
    }

    @ApiStatus.Internal
    @Nullable
    protected AbstractConfigListEntry<Gui> getGuiEntry(boolean remote) {
        return remote ? this.remoteGuiEntry : this.guiEntry;
    }

    @ApiStatus.Internal
    protected void setGuiEntry(@Nullable AbstractConfigListEntry<Gui> guiEntry) {
        this.guiEntry = guiEntry;
    }

    @ApiStatus.Internal
    protected void setRemoteGuiEntry(@Nullable AbstractConfigListEntry<Gui> guiEntry) {
        this.remoteGuiEntry = guiEntry;
    }

    @ApiStatus.Internal
    protected void resetGuiEntry() {
        this.resetGuiEntry(false);
    }

    @ApiStatus.Internal
    protected void resetGuiEntry(boolean remote) {
        AbstractConfigListEntry<Gui> entry = this.getGuiEntry(remote);
        if (entry != null) {
            entry.resetValue();
        }
    }

    @ApiStatus.Internal
    protected void restoreGuiEntry() {
        this.restoreGuiEntry(false);
    }

    @ApiStatus.Internal
    protected void restoreGuiEntry(boolean remote) {
        AbstractConfigListEntry<Gui> entry = this.getGuiEntry(remote);
        if (entry != null) {
            entry.restoreValue();
        }
    }

    protected void removeGUI() {
        this.guiEntry = null;
        this.remoteGuiEntry = null;
    }

    @ApiStatus.Internal
    public void setConfigValue(@Nullable ForgeConfigSpec.ConfigValue<?> value) {
        this.configValue = value;
    }

    @ApiStatus.Internal
    public <T> T apply(Function<? super AbstractConfigEntry<V, Config, Gui>, T> f) {
        return f.apply(this);
    }

    @ApiStatus.Internal
    public void accept(Consumer<? super AbstractConfigEntry<V, Config, Gui>> c) {
        c.accept(this);
    }

    @ApiStatus.Internal
    public V get() {
        if (this.delegate != null) {
            V v = this.delegate.getValue();
            return v != null ? v : this.defValue;
        }
        if (this.nonPersistent) {
            return this.actualValue;
        }
        if (this.configValue == null) {
            throw new SimpleConfig.NoSuchConfigEntryError(this.getGlobalPath());
        }
        return this.get(this.configValue);
    }

    @ApiStatus.Internal
    public void set(V value) {
        if (!this.trySet(value)) {
            throw new SimpleConfig.InvalidConfigValueException(this.getGlobalPath(), value);
        }
        if (this.hasGUI()) {
            this.setGUIAsExternal(this.forGui(value), false);
        }
    }

    @ApiStatus.Internal
    public boolean trySet(V value) {
        if (this.isValidValue(value)) {
            if (this.delegate != null) {
                this.delegate.setValue(value);
            } else if (this.nonPersistent) {
                this.actualValue = value;
            } else {
                if (this.configValue == null) {
                    throw new SimpleConfig.NoSuchConfigEntryError(this.getGlobalPath());
                }
                this.set(this.configValue, value);
            }
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    public V getPresented() {
        return this.forPresentation(this.get());
    }

    @ApiStatus.Internal
    public void setPresented(V value) {
        this.set(this.fromPresentation(value));
    }

    @ApiStatus.Internal
    public void trySetPresentation(V value) {
        if (this.presentation == null || this.presentation.isInvertible()) {
            this.trySet(this.fromPresentation(value));
        }
    }

    protected V get(ForgeConfigSpec.ConfigValue<?> spec) {
        return this.fromConfigOrDefault(this.fromActualConfig(spec.get()));
    }

    protected void set(ForgeConfigSpec.ConfigValue<?> spec, V value) {
        spec.set(this.forActualConfig(this.forConfig(value)));
        this.bakeField();
    }

    protected boolean hasGUI() {
        return this.hasGUI(false);
    }

    protected boolean hasGUI(boolean remote) {
        if (FMLEnvironment.dist != Dist.CLIENT) {
            return false;
        }
        return this.getGuiEntry(remote) != null;
    }

    protected Gui getGUI() {
        return this.getGUI(false);
    }

    protected Gui getGUI(boolean remote) {
        if (FMLEnvironment.dist != Dist.CLIENT) {
            return this.forGui(this.get());
        }
        AbstractConfigListEntry<Gui> guiEntry = this.getGuiEntry(remote);
        return (Gui)(guiEntry != null ? guiEntry.getValue() : this.forGui(this.get()));
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void setGUI(Gui value) {
        this.setGUI(value, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void setGUI(Gui value, boolean remote) {
        AbstractConfigListEntry<Gui> guiEntry = this.getGuiEntry(remote);
        if (guiEntry == null) {
            throw new IllegalStateException("Cannot set GUI value without GUI");
        }
        guiEntry.setValueTransparently(value);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void setGUIAsExternal(Gui value, boolean forRemote) {
        AbstractConfigListEntry<Gui> guiEntry = this.getGuiEntry(forRemote);
        if (guiEntry == null) {
            throw new IllegalStateException("Cannot set GUI value for " + this.getGlobalPath() + " without GUI");
        }
        guiEntry.setExternalValue(value);
    }

    @ApiStatus.Internal
    @Nullable
    public String forCommand(V value) {
        Yaml yaml = SimpleConfigCommentedYamlFormat.getDefaultYaml();
        try {
            return yaml.dumpAs(this.forActualConfig(this.forConfig(value)), null, DumperOptions.FlowStyle.FLOW).trim();
        }
        catch (YAMLException e) {
            return null;
        }
    }

    @ApiStatus.Internal
    public V fromCommand(String value) {
        Yaml yaml = SimpleConfigCommentedYamlFormat.getDefaultYaml();
        try {
            return this.fromConfig(this.fromActualConfig(yaml.load(value)));
        }
        catch (ClassCastException e) {
            throw new SimpleConfig.InvalidConfigValueTypeException(this.getGlobalPath(), e);
        }
        catch (YAMLException e) {
            throw new SimpleConfig.InvalidConfigValueException(this.getGlobalPath(), (Object)e);
        }
    }

    @ApiStatus.Internal
    public String getForCommand() {
        return this.forCommand(this.get());
    }

    @ApiStatus.Internal
    public void setFromCommand(String value) {
        this.set(this.fromCommand(value));
    }

    @ApiStatus.Internal
    public boolean addCommandSuggestions(SuggestionsBuilder builder) {
        String defSerialized;
        String serialized = this.getForCommand();
        if (serialized != null) {
            builder.suggest(serialized, (Message)Component.m_237115_((String)"simpleconfig.command.suggest.current"));
        }
        if ((defSerialized = this.forCommand(this.defValue)) != null) {
            builder.suggest(defSerialized, (Message)Component.m_237115_((String)"simpleconfig.command.suggest.default"));
        }
        return true;
    }

    protected void setBackingField(V value) throws IllegalAccessException {
        if (this.backingField != null) {
            this.backingField.setValue(value);
        }
        if (this.secondaryBackingFields != null) {
            for (BackingField<V, ?> field : this.secondaryBackingFields) {
                field.setValue(value);
            }
        }
    }

    protected V getFromBackingField() throws IllegalAccessException {
        if (this.backingField == null) {
            throw new IllegalStateException("Missing backing field for entry " + this.getGlobalPath());
        }
        if (!this.backingField.canBeRead()) {
            throw new IllegalStateException("Backing field for entry " + this.getGlobalPath() + " is not readable");
        }
        try {
            return this.backingField.readValue();
        }
        catch (SimpleConfig.InvalidConfigValueTypeException e) {
            throw new SimpleConfig.InvalidConfigValueTypeException(this.getGlobalPath(), e);
        }
    }

    protected void commitField() throws IllegalAccessException {
        if (this.backingField != null && this.backingField.canBeRead() && (this.presentation == null || this.presentation.isInvertible())) {
            this.setPresented(this.getFromBackingField());
        }
    }

    protected void bakeField() {
        if (this.backingField != null || this.secondaryBackingFields != null && !this.secondaryBackingFields.isEmpty()) {
            try {
                this.setBackingField(this.getPresented());
            }
            catch (IllegalAccessException e) {
                throw new SimpleConfig.ConfigReflectiveOperationException("Could not access mod config field during config bake\n  Details: " + e.getMessage(), e);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void addTranslationsDebugInfo(List<Component> tooltip) {
        if (this.tooltipSupplier != null) {
            tooltip.add((Component)Component.m_237113_((String)" + Has tooltip supplier").m_130940_(ChatFormatting.GRAY));
        }
        if (this.errorSupplier != null) {
            tooltip.add((Component)Component.m_237113_((String)" + Has error supplier").m_130940_(ChatFormatting.GRAY));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected Optional<Component[]> supplyDebugTooltip(Gui value) {
        MutableComponent status;
        ArrayList<Component> lines = new ArrayList<Component>();
        lines.add((Component)Component.m_237113_((String)"Translation key:").m_130940_(ChatFormatting.GRAY));
        if (this.translation != null) {
            status = I18n.m_118936_((String)this.translation) ? Component.m_237113_((String)"(\u2714 present)").m_130940_(ChatFormatting.DARK_GREEN) : Component.m_237113_((String)"(\u2718 missing)").m_130940_(ChatFormatting.RED);
            lines.add((Component)Component.m_237113_((String)("   " + this.translation + " ")).m_130940_(ChatFormatting.DARK_AQUA).m_7220_((Component)status));
        } else {
            lines.add((Component)Component.m_237113_((String)"   Error: couldn't map translation key").m_130940_(ChatFormatting.RED));
        }
        lines.add((Component)Component.m_237113_((String)"Tooltip key:").m_130940_(ChatFormatting.GRAY));
        if (this.tooltip != null) {
            status = I18n.m_118936_((String)this.tooltip) ? Component.m_237113_((String)"(\u2714 present)").m_130940_(ChatFormatting.DARK_GREEN) : Component.m_237113_((String)"(not present)").m_130940_(ChatFormatting.GOLD);
            lines.add((Component)Component.m_237113_((String)("   " + this.tooltip + " ")).m_130940_(ChatFormatting.DARK_AQUA).m_7220_((Component)status));
        } else {
            lines.add((Component)Component.m_237113_((String)"   Error: couldn't map tooltip translation key").m_130940_(ChatFormatting.RED));
        }
        this.addTranslationsDebugInfo(lines);
        AbstractConfigEntry.addTranslationsDebugSuffix(lines);
        return Optional.of(lines.toArray(new Component[0]));
    }
}

