/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.config;

import com.google.common.collect.Lists;
import endorh.simpleconfig.SimpleConfigMod;
import endorh.simpleconfig.api.ConfigBuilderFactoryProxy;
import endorh.simpleconfig.api.ConfigGroupBuilder;
import endorh.simpleconfig.api.SimpleConfig;
import endorh.simpleconfig.api.SimpleConfigBuilder;
import endorh.simpleconfig.api.annotation.Bind;
import endorh.simpleconfig.api.entry.StringEntryBuilder;
import endorh.simpleconfig.api.ui.icon.SimpleConfigIcons;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class ServerConfig {
    public static SimpleConfig build() {
        StringEntryBuilder playerName = ConfigBuilderFactoryProxy.string("").suggest(() -> {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            ArrayList names = Lists.newArrayList();
            if (server != null) {
                PlayerList pl = server.m_6846_();
                ArrayList ops = Lists.newArrayList((Object[])pl.m_11308_());
                ArrayList whl = Lists.newArrayList((Object[])pl.m_11306_());
                ArrayList nms = Lists.newArrayList((Object[])pl.m_11291_());
                whl.removeAll(ops);
                nms.removeAll(ops);
                nms.removeAll(whl);
                names.addAll(ops);
                names.addAll(whl);
                names.addAll(nms);
            }
            return names;
        });
        Supplier<List> roleNameSupplier = () -> new ArrayList(((Map)SimpleConfigMod.SERVER_CONFIG.getFromGUI("permissions.roles")).keySet());
        Supplier<List<String>> modNameSupplier = () -> ModList.get().getMods().stream().map(IModInfo::getModId).collect(Collectors.toList());
        StringEntryBuilder modName = ConfigBuilderFactoryProxy.string("").suggest(modNameSupplier);
        StringEntryBuilder roleName = (StringEntryBuilder)ConfigBuilderFactoryProxy.string("").suggest(() -> {
            List roles = (List)roleNameSupplier.get();
            roles.add(0, "[all]");
            roles.add(1, "[op]");
            return roles;
        }).error(s -> ((List)roleNameSupplier.get()).contains(s) || "[op]".equals(s) || "[all]".equals(s) ? Optional.empty() : Optional.of(Component.m_237110_((String)"simpleconfig.config.error.unknown_role", (Object[])new Object[]{s})));
        StringEntryBuilder modGroupOrName = ConfigBuilderFactoryProxy.string("").suggest(() -> {
            List modGroups = (List)SimpleConfigMod.SERVER_CONFIG.getGUI("permissions.mod_groups");
            List names = modGroups.stream().map(Pair::getKey).collect(Collectors.toList());
            ModList.get().getMods().stream().map(IModInfo::getModId).forEachOrdered(names::add);
            names.add(0, "[all]");
            return names;
        });
        return ((SimpleConfigBuilder)((SimpleConfigBuilder)((SimpleConfigBuilder)ConfigBuilderFactoryProxy.config("simpleconfig", SimpleConfig.Type.SERVER, ServerConfig.class).withIcon(SimpleConfigIcons.Types.SERVER).withColor(1686147327).withBackground("textures/block/blackstone_bricks.png").text("desc", ServerConfig.makeLink("simpleconfig.config.server.desc.permission_level", "simpleconfig.config.server.desc.permission_level:help", "https://minecraft.fandom.com/wiki/Permission_level", ChatFormatting.DARK_GRAY, ChatFormatting.UNDERLINE))).n((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)ConfigBuilderFactoryProxy.group("permissions", true).add("roles", ConfigBuilderFactoryProxy.map((StringEntryBuilder)ConfigBuilderFactoryProxy.string("").notEmpty().error(s -> "[op]".equals(s) || "[all]".equals(s) ? Optional.of(Component.m_237110_((String)"simpleconfig.config.error.role.reserved", (Object[])new Object[]{s})) : Optional.empty()), ConfigBuilderFactoryProxy.list(playerName)))).add("mod_groups", ConfigBuilderFactoryProxy.map((StringEntryBuilder)ConfigBuilderFactoryProxy.string("").notEmpty().error(s -> "[all]".equals(s) ? Optional.of(Component.m_237110_((String)"simpleconfig.config.error.mod_group.reserved", (Object[])new Object[]{s})) : Optional.empty()), ConfigBuilderFactoryProxy.caption(ConfigBuilderFactoryProxy.option(ListType.WHITELIST), ConfigBuilderFactoryProxy.list(modName))))).add("rules", ConfigBuilderFactoryProxy.pairList(roleName, ConfigBuilderFactoryProxy.caption(ConfigBuilderFactoryProxy.pair(ConfigBuilderFactoryProxy.option(ConfigPermission.EDIT_SERVER_CONFIG), ConfigBuilderFactoryProxy.option(PresetPermission.SAVE_PRESETS)).withSplitPosition(0.4), ConfigBuilderFactoryProxy.list(modGroupOrName)), Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"[op]", (Object)Pair.of((Object)Pair.of((Object)((Object)ConfigPermission.EDIT_SERVER_CONFIG), (Object)((Object)PresetPermission.SAVE_PRESETS)), (Object)Lists.newArrayList((Object[])new String[]{"[all]"})))})))).add("hotkey_rules", ConfigBuilderFactoryProxy.pairList(roleName, ConfigBuilderFactoryProxy.yesNo(true), Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"[op]", (Object)true)})))).add("datapack_permission", ConfigBuilderFactoryProxy.option(ConfigPermission.EDIT_SERVER_CONFIG).restrict(new ConfigPermission[]{ConfigPermission.VIEW_SERVER_CONFIG}))).add("broadcast_datapack_config_changes", ConfigBuilderFactoryProxy.yesNo(false)))).text("end", new Object[0])).buildAndRegister();
    }

    private static MutableComponent makeLink(String key, @Nullable String tooltipKey, String url, ChatFormatting ... styles) {
        return Component.m_237115_((String)key).m_130938_(s -> {
            s = s.m_131152_(styles);
            if (tooltipKey != null) {
                s = s.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)tooltipKey)));
            }
            return s.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, url));
        });
    }

    public static enum ListType {
        WHITELIST,
        BLACKLIST;

    }

    public static enum ConfigPermission {
        INHERIT(false, false),
        DENY(false, false),
        VIEW_SERVER_CONFIG(true, false),
        EDIT_SERVER_CONFIG(true, true);

        private final boolean canView;
        private final boolean canEdit;

        private ConfigPermission(boolean canView, boolean canEdit) {
            this.canView = canView;
            this.canEdit = canEdit;
        }

        public boolean canView() {
            return this.canView;
        }

        public boolean canEdit() {
            return this.canEdit;
        }
    }

    public static enum PresetPermission {
        INHERIT(false, false),
        LOAD_PRESETS(true, false),
        SAVE_PRESETS(true, true);

        private final boolean canLoad;
        private final boolean canSave;

        private PresetPermission(boolean canLoad, boolean canSave) {
            this.canLoad = canLoad;
            this.canSave = canSave;
        }

        public boolean canLoad() {
            return this.canLoad;
        }

        public boolean canSave() {
            return this.canSave;
        }
    }

    @Bind
    public static class permissions {
        private static final String MINECRAFT_MOD_ID = "minecraft";
        @Bind
        public static Map<String, List<String>> roles;
        @Bind
        public static Map<String, Pair<ListType, List<String>>> mod_groups;
        @Bind
        public static List<Pair<String, Pair<Pair<ConfigPermission, PresetPermission>, List<String>>>> rules;
        @Bind
        public static List<Pair<String, Boolean>> hotkey_rules;
        @Bind
        public static ConfigPermission datapack_permission;
        @Bind
        public static boolean broadcast_datapack_config_changes;

        @OnlyIn(value=Dist.CLIENT)
        public static Pair<ConfigPermission, PresetPermission> permissionFor(String mod) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            return player == null ? Pair.of((Object)((Object)ConfigPermission.DENY), (Object)((Object)PresetPermission.LOAD_PRESETS)) : permissions.permissionFor((Player)player, mod);
        }

        public static Pair<ConfigPermission, PresetPermission> permissionFor(Player player, String mod) {
            Set roles = permissions.roles.entrySet().stream().filter(e -> ((List)e.getValue()).contains(player.m_6302_())).map(Map.Entry::getKey).collect(Collectors.toSet());
            if (player.m_20310_(4)) {
                return Pair.of((Object)((Object)ConfigPermission.EDIT_SERVER_CONFIG), (Object)((Object)PresetPermission.SAVE_PRESETS));
            }
            if (player.m_20310_(2)) {
                roles.add("[op]");
            }
            roles.add("[all]");
            Set modGroups = mod_groups.entrySet().stream().filter(e -> ((Pair)e.getValue()).getKey() == ListType.BLACKLIST ^ ((List)((Pair)e.getValue()).getValue()).contains(mod)).map(Map.Entry::getKey).collect(Collectors.toSet());
            modGroups.add("[all]");
            modGroups.add(mod);
            ConfigPermission config = ConfigPermission.DENY;
            PresetPermission preset = PresetPermission.LOAD_PRESETS;
            for (Pair<String, Pair<Pair<ConfigPermission, PresetPermission>, List<String>>> rule : rules) {
                if (!roles.contains(rule.getKey())) continue;
                if (!((List)((Pair)rule.getValue()).getValue()).stream().anyMatch(modGroups::contains)) continue;
                Pair pair = (Pair)((Pair)rule.getValue()).getKey();
                if (pair.getKey() != ConfigPermission.INHERIT) {
                    config = (ConfigPermission)((Object)pair.getKey());
                }
                if (pair.getValue() == PresetPermission.INHERIT) continue;
                preset = (PresetPermission)((Object)pair.getValue());
            }
            return Pair.of((Object)((Object)config), (Object)((Object)preset));
        }

        @OnlyIn(value=Dist.CLIENT)
        public static boolean canEditServerHotKeys() {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            return player != null && permissions.canEditServerHotKeys((Player)player);
        }

        public static boolean canAccessServerProperties(Player player) {
            return (Boolean)DistExecutor.unsafeRunForDist(() -> () -> false, () -> () -> {
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                return server.m_6982_() && ((ConfigPermission)((Object)((Object)((Object)permissions.permissionFor(player, MINECRAFT_MOD_ID).getLeft())))).canEdit();
            });
        }

        public static boolean canEditServerHotKeys(Player player) {
            Set roles = permissions.roles.entrySet().stream().filter(e -> ((List)e.getValue()).contains(player.m_6302_())).map(Map.Entry::getKey).collect(Collectors.toSet());
            if (player.m_20310_(4)) {
                return true;
            }
            if (player.m_20310_(2)) {
                roles.add("[op]");
            }
            roles.add("[all]");
            for (Pair rule : Lists.reverse(hotkey_rules)) {
                if (!roles.contains(rule.getKey())) continue;
                return (Boolean)rule.getValue();
            }
            return false;
        }

        static {
            datapack_permission = ConfigPermission.EDIT_SERVER_CONFIG;
        }
    }
}

