/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.config;

import endorh.simpleconfig.api.ConfigBuilderFactoryProxy;
import endorh.simpleconfig.api.ConfigCategoryBuilder;
import endorh.simpleconfig.api.ConfigEntryBuilder;
import endorh.simpleconfig.api.ConfigGroupBuilder;
import endorh.simpleconfig.api.SimpleConfig;
import endorh.simpleconfig.api.SimpleConfigBuilder;
import endorh.simpleconfig.api.annotation.Bind;
import endorh.simpleconfig.api.entry.BooleanEntryBuilder;
import endorh.simpleconfig.api.entry.EntryListEntryBuilder;
import endorh.simpleconfig.api.ui.icon.SimpleConfigIcons;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;

public class CommonConfig {
    public static SimpleConfig build() {
        Supplier<List<String>> modNameSupplier = () -> ModList.get().getMods().stream().map(IModInfo::getModId).collect(Collectors.toList());
        return ((SimpleConfigBuilder)((SimpleConfigBuilder)ConfigBuilderFactoryProxy.config("simpleconfig", SimpleConfig.Type.COMMON, CommonConfig.class).withIcon(SimpleConfigIcons.Types.COMMON).withColor(1694474384).withBackground("textures/block/warped_planks.png").text("desc", new Object[0])).n((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)ConfigBuilderFactoryProxy.group("menu", true).add("wrap_configs", (ConfigEntryBuilder<?, ?, ?, ?>)ConfigBuilderFactoryProxy.yesNo(true).restart())).add("wrap_config_exceptions", (ConfigEntryBuilder<?, ?, ?, ?>)ConfigBuilderFactoryProxy.list(ConfigBuilderFactoryProxy.string("").suggest(modNameSupplier)).restart())).add("replace_config_menus", (ConfigEntryBuilder<?, ?, ?, ?>)((BooleanEntryBuilder)ConfigBuilderFactoryProxy.yesNo(false).restart()).editable(g -> g.getGUIBoolean("wrap_configs") || !((List)g.getGUI("wrap_config_exceptions")).isEmpty()))).add("replace_menu_exceptions", (ConfigEntryBuilder<?, ?, ?, ?>)((EntryListEntryBuilder)ConfigBuilderFactoryProxy.list(ConfigBuilderFactoryProxy.string("").suggest(modNameSupplier)).restart()).editable(g -> g.getGUIBoolean("wrap_configs") || !((List)g.getGUI("wrap_config_exceptions")).isEmpty()))).add("wrap_top_level_groups_as_categories", (ConfigEntryBuilder<?, ?, ?, ?>)((BooleanEntryBuilder)ConfigBuilderFactoryProxy.yesNo(true).restart()).editable(g -> g.getGUIBoolean("wrap_configs") || !((List)g.getGUI("wrap_config_exceptions")).isEmpty()))).add("prevent_external_menu_replacement", (ConfigEntryBuilder<?, ?, ?, ?>)ConfigBuilderFactoryProxy.yesNo(true).restart()))).n((ConfigCategoryBuilder)((ConfigCategoryBuilder)((ConfigCategoryBuilder)((ConfigCategoryBuilder)ConfigBuilderFactoryProxy.category("demo").withIcon(SimpleConfigIcons.Status.INFO).withColor(-2141163392).withBackground("textures/block/warped_planks.png").add("bool", ConfigBuilderFactoryProxy.yesNo(true))).add("number", ConfigBuilderFactoryProxy.number(0).min(0))).add("slider", ConfigBuilderFactoryProxy.fraction(0.5))).add("color_list", ConfigBuilderFactoryProxy.list(ConfigBuilderFactoryProxy.color(Color.GRAY).alpha(), Arrays.asList(Color.RED, Color.GREEN, Color.BLUE)))).buildAndRegister();
    }

    @Bind
    public static class menu {
        @Bind
        public static boolean wrap_configs;
        @Bind
        public static List<String> wrap_config_exceptions;
        @Bind
        public static boolean replace_config_menus;
        @Bind
        public static List<String> replace_menu_exceptions;
        @Bind
        public static boolean wrap_top_level_groups_as_categories;
        @Bind
        public static boolean prevent_external_menu_replacement;

        public static boolean shouldWrapConfig(String modId) {
            return wrap_configs != wrap_config_exceptions.contains(modId);
        }

        public static boolean shouldReplaceMenu(String modId) {
            return menu.shouldWrapConfig(modId) && replace_config_menus != replace_menu_exceptions.contains(modId);
        }
    }

    public static enum HotKeyLogLocation {
        CHAT,
        RIGHT_OVERLAY,
        CENTER_TOAST,
        NONE;

    }
}

