/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.config;

import endorh.simpleconfig.api.ConfigBuilderFactoryProxy;
import endorh.simpleconfig.api.ConfigCategoryBuilder;
import endorh.simpleconfig.api.ConfigEntryBuilder;
import endorh.simpleconfig.api.ConfigGroupBuilder;
import endorh.simpleconfig.api.EntryTag;
import endorh.simpleconfig.api.SimpleConfig;
import endorh.simpleconfig.api.SimpleConfigBuilder;
import endorh.simpleconfig.api.annotation.Bind;
import endorh.simpleconfig.api.entry.FloatEntryBuilder;
import endorh.simpleconfig.api.entry.KeyBindEntryBuilder;
import endorh.simpleconfig.api.ui.hotkey.ExtendedKeyBind;
import endorh.simpleconfig.api.ui.hotkey.ExtendedKeyBindProvider;
import endorh.simpleconfig.api.ui.hotkey.KeyBindMapping;
import endorh.simpleconfig.api.ui.icon.SimpleConfigIcons;
import endorh.simpleconfig.config.CommonConfig;
import endorh.simpleconfig.core.SimpleConfigImpl;
import endorh.simpleconfig.demo.DemoConfigCategory;
import endorh.simpleconfig.demo.DemoDeclarativeConfigCategory;
import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ClientConfig {
    @ApiStatus.Internal
    public static SimpleConfig build() {
        KeyBindings.register();
        Supplier<List<String>> modNameSupplier = () -> ModList.get().getMods().stream().map(IModInfo::getModId).collect(Collectors.toList());
        return ((SimpleConfigBuilder)((SimpleConfigBuilder)((SimpleConfigBuilder)((SimpleConfigBuilder)ConfigBuilderFactoryProxy.config("simpleconfig", SimpleConfig.Type.CLIENT, ClientConfig.class).withIcon(SimpleConfigIcons.Types.CLIENT).withColor(1687224192).withBackground("textures/block/bookshelf.png").n((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)ConfigBuilderFactoryProxy.group("menu", true).add("options_button_behaviour", ConfigBuilderFactoryProxy.option(OptionsButtonBehaviour.SECONDARY_CLICK))).add("add_options_menu_button", ConfigBuilderFactoryProxy.yesNo(true))).add("options_menu_button_position", (ConfigEntryBuilder<?, ?, ?, ?>)ConfigBuilderFactoryProxy.option(OptionsMenuButtonPosition.TOP_LEFT_CORNER).editable(g -> g.getGUIBoolean("add_options_menu_button"))))).n((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)ConfigBuilderFactoryProxy.group("hotkey_log").add("hotkey_log_location", ConfigBuilderFactoryProxy.option(CommonConfig.HotKeyLogLocation.RIGHT_OVERLAY))).add("log_hotkey_actions", ConfigBuilderFactoryProxy.yesNo(true))).add("remote_hotkey_log_location", (ConfigEntryBuilder<?, ?, ?, ?>)ConfigBuilderFactoryProxy.option(CommonConfig.HotKeyLogLocation.CHAT).withTags(EntryTag.OPERATOR))).add("log_remote_hotkey_actions", (ConfigEntryBuilder<?, ?, ?, ?>)ConfigBuilderFactoryProxy.yesNo(true).withTags(EntryTag.OPERATOR))).add("max_logged_actions", ConfigBuilderFactoryProxy.number(10).min(1))).n((ConfigGroupBuilder)((ConfigGroupBuilder)ConfigBuilderFactoryProxy.group("overlay").add("background_opacity", (ConfigEntryBuilder<?, ?, ?, ?>)ConfigBuilderFactoryProxy.fraction(0.5f).editable(g -> g.getParent().getGUI("hotkey_log_location") == CommonConfig.HotKeyLogLocation.RIGHT_OVERLAY || g.getParent().getGUI("remote_hotkey_log_location") == CommonConfig.HotKeyLogLocation.RIGHT_OVERLAY))).add("display_time", (ConfigEntryBuilder<?, ?, ?, ?>)((FloatEntryBuilder)ConfigBuilderFactoryProxy.number(2.0f).min(0.0f).add_field("ms", f -> (int)(f.floatValue() * 1000.0f), Integer.class)).editable(g -> g.getParent().getGUI("hotkey_log_location") == CommonConfig.HotKeyLogLocation.RIGHT_OVERLAY || g.getParent().getGUI("remote_hotkey_log_location") == CommonConfig.HotKeyLogLocation.RIGHT_OVERLAY)))).n((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)ConfigBuilderFactoryProxy.group("toast").add("relative_height", (ConfigEntryBuilder<?, ?, ?, ?>)ConfigBuilderFactoryProxy.fraction(0.1f).editable(g -> g.getParent().getGUI("hotkey_log_location") == CommonConfig.HotKeyLogLocation.CENTER_TOAST || g.getParent().getGUI("remote_hotkey_log_location") == CommonConfig.HotKeyLogLocation.CENTER_TOAST))).add("background_opacity", (ConfigEntryBuilder<?, ?, ?, ?>)ConfigBuilderFactoryProxy.fraction(0.0f).editable(g -> g.getParent().getGUI("hotkey_log_location") == CommonConfig.HotKeyLogLocation.CENTER_TOAST || g.getParent().getGUI("remote_hotkey_log_location") == CommonConfig.HotKeyLogLocation.CENTER_TOAST))).add("display_time", (ConfigEntryBuilder<?, ?, ?, ?>)((FloatEntryBuilder)ConfigBuilderFactoryProxy.number(1.0f).min(0.0f).add_field("ms", f -> (int)(f.floatValue() * 1000.0f), Integer.class)).editable(g -> g.getParent().getGUI("hotkey_log_location") == CommonConfig.HotKeyLogLocation.CENTER_TOAST || g.getParent().getGUI("remote_hotkey_log_location") == CommonConfig.HotKeyLogLocation.CENTER_TOAST))))).n((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)ConfigBuilderFactoryProxy.group("confirm").add("save", ConfigBuilderFactoryProxy.yesNo(true))).add("discard", ConfigBuilderFactoryProxy.yesNo(true))).add("overwrite_external", ConfigBuilderFactoryProxy.yesNo(true))).add("overwrite_remote", ConfigBuilderFactoryProxy.yesNo(true))).add("reset", ConfigBuilderFactoryProxy.yesNo(false))).add("group_reset", ConfigBuilderFactoryProxy.yesNo(true))).add("restore", ConfigBuilderFactoryProxy.yesNo(false))).add("group_restore", ConfigBuilderFactoryProxy.yesNo(true))).add("save_hotkeys", ConfigBuilderFactoryProxy.yesNo(true))).add("discard_hotkeys", ConfigBuilderFactoryProxy.yesNo(true)))).n((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)ConfigBuilderFactoryProxy.group("advanced").add("allow_save_with_errors", ConfigBuilderFactoryProxy.yesNo(false))).add("max_undo", ConfigBuilderFactoryProxy.number(256).min(0))).add("show_copy_path_button", ConfigBuilderFactoryProxy.yesNo(false))).add("show_ui_tips", ConfigBuilderFactoryProxy.yesNo(true))).add("allow_over_scroll", ConfigBuilderFactoryProxy.yesNo(false))).add("tooltip_max_width", ConfigBuilderFactoryProxy.percent(60.0f))).add("prefer_combo_box", ConfigBuilderFactoryProxy.number(8))).add("cycle_with_scroll", ConfigBuilderFactoryProxy.yesNo(false))).add("commit_keybind_on_click_outside", ConfigBuilderFactoryProxy.yesNo(true))).add("max_options_in_config_comment", (ConfigEntryBuilder<?, ?, ?, ?>)ConfigBuilderFactoryProxy.number(16).min(5).restart())).add("color_picker_saved_colors", ConfigBuilderFactoryProxy.map(ConfigBuilderFactoryProxy.number(0), ConfigBuilderFactoryProxy.color(Color.BLACK).alpha(), (Map)Util.m_137469_(new HashMap(), m -> {
            m.put(0, new Color(0xFF5555));
            m.put(1, new Color(0xFFAA00));
            m.put(2, new Color(0xFFFF55));
            m.put(3, new Color(0x55FF55));
            m.put(4, new Color(0x55FFFF));
            m.put(5, new Color(0x5555FF));
            m.put(6, new Color(0xFF55FF));
            m.put(7, new Color(0xAAAAAA));
        })))).n((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)((ConfigGroupBuilder)ConfigBuilderFactoryProxy.group("search").add("search_filter", ConfigBuilderFactoryProxy.yesNo(false))).add("search_regex", ConfigBuilderFactoryProxy.yesNo(false))).add("search_case_sensitive", ConfigBuilderFactoryProxy.yesNo(false))).add("search_tooltips", ConfigBuilderFactoryProxy.yesNo(true))).add("search_history", ConfigBuilderFactoryProxy.caption(ConfigBuilderFactoryProxy.number(20).min(0).max(1000), ConfigBuilderFactoryProxy.list(ConfigBuilderFactoryProxy.string(""))).split_fields("size"))).add("regex_search_history", ConfigBuilderFactoryProxy.caption(ConfigBuilderFactoryProxy.number(20).max(1000), ConfigBuilderFactoryProxy.list(ConfigBuilderFactoryProxy.pattern(""))).split_fields("size")))).add("translation_debug_mode", (ConfigEntryBuilder<?, ?, ?, ?>)ConfigBuilderFactoryProxy.enable(false).temp()))).n((ConfigCategoryBuilder)((ConfigCategoryBuilder)((ConfigCategoryBuilder)ConfigBuilderFactoryProxy.category("hotkeys").withColor(-2145107201).withIcon(SimpleConfigIcons.Buttons.KEYBOARD).add("open_mod_list", ClientConfig.keyBind(KeyBindings.OPEN_MOD_LIST))).add("edit_config_hotkeys", ClientConfig.keyBind(KeyBindings.EDIT_CONFIG_HOTKEYS))).add("mod_config_hotkeys", (ConfigEntryBuilder<?, ?, ?, ?>)ConfigBuilderFactoryProxy.map((KeyBindEntryBuilder)ConfigBuilderFactoryProxy.key().guiError(m -> m.getSettings().context() != KeyBindMapping.VanillaKeyBindContext.GAME ? Optional.of(Component.m_237110_((String)"simpleconfig.config.error.unsupported_hotkey_context", (Object[])new Object[]{m.getSettings().context().serialize()})) : Optional.empty()), ConfigBuilderFactoryProxy.string("").suggest(modNameSupplier)).expand())).n(DemoConfigCategory.build()).n(DemoDeclarativeConfigCategory.build()).buildAndRegister();
    }

    private static KeyBindEntryBuilder keyBind(ExtendedKeyBind keyBind) {
        return ConfigBuilderFactoryProxy.key(keyBind).inheritTitle();
    }

    public static class KeyBindings {
        public static final ExtendedKeyBind OPEN_MOD_LIST = KeyBindings.keyBind("right.alt>\"m\"", SimpleConfig::showModListGUI);
        public static final ExtendedKeyBind EDIT_CONFIG_HOTKEYS = KeyBindings.keyBind("right.alt>\"h\"", SimpleConfig::showConfigHotkeysGUI);

        private static void register() {
            ExtendedKeyBindProvider.registerProvider(new ModExtendedKeyBindProvider());
            ExtendedKeyBindProvider.registerKeyBinds(OPEN_MOD_LIST, EDIT_CONFIG_HOTKEYS);
        }

        @NotNull
        private static ExtendedKeyBind keyBind(String def, Runnable action) {
            return ExtendedKeyBind.of("simpleconfig", "", def, action);
        }

        public static class ModExtendedKeyBindProvider
        implements ExtendedKeyBindProvider {
            @Override
            @NotNull
            public Iterable<ExtendedKeyBind> getActiveKeyBinds() {
                return hotkeys.mod_config_keybinds;
            }

            @Override
            @NotNull
            public Iterable<ExtendedKeyBind> getAllKeyBinds() {
                return Collections.emptyList();
            }
        }
    }

    public static enum OptionsButtonBehaviour {
        DEFAULT,
        SECONDARY_CLICK,
        MAIN_CLICK;

    }

    public static enum OptionsMenuButtonPosition {
        TOP_LEFT_CORNER,
        TOP_RIGHT_CORNER,
        BOTTOM_LEFT_CORNER,
        BOTTOM_RIGHT_CORNER;

    }

    @Bind
    public static class hotkeys {
        @Bind
        public static Map<KeyBindMapping, String> mod_config_hotkeys;
        public static List<ExtendedKeyBind> mod_config_keybinds;

        @Bind
        public static void bake() {
            mod_config_keybinds = mod_config_hotkeys.entrySet().stream().map(e -> {
                KeyBindMapping mapping = (KeyBindMapping)e.getKey();
                String modId = (String)e.getValue();
                if (mapping.getSettings().context() != KeyBindMapping.VanillaKeyBindContext.GAME) {
                    return null;
                }
                if (!SimpleConfigImpl.getConfigModIds().contains(modId)) {
                    return null;
                }
                return ExtendedKeyBind.of("simpleconfig", (Component)Component.m_237110_((String)"simpleconfig.keybind.open_mod_config", (Object[])new Object[]{SimpleConfigImpl.getModNameOrId(modId)}), mapping, () -> SimpleConfig.showConfigGUI(modId));
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
    }

    @Bind
    public static class advanced {
        @Bind
        public static boolean allow_save_with_errors;
        @Bind
        public static int max_undo;
        @Bind
        public static boolean show_copy_path_button;
        @Bind
        public static boolean show_ui_tips;
        @Bind
        public static boolean allow_over_scroll;
        @Bind
        public static float tooltip_max_width;
        @Bind
        public static int prefer_combo_box;
        @Bind
        public static boolean cycle_with_scroll;
        @Bind
        public static boolean commit_keybind_on_click_outside;
        @Bind
        public static int max_options_in_config_comment;
        @Bind
        public static Map<Integer, Color> color_picker_saved_colors;
        @Bind
        public static boolean translation_debug_mode;

        @Bind
        public static void bake() {
            if (max_undo == 0) {
                max_undo = Integer.MAX_VALUE;
            }
        }

        static {
            max_options_in_config_comment = 4;
        }

        @Bind
        public static class search {
            @Bind
            public static boolean search_filter;
            @Bind
            public static boolean search_regex;
            @Bind
            public static boolean search_case_sensitive;
            @Bind
            public static boolean search_tooltips;
            @Bind
            public static int search_history_size;
            @Bind
            public static List<String> search_history;
            @Bind
            public static int regex_search_history_size;
            @Bind
            public static List<Pattern> regex_search_history;
        }
    }

    @Bind
    public static class confirm {
        @Bind
        public static boolean save;
        @Bind
        public static boolean discard;
        @Bind
        public static boolean overwrite_external;
        @Bind
        public static boolean overwrite_remote;
        @Bind
        public static boolean reset;
        @Bind
        public static boolean restore;
        @Bind
        public static boolean group_reset;
        @Bind
        public static boolean group_restore;
        @Bind
        public static boolean save_hotkeys;
        @Bind
        public static boolean discard_hotkeys;
    }

    @Bind
    public static class hotkey_log {
        @Bind
        public static CommonConfig.HotKeyLogLocation hotkey_log_location;
        @Bind
        public static boolean log_hotkey_actions;
        @Bind
        public static CommonConfig.HotKeyLogLocation remote_hotkey_log_location;
        @Bind
        public static boolean log_remote_hotkey_actions;
        @Bind
        public static int max_logged_actions;

        @Bind
        public static class toast {
            @Bind
            public static float relative_height;
            @Bind
            public static float background_opacity;
            @Bind
            public static int display_time_ms;
        }

        @Bind
        public static class overlay {
            @Bind
            public static float background_opacity;
            @Bind
            public static int display_time_ms;
        }
    }

    @Bind
    public static class menu {
        public static boolean add_pause_menu_button = false;
        public static PauseMenuButtonPosition menu_button_position = PauseMenuButtonPosition.LEFT_OF_OPTIONS_BUTTON;
        @Bind
        public static OptionsButtonBehaviour options_button_behaviour;
        @Bind
        public static boolean add_options_menu_button;
        @Bind
        public static OptionsMenuButtonPosition options_menu_button_position;
    }

    public static enum PauseMenuButtonPosition {
        SPLIT_OPTIONS_BUTTON,
        LEFT_OF_OPTIONS_BUTTON,
        TOP_LEFT_CORNER,
        TOP_RIGHT_CORNER,
        BOTTOM_LEFT_CORNER,
        BOTTOM_RIGHT_CORNER;

    }
}

