/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.api.ui.math;

import endorh.simpleconfig.api.ui.math.Dimension;
import endorh.simpleconfig.api.ui.math.Point;
import org.jetbrains.annotations.NotNull;

public class Rectangle {
    public int x;
    public int y;
    public int width;
    public int height;

    @NotNull
    public static Rectangle of(int x, int y, int width, int height) {
        return new Rectangle(x, y, width, height);
    }

    public Rectangle() {
        this(0, 0, 0, 0);
    }

    public Rectangle(@NotNull Rectangle r) {
        this(r.x, r.y, r.width, r.height);
    }

    public Rectangle(int width, int height) {
        this(0, 0, width, height);
    }

    public Rectangle(@NotNull Point p, @NotNull Dimension d) {
        this(p.x, p.y, d.width, d.height);
    }

    public Rectangle(@NotNull Point p) {
        this(p.x, p.y, 0, 0);
    }

    public Rectangle(@NotNull Dimension d) {
        this(0, 0, d.width, d.height);
    }

    public Rectangle(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public int getX() {
        return this.x;
    }

    public int getMinX() {
        return this.x;
    }

    public int getMaxX() {
        return this.x + this.width;
    }

    public int getCenterX() {
        return this.x + this.width / 2;
    }

    public int getY() {
        return this.y;
    }

    public int getMinY() {
        return this.y;
    }

    public int getMaxY() {
        return this.y + this.height;
    }

    public int getCenterY() {
        return this.y + this.height / 2;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    @NotNull
    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public void setBounds(@NotNull Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    @NotNull
    public Point getLocation() {
        return Point.of(this.x, this.y);
    }

    public void setLocation(@NotNull Point p) {
        this.setLocation(p.x, p.y);
    }

    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void translate(int dx, int dy) {
        this.x += dx;
        this.y += dy;
    }

    @NotNull
    public Rectangle copy() {
        return this.getBounds();
    }

    @NotNull
    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public void setSize(@NotNull Dimension d) {
        this.setSize(d.width, d.height);
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public boolean contains(@NotNull Point p) {
        return this.contains(p.x, p.y);
    }

    public boolean contains(int xx, int yy) {
        if ((this.width | this.height) < 0) {
            return false;
        }
        return xx >= this.x && yy >= this.y && xx < this.x + this.width && yy < this.y + this.height;
    }

    public boolean contains(double x, double y) {
        return this.contains((int)x, (int)y);
    }

    public boolean contains(@NotNull Rectangle r) {
        return this.contains(r.x, r.y, r.width, r.height);
    }

    public boolean contains(int xx, int yy, int ww, int hh) {
        return (this.width | this.height | ww | hh) >= 0 && xx >= this.x && yy >= this.y && xx + ww <= this.x + this.width && yy + hh <= this.y + this.height;
    }

    public boolean intersects(@NotNull Rectangle r) {
        return (r.width | r.height | this.width | this.height) >= 0 && r.x + r.width > this.x && r.y + r.height > this.y && this.x + this.width > r.x && this.y + this.height > r.y;
    }

    public int horizontalIntersection(@NotNull Rectangle r) {
        return Math.min(this.getMaxX(), r.getMaxX()) - Math.max(this.x, r.x);
    }

    public int verticalIntersection(@NotNull Rectangle r) {
        return Math.min(this.getMaxY(), r.getMaxY()) - Math.max(this.y, r.y);
    }

    @NotNull
    public Rectangle intersection(@NotNull Rectangle r) {
        int x = this.x;
        int y = this.y;
        int rx = r.x;
        int ry = r.y;
        long w = (long)x + (long)this.width;
        long h = (long)y + (long)this.height;
        long rw = (long)rx + (long)r.width;
        long rh = (long)ry + (long)r.height;
        if (x < rx) {
            x = rx;
        }
        if (y < ry) {
            y = ry;
        }
        if (w > rw) {
            w = rw;
        }
        if (h > rh) {
            h = rh;
        }
        if ((w -= (long)x) < Integer.MIN_VALUE) {
            w = Integer.MIN_VALUE;
        }
        if ((h -= (long)y) < Integer.MIN_VALUE) {
            h = Integer.MIN_VALUE;
        }
        return new Rectangle(x, y, (int)w, (int)h);
    }

    @NotNull
    public Rectangle union(@NotNull Rectangle r) {
        long w = this.width;
        long h = this.height;
        if ((w | h) < 0L) {
            return new Rectangle(r);
        }
        long rw = r.width;
        long rh = r.height;
        if ((rw | rh) < 0L) {
            return new Rectangle(this);
        }
        int x = this.x;
        int y = this.y;
        w += (long)x;
        h += (long)y;
        int rx = r.x;
        int ry = r.y;
        rw += (long)rx;
        rh += (long)ry;
        if (x > rx) {
            x = rx;
        }
        if (y > ry) {
            y = ry;
        }
        if (w < rw) {
            w = rw;
        }
        if (h < rh) {
            h = rh;
        }
        if ((w -= (long)x) > Integer.MAX_VALUE) {
            w = Integer.MAX_VALUE;
        }
        if ((h -= (long)y) > Integer.MAX_VALUE) {
            h = Integer.MAX_VALUE;
        }
        return new Rectangle(x, y, (int)w, (int)h);
    }

    public void add(int addX, int addY) {
        if ((this.width | this.height) < 0) {
            this.x = addX;
            this.y = addY;
            this.height = 0;
            this.width = 0;
            return;
        }
        int x = this.x;
        int y = this.y;
        long w = (long)this.width + (long)x;
        long h = (long)this.height + (long)y;
        if (x > addX) {
            x = addX;
        }
        if (y > addY) {
            y = addY;
        }
        if (w < (long)addX) {
            w = addX;
        }
        if (h < (long)addY) {
            h = addY;
        }
        if ((w -= (long)x) > Integer.MAX_VALUE) {
            w = Integer.MAX_VALUE;
        }
        if ((h -= (long)y) > Integer.MAX_VALUE) {
            h = Integer.MAX_VALUE;
        }
        this.setBounds(x, y, (int)w, (int)h);
    }

    public void add(@NotNull Point pt) {
        this.add(pt.x, pt.y);
    }

    public void add(@NotNull Rectangle r) {
        long rh;
        long rw;
        long w = this.width;
        long h = this.height;
        if ((w | h) < 0L) {
            this.setBounds(r.x, r.y, r.width, r.height);
        }
        if (((rw = (long)r.width) | (rh = (long)r.height)) < 0L) {
            return;
        }
        int x = this.x;
        int y = this.y;
        w += (long)x;
        h += (long)y;
        int rx = r.x;
        int ry = r.y;
        rw += (long)rx;
        rh += (long)ry;
        if (x > rx) {
            x = rx;
        }
        if (y > ry) {
            y = ry;
        }
        if (w < rw) {
            w = rw;
        }
        if (h < rh) {
            h = rh;
        }
        if ((w -= (long)x) > Integer.MAX_VALUE) {
            w = Integer.MAX_VALUE;
        }
        if ((h -= (long)y) > Integer.MAX_VALUE) {
            h = Integer.MAX_VALUE;
        }
        this.setBounds(x, y, (int)w, (int)h);
    }

    @NotNull
    public Rectangle grow(int left, int up, int right, int down) {
        return new Rectangle(this.x - left, this.y - up, this.width + left + right, this.height + up + down);
    }

    public void grow(int h, int v) {
        long x = this.x;
        long y = this.y;
        long ww = this.width;
        long hh = this.height;
        ww += x;
        hh += y;
        y -= (long)v;
        hh += (long)v;
        if ((ww += (long)h) < (x -= (long)h)) {
            if ((ww -= x) < Integer.MIN_VALUE) {
                ww = Integer.MIN_VALUE;
            }
            if (x < Integer.MIN_VALUE) {
                x = Integer.MIN_VALUE;
            } else if (x > Integer.MAX_VALUE) {
                x = Integer.MAX_VALUE;
            }
        } else {
            if (x < Integer.MIN_VALUE) {
                x = Integer.MIN_VALUE;
            } else if (x > Integer.MAX_VALUE) {
                x = Integer.MAX_VALUE;
            }
            if ((ww -= x) > Integer.MAX_VALUE) {
                ww = Integer.MAX_VALUE;
            }
        }
        if (hh < y) {
            if ((hh -= y) < Integer.MIN_VALUE) {
                hh = Integer.MIN_VALUE;
            }
            if (y < Integer.MIN_VALUE) {
                y = Integer.MIN_VALUE;
            } else if (y > Integer.MAX_VALUE) {
                y = Integer.MAX_VALUE;
            }
        } else {
            if (y < Integer.MIN_VALUE) {
                y = Integer.MIN_VALUE;
            } else if (y > Integer.MAX_VALUE) {
                y = Integer.MAX_VALUE;
            }
            if ((hh -= y) > Integer.MAX_VALUE) {
                hh = Integer.MAX_VALUE;
            }
        }
        this.setBounds((int)x, (int)y, (int)ww, (int)hh);
    }

    public boolean isEmpty() {
        return this.width <= 0 || this.height <= 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Rectangle) {
            Rectangle r = (Rectangle)obj;
            return this.x == r.x && this.y == r.y && this.width == r.width && this.height == r.height;
        }
        return super.equals(obj);
    }

    public String toString() {
        return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + ",width=" + this.width + ",height=" + this.height + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.width;
        result = 31 * result + this.height;
        return result;
    }
}

