/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.api.ui.math;

import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class Point
implements Cloneable {
    public int x;
    public int y;

    @NotNull
    public static Point of(int x, int y) {
        return new Point(x, y);
    }

    @NotNull
    public static Point of(double x, double y) {
        return new Point((int)x, (int)y);
    }

    @NotNull
    public static Point origin() {
        return new Point(0, 0);
    }

    private Point(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    @NotNull
    public Point getPos() {
        return Point.of(this.x, this.y);
    }

    @NotNull
    public Point clone() {
        return this.getPos();
    }

    public void setPos(double x, double y) {
        this.x = (int)Math.floor(x + 0.5);
        this.y = (int)Math.floor(y + 0.5);
    }

    public void move(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void translate(int dx, int dy) {
        this.x += dx;
        this.y += dy;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Point) {
            Point pt = (Point)obj;
            return this.x == pt.x && this.y == pt.y;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        return result;
    }

    public String toString() {
        return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + "]";
    }

    public float distance(float x, float y) {
        float dx = x - (float)this.getX();
        float dy = y - (float)this.getY();
        return Mth.m_14116_((float)(dx * dx + dy * dy));
    }

    public double distance(double x, double y) {
        double dx = x - (double)this.getX();
        double dy = y - (double)this.getY();
        return Mth.m_14116_((float)((float)(dx * dx + dy * dy)));
    }

    public float distance(Point point) {
        return this.distance(point.getX(), point.getY());
    }
}

