/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.api.ui.icon;

import endorh.simpleconfig.api.SimpleConfig;
import endorh.simpleconfig.api.ui.icon.AnimatedIcon;
import endorh.simpleconfig.api.ui.icon.Icon;
import endorh.simpleconfig.api.ui.icon.NinePatchIcon;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class SimpleConfigIcons {
    public static final AnimatedIcon SPINNING_CUBE = AnimatedIcon.ofStripe(Textures.SPINNING_CUBE, 20, 20, 8, 40L);
    public static final AnimatedIcon HOTKEY_RECORDING = AnimatedIcon.ofStripe(Textures.HOTKEY_RECORDING, 18, 18, 16, 50L);

    public static class Textures {
        public static final ResourceLocation CONFIG_MENU = Textures.texture("config_menu");
        public static final ResourceLocation MINECRAFT_OPTIONS = Textures.texture("minecraft_options");
        public static final ResourceLocation SPINNING_CUBE = Textures.texture("cube");
        public static final ResourceLocation HOTKEY_RECORDING = Textures.texture("hotkey_recording");

        private static ResourceLocation texture(String name) {
            return new ResourceLocation("simpleconfig", "textures/gui/simpleconfig/" + name + ".png");
        }
    }

    public static class MinecraftOptions {
        private static final Icon.IconBuilder b = Icon.IconBuilder.ofTexture(Textures.MINECRAFT_OPTIONS, 64, 64);
        public static Icon CONTROLS = b.size(16, 16).at(0, 0);
        public static Icon GRAPHICS = b.at(16, 0);
        public static Icon SOUND = b.at(32, 0);
        public static Icon CHAT = b.at(48, 0);
        public static Icon SKIN = b.at(0, 16);
        public static Icon LANGUAGE = b.at(16, 16);
        public static Icon ONLINE = b.at(32, 16);
        public static Icon ACCESSIBILITY = b.at(48, 16);
        public static Icon ADVANCED = b.at(0, 32);
        public static Icon GAMERULES = b.at(16, 32);
        public static Icon PROPERTIES = b.at(32, 32);
        public static Icon FILE = b.at(48, 32);
    }

    public static class Backgrounds {
        private static Icon.IconBuilder b = Icon.IconBuilder.ofTexture(AbstractWidget.f_93617_, 256, 256);
        public static final NinePatchIcon BUTTON_BACKGROUND = b.size(200, 20).patchSize(2, 2, 2, 3).patchAt(0, 46);

        static {
            b = null;
        }
    }

    public static class ColorPicker {
        private static Icon.IconBuilder b = Icon.IconBuilder.ofTexture(Textures.CONFIG_MENU, 256, 256).offset(40, 36);
        public static final Icon CHESS_BOARD = b.size(40, 40).at(0, 0);
        public static final Icon DIAGONAL_TEXTURE = b.at(40, 0);
        public static final Icon ARROW_RIGHT = b.size(5, 7).at(80, 0);
        public static final Icon ARROW_LEFT = b.at(85, 0);
        public static final Icon POINTER = b.size(11, 11).at(80, 14);

        static {
            b = null;
        }
    }

    public static class ComboBox {
        private static Icon.IconBuilder b = Icon.IconBuilder.ofTexture(Textures.CONFIG_MENU, 256, 256).offset(132, 36);
        public static final Icon UNKNOWN = b.size(20, 20).at(0, 0);
        public static final Icon ERROR = b.at(0, 20);
        public static final Icon DROP_DOWN_ARROW = b.size(10, 10).at(20, 0);

        static {
            b = null;
        }
    }

    public static class Entries {
        private static Icon.IconBuilder b = Icon.IconBuilder.ofTexture(Textures.CONFIG_MENU, 256, 256).offset(39, 0);
        public static final Icon EXPAND = b.size(9, 9).at(0, 0);
        public static final Icon TEXT_EXPAND = b.at(9, 0);
        public static final Icon SLIDER_EDIT = b.at(18, 0);
        public static final Icon ERROR = b.offset(256, 76).reverseOffset(true, false).size(14, 14).at(0, 0);
        public static final Icon WARNING = b.at(14, 0);
        public static final Icon HELP = b.at(28, 0);
        public static final Icon NOT_PERSISTENT = b.at(0, 14);
        public static final Icon REQUIRES_RESTART = b.at(14, 14);
        public static final Icon EXPERIMENTAL = b.at(28, 14);
        public static final Icon COPY = b.at(42, 0);
        public static final Icon TAG = b.at(56, 0);
        public static final Icon WRENCH = b.at(42, 14);
        public static final Icon BOOKMARK = b.at(56, 14);
        public static final Icon LESS_EQUAL = b.offset(162, 36).reverseOffset(false, false).size(18, 18).at(0, 0);
        public static final Icon HELP_SEARCH = b.offset(0, 112).level(0, 0).size(20, 20).at(0, 0);
        public static final Icon HELP_SEARCH_MATCH = HELP_SEARCH.withTint(ChatFormatting.YELLOW);
        public static final Icon HELP_SEARCH_FOCUSED_MATCH = HELP_SEARCH.withTint(ChatFormatting.GOLD);
        public static final Icon MERGE = b.at(20, 0);
        public static final Icon MERGE_ACCEPTED = MERGE.withTint(-8327024);
        public static final Icon MERGE_CONFLICT = MERGE.withTint(-1000064);
        public static final Icon CLOSE_X = b.at(40, 0);

        static {
            b = null;
        }
    }

    public static class Lists {
        private static Icon.IconBuilder b = Icon.IconBuilder.ofTexture(Textures.CONFIG_MENU, 256, 256).offset(0, 0);
        public static final Icon ADD = b.size(9, 9).at(0, 0);
        public static final Icon REMOVE = b.at(9, 0);
        public static final Icon EXPAND = b.at(30, 0);
        public static final Icon INSERT_ARROW = b.size(12, 9).at(18, 0);
        public static final Icon DELETE_ARROW = b.at(18, 18);
        public static final Icon UP_ARROW = b.level(9, 0).size(7, 4).at(1, 27);
        public static final Icon DOWN_ARROW = b.at(1, 32);

        static {
            b = null;
        }
    }

    public static class Hotkeys {
        private static Icon.IconBuilder b = Icon.IconBuilder.ofTexture(Textures.CONFIG_MENU, 256, 256).offset(158, 76);
        public static final Icon LOCAL_HOTKEY = b.size(14, 14).at(0, 0);
        public static final Icon REMOTE_HOTKEY = b.at(0, 14);
        public static final Icon SAVE_HOTKEY = b.at(14, 0);
        public static final Icon RESOURCE_HOTKEY = b.at(14, 14);
        public static final Icon CONTEXT_GAME = b.offset(160, 216).size(8, 9).at(1, 1);
        public static final Icon CONTEXT_MENU = b.at(1, 21);
        public static final Icon CONTEXT_ALL = b.at(21, 1);
        public static final Icon ACTIVATION_PRESS = b.size(5, 9).at(10, 1);
        public static final Icon ACTIVATION_RELEASE = b.at(10, 21);
        public static final Icon ACTIVATION_BOTH = b.at(30, 1);
        public static final Icon ACTIVATION_TOGGLE = b.at(30, 21);
        public static final Icon ACTIVATION_TOGGLE_RELEASE = b.at(35, 21);
        public static final Icon ACTIVATION_REPEAT = b.at(20, 21);
        public static final Icon ACTIVATION_REPEAT_RELEASE = b.at(25, 21);
        public static final Icon ORDER_INSENSITIVE = b.size(8, 5).at(1, 10);
        public static final Icon ORDER_SENSITIVE = b.at(1, 30);
        public static final Icon EXTRA_KEYS_ALLOW = b.size(8, 4).at(1, 15);
        public static final Icon EXTRA_KEYS_BLOCK = b.at(1, 35);
        public static final Icon EXCLUSIVE_NO = b.size(4, 9).at(15, 1);
        public static final Icon EXCLUSIVE_YES = b.at(15, 21);
        public static final Icon MATCH_BY_CODE = b.size(5, 7).at(9, 11);
        public static final Icon MATCH_BY_NAME = b.at(9, 31);
        public static final Icon PREVENT_FURTHER_NO = b.at(14, 11);
        public static final Icon PREVENT_FURTHER_YES = b.at(14, 31);

        static {
            b = null;
        }
    }

    public static class Presets {
        private static Icon.IconBuilder b = Icon.IconBuilder.ofTexture(Textures.CONFIG_MENU, 256, 256).offset(200, 214);
        public static final Icon CLIENT_LOCAL = b.size(14, 14).at(0, 0);
        public static final Icon CLIENT_REMOTE = b.at(14, 0);
        public static final Icon CLIENT_SAVE = b.at(28, 0);
        public static final Icon CLIENT_RESOURCE = b.at(42, 0);
        public static final Icon COMMON_LOCAL = b.at(0, 14);
        public static final Icon COMMON_REMOTE = b.at(14, 14);
        public static final Icon COMMON_SAVE = b.at(28, 14);
        public static final Icon COMMON_RESOURCE = b.at(42, 14);
        public static final Icon SERVER_LOCAL = b.at(0, 28);
        public static final Icon SERVER_REMOTE = b.at(14, 28);
        public static final Icon SERVER_SAVE = b.at(28, 28);
        public static final Icon SERVER_RESOURCE = b.at(42, 28);

        static {
            b = null;
        }
    }

    public static class Widgets {
        private static Icon.IconBuilder b = Icon.IconBuilder.ofTexture(Textures.CONFIG_MENU, 256, 256).offset(184, 0);
        public static final Icon CHECKBOX_FLAT = b.size(18, 18).at(0, 0);
        public static final Icon CHECKBOX = b.at(18, 0);
        public static final Icon TREE_ARROW = b.offset(180, 36).size(16, 16).at(0, 0);
        public static final Icon TREE_DRAG_HANDLE = b.size(8, 16).at(16, 0);
        public static final Icon TREE_ADD = b.offset(60, 112).size(20, 20).at(0, 0);
        public static final Icon TREE_ADD_GROUP = b.at(20, 0);
        public static final Icon TREE_REMOVE = b.at(40, 0);

        static {
            b = null;
        }
    }

    public static class Status {
        private static Icon.IconBuilder b = Icon.IconBuilder.ofTexture(Textures.CONFIG_MENU, 256, 256).offset(66, 0);
        public static final Icon ERROR = b.level(0, 0).size(15, 15).at(0, 0);
        public static final Icon WARNING = b.at(15, 0);
        public static final Icon INFO = b.at(0, 15);
        public static final Icon CHECKMARK = b.at(15, 15);
        public static final Icon H_DOTS = b.at(30, 0);
        public static final Icon V_DOTS = b.at(30, 15);

        static {
            b = null;
        }
    }

    public static class SearchBar {
        private static Icon.IconBuilder b = Icon.IconBuilder.ofTexture(Textures.CONFIG_MENU, 256, 256).offset(112, 0);
        public static final Icon SEARCH_TOOLTIPS = b.size(18, 18).at(0, 0);
        public static final Icon SEARCH_REGEX = b.at(18, 0);
        public static final Icon SEARCH_CASE_SENSITIVE = b.at(36, 0);
        public static final Icon SEARCH_FILTER = b.at(54, 0);

        static {
            b = null;
        }
    }

    public static class Actions {
        private static Icon.IconBuilder b = Icon.IconBuilder.ofTexture(Textures.CONFIG_MENU, 256, 256).offset(256, 104).reverseOffset(true, false);
        public static final Icon NONE = b.size(16, 16).at(0, 0);
        public static final Icon ASSIGN = b.at(0, 16);
        public static final Icon MULTIPLY = b.at(16, 0);
        public static final Icon DIVIDE = b.at(16, 16);
        public static final Icon ADD = b.at(32, 0);
        public static final Icon SUBTRACT = b.at(32, 16);
        public static final Icon ADD_CYCLE = b.at(48, 0);
        public static final Icon SUBTRACT_CYCLE = b.at(48, 16);
        public static final Icon CYCLE = b.at(64, 0);
        public static final Icon CYCLE_REVERSE = b.at(64, 16);

        static {
            b = null;
        }
    }

    public static class Buttons {
        private static Icon.IconBuilder b = Icon.IconBuilder.ofTexture(Textures.CONFIG_MENU, 256, 256).offset(0, 136);
        public static final Icon RESET = b.size(20, 20).at(0, 0);
        public static final Icon RESET_GROUP = b.at(20, 0);
        public static final Icon RESTORE = b.at(40, 0);
        public static final Icon RESTORE_GROUP = b.at(60, 0);
        public static final Icon MERGE_ACCEPT = b.at(80, 0);
        public static final Icon MERGE_ACCEPT_GROUP = b.at(100, 0);
        public static final Icon LOAD = b.at(120, 0);
        public static final Icon SAVE = b.at(140, 0);
        public static final Icon SAVE_REMOTE = b.at(160, 0);
        public static final Icon DELETE = b.at(180, 0);
        public static final Icon EDIT_FILE = b.at(200, 0);
        public static final Icon SEARCH = b.at(0, 60);
        public static final Icon SEARCH_CLOSE = b.at(20, 60);
        public static final Icon UNDO = b.at(40, 60);
        public static final Icon REDO = b.at(60, 60);
        public static final Icon ACCEPT = b.at(80, 60);
        public static final Icon DOWN = b.size(18, 18).at(220, 0);
        public static final Icon UP = b.at(238, 0);
        public static final Icon GEAR = b.twoLevel(true).offset(0, 76).size(18, 18).at(0, 0);
        public static final Icon KEYBOARD = b.at(18, 0);
        public static final Icon COPY = b.at(36, 0);
        public static final Icon SELECT_ALL = b.at(54, 0);
        public static final Icon INVERT_SELECTION = b.at(72, 0);
        public static final Icon CONFIRM_DRAG_LEFT = b.twoLevel(false).offset(0, 36).size(40, 20).at(0, 0);
        public static final Icon CONFIRM_DRAG_RIGHT = b.at(0, 20);
        public static final Icon LEFT_TAB = b.offset(220, 0).size(12, 18).level(12, 0).at(0, 18);
        public static final Icon RIGHT_TAB = b.level(-12, 0).at(24, 0);
        public static final Icon NAVIGATE_UP = b.offset(146, 196).size(18, 18).level(10, 0).cropArea(4, 4, 10, 10).cropFor(0, 0);
        public static final Icon NAVIGATE_DOWN = b.cropFor(0, 10);

        static {
            b = null;
        }
    }

    public static class Types {
        private static Icon.IconBuilder b = Icon.IconBuilder.ofTexture(Textures.CONFIG_MENU, 256, 256).reverseOffset(true, false).offset(256, 198);
        public static final Icon CLIENT = b.size(16, 16).at(0, 0);
        public static final Icon SERVER = b.at(16, 0);
        public static final Icon COMMON = b.at(32, 0);
        public static final Icon COMMON_CLIENT = b.at(48, 0);
        public static final Icon COMMON_SERVER = b.at(64, 0);

        @NotNull
        public static Icon iconFor(SimpleConfig.Type type) {
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case SimpleConfig.Type.CLIENT -> CLIENT;
                case SimpleConfig.Type.SERVER -> SERVER;
                case SimpleConfig.Type.COMMON -> COMMON;
            };
        }

        @NotNull
        public static Icon iconFor(SimpleConfig.EditType type) {
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case SimpleConfig.EditType.CLIENT -> CLIENT;
                case SimpleConfig.EditType.SERVER -> SERVER;
                case SimpleConfig.EditType.COMMON -> COMMON_CLIENT;
                case SimpleConfig.EditType.SERVER_COMMON -> COMMON_SERVER;
            };
        }

        static {
            b = null;
        }
    }
}

