/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.api.ui.icon;

import endorh.simpleconfig.api.ui.icon.Icon;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class NinePatchIcon
extends Icon {
    private final int iu;
    private final int iv;
    private final int iw;
    private final int ih;

    public NinePatchIcon(ResourceLocation texture, int u, int v, int w, int h, int iu, int iv, int iw, int ih, int lX, int lY, int tw, int th, boolean twoLevel, int tint) {
        super(texture, u, v, w, h, lX, lY, tw, th, twoLevel, tint);
        this.iu = iu;
        this.iv = iv;
        this.iw = iw;
        this.ih = ih;
    }

    @Override
    public void renderCentered(@NotNull GuiGraphics gg, int x, int y, int w, int h, int level) {
        this.renderStretch(gg, x, y, w, h, level);
    }

    @Override
    public void renderStretch(@NotNull GuiGraphics gg, int x, int y, int w, int h, int level) {
        this.beforeRender(level);
        int l = this.translateLevel(level);
        int u = this.getU() + l * this.levelOffsetX;
        int v = this.getV() + l * this.levelOffsetY;
        int rw = this.w - this.iw - this.iu;
        int bh = this.h - this.ih - this.iv;
        int lw = this.iu;
        int uh = this.iv;
        if (w < lw + rw) {
            lw = Math.min(lw, Math.max(w / 2, w - rw));
            rw = w - lw;
        }
        if (h < uh + bh) {
            uh = Math.min(uh, Math.max(h / 2, h - bh));
            bh = h - uh;
        }
        int iU = w - lw - rw;
        int iV = h - uh - bh;
        if (uh > 0) {
            if (lw > 0) {
                this.blit(gg, x, y, lw, uh, u, v, lw, uh, this.tw, this.th);
            }
            if (iU > 0) {
                this.blitFill(gg, x + lw, y, iU, uh, u + this.iu, v, this.iw, uh, this.tw, this.th);
            }
            if (rw > 0) {
                this.blit(gg, x + w - rw, y, rw, uh, u + this.iu + this.iw, v, rw, uh, this.tw, this.th);
            }
        }
        if (iV > 0) {
            if (lw > 0) {
                this.blitFill(gg, x, y + uh, lw, iV, u, v + this.iv, lw, this.ih, this.tw, this.th);
            }
            if (iU > 0) {
                this.blitFill(gg, x + lw, y + uh, iU, iV, u + this.iu, v + this.iv, this.iw, this.ih, this.tw, this.th);
            }
            if (rw > 0) {
                this.blitFill(gg, x + w - rw, y + uh, rw, iV, u + this.iu + this.iw, v + this.iv, rw, this.ih, this.tw, this.th);
            }
        }
        if (bh > 0) {
            if (lw > 0) {
                this.blit(gg, x, y + h - bh, lw, bh, u, v + this.iv + this.ih, lw, bh, this.tw, this.th);
            }
            if (iU > 0) {
                this.blitFill(gg, x + lw, y + h - bh, iU, bh, u + this.iu, v + this.iv + this.ih, this.iw, bh, this.tw, this.th);
            }
            if (rw > 0) {
                this.blit(gg, x + w - rw, y + h - bh, rw, bh, u + this.iu + this.iw, v + this.iv + this.ih, rw, bh, this.tw, this.th);
            }
        }
        this.afterRender(level);
    }

    @Override
    public void renderFill(@NotNull GuiGraphics gg, int x, int y, int w, int h, int level) {
        this.renderStretch(gg, x, y, w, h, level);
    }

    protected void blitFill(GuiGraphics gg, int x, int y, int w, int h, int u, int v, int uw, int vh, int tw, int th) {
        int yy;
        int xx;
        for (xx = x; xx < x + w - uw; xx += uw) {
            for (yy = y; yy < y + h - vh; yy += vh) {
                this.blit(gg, xx, yy, uw, vh, u, v, uw, vh, tw, th);
            }
            int yh = y + h - yy;
            this.blit(gg, xx, yy, uw, yh, u, v, uw, yh, tw, th);
        }
        int xw = x + w - xx;
        for (yy = y; yy < y + h - vh; yy += vh) {
            this.blit(gg, xx, yy, xw, vh, u, v, xw, vh, tw, th);
        }
        int yh = y + h - yy;
        this.blit(gg, xx, yy, xw, yh, u, v, xw, yh, tw, th);
    }

    @Override
    @NotNull
    public Icon withTint(int tint) {
        return new NinePatchIcon(this.getTexture(), this.u, this.v, this.w, this.h, this.iu, this.iv, this.iw, this.ih, this.levelOffsetX, this.levelOffsetY, this.tw, this.th, this.isTwoLevel(), tint);
    }
}

