/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.api.ui.icon;

import endorh.simpleconfig.api.ui.icon.Icon;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public abstract class LayeredIcon<L extends IIconLayer>
extends Icon {
    public static SimpleLayeredIcon of(Icon ... layers) {
        return LayeredIcon.of(Arrays.asList(layers));
    }

    public static SimpleLayeredIcon of(List<Icon> layers) {
        return new SimpleLayeredIcon(layers);
    }

    protected LayeredIcon(int w, int h, int tint) {
        super(new ResourceLocation("dummy"), 0, 0, w, h, 0, 0, 0, 0, false, tint);
    }

    @Override
    @NotNull
    public abstract Icon withTint(int var1);

    public abstract List<L> getRenderedLayers();

    @Override
    public int translateLevel(int level) {
        return level;
    }

    @Override
    public void renderCentered(@NotNull GuiGraphics gg, int x, int y, int w, int h, int level) {
        this.beforeRender(level);
        for (IIconLayer layer : this.getRenderedLayers()) {
            if (!layer.isVisible()) continue;
            this.beforeRenderLayer(layer);
            layer.getIcon().renderCentered(gg, x, y, w, h, this.translateLevel(level));
            this.afterRenderLayer(layer);
        }
        this.afterRender(level);
    }

    @Override
    public void renderStretch(@NotNull GuiGraphics gg, int x, int y, int w, int h, int level) {
        this.beforeRender(level);
        for (IIconLayer layer : this.getRenderedLayers()) {
            if (!layer.isVisible()) continue;
            this.beforeRenderLayer(layer);
            layer.getIcon().renderStretch(gg, x, y, w, h, this.translateLevel(level));
            this.afterRenderLayer(layer);
        }
        this.afterRender(level);
    }

    @Override
    public void renderFill(@NotNull GuiGraphics gg, int x, int y, int w, int h, int level) {
        this.beforeRender(level);
        for (IIconLayer layer : this.getRenderedLayers()) {
            if (!layer.isVisible()) continue;
            this.beforeRenderLayer(layer);
            layer.getIcon().renderFill(gg, x, y, w, h, this.translateLevel(level));
            this.afterRenderLayer(layer);
        }
        this.afterRender(level);
    }

    @Override
    public void bindTexture() {
    }

    @Override
    protected void beforeRender(int level) {
    }

    @Override
    protected void afterRender(int level) {
    }

    public void beforeRenderLayer(L layer) {
        if (this.tint != 0) {
            LayeredIcon.setShaderColorMask(this.tint);
        }
    }

    public void afterRenderLayer(L layer) {
        LayeredIcon.removeShaderColorMask();
    }

    public static class SimpleLayeredIcon
    extends LayeredIcon<SimpleIconLayer> {
        private final List<SimpleIconLayer> layers;

        public SimpleLayeredIcon(List<Icon> layers) {
            this(layers, layers.stream().mapToInt(i -> i.w).max().orElse(0), layers.stream().mapToInt(i -> i.h).max().orElse(0), 0);
        }

        public SimpleLayeredIcon(List<Icon> layers, int w, int h, int tint) {
            super(w, h, tint);
            this.layers = layers.stream().map(SimpleIconLayer::new).collect(Collectors.toList());
        }

        @Override
        @NotNull
        public Icon withTint(int tint) {
            return new SimpleLayeredIcon(this.layers.stream().map(SimpleIconLayer::getIcon).collect(Collectors.toList()), this.w, this.h, tint);
        }

        @Override
        public List<SimpleIconLayer> getRenderedLayers() {
            return this.layers;
        }

        public int getLayerCount() {
            return this.layers.size();
        }

        public boolean isLayerVisible(int index) {
            return this.layers.get(index).isVisible();
        }

        public void setLayerVisible(int index) {
            this.layers.get(index).setVisible(true);
        }

        public void setLayerIcon(int index, Icon icon) {
            this.layers.get(index).setIcon(icon);
        }

        public void addLayer(int index, Icon icon) {
            this.layers.add(index, new SimpleIconLayer(icon));
        }

        public void removeLayer(int index) {
            this.layers.remove(index);
        }
    }

    public static interface IIconLayer {
        public Icon getIcon();

        public boolean isVisible();
    }

    public static class SimpleIconLayer
    implements IIconLayer {
        private Icon icon;
        private boolean visible = true;

        public SimpleIconLayer(Icon icon) {
            this.icon = icon;
        }

        @Override
        public Icon getIcon() {
            return this.icon;
        }

        public void setIcon(Icon icon) {
            this.icon = icon;
        }

        @Override
        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }
    }
}

