/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.api.ui.icon;

import endorh.simpleconfig.api.ui.hotkey.ExtendedKeyBindSettings;
import endorh.simpleconfig.api.ui.hotkey.KeyBindMapping;
import endorh.simpleconfig.api.ui.icon.Icon;
import endorh.simpleconfig.api.ui.icon.LayeredIcon;
import endorh.simpleconfig.api.ui.icon.SimpleConfigIcons;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.Util;
import org.jetbrains.annotations.NotNull;

public class KeyBindSettingsIcon
extends LayeredIcon<LayeredIcon.SimpleIconLayer> {
    private static Icon.IconBuilder b = Icon.IconBuilder.ofTexture(SimpleConfigIcons.Textures.CONFIG_MENU, 256, 256).offset(140, 216);
    public static final Icon BACKGROUND = b.size(20, 20).at(0, 0);
    public static final Icon BACKGROUND_HIGHLIGHT = b.at(0, 20);
    public static final Icon BACKGROUND_WARN = BACKGROUND_HIGHLIGHT.withTint(-285212928);
    public static final Icon BACKGROUND_HIGHLIGHT_WARN = BACKGROUND_HIGHLIGHT.withTint(-156);
    public static final Icon CONTEXT_GAME = b.cropArea(1, 1, 8, 9).cropAt(20, 0);
    public static final Icon CONTEXT_MENU = b.cropAt(20, 20);
    public static final Icon CONTEXT_ALL = b.cropAt(40, 0);
    public static final Icon ACTIVATION_PRESS = b.cropArea(10, 1, 5, 9).cropAt(20, 0);
    public static final Icon ACTIVATION_RELEASE = b.cropAt(20, 20);
    public static final Icon ACTIVATION_BOTH = b.cropAt(40, 0);
    public static final Icon ACTIVATION_TOGGLE = b.cropAt(40, 20);
    public static final Icon ACTIVATION_TOGGLE_RELEASE = b.cropFor(55, 21);
    public static final Icon ACTIVATION_REPEAT = b.cropFor(40, 21);
    public static final Icon ORDER_INSENSITIVE = b.cropArea(1, 10, 8, 5).cropAt(20, 0);
    public static final Icon ORDER_SENSITIVE = b.cropAt(20, 20);
    public static final Icon EXTRA_KEYS_ALLOW = b.cropArea(1, 15, 8, 4).cropAt(20, 0);
    public static final Icon EXTRA_KEYS_BLOCK = b.cropAt(20, 20);
    public static final Icon EXCLUSIVE_NOT = b.cropArea(15, 1, 4, 9).cropAt(20, 0);
    public static final Icon EXCLUSIVE_YES = b.cropAt(20, 20);
    public static final Icon STORE_CODE = b.cropArea(9, 11, 5, 7).cropAt(20, 0);
    public static final Icon STORE_CHAR = b.cropAt(20, 20);
    public static final Icon PREVENT_NO = b.cropArea(14, 11, 5, 7).cropAt(20, 0);
    public static final Icon PREVENT_YES = b.cropAt(20, 20);
    private static final Map<KeyBindMapping.KeyBindActivation, Icon> ACTIVATION_ICONS;
    protected LayeredIcon.SimpleIconLayer backgroundLayer = new LayeredIcon.SimpleIconLayer(BACKGROUND);
    protected LayeredIcon.SimpleIconLayer contextLayer = new LayeredIcon.SimpleIconLayer(CONTEXT_GAME);
    protected LayeredIcon.SimpleIconLayer activationLayer = new LayeredIcon.SimpleIconLayer(ACTIVATION_PRESS);
    protected LayeredIcon.SimpleIconLayer orderLayer = new LayeredIcon.SimpleIconLayer(ORDER_INSENSITIVE);
    protected LayeredIcon.SimpleIconLayer extraKeysLayer = new LayeredIcon.SimpleIconLayer(EXTRA_KEYS_ALLOW);
    protected LayeredIcon.SimpleIconLayer exclusiveLayer = new LayeredIcon.SimpleIconLayer(EXCLUSIVE_NOT);
    protected LayeredIcon.SimpleIconLayer storeLayer = new LayeredIcon.SimpleIconLayer(STORE_CODE);
    protected LayeredIcon.SimpleIconLayer preventLayer = new LayeredIcon.SimpleIconLayer(PREVENT_NO);
    protected List<LayeredIcon.SimpleIconLayer> layers = (List)Util.m_137469_(new ArrayList(), l -> Stream.of(this.backgroundLayer, this.contextLayer, this.activationLayer, this.orderLayer, this.extraKeysLayer, this.exclusiveLayer, this.storeLayer, this.preventLayer).forEach(l::add));
    private ExtendedKeyBindSettings settings = ExtendedKeyBindSettings.ingame().build();
    private boolean warning;
    private boolean highlight;

    public KeyBindSettingsIcon() {
        this(0);
    }

    public KeyBindSettingsIcon(int tint) {
        super(20, 20, tint);
    }

    protected void updateBackground() {
        Icon background = this.warning ? (this.highlight ? BACKGROUND_HIGHLIGHT_WARN : BACKGROUND_WARN) : (this.highlight ? BACKGROUND_HIGHLIGHT : BACKGROUND);
        this.backgroundLayer.setIcon(background);
    }

    @Override
    public int translateLevel(int level) {
        return 0;
    }

    protected void updateLayers() {
        this.updateBackground();
        ExtendedKeyBindSettings settings = this.getSettings();
        KeyBindMapping.KeyBindContext context = settings.context();
        this.contextLayer.setIcon(context.getCropIcon());
        KeyBindMapping.KeyBindActivation activation = settings.activation();
        this.activationLayer.setIcon(ACTIVATION_ICONS.get((Object)activation));
        this.orderLayer.setIcon(settings.orderSensitive() ? ORDER_SENSITIVE : ORDER_INSENSITIVE);
        this.extraKeysLayer.setIcon(settings.allowExtraKeys() ? EXTRA_KEYS_ALLOW : EXTRA_KEYS_BLOCK);
        this.exclusiveLayer.setIcon(settings.exclusive() ? EXCLUSIVE_YES : EXCLUSIVE_NOT);
        this.storeLayer.setIcon(settings.matchByChar() ? STORE_CHAR : STORE_CODE);
        this.preventLayer.setIcon(settings.preventFurther() ? PREVENT_YES : PREVENT_NO);
    }

    @Override
    protected void beforeRender(int level) {
        this.updateBackground();
        this.setHighlight(level == 2);
    }

    @Override
    @NotNull
    public Icon withTint(int tint) {
        return new KeyBindSettingsIcon(tint);
    }

    @Override
    public List<LayeredIcon.SimpleIconLayer> getRenderedLayers() {
        return this.layers;
    }

    public ExtendedKeyBindSettings getSettings() {
        return this.settings;
    }

    public void setSettings(ExtendedKeyBindSettings settings) {
        this.settings = settings;
        this.updateLayers();
    }

    public boolean isWarning() {
        return this.warning;
    }

    public void setWarning(boolean warning) {
        this.warning = warning;
    }

    public boolean isHighlight() {
        return this.highlight;
    }

    public void setHighlight(boolean highlight) {
        this.highlight = highlight;
    }

    static {
        b = null;
        ACTIVATION_ICONS = (Map)Util.m_137469_(new EnumMap(KeyBindMapping.KeyBindActivation.class), m -> {
            m.put(KeyBindMapping.KeyBindActivation.PRESS, ACTIVATION_PRESS);
            m.put(KeyBindMapping.KeyBindActivation.RELEASE, ACTIVATION_RELEASE);
            m.put(KeyBindMapping.KeyBindActivation.BOTH, ACTIVATION_BOTH);
            m.put(KeyBindMapping.KeyBindActivation.TOGGLE, ACTIVATION_TOGGLE);
            m.put(KeyBindMapping.KeyBindActivation.TOGGLE_RELEASE, ACTIVATION_TOGGLE_RELEASE);
            m.put(KeyBindMapping.KeyBindActivation.REPEAT, ACTIVATION_REPEAT);
        });
    }
}

