/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.api.ui.icon;

import com.mojang.blaze3d.systems.RenderSystem;
import endorh.simpleconfig.api.ui.icon.CropIcon;
import endorh.simpleconfig.api.ui.icon.NinePatchIcon;
import endorh.simpleconfig.api.ui.math.Rectangle;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class Icon {
    public static final Icon EMPTY = new Icon(new ResourceLocation("simpleconfig", "textures/gui/simpleconfig/empty"), 0, 0, 0, 0, 0, 0){

        @Override
        public void renderCentered(@NotNull GuiGraphics m, int x, int y, int w, int h, int level) {
        }

        @Override
        public void renderStretch(@NotNull GuiGraphics m, int x, int y, int w, int h, int level) {
        }

        @Override
        public void bindTexture() {
        }
    };
    protected final ResourceLocation texture;
    protected final int u;
    protected final int v;
    public final int w;
    public final int h;
    public final int levelOffsetX;
    public final int levelOffsetY;
    public final int tw;
    public final int th;
    public final int tint;
    protected final boolean twoLevel;

    public Icon(ResourceLocation texture, int u, int v, int w, int h, int tw, int th) {
        this(texture, u, v, w, h, tw, th, false);
    }

    public Icon(ResourceLocation texture, int u, int v, int w, int h, int tw, int th, boolean twoLevel) {
        this(texture, u, v, w, h, Integer.MAX_VALUE, Integer.MAX_VALUE, tw, th, twoLevel, 0);
    }

    public Icon(ResourceLocation texture, int u, int v, int w, int h, int lX, int lY, int tw, int th, boolean twoLevel, int tint) {
        this.texture = texture;
        this.u = u;
        this.v = v;
        this.w = w;
        this.h = h;
        if (lX != Integer.MAX_VALUE || lY != Integer.MAX_VALUE) {
            this.levelOffsetX = lX;
            this.levelOffsetY = lY;
        } else {
            this.levelOffsetX = 0;
            this.levelOffsetY = h;
        }
        this.tw = tw;
        this.th = th;
        this.twoLevel = twoLevel;
        this.tint = tint;
    }

    @Contract(pure=true)
    @NotNull
    public Icon withTint(int tint) {
        return new Icon(this.getTexture(), this.u, this.v, this.w, this.h, this.levelOffsetX, this.levelOffsetY, this.tw, this.th, this.isTwoLevel(), tint);
    }

    @Contract(pure=true)
    @NotNull
    public Icon withTint(ChatFormatting tint) {
        Integer color = tint.m_126665_();
        if (color == null) {
            throw new IllegalArgumentException("Not a valid color style: " + tint);
        }
        return this.withTint((int)(color | 0xFF000000));
    }

    @Contract(pure=true)
    @NotNull
    public Icon withTint(Style style) {
        TextColor color = style.m_131135_();
        int c = color != null ? color.m_131265_() : Objects.requireNonNull(ChatFormatting.WHITE.m_126665_()).intValue();
        if ((c & 0xFF000000) == 0) {
            c |= 0xFF000000;
        }
        return this.withTint(c);
    }

    public static void setShaderColorMask(int color) {
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >> 24 & 0xFF) / 255.0f));
    }

    public static void removeShaderColorMask() {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public int translateLevel(int level) {
        if (this.isTwoLevel()) {
            return Math.max(0, level - 1);
        }
        return level;
    }

    public void renderCentered(@NotNull GuiGraphics gg, @NotNull Rectangle rect) {
        this.renderCentered(gg, rect, 0);
    }

    public void renderCentered(@NotNull GuiGraphics gg, int x, int y, int w, int h) {
        this.renderCentered(gg, x, y, w, h, 0);
    }

    public void renderCentered(@NotNull GuiGraphics gg, @NotNull Rectangle rect, int level) {
        this.renderCentered(gg, rect.x, rect.y, rect.width, rect.height, level);
    }

    public void renderCentered(@NotNull GuiGraphics gg, int x, int y, int w, int h, int level) {
        this.beforeRender(level);
        int xx = x + w / 2 - this.w / 2;
        int yy = y + h / 2 - this.h / 2;
        int ww = Math.min(w, this.w);
        int hh = Math.min(h, this.h);
        int l = this.translateLevel(level);
        int u = this.getU();
        int v = this.getV();
        u = Math.max(u + x - xx, u) + l * this.levelOffsetX;
        v = Math.max(v + y - yy, v) + l * this.levelOffsetY;
        this.blit(gg, Math.max(x, xx), Math.max(y, yy), ww, hh, u, v, ww, hh, this.tw, this.th);
        this.afterRender(level);
    }

    public void renderStretch(@NotNull GuiGraphics gg, @NotNull Rectangle rect) {
        this.renderStretch(gg, rect, 0);
    }

    public void renderStretch(@NotNull GuiGraphics gg, int x, int y, int w, int h) {
        this.renderStretch(gg, x, y, w, h, 0);
    }

    public void renderStretch(@NotNull GuiGraphics gg, @NotNull Rectangle rect, int level) {
        this.renderStretch(gg, rect.x, rect.y, rect.width, rect.height, level);
    }

    public void renderStretch(@NotNull GuiGraphics gg, int x, int y, int w, int h, int level) {
        this.beforeRender(level);
        int l = this.translateLevel(level);
        this.blit(gg, x, y, w, h, this.getU() + l * this.levelOffsetX, this.getV() + l * this.levelOffsetY, this.w, this.h, this.tw, this.th);
        this.afterRender(level);
    }

    public void renderFill(@NotNull GuiGraphics gg, @NotNull Rectangle rect) {
        this.renderFill(gg, rect, 0);
    }

    public void renderFill(@NotNull GuiGraphics gg, int x, int y, int w, int h) {
        this.renderFill(gg, x, y, w, h, 0);
    }

    public void renderFill(@NotNull GuiGraphics gg, @NotNull Rectangle rect, int level) {
        this.renderFill(gg, rect.x, rect.y, rect.width, rect.height, level);
    }

    public void renderFill(@NotNull GuiGraphics gg, int x, int y, int w, int h, int level) {
        int yh;
        int yy;
        int xx;
        this.beforeRender(level);
        int l = this.translateLevel(level);
        int u = this.getU() + l * this.levelOffsetX;
        int v = this.getV() + l * this.levelOffsetY;
        for (xx = x; xx < x + w - this.w; xx += this.w) {
            for (yy = y; yy < y + h - this.h; yy += this.h) {
                this.blit(gg, xx, yy, this.w, this.h, u, v, this.w, this.h, this.tw, this.th);
            }
            yh = y + h - yy;
            this.blit(gg, xx, yy, this.w, yh, u, v, this.w, yh, this.tw, this.th);
        }
        int xw = x + w - xx;
        for (yy = y; yy < y + h - this.h; yy += this.h) {
            this.blit(gg, xx, yy, xw, this.h, u, v, xw, this.h, this.tw, this.th);
        }
        yh = y + h - yy;
        this.blit(gg, xx, yy, xw, yh, u, v, xw, yh, this.tw, this.th);
        this.afterRender(level);
    }

    protected void beforeRender(int level) {
        this.bindTexture();
        if (this.tint != 0) {
            Icon.setShaderColorMask(this.tint);
        }
    }

    protected void afterRender(int level) {
        Icon.removeShaderColorMask();
    }

    public void bindTexture() {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.getTexture());
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public int getU() {
        return this.u;
    }

    public int getV() {
        return this.v;
    }

    public boolean isTwoLevel() {
        return this.twoLevel;
    }

    protected void blit(GuiGraphics gg, int x, int y, int w, int h, float u, float v, int uw, int vh, int tw, int th) {
        RenderSystem.enableBlend();
        gg.m_280411_(this.getTexture(), x, y, w, h, u, v, uw, vh, tw, th);
        RenderSystem.disableBlend();
    }

    public static class IconBuilder {
        private ResourceLocation texture;
        private int tw = 256;
        private int th = 256;
        private boolean revU = false;
        private boolean revV = false;
        private int ou = 0;
        private int ov = 0;
        private int lX = Integer.MAX_VALUE;
        private int lY = Integer.MAX_VALUE;
        private int u = 0;
        private int v = 0;
        private int w = 24;
        private int h = 24;
        private int cropU = 0;
        private int cropV = 0;
        private int cropW = 0;
        private int cropH = 0;
        private int patchL = 0;
        private int patchT = 0;
        private int patchR = 0;
        private int patchB = 0;
        private boolean twoLevel = false;

        @NotNull
        public static IconBuilder ofTexture(@NotNull ResourceLocation location, int width, int height) {
            return new IconBuilder(location).texture(location, width, height);
        }

        private IconBuilder(ResourceLocation location) {
            this.texture = location;
        }

        @NotNull
        public IconBuilder texture(ResourceLocation location, int width, int height) {
            this.texture = location;
            this.tw = width;
            this.th = height;
            return this;
        }

        @NotNull
        public IconBuilder size(int w, int h) {
            this.w = w;
            this.h = h;
            return this;
        }

        @NotNull
        public IconBuilder level(Integer lX, Integer lY) {
            this.lX = lX != null ? lX : Integer.MAX_VALUE;
            this.lY = lY != null ? lY : Integer.MAX_VALUE;
            return this;
        }

        @NotNull
        public IconBuilder twoLevel(boolean twoLevel) {
            this.twoLevel = twoLevel;
            return this;
        }

        @NotNull
        public IconBuilder offset(int ox, int oy) {
            this.ou = ox;
            this.ov = oy;
            return this;
        }

        @NotNull
        public IconBuilder reverseOffset(boolean reverseX, boolean reverseY) {
            this.revU = reverseX;
            this.revV = reverseY;
            return this;
        }

        @NotNull
        public IconBuilder cropPos(int baseU, int baseV) {
            this.u = baseU;
            this.v = baseV;
            return this;
        }

        @NotNull
        public IconBuilder cropArea(int uOffset, int vOffset, int cropW, int cropH) {
            this.cropU = uOffset;
            this.cropV = vOffset;
            this.cropW = cropW;
            this.cropH = cropH;
            return this;
        }

        @NotNull
        public CropIcon cropAt(int baseU, int baseV) {
            return new CropIcon(this.texture, this.revU ? this.ou - baseU - this.w : this.ou + baseU, this.revV ? this.ov - baseV - this.h : this.ov + baseV, this.w, this.h, this.lX, this.lY, this.tw, this.th, this.twoLevel, 0, this.cropU, this.cropV, this.cropW, this.cropH);
        }

        @NotNull
        public CropIcon cropFor(int cropU, int cropV) {
            return this.cropAt(cropU - this.cropU, cropV - this.cropV);
        }

        @NotNull
        public CropIcon crop(int uOffset, int vOffset, int cropW, int cropH) {
            return new CropIcon(this.texture, this.revU ? this.ou - this.u - this.w : this.ou + this.u, this.revV ? this.ov - this.v - this.h : this.ov + this.v, this.w, this.h, this.lX, this.lY, this.tw, this.th, this.twoLevel, 0, uOffset, vOffset, cropW, cropH);
        }

        @NotNull
        public IconBuilder patchSize(int left, int top, int right, int bottom) {
            this.patchL = left;
            this.patchT = top;
            this.patchR = right;
            this.patchB = bottom;
            return this;
        }

        @NotNull
        public NinePatchIcon patchAt(int u, int v) {
            return new NinePatchIcon(this.texture, this.revU ? this.ou - u - this.w : this.ou + u, this.revV ? this.ov - v - this.h : this.ov + v, this.w, this.h, this.patchL, this.patchT, this.w - this.patchL - this.patchR, this.h - this.patchT - this.patchB, this.lX, this.lY, this.tw, this.th, this.twoLevel, 0);
        }

        @NotNull
        public Icon at(int u, int v) {
            return new Icon(this.texture, this.revU ? this.ou - u - this.w : this.ou + u, this.revV ? this.ov - v - this.h : this.ov + v, this.w, this.h, this.lX, this.lY, this.tw, this.th, this.twoLevel, 0);
        }
    }
}

