/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.api.ui.icon;

import endorh.simpleconfig.api.ui.icon.Icon;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class CropIcon
extends Icon {
    protected final int cU;
    protected final int cV;
    protected final int cW;
    protected final int cH;

    public CropIcon(ResourceLocation texture, int u, int v, int w, int h, int lX, int lY, int tw, int th, boolean twoLevel, int tint, int cU, int cV, int cW, int cH) {
        super(texture, u, v, w, h, lX, lY, tw, th, twoLevel, tint);
        this.cU = cU;
        this.cV = cV;
        this.cW = cW;
        this.cH = cH;
    }

    @Override
    @NotNull
    public Icon withTint(int tint) {
        return new CropIcon(this.getTexture(), this.u, this.v, this.w, this.h, this.levelOffsetX, this.levelOffsetY, this.tw, this.th, this.twoLevel, tint, this.cU, this.cV, this.cW, this.cH);
    }

    @Override
    public void renderCentered(@NotNull GuiGraphics gg, int x, int y, int w, int h, int level) {
        this.beforeRender(level);
        int xx = x + w / 2 - this.w / 2;
        int yy = y + h / 2 - this.h / 2;
        int l = this.translateLevel(level);
        int u = this.getU();
        int v = this.getV();
        u = Math.max(u + x - xx, u) + l * this.levelOffsetX;
        v = Math.max(v + y - yy, v) + l * this.levelOffsetY;
        int cU = this.getCropU();
        int cV = this.getCropV();
        int ww = Math.min(w - cU, this.getCropW());
        int hh = Math.min(h - cV, this.getCropH());
        this.blit(gg, Math.max(x, xx) + cU, Math.max(y, yy) + cV, ww, hh, u + cU, v + cV, ww, hh, this.tw, this.th);
        this.afterRender(level);
    }

    @Override
    public void renderStretch(@NotNull GuiGraphics gg, int x, int y, int w, int h, int level) {
        this.beforeRender(level);
        int l = this.translateLevel(level);
        int u = this.getU() + l * this.levelOffsetX;
        int v = this.getV() + l * this.levelOffsetY;
        int cU = this.getCropU();
        int cV = this.getCropV();
        int cW = this.getCropW();
        int cH = this.getCropH();
        this.blit(gg, x + Math.round((float)(cU * w) / (float)this.w), y + Math.round((float)(cV * h) / (float)this.h), Math.round((float)(cW * w) / (float)this.w), Math.round((float)(cH * h) / (float)this.h), u + cU, v + cV, cW, cH, this.tw, this.th);
        this.afterRender(level);
    }

    @Override
    public void renderFill(@NotNull GuiGraphics gg, int x, int y, int w, int h, int level) {
        int yh;
        int yy;
        int xx;
        this.beforeRender(level);
        int l = this.translateLevel(level);
        int cU = this.getCropU();
        int cV = this.getCropV();
        int cW = this.getCropW();
        int cH = this.getCropH();
        int u = this.getU() + l * this.levelOffsetX + cU;
        int v = this.getV() + l * this.levelOffsetY + cV;
        for (xx = x + cU; xx < x + cU + w - this.w; xx += this.w) {
            for (yy = y + cV; yy < y + cV + h - this.h; yy += this.h) {
                this.blit(gg, xx, yy, cW, cH, u, v, cW, cH, this.tw, this.th);
            }
            yh = Math.min(cH, y + h - yy - cV);
            this.blit(gg, xx, yy, cW, yh, u, v, cW, yh, this.tw, this.th);
        }
        int xw = Math.min(cW, x + w - xx - cU);
        for (yy = y + cV; yy < y + cV + h - this.h; yy += this.h) {
            this.blit(gg, xx, yy, xw, cH, u, v, xw, cH, this.tw, this.th);
        }
        yh = Math.min(cH, y + h - yy - cV);
        this.blit(gg, xx, yy, xw, yh, u, v, xw, yh, this.tw, this.th);
        this.afterRender(level);
    }

    public int getCropU() {
        return this.cU;
    }

    public int getCropV() {
        return this.cV;
    }

    public int getCropW() {
        return this.cW;
    }

    public int getCropH() {
        return this.cH;
    }
}

