/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.api.ui.icon;

import endorh.simpleconfig.api.ui.icon.Icon;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class AnimatedIcon
extends Icon {
    public final int rows;
    public final int cols;
    public final int frames;
    public long delay;
    protected int lastFrame = 0;
    protected long lastFrameTime = 0L;

    public static AnimatedIcon ofStripe(ResourceLocation texture, int w, int h, int frames, long delay) {
        return new AnimatedIcon(texture, 0, 0, w, h, w * frames, h, 1, frames, delay);
    }

    public AnimatedIcon(ResourceLocation location, int u, int v, int w, int h, int tw, int th, int rows, int cols, long delay) {
        this(location, u, v, w, h, Integer.MAX_VALUE, Integer.MAX_VALUE, tw, th, false, 0, rows, cols, delay);
    }

    public AnimatedIcon(ResourceLocation location, int u, int v, int w, int h, int lX, int lY, int tw, int th, boolean twoLevel, int tint, int rows, int cols, long delay) {
        super(location, u, v, w, h, lX, lY, tw, th, twoLevel, tint);
        this.rows = rows;
        this.cols = cols;
        this.delay = delay;
        this.frames = rows * cols;
    }

    @Override
    @NotNull
    public AnimatedIcon withTint(int tint) {
        return new AnimatedIcon(this.getTexture(), this.u, this.v, this.w, this.h, this.levelOffsetX, this.levelOffsetY, this.tw, this.th, this.twoLevel, tint, this.rows, this.cols, this.delay);
    }

    public AnimatedIcon copy() {
        return this.withTint(this.tint);
    }

    @Override
    public int translateLevel(int level) {
        return 0;
    }

    @Override
    public int getU() {
        return this.u + this.lastFrame % this.cols * this.w;
    }

    @Override
    public int getV() {
        return this.v + this.lastFrame / this.rows * this.h;
    }

    @Override
    protected void beforeRender(int level) {
        super.beforeRender(level);
        this.update();
    }

    public void reset() {
        this.lastFrame = 0;
        this.lastFrameTime = 0L;
    }

    public void setFrame(int frame) {
        this.lastFrame = frame;
        this.lastFrameTime = 0L;
    }

    protected void update() {
        long time = System.currentTimeMillis();
        if (this.lastFrameTime == 0L) {
            this.lastFrameTime = time;
        } else if (time - this.lastFrameTime > this.delay) {
            long skip = time - this.lastFrameTime;
            this.lastFrame = (int)((long)this.lastFrame + skip / this.delay);
            this.lastFrameTime = time - skip % this.delay;
        }
    }

    public static class AnimatedIconBuilder {
        private ResourceLocation location;
        private int tw = 256;
        private int th = 256;
        private int w = 24;
        private int h = 24;
        private int lX = Integer.MAX_VALUE;
        private int lY = Integer.MAX_VALUE;
        private boolean twoLevel = false;
        private long delay = 40L;
        private int rows = 1;
        private int cols = 1;

        public static AnimatedIconBuilder ofTexture(ResourceLocation location, int textureWidth, int textureHeight) {
            return new AnimatedIconBuilder(location).withTexture(location, textureWidth, textureHeight);
        }

        private AnimatedIconBuilder(ResourceLocation location) {
            this.location = location;
        }

        public AnimatedIconBuilder withTexture(ResourceLocation location, int textureWidth, int textureHeight) {
            this.location = location;
            this.tw = textureWidth;
            this.th = textureHeight;
            return this;
        }

        public AnimatedIconBuilder withSize(int w, int h) {
            this.w = w;
            this.h = h;
            return this;
        }

        public AnimatedIconBuilder withFrames(int rows, int cols) {
            this.rows = rows;
            this.cols = cols;
            return this;
        }

        public AnimatedIconBuilder withLevelOffset(Integer lX, Integer lY) {
            this.lX = lX != null ? lX : Integer.MAX_VALUE;
            this.lY = lY != null ? lY : Integer.MAX_VALUE;
            return this;
        }

        public AnimatedIconBuilder twoLevel(boolean twoLevel) {
            this.twoLevel = twoLevel;
            return this;
        }

        public AnimatedIconBuilder withFPS(float fps) {
            this.delay = (long)(1000.0f / fps);
            return this;
        }

        public AnimatedIcon create(int u, int v) {
            return new AnimatedIcon(this.location, u, v, this.w, this.h, this.lX, this.lY, this.tw, this.th, this.twoLevel, 0, this.rows, this.cols, this.delay);
        }

        public AnimatedIcon create(int u, int v, int w, int h) {
            return new AnimatedIcon(this.location, u, v, w, h, this.lX, this.lY, this.tw, this.th, this.twoLevel, 0, this.rows, this.cols, this.delay);
        }
    }
}

