/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.api.ui.hotkey;

import endorh.simpleconfig.api.ui.hotkey.ExtendedKeyBindProxy;
import endorh.simpleconfig.api.ui.hotkey.ExtendedKeyBindSettings;
import endorh.simpleconfig.api.ui.icon.Icon;
import endorh.simpleconfig.api.ui.icon.KeyBindSettingsIcon;
import endorh.simpleconfig.api.ui.icon.SimpleConfigIcons;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface KeyBindMapping {
    @NotNull
    public static KeyBindMapping unset() {
        return KeyBindMapping.unset(ExtendedKeyBindSettings.ingame().build());
    }

    @NotNull
    public static KeyBindMapping unset(ExtendedKeyBindSettings settings) {
        return ExtendedKeyBindProxy.getFactory().unsetMapping(settings);
    }

    @NotNull
    public IntList getRequiredKeys();

    @Nullable
    public Int2ObjectMap<String> getCharMap();

    @NotNull
    public ExtendedKeyBindSettings getSettings();

    public boolean isUnset();

    public boolean overlaps(KeyBindMapping var1);

    @NotNull
    default public Component getDisplayName() {
        return this.getDisplayName(Style.f_131099_);
    }

    @NotNull
    default public Component getDisplayName(ChatFormatting style) {
        return this.getDisplayName(Style.f_131099_.m_131157_(style));
    }

    @NotNull
    public Component getDisplayName(Style var1);

    @NotNull
    public KeyBindMapping copy();

    @NotNull
    public static KeyBindMapping parse(String serialized) {
        return ExtendedKeyBindProxy.getFactory().parseMapping(serialized);
    }

    @NotNull
    public String serialize();

    public static enum VanillaKeyBindContext implements KeyBindContext
    {
        GAME(SimpleConfigIcons.Hotkeys.CONTEXT_GAME, KeyBindSettingsIcon.CONTEXT_GAME),
        MENU(SimpleConfigIcons.Hotkeys.CONTEXT_MENU, KeyBindSettingsIcon.CONTEXT_MENU),
        ALL(SimpleConfigIcons.Hotkeys.CONTEXT_ALL, KeyBindSettingsIcon.CONTEXT_ALL);

        @NotNull
        private final Icon icon;
        @NotNull
        private final Icon cropIcon;
        private final String serialized;

        private VanillaKeyBindContext(Icon icon, Icon cropIcon) {
            this.icon = icon;
            this.serialized = this.name().toLowerCase();
            this.cropIcon = cropIcon;
        }

        @Override
        public boolean isActive() {
            return this == ALL || Minecraft.m_91087_().f_91080_ == null == (this == GAME);
        }

        @Override
        public boolean conflictsWith(KeyBindContext other) {
            return this == ALL || this == other;
        }

        @Override
        @NotNull
        public Component getDisplayName() {
            return Component.m_237115_((String)("simpleconfig.keybind.context." + this.serialized));
        }

        @Override
        @NotNull
        public Icon getIcon() {
            return this.icon;
        }

        @Override
        @NotNull
        public Icon getCropIcon() {
            return this.cropIcon;
        }

        @Override
        @NotNull
        public String serialize() {
            return this.serialized;
        }
    }

    public static interface KeyBindContext {
        public static final Map<String, KeyBindContext> NAME_MAP = (Map)Util.m_137469_(Collections.synchronizedMap(new LinkedHashMap()), m -> {
            for (VanillaKeyBindContext v : VanillaKeyBindContext.values()) {
                m.put(v.serialize(), v);
            }
        });

        @Nullable
        public static KeyBindContext deserialize(String context) {
            return NAME_MAP.get(context);
        }

        public static void registerContext(String serialized, KeyBindContext context) {
            NAME_MAP.put(serialized, context);
        }

        public static Collection<KeyBindContext> getAllContexts() {
            return NAME_MAP.values();
        }

        public boolean isActive();

        public boolean conflictsWith(KeyBindContext var1);

        public Component getDisplayName();

        @NotNull
        public Icon getIcon();

        @NotNull
        public Icon getCropIcon();

        @NotNull
        public String serialize();
    }

    public static enum KeyBindActivation {
        PRESS(SimpleConfigIcons.Hotkeys.ACTIVATION_PRESS),
        RELEASE(SimpleConfigIcons.Hotkeys.ACTIVATION_RELEASE),
        BOTH(SimpleConfigIcons.Hotkeys.ACTIVATION_BOTH),
        TOGGLE(SimpleConfigIcons.Hotkeys.ACTIVATION_TOGGLE),
        TOGGLE_RELEASE(SimpleConfigIcons.Hotkeys.ACTIVATION_TOGGLE_RELEASE),
        REPEAT(SimpleConfigIcons.Hotkeys.ACTIVATION_REPEAT);

        @NotNull
        private final Icon icon;
        private static final Map<String, KeyBindActivation> NAME_MAP;

        private KeyBindActivation(Icon icon) {
            this.icon = icon;
        }

        @NotNull
        public Icon getIcon() {
            return this.icon;
        }

        @Nullable
        public static KeyBindActivation deserialize(String type) {
            return NAME_MAP.get(type);
        }

        @NotNull
        public String serialize() {
            return this.name().toLowerCase();
        }

        static {
            NAME_MAP = (Map)Util.m_137469_(new HashMap(4), m -> {
                for (KeyBindActivation value : KeyBindActivation.values()) {
                    m.put(value.serialize(), value);
                }
            });
        }
    }
}

