/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.api.ui.hotkey;

import endorh.simpleconfig.api.ui.hotkey.ExtendedKeyBindSettings;
import endorh.simpleconfig.api.ui.hotkey.ExtendedKeyBindSettingsImpl;
import endorh.simpleconfig.api.ui.hotkey.KeyBindMapping;
import org.jetbrains.annotations.NotNull;

public class ExtendedKeyBindSettingsBuilder {
    @NotNull
    private KeyBindMapping.KeyBindActivation activation = KeyBindMapping.KeyBindActivation.PRESS;
    @NotNull
    private KeyBindMapping.KeyBindContext context = KeyBindMapping.VanillaKeyBindContext.GAME;
    private boolean allowExtraKeys = true;
    private boolean orderSensitive = false;
    private boolean exclusive = false;
    private boolean matchByChar = false;
    private boolean preventFurther = true;

    public ExtendedKeyBindSettingsBuilder() {
    }

    public ExtendedKeyBindSettingsBuilder(ExtendedKeyBindSettings settings) {
        this.activation = settings.activation();
        this.context = settings.context();
        this.allowExtraKeys = settings.allowExtraKeys();
        this.orderSensitive = settings.orderSensitive();
        this.exclusive = settings.exclusive();
        this.matchByChar = settings.matchByChar();
        this.preventFurther = settings.preventFurther();
    }

    @NotNull
    public KeyBindMapping.KeyBindActivation getActivation() {
        return this.activation;
    }

    public ExtendedKeyBindSettingsBuilder withActivation(KeyBindMapping.KeyBindActivation activation) {
        this.activation = activation;
        return this;
    }

    @NotNull
    public KeyBindMapping.KeyBindContext getContext() {
        return this.context;
    }

    public ExtendedKeyBindSettingsBuilder withContext(KeyBindMapping.KeyBindContext context) {
        this.context = context;
        return this;
    }

    public boolean isAllowExtraKeys() {
        return this.allowExtraKeys;
    }

    public ExtendedKeyBindSettingsBuilder setAllowExtraKeys(boolean allowExtraKeys) {
        this.allowExtraKeys = allowExtraKeys;
        return this;
    }

    public boolean isOrderSensitive() {
        return this.orderSensitive;
    }

    public ExtendedKeyBindSettingsBuilder setOrderSensitive(boolean orderSensitive) {
        this.orderSensitive = orderSensitive;
        return this;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public ExtendedKeyBindSettingsBuilder setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
        return this;
    }

    public boolean isMatchByChar() {
        return this.matchByChar;
    }

    public ExtendedKeyBindSettingsBuilder setMatchByChar(boolean matchByChar) {
        this.matchByChar = matchByChar;
        return this;
    }

    public boolean isPreventFurther() {
        return this.preventFurther;
    }

    public ExtendedKeyBindSettingsBuilder setPreventFurther(boolean preventFurther) {
        this.preventFurther = preventFurther;
        return this;
    }

    public ExtendedKeyBindSettings build() {
        return new ExtendedKeyBindSettingsImpl(this.activation, this.context, this.allowExtraKeys, this.orderSensitive, this.exclusive, this.matchByChar, this.preventFurther);
    }
}

