/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.api.ui.format;

import endorh.simpleconfig.api.ui.TextFormatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import org.jetbrains.annotations.NotNull;

public class ResourceLocationTextFormatter
implements TextFormatter {
    private Style namespaceStyle = Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xA0A0A0));
    private Style colonStyle = Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x808080));
    private Style pathStyle = Style.f_131099_.m_131148_(TextColor.m_131266_((int)8454048));
    private Style slashStyle = Style.f_131099_.m_131148_(TextColor.m_131266_((int)4358399));
    private Style errorStyle = Style.f_131099_.m_131140_(ChatFormatting.RED).m_131162_(Boolean.valueOf(true));
    private static final Pattern RESOURCE_LOCATION_PATTERN = Pattern.compile("^(?<ls>\\s*+)(?<pre>(?<name>[a-zA-Z\\d_.-]*):)?(?<path>[a-zA-Z\\d_./-]+)(?<rs>\\s*+)$");
    private static final Pattern SLASH = Pattern.compile("/");
    private static final Pattern UPPERCASE = Pattern.compile("[A-Z]");

    @Override
    public MutableComponent formatText(String text) {
        if (text.isEmpty()) {
            return Component.m_237119_();
        }
        Matcher m = RESOURCE_LOCATION_PATTERN.matcher(text);
        if (!m.matches()) {
            return Component.m_237113_((String)text).m_130948_(this.errorStyle);
        }
        MutableComponent res = Component.m_237113_((String)m.group("ls"));
        if (m.group("pre") != null) {
            res.m_7220_((Component)this.highlightUppercase(m.group("name"), this.namespaceStyle));
            res.m_7220_((Component)Component.m_237113_((String)":").m_130948_(this.colonStyle));
        }
        String path = m.group("path");
        Matcher s = SLASH.matcher(path);
        int idx = 0;
        while (s.find()) {
            res.m_7220_((Component)this.highlightUppercase(path.substring(idx, s.start()), this.pathStyle));
            res.m_7220_((Component)Component.m_237113_((String)s.group()).m_130948_(this.slashStyle));
            idx = s.end();
        }
        if (idx < path.length()) {
            res.m_7220_((Component)this.highlightUppercase(path.substring(idx), this.pathStyle));
        }
        res.m_7220_((Component)Component.m_237113_((String)m.group("rs")));
        return res;
    }

    private MutableComponent highlightUppercase(String text, Style style) {
        MutableComponent res = null;
        Matcher m = UPPERCASE.matcher(text);
        int last = 0;
        while (m.find()) {
            res = this.append(res, (Component)Component.m_237113_((String)text.substring(last, m.start())).m_130948_(style));
            res = this.append(res, (Component)Component.m_237113_((String)m.group()).m_130948_(this.errorStyle));
            last = m.end();
        }
        if (last < text.length()) {
            res = this.append(res, (Component)Component.m_237113_((String)text.substring(last)).m_130948_(style));
        }
        return res != null ? res : Component.m_237119_();
    }

    private MutableComponent append(MutableComponent c, Component append) {
        return c == null ? append.m_6881_() : c.m_7220_(append);
    }

    public void setNamespaceStyle(Style namespaceStyle) {
        this.namespaceStyle = namespaceStyle;
    }

    public void setColonStyle(Style colonStyle) {
        this.colonStyle = colonStyle;
    }

    public void setPathStyle(Style pathStyle) {
        this.pathStyle = pathStyle;
    }

    public void setSlashStyle(Style slashStyle) {
        this.slashStyle = slashStyle;
    }

    public void setErrorStyle(Style errorStyle) {
        this.errorStyle = errorStyle;
    }

    @Override
    @NotNull
    public String stripInsertText(@NotNull String text) {
        return TextFormatter.filterCharacters(text.toLowerCase(), c -> c.charValue() >= 'a' && c.charValue() <= 'z' || c.charValue() == '/' || c.charValue() == '_' || c.charValue() == '-' || c.charValue() == ':');
    }
}

