/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.api.ui.format;

import endorh.simpleconfig.api.ui.TextFormatter;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NumberTextFormatter
implements TextFormatter {
    private Style numberStyle = Style.f_131099_.m_131148_(TextColor.m_131266_((int)10534399));
    private Style punctuationStyle = Style.f_131099_.m_131148_(TextColor.m_131266_((int)12427519));
    private Style errorStyle = Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFF8080));
    private boolean integer;

    public NumberTextFormatter(boolean integer) {
        this.integer = integer;
    }

    @Override
    public MutableComponent formatText(String text) {
        MutableComponent res = null;
        char[] chars = text.toCharArray();
        boolean seenSign = false;
        boolean seenDot = this.integer;
        boolean seenExp = this.integer;
        int i = 0;
        for (char c : chars) {
            if (Character.isWhitespace(c)) {
                res = this.append(res, (Component)Component.m_237113_((String)String.valueOf(c)));
            } else if (!(c != '-' && c != '+' || seenSign)) {
                res = this.append(res, (Component)Component.m_237113_((String)String.valueOf(c)).m_130948_(this.punctuationStyle));
                seenSign = true;
            } else if (Character.isDigit(c)) {
                res = this.append(res, (Component)Component.m_237113_((String)String.valueOf(c))).m_130948_(this.numberStyle);
                seenSign = true;
            } else if (c == '.' && !seenDot) {
                res = this.append(res, (Component)Component.m_237113_((String)".").m_130948_(this.punctuationStyle));
                seenDot = true;
            } else if (!seenExp && c == 'e' || c == 'E') {
                res = this.append(res, (Component)Component.m_237113_((String)String.valueOf(c)).m_130948_(this.punctuationStyle));
                seenExp = true;
                seenSign = false;
                seenDot = true;
            } else {
                res = this.append(res, (Component)Component.m_237113_((String)text.substring(i)).m_130948_(this.errorStyle));
                break;
            }
            ++i;
        }
        return res != null ? res : Component.m_237119_();
    }

    public boolean isInteger() {
        return this.integer;
    }

    public void setInteger(boolean integer) {
        this.integer = integer;
    }

    public Style getNumberStyle() {
        return this.numberStyle;
    }

    public void setNumberStyle(Style numberStyle) {
        this.numberStyle = numberStyle;
    }

    public Style getPunctuationStyle() {
        return this.punctuationStyle;
    }

    public void setPunctuationStyle(Style punctuationStyle) {
        this.punctuationStyle = punctuationStyle;
    }

    public Style getErrorStyle() {
        return this.errorStyle;
    }

    public void setErrorStyle(Style errorStyle) {
        this.errorStyle = errorStyle;
    }

    private MutableComponent append(@Nullable MutableComponent tc, Component fragment) {
        if (tc == null) {
            return fragment.m_6881_();
        }
        return tc.m_7220_(fragment);
    }

    @Override
    @NotNull
    public String stripInsertText(@NotNull String text) {
        return TextFormatter.filterCharacters(text, c -> Character.isDigit(c.charValue()) || c.charValue() == '-' || c.charValue() == '+' || c.charValue() == '_' || !this.integer && (c.charValue() == '.' || c.charValue() == 'e' || c.charValue() == 'E'));
    }
}

