/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.api.ui.format;

import endorh.simpleconfig.api.ui.TextFormatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import org.jetbrains.annotations.NotNull;

public class ColorTextFormatter
implements TextFormatter {
    private static final Pattern COLOR_PATTERN = Pattern.compile("^#(?<a>[\\da-fA-F]{2})?(?<r>[\\da-fA-F]{2})(?<g>[\\da-fA-F]{2})(?<b>[\\da-fA-F]{2})$");

    @Override
    public MutableComponent formatText(String text) {
        Matcher m = COLOR_PATTERN.matcher(text.toUpperCase());
        TextColor color = TextColor.m_131268_((String)(text.length() == 9 ? "#" + text.substring(3) : text));
        if (color == null || !m.matches()) {
            return Component.m_237113_((String)text).m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.UNDERLINE);
        }
        String a = m.group("a");
        String r = m.group("r");
        String g = m.group("g");
        String b = m.group("b");
        MutableComponent res = Component.m_237113_((String)"#").m_130948_(Style.f_131099_.m_131148_(color));
        if (a != null) {
            res.m_7220_((Component)Component.m_237113_((String)a).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xA0A0A0))));
        }
        res.m_7220_((Component)Component.m_237113_((String)r).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFFBDBD))));
        res.m_7220_((Component)Component.m_237113_((String)g).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xBDFFBD))));
        res.m_7220_((Component)Component.m_237113_((String)b).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xBDBDFF))));
        return res;
    }

    @Override
    @NotNull
    public String stripInsertText(@NotNull String text) {
        return TextFormatter.filterCharacters(text.toUpperCase(), c -> c.charValue() == '#' || Character.isDigit(c.charValue()) || c.charValue() >= 'A' && c.charValue() <= 'F');
    }
}

