/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.api.ui.format;

import endorh.simpleconfig.api.ui.TextFormatter;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public class CharacterBasedTextFormatter
implements TextFormatter {
    private final CharacterFormatter characterFormatter;

    public CharacterBasedTextFormatter(CharacterFormatter formatter) {
        this.characterFormatter = formatter;
    }

    protected Style getCharacterStyle(String text, int pos, char chr, Style last) {
        return this.characterFormatter.getCharacterStyle(text, pos, chr, last);
    }

    @Override
    public MutableComponent formatText(String text) {
        MutableComponent res = null;
        Style last = Style.f_131099_;
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (char c : text.toCharArray()) {
            Style style = this.getCharacterStyle(text, i, c, last);
            if (style != last) {
                MutableComponent added = Component.m_237113_((String)builder.toString()).m_130948_(last);
                last = style;
                builder = new StringBuilder().append(c);
                if (res == null) {
                    res = added;
                } else {
                    res.m_7220_((Component)added);
                }
            } else {
                builder.append(c);
            }
            ++i;
        }
        if (builder.length() > 0) {
            MutableComponent added = Component.m_237113_((String)builder.toString()).m_130948_(last);
            if (res == null) {
                res = added;
            } else {
                res.m_7220_((Component)added);
            }
        }
        return res;
    }

    @FunctionalInterface
    public static interface CharacterFormatter {
        public static final CharacterFormatter DEFAULT = CharacterFormatter.plain(Style.f_131099_);

        public static CharacterFormatter plain(Style style) {
            return (text, pos, chr, last) -> style;
        }

        public Style getCharacterStyle(String var1, int var2, char var3, Style var4);
    }

    public static class CharacterMapTextFormatter
    extends CharacterBasedTextFormatter {
        private final Map<Character, Style> charMap;

        public CharacterMapTextFormatter(Map<Character, Style> charMap) {
            super((String text, int pos, char chr, Style last) -> charMap.getOrDefault(Character.valueOf(chr), last));
            this.charMap = charMap;
        }

        @Override
        protected Style getCharacterStyle(String text, int pos, char chr, Style last) {
            return this.charMap.getOrDefault(Character.valueOf(chr), Style.f_131099_);
        }
    }
}

