/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.api.ui.format;

import endorh.simpleconfig.api.ui.TextFormatter;
import java.util.Objects;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachedTextFormatter
implements TextFormatter {
    private final TextFormatter delegate;
    private String lastText;
    private MutableComponent lastFormattedText;

    public CachedTextFormatter(TextFormatter delegate) {
        this.delegate = delegate;
    }

    @Override
    public MutableComponent formatText(String text) {
        if (Objects.equals(this.lastText, text)) {
            return this.lastFormattedText;
        }
        this.lastText = text;
        this.lastFormattedText = this.delegate.formatText(text);
        return this.lastFormattedText;
    }

    @Override
    @NotNull
    public String stripInsertText(@NotNull String text) {
        return this.delegate.stripInsertText(text);
    }

    @Override
    @Nullable
    public String closingPair(char typedChar, String context, int caretPos) {
        return this.delegate.closingPair(typedChar, context, caretPos);
    }

    @Override
    public boolean shouldSkipClosingPair(char typedChar, String context, int caretPos) {
        return this.delegate.shouldSkipClosingPair(typedChar, context, caretPos);
    }

    public TextFormatter getDelegate() {
        return this.delegate;
    }
}

