/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.api.ui;

import endorh.simpleconfig.api.ui.HighlighterManager;
import endorh.simpleconfig.api.ui.LanguageHighlighter;
import endorh.simpleconfig.api.ui.format.CachedTextFormatter;
import endorh.simpleconfig.api.ui.format.CharacterBasedTextFormatter;
import endorh.simpleconfig.api.ui.format.ColorTextFormatter;
import endorh.simpleconfig.api.ui.format.NumberTextFormatter;
import endorh.simpleconfig.api.ui.format.ResourceLocationTextFormatter;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TextFormatter {
    public static final TextFormatter DEFAULT = TextFormatter.plain(Style.f_131099_);

    @NotNull
    public static CachedTextFormatter cached(TextFormatter formatter) {
        return new CachedTextFormatter(formatter);
    }

    @NotNull
    public static CharacterBasedTextFormatter.CharacterMapTextFormatter characterBased(Map<Character, Style> map) {
        return new CharacterBasedTextFormatter.CharacterMapTextFormatter(map);
    }

    @NotNull
    public static CharacterBasedTextFormatter characterBased(CharacterBasedTextFormatter.CharacterFormatter formatter) {
        return new CharacterBasedTextFormatter(formatter);
    }

    @NotNull
    public static LanguageHighlighter forLanguage(String language) {
        LanguageHighlighter highlighter = HighlighterManager.getInstance().getHighlighter(language);
        if (highlighter == null) {
            throw new IllegalArgumentException("Missing highlighter for language: \"" + language + "\"");
        }
        return highlighter;
    }

    @NotNull
    public static TextFormatter forLanguageOrDefault(String language, TextFormatter def) {
        LanguageHighlighter highlighter = HighlighterManager.getInstance().getHighlighter(language);
        if (highlighter == null) {
            return def;
        }
        return highlighter;
    }

    @NotNull
    public static TextFormatter plain(Style style) {
        return text -> Component.m_237113_((String)text).m_6270_(style);
    }

    @NotNull
    public static NumberTextFormatter numeric(boolean integer) {
        return new NumberTextFormatter(integer);
    }

    @NotNull
    public static ColorTextFormatter forColor() {
        return new ColorTextFormatter();
    }

    @NotNull
    public static ResourceLocationTextFormatter forResourceLocation() {
        return new ResourceLocationTextFormatter();
    }

    @NotNull
    public static String filterCharacters(String text, Predicate<Character> filter) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!filter.test(Character.valueOf(c))) continue;
            builder.append(c);
        }
        return builder.toString();
    }

    public MutableComponent formatText(String var1);

    @NotNull
    default public String stripInsertText(@NotNull String text) {
        return text;
    }

    @Nullable
    default public String closingPair(char typedChar, String context, int caretPos) {
        return null;
    }

    default public boolean shouldSkipClosingPair(char typedChar, String context, int caretPos) {
        return false;
    }
}

