/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.api.range;

import endorh.simpleconfig.api.range.AbstractRange;
import endorh.simpleconfig.api.range.NumberRange;
import java.util.Random;
import org.jetbrains.annotations.NotNull;

public interface LongRange
extends NumberRange<Long, LongRange> {
    public static final LongRange EMPTY = new AbstractRange.LongRangeImpl(0L, 0L, true, true);
    public static final LongRange FULL = new AbstractRange.LongRangeImpl(Long.MIN_VALUE, Long.MAX_VALUE, false, false);
    public static final LongRange UNIT = new AbstractRange.LongRangeImpl(0L, 1L, false, false);

    @NotNull
    public static LongRange inclusive(long min, long max) {
        return new AbstractRange.LongRangeImpl(min, max, false, false);
    }

    @NotNull
    public static LongRange exclusive(long min, long max) {
        return new AbstractRange.LongRangeImpl(min, max, true, true);
    }

    @NotNull
    public static LongRange exactly(long value) {
        return new AbstractRange.LongRangeImpl(value, value, false, false);
    }

    @NotNull
    public static LongRange range(long upToExclusive) {
        return new AbstractRange.LongRangeImpl(0L, upToExclusive, false, true);
    }

    @NotNull
    public static LongRange rangeFrom1(long upToInclusive) {
        return new AbstractRange.LongRangeImpl(0L, upToInclusive, true, false);
    }

    @Override
    public Long randomUniform(Random var1);

    @Override
    public Long randomGaussian(Random var1);

    @Override
    @NotNull
    default public LongRange translate(long translation) {
        return this.translate((Long)translation);
    }

    @Override
    @NotNull
    public LongRange translate(@NotNull Long var1);

    @Override
    @NotNull
    default public LongRange growRelative(long left, long right) {
        return this.growRelative((Long)left, (Long)right);
    }

    @Override
    @NotNull
    default public LongRange growRelative(long both) {
        return (LongRange)this.growRelative(Long.valueOf(both));
    }

    @Override
    @NotNull
    public LongRange growRelative(@NotNull Long var1, @NotNull Long var2);

    @Override
    @NotNull
    default public LongRange grow(long left, long right) {
        return this.grow((Long)left, (Long)right);
    }

    @Override
    @NotNull
    default public LongRange grow(long both) {
        return (LongRange)this.grow(Long.valueOf(both));
    }

    @Override
    @NotNull
    public LongRange grow(@NotNull Long var1, @NotNull Long var2);

    @Override
    @NotNull
    default public LongRange shrinkRelative(long left, long right) {
        return this.shrinkRelative((Long)left, (Long)right);
    }

    @Override
    @NotNull
    default public LongRange shrinkRelative(long both) {
        return (LongRange)this.shrinkRelative(Long.valueOf(both));
    }

    @Override
    @NotNull
    public LongRange shrinkRelative(@NotNull Long var1, @NotNull Long var2);

    @Override
    @NotNull
    default public LongRange shrink(long left, long right) {
        return this.shrink((Long)left, (Long)right);
    }

    @Override
    @NotNull
    default public LongRange shrink(long both) {
        return (LongRange)this.shrink(Long.valueOf(both));
    }

    @Override
    @NotNull
    public LongRange shrink(@NotNull Long var1, @NotNull Long var2);

    @Override
    @NotNull
    public LongRange create(@NotNull Long var1, @NotNull Long var2, boolean var3, boolean var4);

    default public long getLongSize() {
        return (long)this.getSize();
    }

    default public long getLongCenter() {
        return (long)this.getCenter();
    }

    default public long getLongMin() {
        return (Long)this.getMin();
    }

    default public long getLongMax() {
        return (Long)this.getMax();
    }
}

