/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.api.range;

import endorh.simpleconfig.api.range.AbstractRange;
import endorh.simpleconfig.api.range.NumberRange;
import java.util.Random;
import org.jetbrains.annotations.NotNull;

public interface IntRange
extends NumberRange<Integer, IntRange> {
    public static final IntRange EMPTY = new AbstractRange.IntRangeImpl(0, 0, true, true);
    public static final IntRange FULL = new AbstractRange.IntRangeImpl(Integer.MIN_VALUE, Integer.MAX_VALUE, false, false);
    public static final IntRange UNIT = new AbstractRange.IntRangeImpl(0, 1, false, false);

    @NotNull
    public static IntRange inclusive(int min, int max) {
        return new AbstractRange.IntRangeImpl(min, max, false, false);
    }

    @NotNull
    public static IntRange exclusive(int min, int max) {
        return new AbstractRange.IntRangeImpl(min, max, true, true);
    }

    @NotNull
    public static IntRange exactly(int value) {
        return new AbstractRange.IntRangeImpl(value, value, false, false);
    }

    @NotNull
    public static IntRange range(int upToExclusive) {
        return new AbstractRange.IntRangeImpl(0, upToExclusive, false, true);
    }

    @NotNull
    public static IntRange rangeFrom1(int upToInclusive) {
        return new AbstractRange.IntRangeImpl(0, upToInclusive, true, false);
    }

    @Override
    public Integer randomUniform(Random var1);

    @Override
    public Integer randomGaussian(Random var1);

    @Override
    @NotNull
    default public IntRange translate(int translation) {
        return this.translate((Integer)translation);
    }

    @Override
    @NotNull
    public IntRange translate(@NotNull Integer var1);

    @Override
    @NotNull
    default public IntRange growRelative(int left, int right) {
        return this.growRelative((Integer)left, (Integer)right);
    }

    @Override
    @NotNull
    default public IntRange growRelative(int both) {
        return (IntRange)this.growRelative(Integer.valueOf(both));
    }

    @Override
    @NotNull
    public IntRange growRelative(@NotNull Integer var1, @NotNull Integer var2);

    @Override
    @NotNull
    default public IntRange grow(int left, int right) {
        return this.grow((Integer)left, (Integer)right);
    }

    @Override
    @NotNull
    default public IntRange grow(int both) {
        return (IntRange)this.grow(Integer.valueOf(both));
    }

    @Override
    @NotNull
    public IntRange grow(@NotNull Integer var1, @NotNull Integer var2);

    @Override
    @NotNull
    default public IntRange shrinkRelative(int left, int right) {
        return this.shrinkRelative((Integer)left, (Integer)right);
    }

    @Override
    @NotNull
    default public IntRange shrinkRelative(int both) {
        return (IntRange)this.shrinkRelative(Integer.valueOf(both));
    }

    @Override
    @NotNull
    public IntRange shrinkRelative(@NotNull Integer var1, @NotNull Integer var2);

    @Override
    @NotNull
    default public IntRange shrink(int left, int right) {
        return this.shrink((Integer)left, (Integer)right);
    }

    @Override
    @NotNull
    default public IntRange shrink(int both) {
        return (IntRange)this.shrink(Integer.valueOf(both));
    }

    @Override
    @NotNull
    public IntRange shrink(@NotNull Integer var1, @NotNull Integer var2);

    @Override
    @NotNull
    public IntRange create(@NotNull Integer var1, @NotNull Integer var2, boolean var3, boolean var4);

    default public int getIntSize() {
        return (int)this.getSize();
    }

    default public int getIntCenter() {
        return (int)this.getCenter();
    }

    default public int getIntMin() {
        return (Integer)this.getMin();
    }

    default public int getIntMax() {
        return (Integer)this.getMax();
    }
}

