/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.api.range;

import endorh.simpleconfig.api.range.AbstractRange;
import endorh.simpleconfig.api.range.NumberRange;
import java.util.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface FloatRange
extends NumberRange<Float, FloatRange> {
    public static final FloatRange EMPTY = new AbstractRange.FloatRangeImpl(Float.valueOf(0.0f), Float.valueOf(0.0f), true, true);
    public static final FloatRange FULL = new AbstractRange.FloatRangeImpl(Float.valueOf(Float.NEGATIVE_INFINITY), Float.valueOf(Float.POSITIVE_INFINITY), false, false);
    public static final FloatRange UNIT = new AbstractRange.FloatRangeImpl(Float.valueOf(0.0f), Float.valueOf(1.0f), false, false);
    public static final FloatRange HALF_OPEN_UNIT = new AbstractRange.FloatRangeImpl(Float.valueOf(0.0f), Float.valueOf(1.0f), false, true);
    public static final FloatRange OPEN_UNIT = new AbstractRange.FloatRangeImpl(Float.valueOf(0.0f), Float.valueOf(1.0f), true, true);
    public static final FloatRange UNITARY = new AbstractRange.FloatRangeImpl(Float.valueOf(-1.0f), Float.valueOf(1.0f), false, false);

    @NotNull
    public static FloatRange inclusive(float min, float max) {
        return new AbstractRange.FloatRangeImpl(Float.valueOf(min), Float.valueOf(max), false, false);
    }

    @NotNull
    public static FloatRange exclusive(float min, float max) {
        return new AbstractRange.FloatRangeImpl(Float.valueOf(min), Float.valueOf(max), true, true);
    }

    @NotNull
    public static FloatRange of(float min, boolean exclusiveMin, float max, boolean exclusiveMax) {
        return new AbstractRange.FloatRangeImpl(Float.valueOf(min), Float.valueOf(max), exclusiveMin, exclusiveMax);
    }

    @NotNull
    public static FloatRange minimum(float min) {
        return FloatRange.minimum(min, false);
    }

    @NotNull
    public static FloatRange minimum(float min, boolean exclusive) {
        return new AbstractRange.FloatRangeImpl(Float.valueOf(min), Float.valueOf(Float.POSITIVE_INFINITY), exclusive, false);
    }

    @NotNull
    public static FloatRange maximum(float max) {
        return FloatRange.maximum(max, false);
    }

    @NotNull
    public static FloatRange maximum(float max, boolean exclusive) {
        return new AbstractRange.FloatRangeImpl(Float.valueOf(Float.NEGATIVE_INFINITY), Float.valueOf(max), false, exclusive);
    }

    @NotNull
    public static FloatRange exactly(float value) {
        return new AbstractRange.FloatRangeImpl(Float.valueOf(value), Float.valueOf(value), false, false);
    }

    default public float getFloatMin() {
        return ((Float)this.getMin()).floatValue();
    }

    default public float getFloatMax() {
        return ((Float)this.getMax()).floatValue();
    }

    @Override
    @Nullable
    public Float randomUniform(Random var1);

    @Override
    @Nullable
    public Float randomGaussian(Random var1);

    @Override
    @NotNull
    public FloatRange create(@NotNull Float var1, @NotNull Float var2, boolean var3, boolean var4);

    default public float getFloatSize() {
        return (float)this.getSize();
    }

    @Override
    @NotNull
    default public FloatRange translate(float translation) {
        return this.translate(Float.valueOf(translation));
    }

    @Override
    @NotNull
    public FloatRange translate(@NotNull Float var1);

    @Override
    @NotNull
    default public FloatRange growRelative(float left, float right) {
        return this.growRelative(Float.valueOf(left), Float.valueOf(right));
    }

    @Override
    @NotNull
    default public FloatRange growRelative(float both) {
        return (FloatRange)this.growRelative(Float.valueOf(both));
    }

    @Override
    @NotNull
    public FloatRange growRelative(@NotNull Float var1, @NotNull Float var2);

    @Override
    @NotNull
    default public FloatRange grow(float left, float right) {
        return this.grow(Float.valueOf(left), Float.valueOf(right));
    }

    @Override
    @NotNull
    default public FloatRange grow(float both) {
        return (FloatRange)this.grow(Float.valueOf(both));
    }

    @Override
    @NotNull
    public FloatRange grow(@NotNull Float var1, @NotNull Float var2);

    @Override
    @NotNull
    default public FloatRange shrinkRelative(float left, float right) {
        return this.shrinkRelative(Float.valueOf(left), Float.valueOf(right));
    }

    @Override
    @NotNull
    default public FloatRange shrinkRelative(float both) {
        return (FloatRange)this.shrinkRelative(Float.valueOf(both));
    }

    @Override
    @NotNull
    public FloatRange shrinkRelative(@NotNull Float var1, @NotNull Float var2);

    @Override
    @NotNull
    default public FloatRange shrink(float left, float right) {
        return this.shrink(Float.valueOf(left), Float.valueOf(right));
    }

    @Override
    @NotNull
    default public FloatRange shrink(float both) {
        return (FloatRange)this.shrink(Float.valueOf(both));
    }

    @Override
    @NotNull
    public FloatRange shrink(@NotNull Float var1, @NotNull Float var2);

    default public float getFloatCenter() {
        float min = Math.max(((Float)this.getMin()).floatValue(), -3.4028235E38f);
        float max = Math.min(((Float)this.getMax()).floatValue(), Float.MAX_VALUE);
        return (min + max) / 2.0f;
    }

    @Override
    public double getCenter();
}

