/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.api.range;

import endorh.simpleconfig.api.range.AbstractRange;
import endorh.simpleconfig.api.range.NumberRange;
import java.util.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DoubleRange
extends NumberRange<Double, DoubleRange> {
    public static final DoubleRange EMPTY = new AbstractRange.DoubleRangeImpl(0.0, 0.0, true, true);
    public static final DoubleRange FULL = new AbstractRange.DoubleRangeImpl(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, false, false);
    public static final DoubleRange UNIT = new AbstractRange.DoubleRangeImpl(0.0, 1.0, false, false);
    public static final DoubleRange HALF_OPEN_UNIT = new AbstractRange.DoubleRangeImpl(0.0, 1.0, false, true);
    public static final DoubleRange OPEN_UNIT = new AbstractRange.DoubleRangeImpl(0.0, 1.0, true, true);
    public static final DoubleRange UNITARY = new AbstractRange.DoubleRangeImpl(-1.0, 1.0, false, false);

    @NotNull
    public static DoubleRange inclusive(double min, double max) {
        return new AbstractRange.DoubleRangeImpl(min, max, false, false);
    }

    @NotNull
    public static DoubleRange exclusive(double min, double max) {
        return new AbstractRange.DoubleRangeImpl(min, max, true, true);
    }

    @NotNull
    public static DoubleRange of(double min, boolean exclusiveMin, double max, boolean exclusiveMax) {
        return new AbstractRange.DoubleRangeImpl(min, max, exclusiveMin, exclusiveMax);
    }

    @NotNull
    public static DoubleRange minimum(double min) {
        return DoubleRange.minimum(min, false);
    }

    @NotNull
    public static DoubleRange minimum(double min, boolean exclusive) {
        return new AbstractRange.DoubleRangeImpl(min, Double.POSITIVE_INFINITY, exclusive, false);
    }

    @NotNull
    public static DoubleRange maximum(double max) {
        return DoubleRange.maximum(max, false);
    }

    @NotNull
    public static DoubleRange maximum(double max, boolean exclusive) {
        return new AbstractRange.DoubleRangeImpl(Double.NEGATIVE_INFINITY, max, false, exclusive);
    }

    @NotNull
    public static DoubleRange exactly(double value) {
        return new AbstractRange.DoubleRangeImpl(value, value, false, false);
    }

    default public double getDoubleMin() {
        return (Double)this.getMin();
    }

    default public double getDoubleMax() {
        return (Double)this.getMax();
    }

    @Override
    @Nullable
    public Double randomUniform(Random var1);

    @Override
    @Nullable
    public Double randomGaussian(Random var1);

    @Override
    @NotNull
    public DoubleRange create(@NotNull Double var1, @NotNull Double var2, boolean var3, boolean var4);

    @Override
    @NotNull
    default public DoubleRange translate(double translation) {
        return this.translate((Double)translation);
    }

    @Override
    @NotNull
    public DoubleRange translate(@NotNull Double var1);

    @Override
    @NotNull
    default public DoubleRange growRelative(double left, double right) {
        return this.growRelative((Double)left, (Double)right);
    }

    @Override
    @NotNull
    default public DoubleRange growRelative(double both) {
        return (DoubleRange)this.growRelative(Double.valueOf(both));
    }

    @Override
    @NotNull
    public DoubleRange growRelative(@NotNull Double var1, @NotNull Double var2);

    @Override
    @NotNull
    default public DoubleRange grow(double left, double right) {
        return this.grow((Double)left, (Double)right);
    }

    @Override
    @NotNull
    default public DoubleRange grow(double both) {
        return (DoubleRange)this.grow(Double.valueOf(both));
    }

    @Override
    @NotNull
    public DoubleRange grow(@NotNull Double var1, @NotNull Double var2);

    @Override
    @NotNull
    default public DoubleRange shrinkRelative(double left, double right) {
        return this.shrinkRelative((Double)left, (Double)right);
    }

    @Override
    @NotNull
    default public DoubleRange shrinkRelative(double both) {
        return (DoubleRange)this.shrinkRelative(Double.valueOf(both));
    }

    @Override
    @NotNull
    public DoubleRange shrinkRelative(@NotNull Double var1, @NotNull Double var2);

    @Override
    @NotNull
    default public DoubleRange shrink(double left, double right) {
        return this.shrink((Double)left, (Double)right);
    }

    @Override
    @NotNull
    default public DoubleRange shrink(double both) {
        return (DoubleRange)this.shrink(Double.valueOf(both));
    }

    @Override
    @NotNull
    public DoubleRange shrink(@NotNull Double var1, @NotNull Double var2);

    @Override
    public double getCenter();
}

