/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.api.range;

import endorh.simpleconfig.api.range.DoubleRange;
import endorh.simpleconfig.api.range.FloatRange;
import endorh.simpleconfig.api.range.IntRange;
import endorh.simpleconfig.api.range.LongRange;
import endorh.simpleconfig.api.range.NumberRange;
import endorh.simpleconfig.api.range.Range;
import endorh.simpleconfig.api.range.SizedRange;
import java.util.Objects;
import java.util.Random;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class AbstractRange<V extends Comparable<V>, Self extends Range<V, Self>>
implements Range<V, Self> {
    private final boolean exclusiveMin;
    private final boolean exclusiveMax;
    @NotNull
    private final V min;
    @NotNull
    private final V max;

    protected AbstractRange(@NotNull V min, @NotNull V max, boolean exclusiveMin, boolean exclusiveMax) {
        this.min = min;
        this.max = max;
        this.exclusiveMin = exclusiveMin;
        this.exclusiveMax = exclusiveMax;
    }

    @Override
    public boolean contains(@NotNull V value) {
        int l = this.getMin().compareTo(value);
        int r = this.getMax().compareTo(value);
        return (this.isExclusiveMin() ? l < 0 : l <= 0) && (this.isExclusiveMax() ? r > 0 : r >= 0);
    }

    @Override
    @NotNull
    public Self intersect(@NotNull Self range) {
        V mn = this.getMin();
        Object rmn = range.getMin();
        V mx = this.getMax();
        Object rmx = range.getMax();
        int l = mn.compareTo(range.getMin());
        int r = mx.compareTo(range.getMax());
        return this.create(l > 0 ? mn : rmn, r < 0 ? mx : rmx, l <= 0 && range.isExclusiveMin() || l >= 0 && this.isExclusiveMin(), r >= 0 && range.isExclusiveMax() || r <= 0 && this.isExclusiveMax());
    }

    @Override
    public boolean isExclusiveMin() {
        return this.exclusiveMin;
    }

    @Override
    public boolean isExclusiveMax() {
        return this.exclusiveMax;
    }

    @Override
    @NotNull
    public V getMin() {
        return this.min;
    }

    @Override
    @NotNull
    public V getMax() {
        return this.max;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractRange that = (AbstractRange)o;
        return this.exclusiveMin == that.exclusiveMin && this.exclusiveMax == that.exclusiveMax && this.min.equals(that.min) && this.max.equals(that.max);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.exclusiveMin, this.exclusiveMax, this.min, this.max);
    }

    @ApiStatus.Internal
    public static class IntRangeImpl
    extends AbstractNumberRange<Integer, IntRange>
    implements IntRange {
        protected IntRangeImpl(int min, int max, boolean exclusiveMin, boolean exclusiveMax) {
            this((Integer)min, (Integer)max, exclusiveMin, exclusiveMax);
        }

        protected IntRangeImpl(Integer min, Integer max, boolean exclusiveMin, boolean exclusiveMax) {
            super(min != null ? min : Integer.MIN_VALUE, max != null ? max : Integer.MAX_VALUE, exclusiveMin, exclusiveMax);
        }

        @Override
        public Integer randomUniform(Random random) {
            int max;
            int min = this.isExclusiveMin() ? (Integer)this.getMin() + 1 : (Integer)this.getMin();
            int n = max = this.isExclusiveMax() ? (Integer)this.getMax() - 1 : (Integer)this.getMax();
            if (max < min) {
                return null;
            }
            return Math.min((int)Math.floor((float)min + random.nextFloat() * (float)(max - min + 1)), max);
        }

        @Override
        public Integer randomGaussian(Random random) {
            int max;
            int min = this.isExclusiveMin() ? (Integer)this.getMin() + 1 : (Integer)this.getMin();
            int n = max = this.isExclusiveMax() ? (Integer)this.getMax() - 1 : (Integer)this.getMax();
            if (max < min) {
                return null;
            }
            return Math.round((float)(min + max) * 0.5f + (float)random.nextGaussian() * (float)(max - min));
        }

        @Override
        @NotNull
        public IntRange translate(@NotNull Integer translation) {
            return this.create((Integer)this.getMin() + translation, (Integer)this.getMax() + translation, this.isExclusiveMin(), this.isExclusiveMax());
        }

        @Override
        @NotNull
        public IntRange growRelative(@NotNull Integer left, @NotNull Integer right) {
            double size = this.getSize();
            return this.create((int)Math.floor((double)((Integer)this.getMin()).intValue() - (double)left.intValue() * size), (int)Math.ceil((double)((Integer)this.getMax()).intValue() + (double)right.intValue() * size), this.isExclusiveMin(), this.isExclusiveMax());
        }

        @Override
        @NotNull
        public IntRange grow(@NotNull Integer left, @NotNull Integer right) {
            return this.create((Integer)this.getMin() - left, (Integer)this.getMax() + right, this.isExclusiveMin(), this.isExclusiveMax());
        }

        @Override
        @NotNull
        public IntRange shrinkRelative(@NotNull Integer left, @NotNull Integer right) {
            double size = this.getSize();
            return this.create((int)Math.ceil((double)((Integer)this.getMin()).intValue() + (double)left.intValue() * size), (int)Math.floor((double)((Integer)this.getMax()).intValue() - (double)right.intValue() * size), this.isExclusiveMin(), this.isExclusiveMax());
        }

        @Override
        @NotNull
        public IntRange shrink(@NotNull Integer left, @NotNull Integer right) {
            return this.create((Integer)this.getMin() + left, (Integer)this.getMax() - right, this.isExclusiveMin(), this.isExclusiveMax());
        }

        @Override
        @NotNull
        public IntRange create(@NotNull Integer min, @NotNull Integer max, boolean exclusiveMin, boolean exclusiveMax) {
            return new IntRangeImpl(min, max, exclusiveMin, exclusiveMax);
        }

        @Override
        protected double getDistance(Integer left, Integer right) {
            if (left == null || right == null) {
                return Double.NaN;
            }
            return right - left;
        }
    }

    @ApiStatus.Internal
    public static class LongRangeImpl
    extends AbstractNumberRange<Long, LongRange>
    implements LongRange {
        protected LongRangeImpl(long min, long max, boolean exclusiveMin, boolean exclusiveMax) {
            this((Long)min, (Long)max, exclusiveMin, exclusiveMax);
        }

        protected LongRangeImpl(Long min, Long max, boolean exclusiveMin, boolean exclusiveMax) {
            super(min != null ? min : Long.MIN_VALUE, max != null ? max : Long.MAX_VALUE, exclusiveMin, exclusiveMax);
        }

        @Override
        public Long randomUniform(Random random) {
            long max;
            long min = this.isExclusiveMin() ? (Long)this.getMin() + 1L : (Long)this.getMin();
            long l = max = this.isExclusiveMax() ? (Long)this.getMax() - 1L : (Long)this.getMax();
            if (max < min) {
                return null;
            }
            return Math.min((long)Math.floor((double)min + random.nextDouble() * (double)(max - min + 1L)), max);
        }

        @Override
        public Long randomGaussian(Random random) {
            long max;
            long min = this.isExclusiveMin() ? (Long)this.getMin() + 1L : (Long)this.getMin();
            long l = max = this.isExclusiveMax() ? (Long)this.getMax() - 1L : (Long)this.getMax();
            if (max < min) {
                return null;
            }
            return Math.round((double)(min + max) * 0.5 + random.nextGaussian() * (double)(max - min));
        }

        @Override
        @NotNull
        public LongRange translate(@NotNull Long translation) {
            return this.create((Long)this.getMin() + translation, (Long)this.getMax() + translation, this.isExclusiveMin(), this.isExclusiveMax());
        }

        @Override
        @NotNull
        public LongRange growRelative(@NotNull Long left, @NotNull Long right) {
            double size = this.getSize();
            return this.create((long)Math.floor((double)((Long)this.getMin()).longValue() - (double)left.longValue() * size), (long)Math.ceil((double)((Long)this.getMax()).longValue() + (double)right.longValue() * size), this.isExclusiveMin(), this.isExclusiveMax());
        }

        @Override
        @NotNull
        public LongRange grow(@NotNull Long left, @NotNull Long right) {
            return this.create((Long)this.getMin() - left, (Long)this.getMax() + right, this.isExclusiveMin(), this.isExclusiveMax());
        }

        @Override
        @NotNull
        public LongRange shrinkRelative(@NotNull Long left, @NotNull Long right) {
            double size = this.getSize();
            return this.create((long)Math.ceil((double)((Long)this.getMin()).longValue() + (double)left.longValue() * size), (long)Math.floor((double)((Long)this.getMax()).longValue() - (double)right.longValue() * size), this.isExclusiveMin(), this.isExclusiveMax());
        }

        @Override
        @NotNull
        public LongRange shrink(@NotNull Long left, @NotNull Long right) {
            return this.create((Long)this.getMin() + left, (Long)this.getMax() - right, this.isExclusiveMin(), this.isExclusiveMax());
        }

        @Override
        @NotNull
        public LongRange create(@NotNull Long min, @NotNull Long max, boolean exclusiveMin, boolean exclusiveMax) {
            return new LongRangeImpl(min, max, exclusiveMin, exclusiveMax);
        }

        @Override
        protected double getDistance(Long left, Long right) {
            if (left == null || right == null) {
                return Double.NaN;
            }
            return right - left;
        }
    }

    @ApiStatus.Internal
    public static class FloatRangeImpl
    extends AbstractNumberRange<Float, FloatRange>
    implements FloatRange {
        protected FloatRangeImpl(Float min, Float max, boolean exclusiveMin, boolean exclusiveMax) {
            super(Float.valueOf(min != null && !Float.isNaN(min.floatValue()) ? min.floatValue() : Float.NEGATIVE_INFINITY), Float.valueOf(max != null && !Float.isNaN(max.floatValue()) ? max.floatValue() : Float.POSITIVE_INFINITY), exclusiveMin, exclusiveMax);
        }

        @Override
        @Nullable
        public Float randomUniform(Random random) {
            float min = Math.max(((Float)this.getMin()).floatValue(), -3.4028235E38f);
            float max = Math.min(((Float)this.getMax()).floatValue(), Float.MAX_VALUE);
            if (max > min || max == min && this.isExclusiveMin() || this.isExclusiveMax()) {
                return null;
            }
            float v = min + random.nextFloat() * (max - min);
            if (v == min) {
                return Float.valueOf(this.isExclusiveMin() ? (this.isExclusiveMax() ? (max + min) * 0.5f : max) : (this.isExclusiveMax() ? min : (random.nextBoolean() ? min : max)));
            }
            return Float.valueOf(v);
        }

        @Override
        @Nullable
        public Float randomGaussian(Random random) {
            float min = Math.max(((Float)this.getMin()).floatValue(), -3.4028235E38f);
            float max = Math.min(((Float)this.getMax()).floatValue(), Float.MAX_VALUE);
            if (max < min) {
                return null;
            }
            return Float.valueOf((min + max) * 0.5f + (float)random.nextGaussian() * (max - min) * 0.5f);
        }

        @Override
        @NotNull
        public FloatRange create(@NotNull Float min, @NotNull Float max, boolean exclusiveMin, boolean exclusiveMax) {
            return new FloatRangeImpl(min, max, exclusiveMin, exclusiveMax);
        }

        @Override
        @NotNull
        public FloatRange translate(@NotNull Float translation) {
            return this.create(Float.valueOf(((Float)this.getMin()).floatValue() + translation.floatValue()), Float.valueOf(((Float)this.getMax()).floatValue() + translation.floatValue()), this.isExclusiveMin(), this.isExclusiveMax());
        }

        @Override
        @NotNull
        public FloatRange growRelative(@NotNull Float left, @NotNull Float right) {
            float size = this.getFloatSize();
            return this.create(Float.valueOf(((Float)this.getMin()).floatValue() - left.floatValue() * size), Float.valueOf(((Float)this.getMax()).floatValue() + right.floatValue() * size), this.isExclusiveMin(), this.isExclusiveMax());
        }

        @Override
        @NotNull
        public FloatRange grow(@NotNull Float left, @NotNull Float right) {
            return this.create(Float.valueOf(((Float)this.getMin()).floatValue() - left.floatValue()), Float.valueOf(((Float)this.getMax()).floatValue() + right.floatValue()), this.isExclusiveMin(), this.isExclusiveMax());
        }

        @Override
        @NotNull
        public FloatRange shrinkRelative(@NotNull Float left, @NotNull Float right) {
            float size = this.getFloatSize();
            return this.create(Float.valueOf(((Float)this.getMin()).floatValue() + left.floatValue() * size), Float.valueOf(((Float)this.getMax()).floatValue() - right.floatValue() * size), this.isExclusiveMin(), this.isExclusiveMax());
        }

        @Override
        @NotNull
        public FloatRange shrink(@NotNull Float left, @NotNull Float right) {
            return this.create(Float.valueOf(((Float)this.getMin()).floatValue() + left.floatValue()), Float.valueOf(((Float)this.getMax()).floatValue() - right.floatValue()), this.isExclusiveMin(), this.isExclusiveMax());
        }

        @Override
        public double getCenter() {
            return this.getFloatCenter();
        }

        @Override
        protected double getDistance(Float left, Float right) {
            if (left == null || right == null) {
                return Double.NaN;
            }
            return right.floatValue() - left.floatValue();
        }
    }

    @ApiStatus.Internal
    public static class DoubleRangeImpl
    extends AbstractNumberRange<Double, DoubleRange>
    implements DoubleRange {
        protected DoubleRangeImpl(Double min, Double max, boolean exclusiveMin, boolean exclusiveMax) {
            super(min != null && !Double.isNaN(min) ? min : Double.NEGATIVE_INFINITY, max != null && !Double.isNaN(max) ? max : Double.POSITIVE_INFINITY, exclusiveMin, exclusiveMax);
        }

        @Override
        @Nullable
        public Double randomUniform(Random random) {
            double min = Math.max((Double)this.getMin(), -1.7976931348623157E308);
            double max = Math.min((Double)this.getMax(), Double.MAX_VALUE);
            if (max > min || max == min && this.isExclusiveMin() || this.isExclusiveMax()) {
                return null;
            }
            double v = min + random.nextDouble() * (max - min);
            if (v == min) {
                return this.isExclusiveMin() ? (this.isExclusiveMax() ? (max + min) * 0.5 : max) : (this.isExclusiveMax() ? min : (random.nextBoolean() ? min : max));
            }
            return v;
        }

        @Override
        @Nullable
        public Double randomGaussian(Random random) {
            double min = Math.max((Double)this.getMin(), -1.7976931348623157E308);
            double max = Math.min((Double)this.getMax(), Double.MAX_VALUE);
            if (max < min) {
                return null;
            }
            return (min + max) * 0.5 + random.nextGaussian() * (max - min) * 0.5;
        }

        @Override
        @NotNull
        public DoubleRange create(@NotNull Double min, @NotNull Double max, boolean exclusiveMin, boolean exclusiveMax) {
            return new DoubleRangeImpl(min, max, exclusiveMin, exclusiveMax);
        }

        @Override
        @NotNull
        public DoubleRange translate(@NotNull Double translation) {
            return this.create((Double)this.getMin() + translation, (Double)this.getMax() + translation, this.isExclusiveMin(), this.isExclusiveMax());
        }

        @Override
        @NotNull
        public DoubleRange growRelative(@NotNull Double left, @NotNull Double right) {
            double size = this.getSize();
            return this.create((Double)this.getMin() - left * size, (Double)this.getMax() + right * size, this.isExclusiveMin(), this.isExclusiveMax());
        }

        @Override
        @NotNull
        public DoubleRange grow(@NotNull Double left, @NotNull Double right) {
            return this.create((Double)this.getMin() - left, (Double)this.getMax() + right, this.isExclusiveMin(), this.isExclusiveMax());
        }

        @Override
        @NotNull
        public DoubleRange shrinkRelative(@NotNull Double left, @NotNull Double right) {
            double size = this.getSize();
            return this.create((Double)this.getMin() + left * size, (Double)this.getMax() - right * size, this.isExclusiveMin(), this.isExclusiveMax());
        }

        @Override
        @NotNull
        public DoubleRange shrink(@NotNull Double left, @NotNull Double right) {
            return this.create((Double)this.getMin() + left, (Double)this.getMax() - right, this.isExclusiveMin(), this.isExclusiveMax());
        }

        @Override
        public double getCenter() {
            double min = Math.max((Double)this.getMin(), -1.7976931348623157E308);
            double max = Math.min((Double)this.getMax(), Double.MAX_VALUE);
            return (min + max) / 2.0;
        }

        @Override
        protected double getDistance(Double left, Double right) {
            if (left == null || right == null) {
                return Double.NaN;
            }
            return right - left;
        }
    }

    @ApiStatus.Internal
    public static abstract class AbstractNumberRange<N extends Number, Self extends NumberRange<N, Self>>
    extends AbstractSizedRange<N, Self>
    implements NumberRange<N, Self> {
        protected AbstractNumberRange(N min, N max, boolean exclusiveMin, boolean exclusiveMax) {
            super(min, max, exclusiveMin, exclusiveMax);
        }

        @Override
        public double getCenter() {
            return (((Number)this.getMin()).doubleValue() + ((Number)this.getMax()).doubleValue()) * 0.5;
        }

        @Override
        public double getRadius() {
            return this.getSize() * 0.5;
        }

        @Override
        @NotNull
        public Self growRelative(@NotNull N both) {
            return this.growRelative(both, both);
        }

        @Override
        @NotNull
        public Self grow(@NotNull N both) {
            return this.grow(both, both);
        }

        @Override
        @NotNull
        public Self shrinkRelative(@NotNull N both) {
            return this.shrinkRelative(both, both);
        }

        @Override
        @NotNull
        public Self shrink(@NotNull N both) {
            return this.shrink(both, both);
        }

        @Override
        protected double getDistance(N left, N right) {
            if (left == null || right == null) {
                return Double.NaN;
            }
            return ((Number)left).doubleValue() - ((Number)right).doubleValue();
        }
    }

    @ApiStatus.Internal
    public static abstract class AbstractSizedRange<V extends Comparable<V>, Self extends SizedRange<V, Self>>
    extends AbstractRange<V, Self>
    implements SizedRange<V, Self> {
        protected AbstractSizedRange(V min, V max, boolean exclusiveMin, boolean exclusiveMax) {
            super(min, max, exclusiveMin, exclusiveMax);
        }

        protected abstract double getDistance(V var1, V var2);

        @Override
        public double getSize() {
            double size = this.getDistance(this.getMin(), this.getMax());
            if (size == 0.0 && (this.isExclusiveMin() || this.isExclusiveMax())) {
                return -4.9E-324;
            }
            return size;
        }

        @Override
        public boolean isEmpty() {
            return this.getSize() < 0.0;
        }
    }
}

