/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.api.entry;

import endorh.simpleconfig.api.ConfigEntryBuilder;
import it.unimi.dsi.fastutil.doubles.Double2DoubleFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RangedEntryBuilder<V extends Comparable<V>, Config, Gui, Self extends RangedEntryBuilder<V, Config, Gui, Self>>
extends ConfigEntryBuilder<V, Config, Gui, Self> {
    @Contract(pure=true)
    @NotNull
    public Self min(V var1);

    @Contract(pure=true)
    @NotNull
    public Self max(V var1);

    @Contract(pure=true)
    @NotNull
    public Self range(@Nullable V var1, @Nullable V var2);

    @Contract(pure=true)
    @NotNull
    public Self slider();

    @Contract(pure=true)
    @NotNull
    public Self slider(boolean var1);

    @Contract(pure=true)
    @NotNull
    public Self slider(String var1);

    @Contract(pure=true)
    @NotNull
    public Self slider(Function<V, Component> var1);

    @Contract(pure=true)
    @NotNull
    public Self sliderRange(V var1, V var2);

    @Contract(pure=true)
    @NotNull
    default public Self sliderMap(DoubleUnaryOperator map, DoubleUnaryOperator inverse) {
        return this.sliderMap(InvertibleDouble2DoubleFunction.of(map, inverse));
    }

    @Contract(pure=true)
    @NotNull
    public Self sliderMap(@Nullable InvertibleDouble2DoubleFunction var1);

    public static interface InvertibleDouble2DoubleFunction
    extends Double2DoubleFunction {
        public static InvertibleDouble2DoubleFunction identity() {
            Double2DoubleFunction identity = Double2DoubleFunction.identity();
            return InvertibleDouble2DoubleFunction.of((DoubleUnaryOperator)identity, (DoubleUnaryOperator)identity);
        }

        public static InvertibleDouble2DoubleFunction of(final DoubleUnaryOperator map, final DoubleUnaryOperator inverse) {
            return new InvertibleDouble2DoubleFunction(){

                public double get(double key) {
                    return map.applyAsDouble(key);
                }

                @Override
                public double inverse(double value) {
                    return inverse.applyAsDouble(value);
                }
            };
        }

        public static InvertibleDouble2DoubleFunction neg() {
            return InvertibleDouble2DoubleFunction.of(d -> -d, d -> -d);
        }

        public static InvertibleDouble2DoubleFunction sum(double summand) {
            return InvertibleDouble2DoubleFunction.of(d -> d + summand, d -> d - summand);
        }

        public static InvertibleDouble2DoubleFunction sqrt() {
            return InvertibleDouble2DoubleFunction.of(Math::sqrt, d -> d * d);
        }

        public static InvertibleDouble2DoubleFunction pow(double power) {
            return InvertibleDouble2DoubleFunction.of(d -> Math.pow(d, power), d -> Math.pow(d, 1.0 / power));
        }

        public static InvertibleDouble2DoubleFunction expMap(double width) {
            double exp = Math.exp(width);
            return InvertibleDouble2DoubleFunction.of(f -> (Math.exp(width * f) - 1.0) / (exp - 1.0), f -> Math.log((exp - 1.0) * f + 1.0) / width);
        }

        public double inverse(double var1);

        default public InvertibleDouble2DoubleFunction inverse() {
            return InvertibleDouble2DoubleFunction.of(this::inverse, (DoubleUnaryOperator)((Object)this));
        }

        default public InvertibleDouble2DoubleFunction andThen(InvertibleDouble2DoubleFunction after) {
            return InvertibleDouble2DoubleFunction.of(this.andThen((DoubleUnaryOperator)((Object)after)), (DoubleUnaryOperator)this.inverse().composeDouble(after.inverse()));
        }

        default public InvertibleDouble2DoubleFunction compose(InvertibleDouble2DoubleFunction before) {
            return InvertibleDouble2DoubleFunction.of(this.compose((DoubleUnaryOperator)((Object)before)), (DoubleUnaryOperator)((Object)this.inverse().andThen(before.inverse())));
        }
    }
}

