/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.api.entry;

import endorh.simpleconfig.api.AtomicEntryBuilder;
import endorh.simpleconfig.api.ConfigEntryBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface BooleanEntryBuilder
extends ConfigEntryBuilder<Boolean, Boolean, Boolean, BooleanEntryBuilder>,
AtomicEntryBuilder {
    @Contract(pure=true)
    @NotNull
    public BooleanEntryBuilder text(BooleanDisplayer var1);

    @Contract(pure=true)
    @NotNull
    public BooleanEntryBuilder text(String var1);

    public static interface BooleanDisplayer {
        public static final BooleanDisplayer TRUE_FALSE = BooleanDisplayer.forTranslation("simpleconfig.format.bool.true_false");
        public static final BooleanDisplayer YES_NO = BooleanDisplayer.forTranslation("simpleconfig.format.bool.yes_no", "yes", "no");
        public static final BooleanDisplayer ENABLED_DISABLED = BooleanDisplayer.forTranslation("simpleconfig.format.bool.enabled_disabled", "enabled", "disabled");
        public static final BooleanDisplayer ON_OFF = BooleanDisplayer.forTranslation("simpleconfig.format.bool.on_off", "on", "off");

        public static BooleanDisplayer forTranslation(String translation) {
            return BooleanDisplayer.forTranslation(translation, "true", "false");
        }

        public static BooleanDisplayer forTranslation(final String translation, final String serialTrue, final String serialFalse) {
            return new BooleanDisplayer(){

                @Override
                public Component getDisplayName(boolean value) {
                    return Component.m_237115_((String)(translation + (value ? ".true" : ".false"))).m_130940_(value ? ChatFormatting.GREEN : ChatFormatting.RED);
                }

                @Override
                public String getSerializableName(boolean value) {
                    return value ? serialTrue : serialFalse;
                }
            };
        }

        public Component getDisplayName(boolean var1);

        default public String getSerializableName(boolean value) {
            return String.valueOf(value);
        }
    }
}

