/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.api.command;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ParsedArgument<A>(A value, String text) {
    @Override
    public String toString() {
        return this.text;
    }

    @Nullable
    public static <A> ParsedArgument<A> tryParse(ArgumentType<A> type, @Nullable String text) {
        if (text == null) {
            return null;
        }
        StringReader reader = new StringReader(text);
        try {
            Object parsed = type.parse(reader);
            if (!reader.canRead()) {
                return new ParsedArgument<Object>(parsed, text);
            }
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return null;
    }

    @NotNull
    public static <A> ParsedArgument<A> parse(ArgumentType<A> type, String text) throws CommandSyntaxException {
        StringReader reader = new StringReader(text);
        Object parsed = type.parse(reader);
        if (reader.canRead()) {
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().createWithContext((ImmutableStringReader)reader);
        }
        return new ParsedArgument<Object>(parsed, text);
    }

    @NotNull
    public static <A> List<ParsedArgument<A>> getExamples(ArgumentType<A> type) {
        return type.getExamples().stream().map(s -> ParsedArgument.tryParse(type, s)).filter(Objects::nonNull).toList();
    }
}

