/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.api.annotation;

import endorh.simpleconfig.api.entry.RangedEntryBuilder;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Optional;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

@Target(value={ElementType.FIELD, ElementType.TYPE_USE, ElementType.ANNOTATION_TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface Slider {
    public String label() default "";

    public double min() default NaN;

    public double max() default NaN;

    public SliderType type() default SliderType.LINEAR;

    public double arg() default NaN;

    public static enum SliderType {
        LINEAR(null),
        SQRT(RangedEntryBuilder.InvertibleDouble2DoubleFunction.sqrt()),
        POW(RangedEntryBuilder.InvertibleDouble2DoubleFunction::pow, 2.0),
        EXP_MAP(RangedEntryBuilder.InvertibleDouble2DoubleFunction::expMap, 10.0);

        @Nullable
        private final RangedEntryBuilder.InvertibleDouble2DoubleFunction map;
        @Nullable
        private final Function<Double, RangedEntryBuilder.InvertibleDouble2DoubleFunction> mapFactory;
        private final double def;

        private SliderType(RangedEntryBuilder.InvertibleDouble2DoubleFunction map) {
            this.map = map;
            this.mapFactory = null;
            this.def = Double.NaN;
        }

        private SliderType(Function<Double, RangedEntryBuilder.InvertibleDouble2DoubleFunction> mapFactory, double def) {
            this.mapFactory = mapFactory;
            this.map = null;
            this.def = def;
        }

        public static Optional<RangedEntryBuilder.InvertibleDouble2DoubleFunction> fromAnnotation(Slider a) {
            SliderType type = a.type();
            if (type.map != null) {
                return Optional.of(type.map);
            }
            if (type.mapFactory != null) {
                double arg = a.arg();
                return Optional.of(type.mapFactory.apply(Double.isNaN(arg) ? type.def : arg));
            }
            return Optional.empty();
        }
    }
}

